Streamline bare-metal example for Arm M profile
===============================================
An example showing how to configure the Streamline bare-metal agent, run it and then analyze it.

Purpose and scope
-----------------
This example demonstrates how to use the Streamline bare-metal agent (barman).
The code is built for ARMv7-M and ARMv8-M only but the interface with barman is mostly architecture agnostic.

This example is intended to be built with [Arm Compiler for Embedded 6](https://developer.arm.com/tools-and-software/embedded/arm-compiler).
The executable is intended for running on the MCBSTM32E.
A ready-made launch configuration `Streamline_bare_metal_M_profile-mcbstm32e.launch` is provided.
For a good debug view, the compiler's optimization level is set to `-O1` in the makefile.
You can change this to raise the optimization level to `-O2` or `-O3` for higher performance code generation, but at the cost of a worse debug view.

Importing into Arm DS IDE
-------------------------
This example may be imported directly into Arm DS IDE using the Examples & Programming Libraries wizard, or by following these steps:

1. From Arm DS IDE select "File->Import...".
2. Choose "General->Existing Projects into Workspace".
3. Set "Select root directory" to this directory and import the project.

Configuring barman in Streamline
--------------------------------
1. Open Streamline and select the "Streamline" menu and then "Generate Barman Sources"
2. In the dialog choose "ITM Interface" for the data storage backend and under "Advanced options" set the maximum number of task information records to 5, then click "Next"
3. Now choose the core, Cortex-M3 for this example, and then click "Next"
4. Choose some events. For example, select them all, then click "Next"
5. Now you can set the PC sampling interval. For example, the default is fine, then click "Next"
6. Click "Next" again as we have no custom counters in this example
7. Finally set the save location to the `common/src` directory of this project, click "Next" and then click "Finish"

Building the example
--------------------
This example can be built with Arm Compiler for Embedded 6 using the supplied Eclipse (makefile builder) project, or directly on the command-line with the supplied makefile using the `make` utility.

A prebuilt binary suitable for running on the MCBSTM32E board is provided in `prebuilt/barman_example.axf`

Building on the command-line
----------------------------
To build the example on the command-line with the supplied `make` utility:

* On Windows, open a "Arm DS IDE Command Prompt" from the Start menu, run the `select_toolchain` utility, and select `Arm Compiler for Embedded 6` from the list
* On Linux, run the `suite_exec` utility with the `--toolchain` option to select the compiler and start a shell configured for the suite environment, for example: `~/Arm_ds/bin/suite_exec --toolchain "Arm Compiler for Embedded 6" bash`

Then navigate to the root directory of the project, and type: `make`
The usual `make` rules: `clean` and `all` are provided in the makefile.

Running the example in Arm DS IDE
---------------------------------
1. Select "Debug Configurations" from the "Run" menu.
2. Select `Streamline_bare_metal_M_profile-mcbstm32e` from the list of Arm DS IDE Debugger configurations.
3. Under "Connections => Bare Metal Debug" set "Connection" appropriately and then under "Connections => DTSL Options" click "Edit..."
  1. Under the "Trace Buffer" tab set "Trace capture method" to your desired method, e.g., "DSTREAM 4GB Trace Buffer"
  2. Under the "ITM" tab tick "Enable ITM Trace". Under that choose "The target will setup the ITM" and under that set "ITM ATBID" to 2.
  3. Now click "OK".
4. If using prebuilt assets: in "Files" tab, click "Workspace..." button and locate `barman_example.axf` in `prebuilt` directory
5. Click on "Debug" to start debugging.  The executable image will be downloaded to the target and the program counter set to `main` in `main.c`.
6. Run the executable (press F8).  The following output is displayed in the "Target Console":
   ```
   Insertion sort took 4 clock ticks
   Shell sort took 4 clock ticks
   Quick sort took 4 clock ticks
   ```
7. Now interrupt the target (press F9).
8. In the debug console type: `trace dump <directory name of choice> ITM`.

Analyzing the capture in Streamline
-----------------------------------
1. Click the "Import Capture File(s)" button and find the trace dump named 'ITM_0.bin' in the directory you chose, click "Next" button
2. In "Select what to Import" step select "Barman Agent Capture (via ITM)", then click "Next" button
3. Fill "Barman XML" field with path to generated 'barman.xml' which will be in 'common/src' if you didn't choose a different directory in the wizard
4. Fill "Agent Image" field with path to image, which will be in 'build/mcbstm32e' directory (or 'prebuilt' if using prebuilt example), then click "Finish" button
5. After import is completed, find capture named "barman_M_profile_example_on_mcbstm32e" in Streamline Data view and click "Change analysis options and regenerate the reports" button
6. In "Analyze" window: change "Resolution mode" value to 'Ultra-High', then click "Analyze" button
7. After Analyze is finished, in the "Timeline" view set the resolution to 5ms, for a good view.

Barman related code
-------------------
In `common/src/barman-example.c` you can see the barman related code that was needed for barman to work. Refer to the comments within the file for explanation.
You can see the use of task switching in `common/src/sorts.c` and you can see the use of annotations in `common/src/timer.c`.
