/**
 * Copyright (C) 2006-2025 by Arm Limited (or its affiliates). All rights reserved.
 * Use, modification and redistribution of this file is subject to your possession of a
 * valid End User License Agreement for the Arm Product of which these examples are part of
 * and your compliance with all applicable terms and conditions of such license agreement.
 *
 * Redistribution permitted only in object code form and only as
 * part of Software Applications developed by you or your permitted users. If you
 * choose to redistribute the whole or any part of Example Code, you agree: (a)
 * to ensure that they are licensed for use only as part of Software Applications
 * and only for execution on microprocessors manufactured or simulated under
 * licence from Arm; (b) not to use Arm's or any of its licensors names, logos or
 * trademarks to market Software Applications; (c) to include valid copyright
 * notices on Software Applications, and preserve any copyright notices which are
 * included with, or in, the Example Code; and (d) to ensure that any further
 * redistribution is limited to redistribution by either or both your customers
 * and your authorised distributors as part of Software Applications and that
 * your customers and your authorised distributors comply with these terms.
 */
/*
** This file implements SysTick initialization and SysTick exception handler.
*/

#include "timer.h"
#include "scs.h"
#include "barman-example.h"
#include "barman.h"

#include <stdio.h>

#define RELOAD 7200000

static unsigned int ticks = 0;


/* SysTick initialization */

void SysTick_init(void)
{
#if (RELOAD > 0xFFFFFF)
   #error "Reload Value too large!"
#else
    *SysTickLoad  = RELOAD; /* reload value on timeout */
    *SysTickValue = 0;      /* clear current value */

    /* Start timer, with interrupts enabled */
    *SysTickCtrl = SysTickEnable | SysTickInterrupt | SysTickClkSource;
#endif
}


/* SysTick exception handler */

__attribute__((interrupt)) void SysTickHandler(void)
{
    char buffer[100];
    enum task_id previous_task_id = getTaskId();

    switchTask(TASK_ID_INTERRUPT);
    ticks++;
    snprintf(buffer, sizeof(buffer), "tick %d", ticks);
    barman_annotate_channel(0, BM_ANNOTATE_COLOR_CYCLIC, buffer);
    switchTask(previous_task_id);
}
