Streamline bare-metal example for AArch64
=========================================
An example showing how to configure the Streamline bare-metal agent, run it and then analyze it.

Purpose and scope
-----------------
This example demonstrates how to use the Streamline bare-metal agent (barman).
The code is built for AArch64 only but the interface with barman is mostly architecture agnostic.

This example is intended to be built with [Arm Compiler for Embedded 6](https://developer.arm.com/tools-and-software/embedded/arm-compiler) or [Linaro bare-metal GCC](https://releases.linaro.org/components/toolchain/binaries/latest-5/aarch64-elf/).
The executable is intended for running on the Cortex-A57x2-A53x4 model or the Juno platform.
This example does not depend on any semihosting support being provided by the debugger.
Ready-made launch configurations `Streamline_bare_metal_ARMv8_AArch64-FVP_Base_Cortex-A57x2-A53x4.launch` and `Streamline_bare_metal_ARMv8_AArch64-juno_r0.launch` are provided.
For a good debug view, the compiler's optimization level is set to `-O1` in the makefile.
You can change this to raise the optimization level to `-O2` or `-O3` for higher performance code generation, but at the cost of a worse debug view.

Importing into Arm DS IDE
-------------------------
This example may be imported directly into Arm DS IDE using the File -> Import... -> Arm DS IDE -> Examples & Programming Libraries wizard, or by following these steps:

1. From Arm DS IDE select "File->Import...".
2. Choose "General->Existing Projects into Workspace".
3. Set "Select root directory" to this directory and import the project.

Configuring barman in Streamline
--------------------------------
1. Open Streamline and select the "Streamline" menu and then "Generate Barman Sources"
2. In the dialog choose the desired settings. All targets support the RAM buffer datastore, but the Juno also supports using the STM datastore.
   Set the maximum number of cores to 6 and then click "Next"
3. If you selected the STM datastore you will get an additional page here where you need to enter in the STM master IDs.
   Consulting the reference manual you will see they are `64-71` for the Juno, enter that and click "Next".
4. Now choose the cores, Cortex-A57 and Cortex-A53 for the model or just Cortex-A53 for the Juno, and then click "Next"
   You should add all the cores enabled in the system on which the agent will run.
5. Choose some events for the core types. For example, Branch - PC change, Cache - Data refill, Clock - Cycles, Exception - Taken, then click "Next"
   You should add events for all the cores enabled in the system on which the agent will run.
6. Click "Next" again as we have no custom counters in this example
7. Finally set the save location to the `<target>/src` directory of this project, where `<target>` is your choice of `FVP_Base_Cortex-A57x2-A53x4` or `juno_r0`.
   Click "Next" and then click "Finish"

Building the example
--------------------
This example can be built with Arm Compiler for Embedded 6 or Linaro bare-metal GCC; using the supplied Eclipse (makefile builder) project, or directly on the command-line with the supplied makefile using the `make` utility.

A prebuilt binary suitable for running on the FVP model is provided in `prebuilt/barman_example.axf`

Building on the command-line
----------------------------
To build the example on the command-line with the supplied `make` utility:

* On Windows, open a "Arm DS IDE Command Prompt" from the Start menu, run the `select_toolchain` utility, and select `Arm Compiler for Embedded 6` from the list
* On Linux, run the `suite_exec` utility with the `--toolchain` option to select the compiler and start a shell configured for the suite environment, for example: `~/Arm_ds/bin/suite_exec --toolchain "Arm Compiler for Embedded 6" bash`

Then navigate to the `.../Streamline_bare_metal_ARMv8_AArch64` directory, and type: `make`
The usual `make` rules: `clean` and `all` are provided in the makefile.
The makefile compiles the sources as:
`armclang -c --target=aarch64-arm-none-eabi -g -O1`

Running the example in Arm DS IDE
---------------------------------
1. Select "Debug Configurations" from the "Run" menu.
2. Select `Streamline_bare_metal_ARMv8_AArch64-<target>` from the list of Arm DS IDE Debugger configurations.
3. If connecting to a physical target, under "Connections => Bare Metal Debug" set "Connection" appropriately and then under "Connections => DTSL Options" click "Edit..."
  1. Under the "Trace Buffer" tab set "Trace capture method" to your desired method, e.g., "DSTREAM 4GB Trace Buffer"
  2. If using the STM datastore, under the "STM" tab tick "Enable STM Trace".
  3. Now click "OK".
4. Click on "Debug" to start debugging. The executable image will be downloaded to the target and the program counter set to the entry point at `start64` in `startup.s`.
5. Run the executable (press F8). The following output is displayed in the "Target Console":
   ```
   Arm DS IDE ARMv8 Prime Number Generator Example

   CPU 0: 31 (prime 10 of 100)
   CPU 3: 37 (prime 11 of 100)
   CPU 5: 41 (prime 12 of 100)
   CPU 1: 43 (prime 13 of 100)
   CPU 2: 47 (prime 14 of 100)
   CPU 5: 53 (prime 15 of 100)
   CPU 1: 59 (prime 16 of 100)
   CPU 3: 61 (prime 17 of 100)
   CPU 4: 67 (prime 18 of 100)
   CPU 2: 71 (prime 19 of 100)
   CPU 1: 73 (prime 20 of 100)
   CPU 4: 79 (prime 21 of 100)
   CPU 2: 83 (prime 22 of 100)
   CPU 1: 89 (prime 23 of 100)
   ```
6. After a few seconds pause the example.
7. In the debug console type:
  * For a RAM buffer datastore `dump value <file name of choice>.raw buffer_for_barman`.
  * For the STM datastore `trace dump <directory name of choice>.raw STM`.

Analyzing the capture in Streamline
-----------------------------------
1. Click the "Import Capture File(s)" button and find the capture in the root of your workspace, making sure to select the appropriate option in the drop-down menu.
  * For a RAM buffer datastore "Bare-Metal Agent captures".
  * For the STM datastore "STM Trace Files".
2. If prompted, find the `barman.xml` in `<target>/src` if you didn't chose a different directory in the wizard.
3. Click the "Change analysis options and regenerate the report" button.
4. Because we only sampled for a very short period in model time, change the "Resolution mode" to "Ultra-High".
5. Click the "Add ELF image..." button and add `build/<target>/barman_example.axf`.
6. Now click "Analyze".
7. In the "Timeline" view set the resolution to 10 microseconds, which was the sample period, for a good view.

Barman related code
-------------------
In `src/barman_interrupts.c` you can see the barman related code that was needed for barman to work. Refer to the comments within the file for explanation.
