//==================================================================
// MP GICv2 example code
//
// Copyright (C) 2014-2025 by Arm Limited (or its affiliates). All rights reserved.
// Use, modification and redistribution of this file is subject to your possession of a
// valid End User License Agreement for the Arm Product of which these examples are part of
// and your compliance with all applicable terms and conditions of such license agreement.
//
// Redistribution permitted only in object code form and only as
// part of Software Applications developed by you or your permitted users. If you
// choose to redistribute the whole or any part of Example Code, you agree: (a)
// to ensure that they are licensed for use only as part of Software Applications
// and only for execution on microprocessors manufactured or simulated under
// licence from Arm; (b) not to use Arm's or any of its licensors names, logos or
// trademarks to market Software Applications; (c) to include valid copyright
// notices on Software Applications, and preserve any copyright notices which are
// included with, or in, the Example Code; and (d) to ensure that any further
// redistribution is limited to redistribution by either or both your customers
// and your authorised distributors as part of Software Applications and that
// your customers and your authorised distributors comply with these terms.
//==================================================================

//==================================================================
// GIC. Generic Interrupt Controller Architecture Specification
//==================================================================
//
// This code assumes a maximum of 512 interrupt sources, which is
// 2^9. Many of the interrupt controls are split up with multiple
// interrupts programmed per GICD_ register, so a varying number
// of bits are extracted from IntId parameters according to the
// no. of interrupts per register
//
// The CPU Interface and Interrupt Distributor are accessed via addresses
// GICD_BASE and GICC_BASE in the private peripheral space

// Typical calls to enable interrupt ID X:
// enableIntID(X)                    <-- Enable that ID
// setIRQPriority(X, 0)              <-- Set the priority of X to 0 (the max priority)
// setPriorityMask(0x1F)             <-- Set CPU's priority mask to 0x1F (the lowest priority)
// enableGIC()                       <-- Enable the GIC (global)
// enableGICProcessorInterface()     <-- Enable the CPU interface (local to the CPU)

//
//    set IRQ id as a Group<group> interrupt
//
//  Inputs
//    id - IRQ number
//    group - group (0 or 1)
//
//  Returns
//    <nothing>
//
void SetIrqGroup(unsigned int id, unsigned int group);



//
//    set block of IRQs as a Group<group> interrupt
//
//  Inputs
//    block - set of IRQs, modulo 32
//    group - group (0 or 1)
//
//  Returns
//    <nothing>
//
void SetBlockGroup(unsigned int block, unsigned int group);



//
//    set all SPI IRQs as Group<group> interrupts
//
//  Inputs
//    group - group (0 or 1)
//
//  Returns
//    <nothing>
//
void SetSPIGroup(unsigned int group);



void SetIRQPriority(unsigned int ID, unsigned int priority);



void EnableIRQ(unsigned int id);



void DisableIRQ(unsigned int ID);



unsigned int TestIRQ(unsigned int ID);



void ClearIRQ(unsigned int ID);



// Global enable of the Interrupt Distributor
// Enables forwarding of both Group1 and Group0 pending interrupts from the Distributor to the CPU interfaces
//
void EnableGICD(void);



// Global disable of the Interrupt Distributor
// Disables forwarding of both Group1 and Group0 pending interrupts from the Distributor to the CPU interfaces
//
void DisableGICD(void);



void EnableGICC(void);



void DisableGICC(void);



void SetPriorityMask(unsigned int priority);



void SetBinaryPoint(unsigned int bp);



unsigned int ReadIAR(void);



void WriteEOI(unsigned int ID);



void SendSGI(unsigned int id, unsigned int filter,
             unsigned int target, unsigned int group);



void ClearSGI(unsigned int id, unsigned int cpu);

