/*
** Copyright (c) 2018-2025 Arm Limited (or its affiliates). All rights reserved.
** Use, modification and redistribution of this file is subject to your possession of a
** valid End User License Agreement for the Arm Product of which these examples are part of
** and your compliance with all applicable terms and conditions of such license agreement.
**
** Redistribution permitted only in object code form and only as
** part of Software Applications developed by you or your permitted users. If you
** choose to redistribute the whole or any part of Example Code, you agree: (a)
** to ensure that they are licensed for use only as part of Software Applications
** and only for execution on microprocessors manufactured or simulated under
** licence from Arm; (b) not to use Arm's or any of its licensors names, logos or
** trademarks to market Software Applications; (c) to include valid copyright
** notices on Software Applications, and preserve any copyright notices which are
** included with, or in, the Example Code; and (d) to ensure that any further
** redistribution is limited to redistribution by either or both your customers
** and your authorised distributors as part of Software Applications and that
** your customers and your authorised distributors comply with these terms.
**
*/

/* Simple polled UART driver for Cortex-M MPS2 FVP model */

// Ensure uart_init() is called before any other functions in this file.

typedef struct
{
  volatile unsigned int DATA;
  volatile unsigned int STATE;
  volatile unsigned int CTRL;
  volatile unsigned int INTERRUPT;
  volatile unsigned int BAUDDIV;
} UART_struct;


#define UART ((UART_struct *) 0x40004000UL )

void uart_init(void)
{
  UART->BAUDDIV = 16;
  UART->CTRL    = 0x41; // High speed test mode, TX only
}

void uart_putc_polled(char c)
{
  while ((UART->STATE & 1)); // Wait if Transmit Holding register is full
  UART->DATA = c;
}

char uart_getchar_polled(void)
{
  while ((UART->STATE & 2)==0); // Wait if Receive Holding register is empty
  return (UART->DATA);
}
