/* Copyright (C) 2024-2025 by Arm Limited (or its affiliates). All rights reserved. */

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// This file is generated and has a matching component in Streamline.
// Do not manually modify the metric definitions without doing the same in Streamline.
// Updated on 2025-11-05T11:26:53.271077031 using <unknown> - HEAD (241ad508333e47385d620dec906219ddecb52e11) - "X"
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

#include "metrics/definitions.hpp"

#include <cstdint>

// NOLINTBEGIN(cert-err58-cpp)

namespace metrics {
    namespace {
        [[maybe_unused]] const metric_events_set_t backend_bound_0 {
            {
                {std::uint16_t(0x003d), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "backend_bound",
            "Backend Bound",
            "This metric is the percentage of total slots that were stalled due to resource constraints in the backend "
            "of the processor.",
            "percent",
            0,
            metric_priority_t::boundness,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t backend_bound_1 {
            {
                {std::uint16_t(0x003d), 2},
                {std::uint16_t(0x0010), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "backend_bound",
            "Backend Bound",
            "This metric is the percentage of total slots that were stalled due to resource constraints in the backend "
            "of the processor.",
            "percent",
            1,
            metric_priority_t::boundness,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t backend_busy_bound_0 {
            {
                {std::uint16_t(0x816b), 8},
                {std::uint16_t(0x0024), 2},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_busy_bound",
            "Backend Busy Bound",
            "This metric is the percentage of total cycles stalled in the backend due to issue queues being full to "
            "accept operations for execution.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_busy_ls_bound_0 {
            {
                {std::uint16_t(0x0024), 2},
                {std::uint16_t(0x00f1), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_busy_ls_bound",
            "Backend Busy LS Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory system issue queues "
            "being full to accept operations for execution.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_busy_vpu_arb_bound_0 {
            {
                {std::uint16_t(0x00ef), 8},
                {std::uint16_t(0x0024), 2},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_busy_vpu_arb_bound",
            "Backend Busy VPU Arbitration Bound",
            "This metric is the percentage of total cycles stalled in the backend due to VPU arbitration preventing "
            "the VPU from accepting operations for execution.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_cache_l1d_bound_0 {
            {
                {std::uint16_t(0x4005), 8},
                {std::uint16_t(0x8165), 32},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_cache_l1d_bound",
            "Backend Cache L1D Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory access latency issues "
            "caused by level 1 data cache misses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_cache_l2d_bound_0 {
            {
                {std::uint16_t(0x4005), 8},
                {std::uint16_t(0x8165), 32},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_cache_l2d_bound",
            "Backend Cache L2D Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory access latency issues "
            "caused by level 2 data cache misses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_cme_backpressure_bound_0 {
            {
                {std::uint16_t(0x3200), 32},
                {std::uint16_t(0x3201), 128},
            },
            {
                metric_group_id_t::topdown_cme,
            },
            "backend_cme_backpressure_bound",
            "Backend SME Backpressure Bound",
            "This metric is the percentage of total cycles stalled in the backend as the SME unit is busy\ndue to "
            "other reasons like the SME unit being power down(TBD)",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_cme_busy_arb_bound_0 {
            {
                {std::uint16_t(0x3200), 32},
                {std::uint16_t(0x3202), 128},
            },
            {
                metric_group_id_t::topdown_cme,
            },
            "backend_cme_busy_arb_bound",
            "Backend SME Arbitration Bound",
            "This metric is the percentage of total cycles stalled in the backend because an SME is busy. "
            "The\ninstruction cannot be sent to SME because it is waiting for arbitration.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_cme_busy_bound_0 {
            {
                {std::uint16_t(0x3200), 32},
                {std::uint16_t(0x816b), 8},
            },
            {
                metric_group_id_t::topdown_cme,
            },
            "backend_cme_busy_bound",
            "Backend SME Busy Bound",
            "This metric is the percentage of total cycles stalled in the backend as the SME unit is busy.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_cme_busy_bound_1 {
            {
                {std::uint16_t(0x3200), 32},
            },
            {
                metric_group_id_t::topdown_cme,
            },
            "backend_cme_busy_bound",
            "Backend SME Busy Bound",
            "This metric is the percentage of total cycles stalled in the backend as the SME unit is busy.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_cme_cpu_bound_0 {
            {
                {std::uint16_t(0x3203), 128},
                {std::uint16_t(0x3200), 32},
            },
            {
                metric_group_id_t::topdown_cme,
            },
            "backend_cme_cpu_bound",
            "Backend SME CPU Bound",
            "This metric is the percentage of total cycles stalled in the SME unit of the backend due to "
            "dependency\nto the other units of CPU for execution.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_core_bound_0 {
            {
                {std::uint16_t(0x0024), 2},
                {std::uint16_t(0x816a), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_core_bound",
            "Backend Core Bound",
            "This metric is the percentage of total cycles stalled in the backend due to backend core resource "
            "constraints not related to instruction fetch latency issues caused by memory access components.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_core_cme_bound_0 {
            {
                {std::uint16_t(0x3200), 32},
                {std::uint16_t(0x816a), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_core_cme_bound",
            "Backend Core SME Bound",
            "This metric is the percentage of total cycles stalled in the backend due to the resource constraints to "
            "dispatch to the SME.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_core_other_bound_0 {
            {
                {std::uint16_t(0x1003), 32},
                {std::uint16_t(0x1005), 32},
                {std::uint16_t(0x816a), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_core_other_bound",
            "Backend Core Other Bound",
            "This metric is the percentage of total cycles stalled in the backend as some other resource is "
            "unavailable.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_core_other_bound_1 {
            {
                {std::uint16_t(0x1338), 32},
                {std::uint16_t(0x816a), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_core_other_bound",
            "Backend Core Other Bound",
            "This metric is the percentage of total cycles stalled in the backend as some other resource is "
            "unavailable.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_core_rename_bound_0 {
            {
                {std::uint16_t(0x816a), 8},
                {std::uint16_t(0x816d), 32},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_core_rename_bound",
            "Backend Core Rename Bound",
            "This metric is the percentage of total cycles stalled in the backend as the rename unit registers are "
            "unavailable.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_core_spec_throttle_bound_0 {
            {
                {std::uint16_t(0x3009), 32},
                {std::uint16_t(0x816a), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_core_spec_throttle_bound",
            "Backend Core Specuation Throttle Bound",
            "This metric is the percentage of total cycles stalled in the backend as the processor is stalling due to "
            "power throttling linked to low confidence branches",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_bound_0 {
            {
                {std::uint16_t(0x4005), 8},
                {std::uint16_t(0x0024), 2},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_bound",
            "Backend Memory Bound",
            "This metric is the percentage of backend stalled cycles that were stalled due a miss in the last level of "
            "cache.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_bound_1 {
            {
                {std::uint16_t(0x0024), 2},
                {std::uint16_t(0x8164), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_bound",
            "Backend Memory Bound",
            "This metric is the percentage of total cycles stalled in the backend due to backend core resource "
            "constraints related to memory access latency issues caused by memory access components.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_cache_bound_0 {
            {
                {std::uint16_t(0x4005), 8},
                {std::uint16_t(0x8165), 32},
                {std::uint16_t(0x8164), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_cache_bound",
            "Backend Mem Cache Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused "
            "by data cache misses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_cache_bound_1 {
            {
                {std::uint16_t(0x4005), 8},
                {std::uint16_t(0x8165), 32},
                {std::uint16_t(0x8164), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_cache_bound",
            "Backend Memory Cache Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused "
            "by data cache misses.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_cme_barrier_bound_0 {
            {
                {std::uint16_t(0x3210), 32},
                {std::uint16_t(0x320d), 128},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_cme_barrier_bound",
            "Backend SME LSRT Barrier Bound",
            "This metric is the percentage of total cycles stalled in the backend as the SME unit is busy\nbecause a "
            "CPU barrier waits for SME load/store transaction completion.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_cme_bound_0 {
            {
                {std::uint16_t(0x3210), 32},
                {std::uint16_t(0x8164), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_cme_bound",
            "Backend Memory SME Bound",
            "This metric is the percentage of total cycles stalled in the backend caused by\nload or store address "
            "hazards caused by SME unit memory execution dependency.\nSME and PE share the CPU memory subsystem and "
            "are synchronized via the LSRT block,\ncausing memory execution units in them to have dependencies on data "
            "accesses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_cme_hazard_cpu_bound_0 {
            {
                {std::uint16_t(0x3210), 32},
                {std::uint16_t(0x320e), 128},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_cme_hazard_cpu_bound",
            "Backend SME Memory Hazard CPU Bound",
            "This metric is the percentage of total cycles stalled in the backend\ndue to a SME LSRT hazard causing "
            "SME instructions to stall. SME and PE share the CPU memory subsystem and are\nsynchronized via the LSRT "
            "block, causing both the execution units to have dependencies\non data accesses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_cme_lsrt_full_bound_0 {
            {
                {std::uint16_t(0x3210), 32},
                {std::uint16_t(0x320c), 128},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_cme_lsrt_full_bound",
            "Backend SME LSRT Full Bound",
            "This metric is the percentage of total cycles stalled in the backend as the SME unit is busy\ndue to the "
            "LSRT being full. SME and PE share the CPU memory subsystem and are\nsynchronized via the LSRT block, "
            "causing both execution units to have dependencies\non data accesses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_cpu_hazard_cme_bound_0 {
            {
                {std::uint16_t(0x3210), 32},
                {std::uint16_t(0x320f), 128},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_cpu_hazard_cme_bound",
            "Backend CPU Memory Hazard SME Bound",
            "This metric is the percentage of total cycles stalled in the backend as the SME unit is busy\ndue SME "
            "LSRT hazard causing CPU instructions to stall. SME and PE share the CPU memory subsystem and "
            "are\nsynchronized via the LSRT block, causing both execution units to have dependencies\non data "
            "accesses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_store_bound_0 {
            {
                {std::uint16_t(0x8168), 32},
                {std::uint16_t(0x8164), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_store_bound",
            "Backend Mem Store Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused "
            "by stores stalled in the pre-commit stage.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_store_bound_1 {
            {
                {std::uint16_t(0x8168), 32},
                {std::uint16_t(0x8164), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_store_bound",
            "Backend Memory Store Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused "
            "by stores stalled in the pre-commit stage.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_tlb_bound_0 {
            {
                {std::uint16_t(0x8164), 8},
                {std::uint16_t(0x8167), 32},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_tlb_bound",
            "Backend Mem Tlb Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory access latency issues "
            "caused by data TLB misses.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_mem_tlb_bound_1 {
            {
                {std::uint16_t(0x8164), 8},
                {std::uint16_t(0x8167), 32},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_mem_tlb_bound",
            "Backend Memory TLB Bound",
            "This metric is the percentage of total cycles stalled in the backend due to memory access latency issues "
            "caused by data TLB misses.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_stall_interlock_bound_0 {
            {
                {std::uint16_t(0x00e4), 8},
                {std::uint16_t(0x0024), 2},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_stall_interlock_bound",
            "Backend Stall Interlock Rate",
            "This metric is the percentage of total cycles stalled in the backend due to instruction interlocks. A "
            "high rate of interlock stalls is likely an indication of sub-optimal instruction scheduling for an "
            "in-order core.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_stall_interlock_bound_1 {
            {
                {std::uint16_t(0x816c), 8},
                {std::uint16_t(0x0024), 2},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_stall_interlock_bound",
            "Backend Stall Interlock Rate",
            "This metric is the percentage of total cycles stalled in the backend due to instruction interlocks. A "
            "high rate of interlock stalls is likely an indication of sub-optimal instruction scheduling for an "
            "in-order core.",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_stall_interlock_ls_bound_0 {
            {
                {std::uint16_t(0x00f2), 8},
                {std::uint16_t(0x0024), 2},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_stall_interlock_ls_bound",
            "Backend Stall memory source interlock",
            "This metric is the percentage of backend stalls due to an interlock, where the source of at least one "
            "interlock is a memory operation. Refer to `backend_mem_bound` and subsequent breakdown to check whether "
            "the interlock is likely affected by memory resources such as caches or TLBs, or is instead primarily "
            "affected by load-to-use latency.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_stall_interlock_ptr_chase_bound_0 {
            {
                {std::uint16_t(0x0024), 2},
                {std::uint16_t(0x00f3), 8},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_stall_interlock_ptr_chase_bound",
            "Backend Stall pointer chase interlock Rate",
            "This metric is the percentage of backend stalls due to a pointer chase interlock - that is, the source of "
            "at least one interlock is a memory instruction, and the destination is the address of another memory "
            "instruction. Refer to `backend_mem_bound` and subsequent breakdown to check whether the interlock is "
            "likely affected by memory resources such as caches or TLBs, or is instead primarily affected by "
            "load-to-use latency.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_stall_interlock_vpu_bound_0 {
            {
                {std::uint16_t(0x00e6), 8},
                {std::uint16_t(0x0024), 2},
            },
            {
                metric_group_id_t::topdown_backend,
            },
            "backend_stall_interlock_vpu_bound",
            "Backend Stall VPU source interlock",
            "This metric is the percentage of backend stalls due to an interlock, where the source of at least one "
            "interlock is a VPU operation.",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t backend_stalled_cycles_0 {
            {
                {std::uint16_t(0x0024), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cycle_accounting,
            },
            "backend_stalled_cycles",
            "Backend Stalled Cycles",
            "This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit "
            "of the processor.",
            "percent",
            0,
            metric_priority_t::stall_cycles,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t bad_speculation_0 {
            {
                {std::uint16_t(0x003a), 2},
                {std::uint16_t(0x003f), 2},
                {std::uint16_t(0x003b), 2},
                {std::uint16_t(0x8162), 32},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "bad_speculation",
            "Bad Speculation",
            "This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline "
            "flush.\nThis indicates cycles that were utilized but inefficiently.",
            "percent",
            0,
            metric_priority_t::top_level,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t bad_speculation_1 {
            {
                {std::uint16_t(0x003a), 2},
                {std::uint16_t(0x003f), 2},
                {std::uint16_t(0x003b), 2},
                {std::uint16_t(0x0010), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "bad_speculation",
            "Bad Speculation",
            "This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline "
            "flush.\nThis indicates cycles that were utilized but inefficiently.",
            "percent",
            1,
            metric_priority_t::top_level,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t bad_speculation_2 {
            {
                {std::uint16_t(0x003a), 2},
                {std::uint16_t(0x003f), 2},
                {std::uint16_t(0x003b), 2},
                {std::uint16_t(0x0010), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "bad_speculation",
            "Bad Speculation",
            "This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline "
            "flush.\nThis indicates cycles that were utilized but inefficiently.",
            "percent",
            2,
            metric_priority_t::top_level,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t barrier_percentage_0 {
            {
                {std::uint16_t(0x007e), 2},
                {std::uint16_t(0x007d), 2},
                {std::uint16_t(0x001b), 2},
                {std::uint16_t(0x007c), 2},
            },
            {
                metric_group_id_t::operation_mix,
            },
            "barrier_percentage",
            "Barrier Operations Percentage",
            "This metric measures instruction and data barrier operations as a percentage of operations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t branch_direct_ratio_0 {
            {
                {std::uint16_t(0x0021), 4},
                {std::uint16_t(0x000d), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::branch_effectiveness,
            },
            "branch_direct_ratio",
            "Branch Direct Percentage",
            "This metric measures the ratio of direct branches retired to the total number of branches architecturally "
            "executed.",
            "percent",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t branch_indirect_ratio_0 {
            {
                {std::uint16_t(0x0021), 4},
                {std::uint16_t(0x811d), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::branch_effectiveness,
            },
            "branch_indirect_ratio",
            "Branch Indirect Percentage",
            "This metric measures the ratio of indirect branches retired, including function returns, to the total "
            "number of branches architecturally executed.",
            "percent",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t branch_misprediction_ratio_0 {
            {
                {std::uint16_t(0x0021), 4},
                {std::uint16_t(0x0022), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::branch_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "branch_misprediction_ratio",
            "Branch Misprediction Percentage",
            "This metric measures the ratio of branches mispredicted to the total number of branches architecturally "
            "executed. This gives an indication of the effectiveness of the branch prediction unit.",
            "percent",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t branch_mpki_0 {
            {
                {std::uint16_t(0x0008), 2},
                {std::uint16_t(0x0010), 16},
            },
            {
                metric_group_id_t::branch_effectiveness,
                metric_group_id_t::mpki,
            },
            "branch_mpki",
            "Branch MPKI",
            "This metric measures the number of branch mispredictions per thousand instructions executed",
            "misses",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t branch_mpki_1 {
            {
                {std::uint16_t(0x0022), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::branch_effectiveness,
                metric_group_id_t::mpki,
            },
            "branch_mpki",
            "Branch MPKI",
            "This metric measures the number of branch mispredictions per thousand instructions executed.",
            "misses",
            1,
            metric_priority_t::branch,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t branch_percentage_0 {
            {
                {std::uint16_t(0x0078), 8},
                {std::uint16_t(0x007a), 8},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::operation_mix,
            },
            "branch_percentage",
            "Branch Operations Percentage",
            "This metric measures branch operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t branch_percentage_1 {
            {
                {std::uint16_t(0x0076), 2},
                {std::uint16_t(0x001b), 2},
                {std::uint16_t(0x007c), 2},
            },
            {
                metric_group_id_t::operation_mix,
            },
            "branch_percentage",
            "Branch Operations Percentage",
            "This metric measures branch operations as a percentage of operations speculatively executed.",
            "percent",
            1,
            metric_priority_t::branch,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t branch_percentage_2 {
            {
                {std::uint16_t(0x0076), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::operation_mix,
            },
            "branch_percentage",
            "Branch Operations Percentage",
            "This metric measures branch operations as a percentage of operations speculatively executed.",
            "percent",
            2,
            metric_priority_t::branch,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t branch_port_utilization_0 {
            {
                {std::uint16_t(0x3000), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::port_utilization,
            },
            "branch_port_utilization",
            "Branch Execution Unit Utilization",
            "This metric measures the average number of branch operations executed per cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t branch_return_ratio_0 {
            {
                {std::uint16_t(0x0021), 4},
                {std::uint16_t(0x000e), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::branch_effectiveness,
            },
            "branch_return_ratio",
            "Branch Return Percentage",
            "This metric measures the ratio of branches retired that are function returns to the total number of "
            "branches architecturally executed.",
            "percent",
            0,
            metric_priority_t::branch,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t bus_access_average_count_0 {
            {
                {std::uint16_t(0x0061), 2},
                {std::uint16_t(0x818f), 2},
                {std::uint16_t(0x0060), 2},
            },
            {
                metric_group_id_t::bus_effectiveness,
            },
            "bus_access_average_count",
            "Bus Access Average Count",
            "This metric measures the average count of bus accesses taken for read and write requests made by this "
            "processor",
            "accesses",
            0,
            metric_priority_t::bus,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t bus_read_requests_average_latency_0 {
            {
                {std::uint16_t(0x8125), 2},
                {std::uint16_t(0x818d), 2},
            },
            {
                metric_group_id_t::average_latency,
                metric_group_id_t::bus_effectiveness,
            },
            "bus_read_requests_average_latency",
            "Bus Read Request Average Latency",
            "This metric measures the average latency of read requests made by this processor on the system bus in CPU "
            "cycles",
            "cycles",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cas_far_ratio_0 {
            {
                {std::uint16_t(0x8174), 2},
                {std::uint16_t(0x8172), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
            },
            "cas_far_ratio",
            "Compare and Swap Far Percentage",
            "This metric measures the ratio of compare and swap instructions that did not execute locally to the PE to "
            "the total compare and swap instructions.",
            "percent",
            0,
            metric_priority_t::cas,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cas_near_fail_ratio_0 {
            {
                {std::uint16_t(0x8172), 2},
                {std::uint16_t(0x8171), 8},
            },
            {
                metric_group_id_t::atomics_effectiveness,
            },
            "cas_near_fail_ratio",
            "Compare and Swap Near Fail Percentage",
            "This metric measures the ratio of failed compare and swap instructions speculatively executed locally to "
            "the PE that do not update the location accessed to the total near compare and swap instructions.",
            "percent",
            0,
            metric_priority_t::cas,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cas_near_pass_ratio_0 {
            {
                {std::uint16_t(0x8172), 2},
                {std::uint16_t(0x8171), 8},
            },
            {
                metric_group_id_t::atomics_effectiveness,
            },
            "cas_near_pass_ratio",
            "Compare and Swap Near Pass Percentage",
            "This metric measures the ratio of passed compare and swap instructions speculatively executed locally to "
            "the PE that updated the location accessed to the total near compare and swap instructions.",
            "percent",
            0,
            metric_priority_t::cas,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cas_near_ratio_0 {
            {
                {std::uint16_t(0x8174), 2},
                {std::uint16_t(0x8172), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
            },
            "cas_near_ratio",
            "Compare and Swap Near Percentage",
            "This metric measures the ratio of compare and swap instructions speculatively executed locally to the PE "
            "to the total compare and swap instructions.",
            "percent",
            0,
            metric_priority_t::cas,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_alloc_cycles_ratio_0 {
            {
                {std::uint16_t(0x3213), 2},
            },
            {
                metric_group_id_t::cycle_accounting,
            },
            "cme_alloc_cycles_ratio",
            "SME Allocation Cycles Percentage",
            "This metric is measures the ratio of cycles where the CPU had an SME allocated to it,\nsuch that the SME "
            "and Streaming SVE state of the CPU is held in that SME\nto the total number of CPU cycles.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t cme_alu_port_utilization_0 {
            {
                {std::uint16_t(0x3246), 2},
                {std::uint16_t(0x3260), 2},
            },
            {
                metric_group_id_t::cme_port_utilization,
            },
            "cme_alu_port_utilization",
            "SME Arithmetic EU Utilization",
            "This metric measures the average number of operations\nexecuted by the ALU execution unit per cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_arb_pending_ratio_0 {
            {
                {std::uint16_t(0x3214), 2},
            },
            {
                metric_group_id_t::cycle_accounting,
            },
            "cme_arb_pending_ratio",
            "SME Arbitration Pending Cycles Percentage",
            "This metric is measures the ratio of cycles where the CPU is in arbitration while attempting\nto access "
            "an SME to the total number of CPU cycles.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t cme_backend_bound_0 {
            {
                {std::uint16_t(0x324d), 2},
                {std::uint16_t(0x3246), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_topdown_l1,
            },
            "cme_backend_bound",
            "SME Backend Bound",
            "This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit "
            "of SME.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_backend_core_bound_0 {
            {
                {std::uint16_t(0x324d), 2},
                {std::uint16_t(0x324e), 8},
            },
            {
                metric_group_id_t::cme_topdown_backend,
            },
            "cme_backend_core_bound",
            "SME Backend Core Bound",
            "This metric is the percentage of total cycles stalled in the backend due to DP issue queues not accepting "
            "instructions.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_backend_mem_bound_0 {
            {
                {std::uint16_t(0x324f), 8},
                {std::uint16_t(0x324d), 2},
            },
            {
                metric_group_id_t::cme_topdown_backend,
            },
            "cme_backend_mem_bound",
            "SME Backend Memory Bound",
            "This metric is the percentage of total cycles stalled in the backend due to Load-Store issue queues not "
            "accepting instructions.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_backend_mem_cache_bound_0 {
            {
                {std::uint16_t(0x324f), 8},
                {std::uint16_t(0x3251), 32},
            },
            {
                metric_group_id_t::cme_topdown_backend,
            },
            "cme_backend_mem_cache_bound",
            "SME Backend Cache Bound",
            "This metric is the percentage of total cycles stalled in the backend for memory resource constraints, "
            "with the oldest instruction in at least one of the LS issue queues waiting for cache arbitration.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_backend_mem_store_bound_0 {
            {
                {std::uint16_t(0x324f), 8},
                {std::uint16_t(0x3252), 32},
            },
            {
                metric_group_id_t::cme_topdown_backend,
            },
            "cme_backend_mem_store_bound",
            "SME Backend Store Bound",
            "This metric is the percentage of total cycles stalled in the backend due to Load-Store issue queues not "
            "accepting instructions.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_backend_prefetch_bound_0 {
            {
                {std::uint16_t(0x324d), 2},
                {std::uint16_t(0x3250), 8},
            },
            {
                metric_group_id_t::cme_topdown_backend,
            },
            "cme_backend_prefetch_bound",
            "SME Backend Prefetch Bound",
            "This metric is the percentage of total cycles stalled in the backend due to hardware prefetcher issue "
            "queues not accepting instructions.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_bus_access_average_length_0 {
            {
                {std::uint16_t(0x3267), 2},
                {std::uint16_t(0x326b), 2},
            },
            {
                metric_group_id_t::cme_bus_effectiveness,
            },
            "cme_bus_access_average_length",
            "SME Bus Access Average Length",
            "This metric measures the average length of bus accesses taken for all the bus requests made by SME",
            "accesses",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_frontend_bound_0 {
            {
                {std::uint16_t(0x3246), 2},
                {std::uint16_t(0x324a), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_topdown_l1,
            },
            "cme_frontend_bound",
            "SME Frontend Bound",
            "This metric is the percentage of cycles that were stalled due to resource constraints in the frontend "
            "unit of SME.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_frontend_cpu_bound_0 {
            {
                {std::uint16_t(0x324a), 2},
                {std::uint16_t(0x324b), 8},
            },
            {
                metric_group_id_t::cme_topdown_frontend,
            },
            "cme_frontend_cpu_bound",
            "SME Frontend CPU Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to frontend core resource "
            "constraints not related to instruction fetch latency issues caused by no instructions sent by CPU.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_frontend_other_bound_0 {
            {
                {std::uint16_t(0x324a), 2},
                {std::uint16_t(0x324c), 8},
            },
            {
                metric_group_id_t::cme_topdown_frontend,
            },
            "cme_frontend_other_bound",
            "SME Frontend Other CPU Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to frontend core resource "
            "constraints not related to instruction fetch latency issues caused by no instructions sent by CPU.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_ipc_0 {
            {
                {std::uint16_t(0x3247), 2},
                {std::uint16_t(0x3246), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_general,
            },
            "cme_ipc",
            "SME IPC",
            "This metric measures the number of SME instructions retired per SME cycles.",
            "instructions",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_iq_dp0_stall_percentage_0 {
            {
                {std::uint16_t(0x325d), 8},
                {std::uint16_t(0x324d), 2},
            },
            {
                metric_group_id_t::cme_iq_effectiveness,
            },
            "cme_iq_dp0_stall_percentage",
            "IQ DP0 Stall Percentage",
            "This metric measures the percentage of backend stall cycles\nwhere at least one operation is waiting to "
            "issue to the\nissue queue DP0, but it is full.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_iq_dp1_stall_percentage_0 {
            {
                {std::uint16_t(0x324d), 2},
                {std::uint16_t(0x325e), 8},
            },
            {
                metric_group_id_t::cme_iq_effectiveness,
            },
            "cme_iq_dp1_stall_percentage",
            "IQ DP1 Stall Percentage",
            "This metric measures the percentage of backend stall cycles\nwhere at least one operation is waiting to "
            "issue to the\nissue queue DP1, but it is full.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_iq_load_stall_percentage_0 {
            {
                {std::uint16_t(0x325f), 8},
                {std::uint16_t(0x324d), 2},
            },
            {
                metric_group_id_t::cme_iq_effectiveness,
            },
            "cme_iq_load_stall_percentage",
            "IQ Load Stall Percentage",
            "This metric measures the percentage of backend stall cycles\nwhere at least one operation is waiting to "
            "issue to the\nissue queue LD, but it is full.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_l1_prefetcher_accuracy_0 {
            {
                {std::uint16_t(0x32b2), 2},
                {std::uint16_t(0x32ad), 2},
                {std::uint16_t(0x3274), 2},
            },
            {
                metric_group_id_t::cme_prefetcher_effectiveness,
            },
            "cme_l1_prefetcher_accuracy",
            "SME L1D Cache Prefetcher Accuracy",
            "This metric measures SME L1D cache prefetcher accuracy",
            "prefetches",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_l1_prefetcher_coverage_0 {
            {
                {std::uint16_t(0x3281), 2},
                {std::uint16_t(0x32ad), 2},
                {std::uint16_t(0x3274), 2},
                {std::uint16_t(0x3280), 2},
            },
            {
                metric_group_id_t::cme_prefetcher_effectiveness,
            },
            "cme_l1_prefetcher_coverage",
            "SME L1D Cache Prefetcher Coverage",
            "This metric measures L1D cache prefetcher coverage",
            "prefetches",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_l1_prefetcher_timeliness_0 {
            {
                {std::uint16_t(0x32ad), 2},
                {std::uint16_t(0x3274), 2},
            },
            {
                metric_group_id_t::cme_prefetcher_effectiveness,
            },
            "cme_l1_prefetcher_timeliness",
            "SME L1D Cache Prefetcher Timeliness",
            "This metric measures SME L1D cache prefetcher timeliness",
            "prefetches",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_l1d_cache_hit_ratio_0 {
            {
                {std::uint16_t(0x326f), 4},
                {std::uint16_t(0x3270), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_l1d_cache_effectiveness,
                metric_group_id_t::cme_miss_ratio,
            },
            "cme_l1d_cache_hit_ratio",
            "SME L1D Cache Hit Percentage",
            "This metric measures the ratio of level 1 data cache access hits to the total number of level 1 data "
            "cache accesses. This gives an indication of the effectiveness of the level 1 data cache.",
            "percent",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_l1d_cache_miss_ratio_0 {
            {
                {std::uint16_t(0x326f), 4},
                {std::uint16_t(0x327c), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_l1d_cache_effectiveness,
                metric_group_id_t::cme_miss_ratio,
            },
            "cme_l1d_cache_miss_ratio",
            "SME L1D Cache Miss Percentage",
            "This metric measures the ratio of SME level 1 data cache accesses missed to the total number of level 1 "
            "data cache accesses. This gives an indication of the effectiveness of the level 1 data cache.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_l1d_cache_mpki_0 {
            {
                {std::uint16_t(0x327c), 4},
                {std::uint16_t(0x3247), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_l1d_cache_effectiveness,
                metric_group_id_t::cme_mpki,
            },
            "cme_l1d_cache_mpki",
            "SME L1D Cache MPKI",
            "This metric measures the number of SME level 1 data cache accesses missed per thousand SME instructions "
            "executed.",
            "misses",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_l3d_cache_hit_ratio_0 {
            {
                {std::uint16_t(0x3287), 4},
                {std::uint16_t(0x328e), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_l3d_cache_effectiveness,
                metric_group_id_t::cme_miss_ratio,
            },
            "cme_l3d_cache_hit_ratio",
            "SME L3D Cache Hit Percentage",
            "This metric measures the ratio of SME level 3 cache access hits to the total number of level 3 cache "
            "accesses, requested by the SME.",
            "percent",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_l3d_cache_miss_ratio_0 {
            {
                {std::uint16_t(0x3287), 4},
                {std::uint16_t(0x3290), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_l3d_cache_effectiveness,
                metric_group_id_t::cme_miss_ratio,
            },
            "cme_l3d_cache_miss_ratio",
            "SME L3D Cache Miss Percentage",
            "This metric measures the ratio of SME level 3 cache accesses missed to the total number of level 3 cache "
            "accesses, requested by the SME.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_l3d_cache_mpki_0 {
            {
                {std::uint16_t(0x3247), 2},
                {std::uint16_t(0x3290), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_l3d_cache_effectiveness,
                metric_group_id_t::cme_mpki,
            },
            "cme_l3d_cache_mpki",
            "SME L3D Cache MPKI",
            "This metric measures the number of SME level 3 cache accesses missed per thousand SME instructions "
            "executed.",
            "misses",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_ll_cache_read_hit_ratio_0 {
            {
                {std::uint16_t(0x3295), 16},
                {std::uint16_t(0x3294), 4},
            },
            {
                metric_group_id_t::cme_ll_cache_effectiveness,
            },
            "cme_ll_cache_read_hit_ratio",
            "SME LL Cache Read Hit Percentage",
            "This metric measures the ratio of SME last level cache read accesses hit in the cache to the total number "
            "of SME last level cache accesses.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_ll_cache_read_miss_ratio_0 {
            {
                {std::uint16_t(0x3295), 16},
                {std::uint16_t(0x3294), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_ll_cache_effectiveness,
                metric_group_id_t::cme_miss_ratio,
            },
            "cme_ll_cache_read_miss_ratio",
            "SME LL Cache Read Miss Percentage",
            "This metric measures the ratio of SME last level cache read accesses missed to the total number of last "
            "level cache accesses requested by the SME.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_ll_cache_read_mpki_0 {
            {
                {std::uint16_t(0x3295), 16},
                {std::uint16_t(0x3247), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_ll_cache_effectiveness,
                metric_group_id_t::cme_mpki,
            },
            "cme_ll_cache_read_mpki",
            "SME LL Cache Read MPKI",
            "This metric measures the number of SME last level cache read accesses missed per SME thousand "
            "instructions executed.",
            "misses",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_load_percentage_0 {
            {
                {std::uint16_t(0x3254), 2},
                {std::uint16_t(0x3247), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "cme_load_percentage",
            "SME Load Operations Percentage",
            "This metric measures SME load operations as a percentage of SME operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_mac_port_utilization_0 {
            {
                {std::uint16_t(0x3261), 2},
                {std::uint16_t(0x3246), 2},
            },
            {
                metric_group_id_t::cme_port_utilization,
            },
            "cme_mac_port_utilization",
            "SME MAC EU Utilization",
            "This metric measures the average number of operations\nexecuted by the MAC execution unit per cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_mmdp_port_utilization_0 {
            {
                {std::uint16_t(0x3246), 2},
                {std::uint16_t(0x3264), 2},
            },
            {
                metric_group_id_t::cme_port_utilization,
            },
            "cme_mmdp_port_utilization",
            "Matmul Datapath EU Utilization",
            "This metric measures the average number of operations\nexecuted by the Matmul data path execution unit "
            "per cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_mmmv_port_utilization_0 {
            {
                {std::uint16_t(0x3265), 2},
                {std::uint16_t(0x3246), 2},
            },
            {
                metric_group_id_t::cme_port_utilization,
            },
            "cme_mmmv_port_utilization",
            "Matmul Move EU Utilization",
            "This metric measures the average number of operations\nexecuted by the Matmul move execution unit per "
            "cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_perm_port_utilization_0 {
            {
                {std::uint16_t(0x3262), 2},
                {std::uint16_t(0x3246), 2},
            },
            {
                metric_group_id_t::cme_port_utilization,
            },
            "cme_perm_port_utilization",
            "Permute EU Utilization",
            "This metric measures the average number of operations\nexecuted by the permute execution unit per cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_retiring_0 {
            {
                {std::uint16_t(0x324d), 2},
                {std::uint16_t(0x3246), 2},
                {std::uint16_t(0x324a), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_topdown_l1,
            },
            "cme_retiring",
            "SME Retiring",
            "This metric is the percentage of cycles that were not stalled for any reason.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_st_port_utilization_0 {
            {
                {std::uint16_t(0x3263), 2},
                {std::uint16_t(0x3246), 2},
            },
            {
                metric_group_id_t::cme_port_utilization,
            },
            "cme_st_port_utilization",
            "Store EU Utilization",
            "This metric measures the average number of operations\nexecuted by the store execution unit per cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_store_percentage_0 {
            {
                {std::uint16_t(0x3259), 2},
                {std::uint16_t(0x3247), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "cme_store_percentage",
            "SME Store Operations Percentage",
            "This metric measures store operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_system_dram_mem_hit_ratio_0 {
            {
                {std::uint16_t(0x327c), 4},
                {std::uint16_t(0x32ac), 16},
            },
            {
                metric_group_id_t::cme_system_memory_effectiveness,
            },
            "cme_system_dram_mem_hit_ratio",
            "SME System DRAM Hit Percentage",
            "This metric measures the ratio of DRAM hits to the total memory accesses that missed in the private L1 "
            "cache of SME. This metric indicates that the workload is memory bound obtaining data from the local DRAM.",
            "percent",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_system_l3d_cache_hit_ratio_0 {
            {
                {std::uint16_t(0x327c), 4},
                {std::uint16_t(0x328e), 16},
            },
            {
                metric_group_id_t::cme_system_memory_effectiveness,
            },
            "cme_system_l3d_cache_hit_ratio",
            "SME System L3D Cache Hit Percentage",
            "This metric measures the ratio of L3 cache hits to the total memory accesses that missed in the private "
            "L1 cache of SME. This metric indicates that the workload is memory bound obtaining data from L3 cache.",
            "percent",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cme_system_ll_cache_hit_ratio_0 {
            {
                {std::uint16_t(0x327c), 4},
                {std::uint16_t(0x3296), 16},
            },
            {
                metric_group_id_t::cme_system_memory_effectiveness,
            },
            "cme_system_ll_cache_hit_ratio",
            "SME System Last Level Cache Hit Percentage",
            "This metric measures the ratio of Last level cache hits to the total memory accesses that missed in the "
            "private L1 cache of SME. This metric indicates that the workload is memory bound obtaining data from LL "
            "cache.",
            "percent",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t cpi_0 {
            {
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::general,
            },
            "cpi",
            "Cycles Per Instruction",
            "This metric measures the number of cycles per instructions retired",
            "cycles",
            0,
            metric_priority_t::top_level,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t crypto_percentage_0 {
            {
                {std::uint16_t(0x001b), 2},
                {std::uint16_t(0x0077), 2},
            },
            {
                metric_group_id_t::operation_mix,
            },
            "crypto_percentage",
            "Crypto Operations Percentage",
            "This metric measures crypto operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t dtlb_mpki_0 {
            {
                {std::uint16_t(0x0008), 2},
                {std::uint16_t(0x0034), 16},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::mpki,
            },
            "dtlb_mpki",
            "DTLB MPKI",
            "This metric measures the number of data TLB Walks per thousand instructions executed.",
            "misses",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_average_depth_0 {
            {
                {std::uint16_t(0x8136), 2},
                {std::uint16_t(0x0034), 16},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
            },
            "dtlb_walk_average_depth",
            "DTLB Walk Average Depth of Accesses",
            "This metric measures the average depth of the data TLB walks for a data TLB refill",
            "accesses",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_average_latency_0 {
            {
                {std::uint16_t(0x8128), 2},
                {std::uint16_t(0x0034), 16},
            },
            {
                metric_group_id_t::average_latency,
                metric_group_id_t::dtlb_effectiveness,
            },
            "dtlb_walk_average_latency",
            "DTLB Walk Average Latency",
            "This metric measures the average latency of data TLB walks in CPU cycles",
            "cycles",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_block_ratio_0 {
            {
                {std::uint16_t(0x8188), 16},
                {std::uint16_t(0x0025), 4},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
            },
            "dtlb_walk_block_ratio",
            "DTLB Walk Block Percentage",
            "This metric measures the ratio of data TLB Walks that returned a block to the total number of data TLB "
            "accesses. Block size is any memory block larger than the page granule size set by the system.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_large_ratio_0 {
            {
                {std::uint16_t(0x8138), 16},
                {std::uint16_t(0x0025), 4},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
            },
            "dtlb_walk_large_ratio",
            "DTLB Walk Large Page Percentage",
            "This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB "
            "accesses.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_page_ratio_0 {
            {
                {std::uint16_t(0x818a), 16},
                {std::uint16_t(0x0025), 4},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
            },
            "dtlb_walk_page_ratio",
            "DTLB Walk Page Percentage",
            "This metric measures the ratio of data TLB Walks that returned a page to the total number of data TLB "
            "accesses. Page size is determined by the page granule size set by the system.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_ratio_0 {
            {
                {std::uint16_t(0x0025), 4},
                {std::uint16_t(0x0034), 16},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "dtlb_walk_ratio",
            "DTLB Walk Percentage",
            "This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an "
            "indication of the effectiveness of the data TLB accesses.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t dtlb_walk_small_ratio_0 {
            {
                {std::uint16_t(0x813a), 16},
                {std::uint16_t(0x0025), 4},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
            },
            "dtlb_walk_small_ratio",
            "DTLB Walk Small Page Percentage",
            "This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB "
            "accesses.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t fp16_percentage_0 {
            {
                {std::uint16_t(0x8014), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::fp_precision_mix,
            },
            "fp16_percentage",
            "Half Precision Floating Point Percentage",
            "This metric measures half-precision floating point operations as a percentage of operations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t fp32_percentage_0 {
            {
                {std::uint16_t(0x8018), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::fp_precision_mix,
            },
            "fp32_percentage",
            "Single Precision Floating Point Percentage",
            "This metric measures single-precision floating point operations as a percentage of operations "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t fp64_percentage_0 {
            {
                {std::uint16_t(0x001b), 2},
                {std::uint16_t(0x801c), 2},
            },
            {
                metric_group_id_t::fp_precision_mix,
            },
            "fp64_percentage",
            "Double Precision Floating Point Percentage",
            "This metric measures double-precision floating point operations as a percentage of operations "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t fp_ops_per_cycle_0 {
            {
                {std::uint16_t(0x80c0), 2},
                {std::uint16_t(0x80c1), 2},
            },
            {
                metric_group_id_t::fp_arithmetic_intensity,
            },
            "fp_ops_per_cycle",
            "Floating Point Operations per Cycle",
            "This metric measures floating point operations per cycle in any precision performed by any instruction. "
            "Operations are counted by computation and by vector lanes, fused computations such as multiply-add count "
            "as twice per vector lane for example.",
            "operations",
            0,
            metric_priority_t::numeric,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t frontend_bound_0 {
            {
                {std::uint16_t(0x003e), 2},
                {std::uint16_t(0x8162), 32},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "frontend_bound",
            "Frontend Bound",
            "This metric is the percentage of total slots that were stalled due to resource constraints in the "
            "frontend of the processor.",
            "percent",
            0,
            metric_priority_t::boundness,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t frontend_bound_1 {
            {
                {std::uint16_t(0x003e), 2},
                {std::uint16_t(0x0010), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "frontend_bound",
            "Frontend Bound",
            "This metric is the percentage of total slots that were stalled due to resource constraints in the "
            "frontend of the processor.",
            "percent",
            1,
            metric_priority_t::boundness,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t frontend_bound_2 {
            {
                {std::uint16_t(0x003e), 2},
                {std::uint16_t(0x0010), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "frontend_bound",
            "Frontend Bound",
            "This metric is the percentage of total slots that were stalled due to resource constraints in the "
            "frontend of the processor.",
            "percent",
            2,
            metric_priority_t::boundness,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t frontend_cache_l1i_bound_0 {
            {
                {std::uint16_t(0x8159), 32},
                {std::uint16_t(0x815b), 32},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_cache_l1i_bound",
            "Frontend Cache L1I Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues "
            "caused by level 1 instruction cache misses.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_cache_l2i_bound_0 {
            {
                {std::uint16_t(0x8159), 32},
                {std::uint16_t(0x815b), 32},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_cache_l2i_bound",
            "Frontend Cache L2I Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues "
            "caused by level 2 instruction cache misses.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_core_bound_0 {
            {
                {std::uint16_t(0x8160), 8},
                {std::uint16_t(0x0023), 2},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_core_bound",
            "Frontend Core Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to frontend core resource "
            "constraints not related to instruction fetch latency issues caused by memory access components.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_core_flow_bound_0 {
            {
                {std::uint16_t(0x8161), 32},
                {std::uint16_t(0x8160), 8},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_core_flow_bound",
            "Frontend Core Flow Bound",
            "This metric is the percentage of total cycles stalled in the frontend as the decode unit is awaiting "
            "input from the branch prediction unit.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_core_flush_bound_0 {
            {
                {std::uint16_t(0x8160), 8},
                {std::uint16_t(0x8162), 32},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_core_flush_bound",
            "Frontend Core Flush Bound",
            "This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from "
            "a pipeline flush caused by bad speculation or other machine resteers.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_core_flush_machine_clear_bound_0 {
            {
                {std::uint16_t(0x8162), 32},
                {std::uint16_t(0x3006), 128},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_core_flush_machine_clear_bound",
            "Frontend Core Flush Machine Clear Bound",
            "This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from "
            "a pipeline flush caused by machine resteers other than bad speculation.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_core_flush_resteer_bound_0 {
            {
                {std::uint16_t(0x3007), 128},
                {std::uint16_t(0x8162), 32},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_core_flush_resteer_bound",
            "Frontend Core Flush Branch Resteer Bound",
            "This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from "
            "a pipeline flush caused by bad speculation.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_core_spec_throttle_bound_0 {
            {
                {std::uint16_t(0x3005), 2},
                {std::uint16_t(0x8160), 8},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_core_spec_throttle_bound",
            "Frontend Core Specuation Throttle Bound",
            "This metric is the percentage of total cycles stalled in the frontend as the processor is stalling due to "
            "power throttling linked to low confidence branches",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_mem_bound_0 {
            {
                {std::uint16_t(0x8158), 8},
                {std::uint16_t(0x0023), 2},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_mem_bound",
            "Frontend Memory Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to frontend core resource "
            "constraints related to the instruction fetch latency issues caused by memory access components.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_mem_cache_bound_0 {
            {
                {std::uint16_t(0x8158), 8},
                {std::uint16_t(0x8159), 32},
                {std::uint16_t(0x815b), 32},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_mem_cache_bound",
            "Frontend Mem Cache Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency "
            "issues caused by instruction cache misses.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_mem_tlb_bound_0 {
            {
                {std::uint16_t(0x815c), 32},
                {std::uint16_t(0x8158), 8},
            },
            {
                metric_group_id_t::topdown_frontend,
            },
            "frontend_mem_tlb_bound",
            "Frontend Mem TLB Bound",
            "This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency "
            "issues caused by instruction TLB misses.",
            "percent",
            0,
            metric_priority_t::frontend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t frontend_stalled_cycles_0 {
            {
                {std::uint16_t(0x0023), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cycle_accounting,
            },
            "frontend_stalled_cycles",
            "Frontend Stalled Cycles",
            "This metric is the percentage of cycles that were stalled due to resource constraints in the frontend "
            "unit of the processor.",
            "percent",
            0,
            metric_priority_t::stall_cycles,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t instruction_fetch_average_latency_0 {
            {
                {std::uint16_t(0x8120), 2},
                {std::uint16_t(0x8124), 2},
            },
            {
                metric_group_id_t::average_latency,
            },
            "instruction_fetch_average_latency",
            "Instruction Fetch Average Latency",
            "This metric measures the average latency of instruction fetches in CPU cycles",
            "cycles",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t int_port_utilization_0 {
            {
                {std::uint16_t(0x3001), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::port_utilization,
            },
            "int_port_utilization",
            "Integer Execution Unit Utilization",
            "This metric measures the average number of integer operations executed per cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t integer_dp_percentage_0 {
            {
                {std::uint16_t(0x007d), 2},
                {std::uint16_t(0x0073), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
            "integer_dp_percentage",
            "Integer Operations Percentage",
            "This metric measures scalar integer operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t integer_dp_percentage_1 {
            {
                {std::uint16_t(0x0073), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
            "integer_dp_percentage",
            "Integer Operations Percentage",
            "This metric measures scalar integer operations as a percentage of operations speculatively executed.",
            "percent",
            1,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t ipc_0 {
            {
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::general,
            },
            "ipc",
            "Instructions Per Cycle",
            "This metric measures the number of instructions retired per cycle.",
            "instructions",
            0,
            metric_priority_t::top_level,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t iq_stall_lsu_percentage_0 {
            {
                {std::uint16_t(0x015e), 32},
                {std::uint16_t(0x816b), 8},
            },
            {
                metric_group_id_t::iq_effectiveness,
            },
            "iq_stall_lsu_percentage",
            "Load/Store IQ Stall Percentage",
            "This metric measures the percentage of backend stall cycles where the oldest operation was a load or "
            "store operation",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t iq_stall_mx_percentage_0 {
            {
                {std::uint16_t(0x015d), 32},
                {std::uint16_t(0x816b), 8},
            },
            {
                metric_group_id_t::iq_effectiveness,
            },
            "iq_stall_mx_percentage",
            "Integer MX IQ Stall Percentage",
            "This metric measures the percentage of backend stall cycles where the oldest operation was an integer "
            "operation",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t iq_stall_sx_percentage_0 {
            {
                {std::uint16_t(0x816b), 8},
                {std::uint16_t(0x015c), 32},
            },
            {
                metric_group_id_t::iq_effectiveness,
            },
            "iq_stall_sx_percentage",
            "Integer SX IQ Stall Percentage",
            "This metric measures the percentage of backend stall cycles where the oldest operation was an integer "
            "operation",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t iq_stall_vpu_percentage_0 {
            {
                {std::uint16_t(0x816b), 8},
                {std::uint16_t(0x015f), 32},
            },
            {
                metric_group_id_t::iq_effectiveness,
            },
            "iq_stall_vpu_percentage",
            "Vector IQ Stall Percentage",
            "This metric measures the percentage of backend stall cycles where the oldest operation was a vector "
            "operation",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t itlb_mpki_0 {
            {
                {std::uint16_t(0x0035), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::mpki,
            },
            "itlb_mpki",
            "ITLB MPKI",
            "This metric measures the number of instruction TLB Walks per thousand instructions executed.",
            "misses",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_average_depth_0 {
            {
                {std::uint16_t(0x0035), 16},
                {std::uint16_t(0x8137), 2},
            },
            {
                metric_group_id_t::itlb_effectiveness,
            },
            "itlb_walk_average_depth",
            "ITLB Walk Average Depth of Accesses",
            "This metric measures the average depth of the instruction TLB walks for an instruction TLB refill",
            "accesses",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_average_latency_0 {
            {
                {std::uint16_t(0x0035), 16},
                {std::uint16_t(0x8129), 2},
            },
            {
                metric_group_id_t::average_latency,
                metric_group_id_t::itlb_effectiveness,
            },
            "itlb_walk_average_latency",
            "ITLB Walk Average Latency",
            "This metric measures the average latency of instruction TLB walks in CPU cycles",
            "cycles",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_block_ratio_0 {
            {
                {std::uint16_t(0x0026), 4},
                {std::uint16_t(0x8189), 16},
            },
            {
                metric_group_id_t::itlb_effectiveness,
            },
            "itlb_walk_block_ratio",
            "ITLB Walk Block Percentage",
            "This metric measures the ratio of instruction TLB Walks that returned a block to the total number of "
            "instruction TLB accesses. Block size is any memory block larger than the page granule size set by the "
            "system.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_large_ratio_0 {
            {
                {std::uint16_t(0x8139), 16},
                {std::uint16_t(0x0026), 4},
            },
            {
                metric_group_id_t::itlb_effectiveness,
            },
            "itlb_walk_large_ratio",
            "ITLB Walk Large Page Percentage",
            "This metric measures the ratio of instruction TLB Walks that returned large page to the total number of "
            "instruction TLB accesses.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_page_ratio_0 {
            {
                {std::uint16_t(0x818b), 16},
                {std::uint16_t(0x0026), 4},
            },
            {
                metric_group_id_t::itlb_effectiveness,
            },
            "itlb_walk_page_ratio",
            "ITLB Walk Page Percentage",
            "This metric measures the ratio of instruction TLB Walks that returned a page to the total number of "
            "instruction TLB accesses. Page size is determined by the page granule size set by the system.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_ratio_0 {
            {
                {std::uint16_t(0x0035), 16},
                {std::uint16_t(0x0026), 4},
            },
            {
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "itlb_walk_ratio",
            "ITLB Walk Percentage",
            "This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. "
            "This gives an indication of the effectiveness of the instruction TLB accesses.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t itlb_walk_small_ratio_0 {
            {
                {std::uint16_t(0x813b), 16},
                {std::uint16_t(0x0026), 4},
            },
            {
                metric_group_id_t::itlb_effectiveness,
            },
            "itlb_walk_small_ratio",
            "ITLB Walk Small Page Percentage",
            "This metric measures the ratio of instruction TLB Walks that returned large page to the total number of "
            "instruction TLB accesses.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1_prefetcher_accuracy_0 {
            {
                {std::uint16_t(0x81ec), 2},
                {std::uint16_t(0x81bc), 2},
                {std::uint16_t(0x826c), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l1_prefetcher_accuracy",
            "L1D Prefetcher Accuracy",
            "This metric measures L1D cache prefetcher accuracy",
            "prefetches",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1_prefetcher_accuracy_1 {
            {
                {std::uint16_t(0x81ec), 2},
                {std::uint16_t(0x81bc), 2},
                {std::uint16_t(0x826c), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l1_prefetcher_accuracy",
            "L1D Prefetcher Accuracy",
            "This metric measures L1D cache prefetcher accuracy",
            "prefetches",
            1,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1_prefetcher_coverage_0 {
            {
                {std::uint16_t(0x81ec), 2},
                {std::uint16_t(0x0042), 16},
                {std::uint16_t(0x0043), 16},
                {std::uint16_t(0x826c), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l1_prefetcher_coverage",
            "L1D Prefetcher Coverage",
            "This metric measures L1D cache prefetcher coverage",
            "prefetches",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1_prefetcher_timeliness_0 {
            {
                {std::uint16_t(0x81ec), 2},
                {std::uint16_t(0x826c), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l1_prefetcher_timeliness",
            "L1D Prefetcher Timeliness",
            "This metric measures L1D cache prefetcher timeliness",
            "prefetches",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1d_cache_demand_mpki_0 {
            {
                {std::uint16_t(0x0042), 16},
                {std::uint16_t(0x0008), 2},
                {std::uint16_t(0x0043), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1d_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l1d_cache_demand_mpki",
            "L1D Cache Demand MPKI",
            "This metric measures the number of level 1 data cache accesses missed per thousand instructions executed.",
            "misses",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1d_cache_miss_ratio_0 {
            {
                {std::uint16_t(0x0042), 16},
                {std::uint16_t(0x8140), 4},
                {std::uint16_t(0x0043), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1d_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l1d_cache_miss_ratio",
            "L1D Cache Miss Percentage",
            "This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data "
            "cache accesses. This gives an indication of the effectiveness of the level 1 data cache.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1d_cache_miss_ratio_1 {
            {
                {std::uint16_t(0x0003), 16},
                {std::uint16_t(0x0004), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1d_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l1d_cache_miss_ratio",
            "L1D Cache Miss Percentage",
            "This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data "
            "cache accesses. This gives an indication of the effectiveness of the level 1 data cache.",
            "percent",
            1,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1d_cache_mpki_0 {
            {
                {std::uint16_t(0x0042), 16},
                {std::uint16_t(0x0008), 2},
                {std::uint16_t(0x0043), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1d_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l1d_cache_mpki",
            "L1D Cache MPKI",
            "This metric measures the number of level 1 data cache accesses missed per thousand instructions executed.",
            "misses",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1d_cache_mpki_1 {
            {
                {std::uint16_t(0x0008), 2},
                {std::uint16_t(0x0003), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1d_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l1d_cache_mpki",
            "L1D Cache MPKI",
            "This metric measures the number of level 1 data cache accesses missed per thousand instructions executed.",
            "misses",
            1,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1d_tlb_miss_ratio_0 {
            {
                {std::uint16_t(0x0005), 16},
                {std::uint16_t(0x0025), 4},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l1d_tlb_miss_ratio",
            "L1 Data TLB Miss Percentage",
            "This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data "
            "TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB.",
            "percent",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1d_tlb_mpki_0 {
            {
                {std::uint16_t(0x0005), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::mpki,
            },
            "l1d_tlb_mpki",
            "L1 Data TLB MPKI",
            "This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed.",
            "misses",
            0,
            metric_priority_t::data,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1i_cache_miss_ratio_0 {
            {
                {std::uint16_t(0x0001), 16},
                {std::uint16_t(0x0014), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1i_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l1i_cache_miss_ratio",
            "L1I Cache Miss Percentage",
            "This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level "
            "1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction "
            "cache.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1i_cache_mpki_0 {
            {
                {std::uint16_t(0x0001), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l1i_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l1i_cache_mpki",
            "L1I Cache MPKI",
            "This metric measures the number of level 1 instruction cache accesses missed per thousand instructions "
            "executed.",
            "misses",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1i_tlb_miss_ratio_0 {
            {
                {std::uint16_t(0x0002), 16},
                {std::uint16_t(0x0026), 4},
            },
            {
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l1i_tlb_miss_ratio",
            "L1 Instruction TLB Miss Percentage",
            "This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 "
            "instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB.",
            "percent",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l1i_tlb_mpki_0 {
            {
                {std::uint16_t(0x0002), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::mpki,
            },
            "l1i_tlb_mpki",
            "L1 Instruction TLB MPKI",
            "This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions "
            "executed.",
            "misses",
            0,
            metric_priority_t::instruction,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_cache_miss_ratio_0 {
            {
                {std::uint16_t(0x0052), 16},
                {std::uint16_t(0x0053), 16},
                {std::uint16_t(0x8148), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l2_cache_miss_ratio",
            "L2 Cache Miss Percentage",
            "This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache "
            "accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache "
            "that stores both data and instruction. Note that cache accesses in this cache are either data memory "
            "access or instruction fetch as this is a unified cache.",
            "percent",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_cache_miss_ratio_1 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x0016), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l2_cache_miss_ratio",
            "L2 Cache Miss Percentage",
            "This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache "
            "accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache "
            "that stores both data and instruction. Note that cache accesses in this cache are either data memory "
            "access or instruction fetch as this is a unified cache.",
            "percent",
            1,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_cache_mpki_0 {
            {
                {std::uint16_t(0x0052), 16},
                {std::uint16_t(0x0008), 2},
                {std::uint16_t(0x0053), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l2_cache_mpki",
            "L2 Cache MPKI",
            "This metric measures the number of level 2 unified cache accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_cache_mpki_1 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l2_cache_mpki",
            "L2 Cache MPKI",
            "This metric measures the number of level 2 unified cache accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            1,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_prefetcher_accuracy_l1hwprf_exclusive_0 {
            {
                {std::uint16_t(0x81ed), 2},
                {std::uint16_t(0x81bd), 2},
                {std::uint16_t(0x826d), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l2_prefetcher_accuracy_l1hwprf_exclusive",
            "L2 Cache Prefetcher Accuracy (L1 HW prefetch exclusive)",
            "This metric measures L2D cache prefetcher accuracy excluding L1 hardware prefetch requests",
            "prefetches",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_prefetcher_accuracy_l1hwprf_exclusive_1 {
            {
                {std::uint16_t(0x81ed), 2},
                {std::uint16_t(0x81bd), 2},
                {std::uint16_t(0x826d), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l2_prefetcher_accuracy_l1hwprf_exclusive",
            "L2 Cache Prefetcher Accuracy (L1 HW prefetch exclusive)",
            "This metric measures L2D cache prefetcher accuracy excluding L1 hardware prefetch requests",
            "prefetches",
            1,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_prefetcher_accuracy_l1hwprf_inclusive_0 {
            {
                {std::uint16_t(0x0179), 2},
                {std::uint16_t(0x010b), 2},
                {std::uint16_t(0x81bd), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l2_prefetcher_accuracy_l1hwprf_inclusive",
            "L2 Cache Prefetcher Accuracy (L1 HW prefetch inclusive)",
            "This metric measures L2D cache prefetcher accuracy treating L1 hardware prefetches as demand requests",
            "prefetches",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_prefetcher_accuracy_l1hwprf_inclusive_1 {
            {
                {std::uint16_t(0x0179), 2},
                {std::uint16_t(0x010b), 2},
                {std::uint16_t(0x81bd), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l2_prefetcher_accuracy_l1hwprf_inclusive",
            "L2 Cache Prefetcher Accuracy (L1 HW prefetch inclusive)",
            "This metric measures L2D cache prefetcher accuracy treating L1 hardware prefetches as demand requests",
            "prefetches",
            1,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_prefetcher_coverage_l1hwprf_exclusive_0 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x01b9), 2},
                {std::uint16_t(0x81ed), 2},
                {std::uint16_t(0x81bd), 2},
                {std::uint16_t(0x826d), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l2_prefetcher_coverage_l1hwprf_exclusive",
            "L2 Cache Prefetcher Coverage (L1 HW prefetch exclusive)",
            "This metric measures L2D cache prefetcher coverage excluding L1 hardware prefetch requests",
            "prefetches",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_prefetcher_coverage_l1hwprf_exclusive_1 {
            {
                {std::uint16_t(0x0052), 16},
                {std::uint16_t(0x81ed), 2},
                {std::uint16_t(0x0053), 16},
                {std::uint16_t(0x826d), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l2_prefetcher_coverage_l1hwprf_exclusive",
            "L2 Cache Prefetcher Coverage (L1 HW prefetch exclusive)",
            "This metric measures L2D cache prefetcher coverage excluding L1 hardware prefetch requests",
            "prefetches",
            1,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_prefetcher_coverage_l1hwprf_inclusive_0 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x0179), 2},
                {std::uint16_t(0x010b), 2},
                {std::uint16_t(0x81bd), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l2_prefetcher_coverage_l1hwprf_inclusive",
            "L2 Cache Prefetcher Coverage (L1 HW prefetch inclusive)",
            "This metric measures L2D cache prefetcher coverage treating L1 hardware prefetches as demand requests",
            "prefetches",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_prefetcher_timeliness_l1hwprf_exclusive_0 {
            {
                {std::uint16_t(0x81ed), 2},
                {std::uint16_t(0x826d), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l2_prefetcher_timeliness_l1hwprf_exclusive",
            "L2 Cache Prefetcher Timeliness (L1 HW prefetch exclusive)",
            "This metric measures L2D cache prefetcher timeliness excluding L1 hardware prefetch requests",
            "prefetches",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_prefetcher_timeliness_l1hwprf_inclusive_0 {
            {
                {std::uint16_t(0x0179), 2},
                {std::uint16_t(0x010b), 2},
            },
            {
                metric_group_id_t::prefetcher_effectiveness,
            },
            "l2_prefetcher_timeliness_l1hwprf_inclusive",
            "L2 Cache Prefetcher Timeliness (L1 HW prefetch inclusive)",
            "This metric measures L2D cache prefetcher timeliness treating L1 hardware prefetches as demand requests",
            "prefetches",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_tlb_miss_ratio_0 {
            {
                {std::uint16_t(0x002d), 16},
                {std::uint16_t(0x002f), 4},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l2_tlb_miss_ratio",
            "L2 Unified TLB Miss Percentage",
            "This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 "
            "unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB.",
            "percent",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2_tlb_mpki_0 {
            {
                {std::uint16_t(0x002d), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::dtlb_effectiveness,
                metric_group_id_t::itlb_effectiveness,
                metric_group_id_t::mpki,
            },
            "l2_tlb_mpki",
            "L2 Unified TLB MPKI",
            "This metric measures the number of level 2 unified TLB accesses missed per thousand instructions "
            "executed.",
            "misses",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2d_cache_demand_mpki_0 {
            {
                {std::uint16_t(0x0052), 16},
                {std::uint16_t(0x0008), 2},
                {std::uint16_t(0x0053), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2d_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l2d_cache_demand_mpki",
            "L2D Cache Demand MPKI",
            "This metric measures the number of level 2 unified cache data demand accesses missed per thousand "
            "instructions executed. Note that cache accesses in this cache are either data memory access or "
            "instruction fetch as this is a unified cache.",
            "misses",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2d_cache_miss_ratio_0 {
            {
                {std::uint16_t(0x0052), 16},
                {std::uint16_t(0x0053), 16},
                {std::uint16_t(0x8148), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2d_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l2d_cache_miss_ratio",
            "L2D Cache Miss Percentage",
            "This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 cache "
            "data accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which "
            "is a unified cache that stores both data and instruction. Note that cache accesses in this cache are "
            "either data memory access or instruction fetch as this is a unified cache.",
            "percent",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2d_cache_miss_ratio_1 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x0051), 2},
                {std::uint16_t(0x0016), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2d_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l2d_cache_miss_ratio",
            "L2D Cache Miss Percentage",
            "This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data "
            "cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, "
            "which is a unified cache that stores both data and instruction. Note that cache accesses in this cache "
            "are either data memory access or instruction fetch as this is a unified cache.",
            "percent",
            1,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2d_cache_miss_ratio_2 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x0016), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2d_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l2d_cache_miss_ratio",
            "L2D Cache Miss Percentage",
            "This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data "
            "cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, "
            "which is a unified cache that stores both data and instruction. Note that cache accesses in this cache "
            "are either data memory access or instruction fetch as this is a unified cache.",
            "percent",
            2,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2d_cache_mpki_0 {
            {
                {std::uint16_t(0x0052), 16},
                {std::uint16_t(0x0008), 2},
                {std::uint16_t(0x0053), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2d_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l2d_cache_mpki",
            "L2D Cache MPKI",
            "This metric measures the number of level 2 unified cache data accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2d_cache_mpki_1 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2d_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l2d_cache_mpki",
            "L2D Cache MPKI",
            "This metric measures the number of level 2 unified cache data accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            1,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2i_cache_miss_ratio_0 {
            {
                {std::uint16_t(0x0028), 16},
                {std::uint16_t(0x0027), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2i_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l2i_cache_miss_ratio",
            "L2I Cache Miss Percentage",
            "This metric measures the ratio of level 2 cache instruction accesses missed to the total number of level "
            "2 cache instruction accesses. This gives an indication of the effectiveness of instruction accesses in "
            "the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache "
            "accesses in this cache are either data memory access or instruction fetch as this is a unified cache.",
            "percent",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l2i_cache_mpki_0 {
            {
                {std::uint16_t(0x0028), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l2i_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l2i_cache_mpki",
            "L2I Cache MPKI",
            "This metric measures the number of level 2 unified cache instruction accesses missed per thousand "
            "instructions executed. Note that cache accesses in this cache are either data memory access or "
            "instruction fetch as this is a unified cache.",
            "misses",
            0,
            metric_priority_t::l2,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l3_cache_miss_ratio_0 {
            {
                {std::uint16_t(0x002a), 16},
                {std::uint16_t(0x002b), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l3_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l3_cache_miss_ratio",
            "L3 Cache Miss Percentage",
            "This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache "
            "accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache "
            "that stores both data and instruction. Note that cache accesses in this cache are either data memory "
            "access or instruction fetch as this is a unified cache.",
            "percent",
            0,
            metric_priority_t::l3,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l3_cache_miss_ratio_1 {
            {
                {std::uint16_t(0x00a2), 16},
                {std::uint16_t(0x00a0), 4},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l3_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "l3_cache_miss_ratio",
            "L3 Cache Miss Percentage",
            "This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache "
            "accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache "
            "that stores both data and instruction. Note that cache accesses in this cache are either data memory "
            "access or instruction fetch as this is a unified cache.",
            "percent",
            1,
            metric_priority_t::l3,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l3_cache_mpki_0 {
            {
                {std::uint16_t(0x002a), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l3_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l3_cache_mpki",
            "L3 Cache MPKI",
            "This metric measures the number of level 3 unified cache accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            0,
            metric_priority_t::l3,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t l3_cache_mpki_1 {
            {
                {std::uint16_t(0x00a2), 16},
                {std::uint16_t(0x0008), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::l3_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "l3_cache_mpki",
            "L3 Cache MPKI",
            "This metric measures the number of level 3 unified cache accesses missed per thousand instructions "
            "executed. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a unified cache.",
            "misses",
            1,
            metric_priority_t::l3,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t ldrex_percentage_0 {
            {
                {std::uint16_t(0x006c), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
                metric_group_id_t::operation_mix,
            },
            "ldrex_percentage",
            "Load-Exclusive Instructions Percentage",
            "This metric measures load-exclusive instructions as a percentage of instructions speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t ll_cache_read_hit_ratio_0 {
            {
                {std::uint16_t(0x0036), 4},
                {std::uint16_t(0x0037), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::ll_cache_effectiveness,
            },
            "ll_cache_read_hit_ratio",
            "LL Cache Read Hit Percentage",
            "This metric measures the ratio of last level cache read accesses hit in the cache to the total number of "
            "last level cache accesses. This gives an indication of the effectiveness of the last level cache for read "
            "traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as "
            "this is a system level cache.",
            "percent",
            0,
            metric_priority_t::ll,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t ll_cache_read_miss_ratio_0 {
            {
                {std::uint16_t(0x0036), 4},
                {std::uint16_t(0x0037), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::ll_cache_effectiveness,
                metric_group_id_t::miss_ratio,
            },
            "ll_cache_read_miss_ratio",
            "LL Cache Read Miss Percentage",
            "This metric measures the ratio of last level cache read accesses missed to the total number of last level "
            "cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. "
            "Note that cache accesses in this cache are either data memory access or instruction fetch as this is a "
            "system level cache.",
            "percent",
            0,
            metric_priority_t::ll,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t ll_cache_read_mpki_0 {
            {
                {std::uint16_t(0x0008), 2},
                {std::uint16_t(0x0037), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::ll_cache_effectiveness,
                metric_group_id_t::mpki,
            },
            "ll_cache_read_mpki",
            "LL Cache Read MPKI",
            "This metric measures the number of last level cache read accesses missed per thousand instructions "
            "executed.",
            "misses",
            0,
            metric_priority_t::ll,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t load_average_latency_0 {
            {
                {std::uint16_t(0x0013), 2},
                {std::uint16_t(0x8121), 2},
            },
            {
                metric_group_id_t::average_latency,
            },
            "load_average_latency",
            "Load Operation Average Latency",
            "This metric measures the average latency of load operations in CPU cycles",
            "cycles",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t load_ls_percentage_0 {
            {
                {std::uint16_t(0x0070), 2},
                {std::uint16_t(0x0072), 2},
            },
            {
                metric_group_id_t::operation_mix,
            },
            "load_ls_percentage",
            "Load as Load/Store Operations Percentage",
            "This metric measures load operations as a percentage of load and store operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t load_percentage_0 {
            {
                {std::uint16_t(0x0070), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
            "load_percentage",
            "Load Operations Percentage",
            "This metric measures load operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t load_store_percentage_0 {
            {
                {std::uint16_t(0x001b), 2},
                {std::uint16_t(0x0072), 2},
            },
            {
                metric_group_id_t::operation_mix,
            },
            "load_store_percentage",
            "Load/Store Operations Percentage",
            "This metric measures load and store operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t lse_atomics_ratio_0 {
            {
                {std::uint16_t(0x8177), 2},
                {std::uint16_t(0x0072), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
            },
            "lse_atomics_ratio",
            "LSE Atomics Percentage",
            "This metric measures the ratio of LSE atomics instructions speculatively executed locally to the PE to "
            "the total load and store instructions.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t lse_load_ratio_0 {
            {
                {std::uint16_t(0x8177), 2},
                {std::uint16_t(0x8175), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
            },
            "lse_load_ratio",
            "LSE Load Percentage",
            "This metric measures the ratio of LSE load instructions speculatively executed to the total LSE "
            "instructions.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t lse_store_ratio_0 {
            {
                {std::uint16_t(0x8177), 2},
                {std::uint16_t(0x8176), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
            },
            "lse_store_ratio",
            "LSE Store Percentage",
            "This metric measures the ratio of LSE store instructions speculatively executed to the total LSE "
            "instructions.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t lsu_port_utilization_0 {
            {
                {std::uint16_t(0x3003), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::port_utilization,
            },
            "lsu_port_utilization",
            "Load/Store Address Execution Unit Utilization",
            "This metric measures the average number of load/store operations executed per cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t mcq_stall_percentage_0 {
            {
                {std::uint16_t(0x0160), 32},
                {std::uint16_t(0x816a), 8},
            },
            {
                metric_group_id_t::mcq_effectiveness,
            },
            "mcq_stall_percentage",
            "Commit Queue Stall Percentage",
            "This metric measures the percentage of backend stall cycles where no commit queue resource was available",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t nonsve_fp_ops_per_cycle_0 {
            {
                {std::uint16_t(0x80c1), 2},
            },
            {
                metric_group_id_t::fp_arithmetic_intensity,
            },
            "nonsve_fp_ops_per_cycle",
            "Non-SVE Floating Point Operations per Cycle",
            "This metric measures floating point operations per cycle in any precision performed by an instruction "
            "that is not an SVE instruction. Operations are counted by computation and by vector lanes, fused "
            "computations such as multiply-add count as twice per vector lane for example.",
            "operations",
            0,
            metric_priority_t::numeric,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t rc_ld_percentage_0 {
            {
                {std::uint16_t(0x0090), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
                metric_group_id_t::operation_mix,
            },
            "rc_ld_percentage",
            "Load-Acquire Instructions Percentage",
            "This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of "
            "instructions speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t rc_st_percentage_0 {
            {
                {std::uint16_t(0x0091), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
                metric_group_id_t::operation_mix,
            },
            "rc_st_percentage",
            "Store-Release Instructions Percentage",
            "This metric measures memory-write instructions with release semantics as a percentage of instructions "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t rename_stall_flags_ratio_0 {
            {
                {std::uint16_t(0x0399), 128},
                {std::uint16_t(0x0159), 128},
                {std::uint16_t(0x0158), 128},
                {std::uint16_t(0x015a), 128},
            },
            {
                metric_group_id_t::rename_effectiveness,
            },
            "rename_stall_flags_ratio",
            "Flag Register Rename Percentage",
            "This metric measures the percentage of rename stall cycles due to flag register rename availability",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t rename_stall_flags_ratio_1 {
            {
                {std::uint16_t(0x0158), 128},
                {std::uint16_t(0x816d), 32},
            },
            {
                metric_group_id_t::rename_effectiveness,
            },
            "rename_stall_flags_ratio",
            "Flag Register Rename Percentage",
            "This metric measures the percentage of rename stall cycles due to flag register rename availability",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t rename_stall_int_ratio_0 {
            {
                {std::uint16_t(0x0399), 128},
                {std::uint16_t(0x0159), 128},
                {std::uint16_t(0x015a), 128},
                {std::uint16_t(0x0158), 128},
            },
            {
                metric_group_id_t::rename_effectiveness,
            },
            "rename_stall_int_ratio",
            "Integer Register Rename Percentage",
            "This metric measures the percentage of rename stall cycles due to GPR register rename availability",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t rename_stall_int_ratio_1 {
            {
                {std::uint16_t(0x0159), 128},
                {std::uint16_t(0x816d), 32},
            },
            {
                metric_group_id_t::rename_effectiveness,
            },
            "rename_stall_int_ratio",
            "Integer Register Rename Percentage",
            "This metric measures the percentage of rename stall cycles due to GPR register rename availability",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t rename_stall_pred_ratio_0 {
            {
                {std::uint16_t(0x0399), 128},
                {std::uint16_t(0x0159), 128},
                {std::uint16_t(0x015a), 128},
                {std::uint16_t(0x0158), 128},
            },
            {
                metric_group_id_t::rename_effectiveness,
            },
            "rename_stall_pred_ratio",
            "Predicate Register Rename Percentage",
            "This metric measures the percentage of rename stall cycles due to predicate register rename availability",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t rename_stall_pred_ratio_1 {
            {
                {std::uint16_t(0x0170), 128},
                {std::uint16_t(0x816d), 32},
            },
            {
                metric_group_id_t::rename_effectiveness,
            },
            "rename_stall_pred_ratio",
            "Predicate Register Rename Percentage",
            "This metric measures the percentage of rename stall cycles due to predicate register rename availability",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t rename_stall_vec_ratio_0 {
            {
                {std::uint16_t(0x0399), 128},
                {std::uint16_t(0x0159), 128},
                {std::uint16_t(0x015a), 128},
                {std::uint16_t(0x0158), 128},
            },
            {
                metric_group_id_t::rename_effectiveness,
            },
            "rename_stall_vec_ratio",
            "Vector Register Rename Percentage",
            "This metric measures the percentage of rename stall cycles due to vector register rename availability",
            "percent",
            0,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t rename_stall_vec_ratio_1 {
            {
                {std::uint16_t(0x015a), 128},
                {std::uint16_t(0x816d), 32},
            },
            {
                metric_group_id_t::rename_effectiveness,
            },
            "rename_stall_vec_ratio",
            "Vector Register Rename Percentage",
            "This metric measures the percentage of rename stall cycles due to vector register rename availability",
            "percent",
            1,
            metric_priority_t::backend,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t retired_insns_percent_0 {
            {
                {std::uint16_t(0x0008), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::topdown_l1,
            },
            "retired_insns_percent",
            "Retired Instructions Percentage",
            "This metric measures the percentage of instructions speculatively executed that are subsequently retired",
            "percent",
            0,
            metric_priority_t::top_level,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t retired_ops_percent_0 {
            {
                {std::uint16_t(0x003a), 2},
                {std::uint16_t(0x003b), 2},
            },
            {
                metric_group_id_t::topdown_l1,
            },
            "retired_ops_percent",
            "Retired Operations Percentage",
            "This metric measures the percentage of operations speculatively executed that are subsequently retired",
            "percent",
            0,
            metric_priority_t::top_level,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t retiring_0 {
            {
                {std::uint16_t(0x003a), 2},
                {std::uint16_t(0x003f), 2},
                {std::uint16_t(0x003b), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "retiring",
            "Retiring",
            "This metric is the percentage of total slots that retired operations, which indicates cycles that were "
            "utilized efficiently.",
            "percent",
            0,
            metric_priority_t::top_level,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t retiring_1 {
            {
                {std::uint16_t(0x003a), 2},
                {std::uint16_t(0x003f), 2},
                {std::uint16_t(0x003b), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "retiring",
            "Retiring",
            "This metric is the percentage of total slots that retired operations, which indicates cycles that were "
            "utilized efficiently.",
            "percent",
            1,
            metric_priority_t::top_level,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t retiring_2 {
            {
                {std::uint16_t(0x003a), 2},
                {std::uint16_t(0x003f), 2},
                {std::uint16_t(0x003b), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::topdown_l1,
            },
            "retiring",
            "Retiring",
            "This metric is the percentage of total slots that retired operations, which indicates cycles that were "
            "utilized efficiently.",
            "percent",
            2,
            metric_priority_t::top_level,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t scalar_fp_percentage_0 {
            {
                {std::uint16_t(0x0075), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
            "scalar_fp_percentage",
            "Floating Point Operations Percentage",
            "This metric measures scalar floating point operations as a percentage of operations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t simd_percentage_0 {
            {
                {std::uint16_t(0x0074), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
            "simd_percentage",
            "Advanced SIMD Operations Percentage",
            "This metric measures advanced SIMD operations as a percentage of total operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t sme_percentage_0 {
            {
                {std::uint16_t(0x001b), 2},
                {std::uint16_t(0x835e), 2},
            },
            {
                metric_group_id_t::operation_mix,
            },
            "sme_percentage",
            "SME Operations Percentage",
            "This metric measures Scalable Matrix extension data processing operations as a percentage\nof operations "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t std_port_utilization_0 {
            {
                {std::uint16_t(0x3004), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::port_utilization,
            },
            "std_port_utilization",
            "Integer Store Data Execution Unit Utilization",
            "This metric measures the average number of integer store data operations executed per cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t store_ls_percentage_0 {
            {
                {std::uint16_t(0x0071), 2},
                {std::uint16_t(0x0072), 2},
            },
            {
                metric_group_id_t::operation_mix,
            },
            "store_ls_percentage",
            "Store as Load/Store Operations Percentage",
            "This metric measures store operations as a percentage of load and store operations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t store_percentage_0 {
            {
                {std::uint16_t(0x0071), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
            "store_percentage",
            "Store Operations Percentage",
            "This metric measures store operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t streaming_fp_op_percentage_0 {
            {
                {std::uint16_t(0x3220), 2},
                {std::uint16_t(0x3219), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "streaming_fp_op_percentage",
            "Streaming FP Operations Percentage",
            "This metric measures streaming floating point operations as a percentage of streaming\noperations "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t streaming_int_op_percentage_0 {
            {
                {std::uint16_t(0x321f), 2},
                {std::uint16_t(0x3219), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "streaming_int_op_percentage",
            "Streaming Integer Operations Percentage",
            "This metric measures streaming integer operations as a percentage of streaming\noperations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t streaming_ld_op_percentage_0 {
            {
                {std::uint16_t(0x321c), 2},
                {std::uint16_t(0x3219), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "streaming_ld_op_percentage",
            "Streaming Load Operations Percentage",
            "This metric measures streaming load operations as a percentage of streaming\noperations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t streaming_ls_op_percentage_0 {
            {
                {std::uint16_t(0x321b), 2},
                {std::uint16_t(0x3219), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "streaming_ls_op_percentage",
            "Streaming Load/Store Operations Percentage",
            "This metric measures streaming load and store operations as a percentage of streaming\noperations "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t streaming_op_percentage_0 {
            {
                {std::uint16_t(0x3219), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "streaming_op_percentage",
            "Streaming Operations Percentage",
            "This metric measures streaming operations as a percentage of operations speculatively "
            "executed.\nStreaming operations include Advanced SIMD, Scalable vector or\nor Scalable Matrix extension "
            "data processing when the CPU is in streaming\nmode.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t streaming_slow_inst_percentage_0 {
            {
                {std::uint16_t(0x3219), 2},
                {std::uint16_t(0x32a4), 8},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "streaming_slow_inst_percentage",
            "Streaming Slow Instructions Percentage",
            "This metric measures streaming slow instructions as a percentage of streaming\noperations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t streaming_st_op_percentage_0 {
            {
                {std::uint16_t(0x321d), 2},
                {std::uint16_t(0x3219), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "streaming_st_op_percentage",
            "Streaming Store Operations Percentage",
            "This metric measures streaming store operations as a percentage of streaming\noperations speculatively "
            "executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t strex_fail_mpki_0 {
            {
                {std::uint16_t(0x001b), 2},
                {std::uint16_t(0x006e), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
                metric_group_id_t::mpki,
            },
            "strex_fail_mpki",
            "Store-Exclusive Failures PKI",
            "This metric measures the number of store-exclusive instructions that failed per thousand instructions "
            "speculatively executed",
            "failures",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t strex_fail_percent_0 {
            {
                {std::uint16_t(0x006f), 2},
                {std::uint16_t(0x006e), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
            },
            "strex_fail_percent",
            "Store-Exclusive Failures Percentage",
            "This metric measures the number of store-exclusive instructions that failed as a percentage of "
            "store-exclusive instructions speculatively executed",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t strex_percentage_0 {
            {
                {std::uint16_t(0x006f), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::atomics_effectiveness,
                metric_group_id_t::operation_mix,
            },
            "strex_percentage",
            "Store-Exclusive Instructions Percentage",
            "This metric measures store-exclusive instructions as a percentage of instructions speculatively executed.",
            "percent",
            0,
            metric_priority_t::ls,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t sve_all_percentage_0 {
            {
                {std::uint16_t(0x001b), 2},
                {std::uint16_t(0x8006), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::operation_mix,
            },
            "sve_all_percentage",
            "SVE Operations (Load/Store Inclusive) Percentage",
            "This metric measures scalable vector operations, including loads and stores, as a percentage of "
            "operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t sve_fp_ops_per_cycle_0 {
            {
                {std::uint16_t(0x80c0), 2},
            },
            {
                metric_group_id_t::fp_arithmetic_intensity,
            },
            "sve_fp_ops_per_cycle",
            "SVE Floating Point Operations per Cycle",
            "This metric measures floating point operations per cycle in any precision performed by SVE instructions. "
            "Operations are counted by computation and by vector lanes, fused computations such as multiply-add count "
            "as twice per vector lane for example.",
            "operations",
            0,
            metric_priority_t::numeric,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t sve_percentage_0 {
            {
                {std::uint16_t(0x8056), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::operation_mix,
            },
            "sve_percentage",
            "SVE Operations Percentage",
            "This metric measures scalable vector operations as a percentage of operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t sve_predicate_empty_percentage_0 {
            {
                {std::uint16_t(0x8075), 2},
                {std::uint16_t(0x8074), 2},
            },
            {
                metric_group_id_t::sve_effectiveness,
            },
            "sve_predicate_empty_percentage",
            "SVE Empty Predicate Percentage",
            "This metric measures scalable vector operations with no active predicates as a percentage of sve "
            "predicated operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t sve_predicate_full_percentage_0 {
            {
                {std::uint16_t(0x8076), 2},
                {std::uint16_t(0x8074), 2},
            },
            {
                metric_group_id_t::sve_effectiveness,
            },
            "sve_predicate_full_percentage",
            "SVE Full Predicate Percentage",
            "This metric measures scalable vector operations with all active predicates as a percentage of sve "
            "predicated operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t sve_predicate_partial_percentage_0 {
            {
                {std::uint16_t(0x8077), 2},
                {std::uint16_t(0x8074), 2},
            },
            {
                metric_group_id_t::sve_effectiveness,
            },
            "sve_predicate_partial_percentage",
            "SVE Partial Predicate Percentage",
            "This metric measures scalable vector operations with at least one active predicates as a percentage of "
            "sve predicated operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t sve_predicate_percentage_0 {
            {
                {std::uint16_t(0x8074), 2},
                {std::uint16_t(0x001b), 2},
            },
            {
                metric_group_id_t::sve_effectiveness,
            },
            "sve_predicate_percentage",
            "SVE Predicate Percentage",
            "This metric measures scalable vector operations with predicates as a percentage of operations "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t system_dram_mem_hit_ratio_0 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x3008), 2},
                {std::uint16_t(0x0028), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::system_memory_effectiveness,
            },
            "system_dram_mem_hit_ratio",
            "System DRAM Hit Percentage",
            "This metric measures the ratio of DRAM hits to the total memory accesses that missed\nin the private L2 "
            "cache of the core. This metric indicates that the workload is memory bound obtaining data from the local "
            "DRAM.",
            "percent",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t system_l3_cache_hit_ratio_0 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x8206), 2},
                {std::uint16_t(0x0028), 16},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::system_memory_effectiveness,
            },
            "system_l3_cache_hit_ratio",
            "System L3 Cache Hit Percentage",
            "This metric measures the ratio of system L3 cache hits to the total memory accesses that missed\nin the "
            "private L2 cache of the core. This metric indicates that the workload is memory bound obtaining data from "
            "L3 cache.",
            "percent",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t system_llc_cache_hit_ratio_0 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x0028), 16},
                {std::uint16_t(0x8207), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::system_memory_effectiveness,
            },
            "system_llc_cache_hit_ratio",
            "System Last Level Cache Hit Percentage",
            "This metric measures the ratio of system last level cache hits to the total memory accesses that "
            "missed\nin the private L2 cache of the core. This metric indicates that the workload is memory bound "
            "obtaining data from system's last level cache.",
            "percent",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t system_peer_cluster_cache_hit_ratio_0 {
            {
                {std::uint16_t(0x0017), 16},
                {std::uint16_t(0x8190), 2},
                {std::uint16_t(0x0028), 16},
                {std::uint16_t(0x81b4), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::system_memory_effectiveness,
            },
            "system_peer_cluster_cache_hit_ratio",
            "System Peer Cluster Cache Hit Percentage",
            "This metric measures the ratio of peer cluster cache hits to the total memory accesses that missed\nin "
            "the private L2 cache of the core.\nThis metric indicates that the workload is memory bound obtaining data "
            "from peer cores in the compute cluster.",
            "percent",
            0,
            metric_priority_t::mem,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t vpu_port_utilization_0 {
            {
                {std::uint16_t(0x3002), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::port_utilization,
            },
            "vpu_port_utilization",
            "Vector Execution Unit Utilization",
            "This metric measures the average number of vector operations executed per cycle",
            "operations",
            0,
            metric_priority_t::backend,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t za_active_cycles_ratio_0 {
            {
                {std::uint16_t(0x8380), 2},
            },
            {
                metric_group_id_t::cycle_accounting,
            },
            "za_active_cycles_ratio",
            "ZA Active Cycles Percentage",
            "This metric is measures the ratio of cycles when PSTATE.ZA was enabled\nto the total number of CPU "
            "cycles.",
            "percent",
            0,
            metric_priority_t::cme,
            metric_arch_t::v8,
            true,
        };
        [[maybe_unused]] const metric_events_set_t za_fp_addsub_percentage_0 {
            {
                {std::uint16_t(0x8370), 2},
                {std::uint16_t(0x8352), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_fp_addsub_percentage",
            "Streaming ZA Add Sub Floating Point Operations Percentage",
            "This metric measures SME/SVE classified floating point addition or subtraction operations\nthat used ZA "
            "arrays as a percentage of all the SME floating point ZA operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t za_fp_dot_percentage_0 {
            {
                {std::uint16_t(0x8352), 2},
                {std::uint16_t(0x8374), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_fp_dot_percentage",
            "Streaming ZA Dot Floating Point Operations Percentage",
            "This metric measures SME/SVE classified floating point dot product operations that used ZA arrays as "
            "a\npercentage of all the SME floating point ZA operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t za_fp_fma_percentage_0 {
            {
                {std::uint16_t(0x8352), 2},
                {std::uint16_t(0x8372), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_fp_fma_percentage",
            "Streaming ZA FMA Floating Point Operations Percentage",
            "This metric measures SME/SVE classified floating point multiply-add, multiply-add long, multiply-subtract "
            "and\nmultiply-subtract long operations that used ZA arrays as a percentage of\nall the SME floating point "
            "ZA operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t za_fp_mopa_percentage_0 {
            {
                {std::uint16_t(0x8352), 2},
                {std::uint16_t(0x8376), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_fp_mopa_percentage",
            "Streaming ZA MOPA Floating Point Operations Percentage",
            "This metric measures SME/SVE classified floating point outer product and accumulate, or outer\nproduct "
            "and subtract operations that used ZA arrays as a percentage of\nall the SME integer ZA operations "
            "speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t za_fp_op_percentage_0 {
            {
                {std::uint16_t(0x8352), 2},
                {std::uint16_t(0x835e), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_fp_op_percentage",
            "Streaming ZA Floating Point Operations Percentage",
            "This metric measures SME/SVE classified floating point operations and used ZA arrays as a percentage "
            "of\nall the SME operations speculatively executed that used ZA array.\nZA arrays are required for "
            "instructions that required PSTATE.ZA to be set.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t za_fp_other_percentage_0 {
            {
                {std::uint16_t(0x32b0), 2},
                {std::uint16_t(0x8352), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_fp_other_percentage",
            "Streaming ZA Other Floating Point Operations Percentage",
            "This metric measures SME/SVE classified floating point operations that used ZA arrays not\ncounted in any "
            "other category as a percentage of\nall the SME floating point ZA operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t za_int_dot_percentage_0 {
            {
                {std::uint16_t(0x8378), 2},
                {std::uint16_t(0x837c), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_int_dot_percentage",
            "Streaming ZA Dot Integer Operations Percentage",
            "This metric measures SME integer dot product operations that used ZA arrays as a percentage of\nall the "
            "SME integer ZA operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t za_int_mopa_percentage_0 {
            {
                {std::uint16_t(0x8378), 2},
                {std::uint16_t(0x837e), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_int_mopa_percentage",
            "Streaming ZA MOPA Integer Operations Percentage",
            "This metric measures SME integer outer product and accumulate, or outer\nproduct and subtract operations "
            "that used ZA arrays as a percentage of\nall the SME integer ZA operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t za_int_op_percentage_0 {
            {
                {std::uint16_t(0x8378), 2},
                {std::uint16_t(0x835e), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_int_op_percentage",
            "Streaming ZA Integer Operations Percentage",
            "This metric measures SME integer operations that used ZA arrays as a percentage of\nall the SME "
            "operations speculatively executed that used ZA array.\nZA arrays are required for instructions that "
            "required PSTATE.ZA to be set.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t za_int_other_percentage_0 {
            {
                {std::uint16_t(0x8378), 2},
                {std::uint16_t(0x32af), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_int_other_percentage",
            "Streaming ZA Other Integer Operations Percentage",
            "This metric measures SME integer operations that used ZA arrays not\ncounted in any other category as a "
            "percentage of\nall the SME integer ZA operations speculatively executed.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        [[maybe_unused]] const metric_events_set_t za_op_percentage_0 {
            {
                {std::uint16_t(0x001b), 2},
                {std::uint16_t(0x835e), 2},
            },
            {
                metric_group_id_t::basic,
                metric_group_id_t::cme_operation_mix,
            },
            "za_op_percentage",
            "Streaming ZA Operations Percentage",
            "This metric measures SME operations that used ZA arrays as a percentage of operations speculatively "
            "executed.\nZA arrays are required for instructions that required PSTATE.ZA to be set.",
            "percent",
            0,
            metric_priority_t::numeric,
            metric_arch_t::any,
            false,
        };
        const metric_cpu_events_t c1_nano_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {
                                            {
                                                l2i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_page_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_block_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_cme_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {
                                    {
                                        backend_busy_ls_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_busy_vpu_arb_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cme_busy_bound_0,
                                        {
                                            {
                                                backend_cme_cpu_bound_0,
                                                {},
                                                metric_group_id_t::topdown_backend,
                                                true,
                                            },
                                            {
                                                backend_cme_backpressure_bound_0,
                                                {},
                                                metric_group_id_t::topdown_cme,
                                                true,
                                            },
                                            {
                                                backend_cme_busy_arb_bound_0,
                                                {},
                                                metric_group_id_t::topdown_cme,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_cme,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_stall_interlock_bound_1,
                                {
                                    {
                                        backend_stall_interlock_ls_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_stall_interlock_ptr_chase_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_stall_interlock_vpu_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cme_bound_0,
                                {
                                    {
                                        backend_mem_cme_hazard_cpu_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cpu_hazard_cme_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cme_lsrt_full_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cme_barrier_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_cache_bound_0,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2d_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2d_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_0,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_page_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_block_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                cas_near_fail_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_pass_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_far_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_atomics_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_load_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_store_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_coverage_l1hwprf_exclusive_1,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_accuracy_l1hwprf_exclusive_1,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_timeliness_l1hwprf_exclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sme_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cme_frontend_bound_0,
                {
                    {
                        cme_frontend_cpu_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_frontend,
                        true,
                    },
                    {
                        cme_frontend_other_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                cme_backend_bound_0,
                {
                    {
                        cme_backend_prefetch_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                    {
                        cme_backend_core_bound_0,
                        {
                            {
                                cme_iq_dp0_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_iq_dp1_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_iq_load_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_st_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_alu_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mac_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mmdp_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mmmv_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_perm_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                        },
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                    {
                        cme_backend_mem_bound_0,
                        {
                            {
                                cme_backend_mem_cache_bound_0,
                                {
                                    {
                                        cme_l1d_cache_mpki_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l1d_cache_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l1d_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l3d_cache_mpki_0,
                                        {},
                                        metric_group_id_t::cme_l3d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l3d_cache_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l3d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_mpki_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_dram_mem_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_l3d_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_ll_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::cme_topdown_backend,
                                true,
                            },
                            {
                                cme_backend_mem_store_bound_0,
                                {},
                                metric_group_id_t::cme_topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                cme_retiring_0,
                {
                    {
                        cme_load_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        cme_store_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_int_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_fp_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_ld_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_st_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_ls_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_slow_inst_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_mopa_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_dot_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_other_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_mopa_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_fma_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_dot_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_addsub_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_other_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                bus_read_requests_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_alloc_cycles_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_arb_pending_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_bus_access_average_length_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_ipc_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_accuracy_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_coverage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_timeliness_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l3d_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_miss_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                za_active_cycles_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t c1_premium_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {
                                    {
                                        frontend_core_flush_resteer_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_core_flush_machine_clear_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {
                                            {
                                                l2i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_page_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_block_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_cme_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_core_rename_bound_0,
                                {
                                    {
                                        rename_stall_vec_ratio_0,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_pred_ratio_0,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_flags_ratio_0,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_int_ratio_0,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_core_other_bound_1,
                                {
                                    {
                                        backend_core_spec_throttle_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        mcq_stall_percentage_0,
                                        {},
                                        metric_group_id_t::mcq_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {
                                    {
                                        backend_cme_busy_bound_1,
                                        {
                                            {
                                                backend_cme_cpu_bound_0,
                                                {},
                                                metric_group_id_t::topdown_backend,
                                                true,
                                            },
                                            {
                                                backend_cme_backpressure_bound_0,
                                                {},
                                                metric_group_id_t::topdown_cme,
                                                true,
                                            },
                                            {
                                                backend_cme_busy_arb_bound_0,
                                                {},
                                                metric_group_id_t::topdown_cme,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_cme,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cme_bound_0,
                                {
                                    {
                                        backend_mem_cme_hazard_cpu_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cpu_hazard_cme_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cme_lsrt_full_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cme_barrier_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_cache_bound_1,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2d_cache_miss_ratio_2,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_page_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_block_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                cas_near_fail_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_pass_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_far_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_atomics_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_load_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_store_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                l1_prefetcher_coverage_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l1_prefetcher_accuracy_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l1_prefetcher_timeliness_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_coverage_l1hwprf_exclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_accuracy_l1hwprf_exclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_timeliness_l1hwprf_exclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_coverage_l1hwprf_inclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_accuracy_l1hwprf_inclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_timeliness_l1hwprf_inclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_2,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sme_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        vpu_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        branch_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        int_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        lsu_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        std_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        iq_stall_lsu_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_sx_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_mx_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_vpu_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cme_frontend_bound_0,
                {
                    {
                        cme_frontend_cpu_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_frontend,
                        true,
                    },
                    {
                        cme_frontend_other_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                cme_backend_bound_0,
                {
                    {
                        cme_backend_prefetch_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                    {
                        cme_backend_core_bound_0,
                        {
                            {
                                cme_iq_dp0_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_iq_dp1_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_iq_load_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_st_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_alu_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mac_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mmdp_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mmmv_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_perm_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                        },
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                    {
                        cme_backend_mem_bound_0,
                        {
                            {
                                cme_backend_mem_cache_bound_0,
                                {
                                    {
                                        cme_l1d_cache_mpki_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l1d_cache_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l1d_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l3d_cache_mpki_0,
                                        {},
                                        metric_group_id_t::cme_l3d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l3d_cache_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l3d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_mpki_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_dram_mem_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_l3d_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_ll_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::cme_topdown_backend,
                                true,
                            },
                            {
                                cme_backend_mem_store_bound_0,
                                {},
                                metric_group_id_t::cme_topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                cme_retiring_0,
                {
                    {
                        cme_load_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        cme_store_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_int_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_fp_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_ld_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_st_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_ls_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_slow_inst_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_mopa_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_dot_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_other_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_mopa_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_fma_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_dot_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_addsub_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_other_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                bus_access_average_count_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                bus_read_requests_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_alloc_cycles_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_arb_pending_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_bus_access_average_length_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_ipc_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_accuracy_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_coverage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_timeliness_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l3d_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                frontend_core_spec_throttle_bound_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_dram_mem_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_l3_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_llc_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_peer_cluster_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                za_active_cycles_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t c1_pro_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {
                                    {
                                        frontend_core_flush_resteer_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_core_flush_machine_clear_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {
                                            {
                                                l2i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_page_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_block_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_cme_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_core_rename_bound_0,
                                {
                                    {
                                        rename_stall_vec_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_pred_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_flags_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_int_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_core_other_bound_0,
                                {
                                    {
                                        mcq_stall_percentage_0,
                                        {},
                                        metric_group_id_t::mcq_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {
                                    {
                                        backend_cme_busy_bound_1,
                                        {
                                            {
                                                backend_cme_cpu_bound_0,
                                                {},
                                                metric_group_id_t::topdown_backend,
                                                true,
                                            },
                                            {
                                                backend_cme_backpressure_bound_0,
                                                {},
                                                metric_group_id_t::topdown_cme,
                                                true,
                                            },
                                            {
                                                backend_cme_busy_arb_bound_0,
                                                {},
                                                metric_group_id_t::topdown_cme,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_cme,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cme_bound_0,
                                {
                                    {
                                        backend_mem_cme_hazard_cpu_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cpu_hazard_cme_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cme_lsrt_full_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cme_barrier_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_cache_bound_1,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2d_cache_miss_ratio_2,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_page_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_block_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                cas_near_fail_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_pass_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_far_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_atomics_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_load_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_store_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                l1_prefetcher_coverage_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l1_prefetcher_accuracy_1,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l1_prefetcher_timeliness_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_coverage_l1hwprf_exclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_accuracy_l1hwprf_exclusive_1,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_timeliness_l1hwprf_exclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_coverage_l1hwprf_inclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_accuracy_l1hwprf_inclusive_1,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_timeliness_l1hwprf_inclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sme_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        vpu_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        branch_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        int_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        lsu_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        std_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        iq_stall_lsu_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_sx_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_mx_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_vpu_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cme_frontend_bound_0,
                {
                    {
                        cme_frontend_cpu_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_frontend,
                        true,
                    },
                    {
                        cme_frontend_other_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                cme_backend_bound_0,
                {
                    {
                        cme_backend_prefetch_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                    {
                        cme_backend_core_bound_0,
                        {
                            {
                                cme_iq_dp0_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_iq_dp1_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_iq_load_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_st_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_alu_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mac_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mmdp_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mmmv_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_perm_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                        },
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                    {
                        cme_backend_mem_bound_0,
                        {
                            {
                                cme_backend_mem_cache_bound_0,
                                {
                                    {
                                        cme_l1d_cache_mpki_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l1d_cache_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l1d_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l3d_cache_mpki_0,
                                        {},
                                        metric_group_id_t::cme_l3d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l3d_cache_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l3d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_mpki_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_dram_mem_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_l3d_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_ll_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::cme_topdown_backend,
                                true,
                            },
                            {
                                cme_backend_mem_store_bound_0,
                                {},
                                metric_group_id_t::cme_topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                cme_retiring_0,
                {
                    {
                        cme_load_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        cme_store_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_int_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_fp_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_ld_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_st_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_ls_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_slow_inst_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_mopa_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_dot_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_other_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_mopa_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_fma_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_dot_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_addsub_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_other_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                bus_access_average_count_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                bus_read_requests_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_alloc_cycles_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_arb_pending_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_bus_access_average_length_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_ipc_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_accuracy_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_coverage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_timeliness_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l3d_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_dram_mem_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_l3_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_llc_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_peer_cluster_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                za_active_cycles_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t c1_ultra_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {
                                    {
                                        frontend_core_flush_resteer_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_core_flush_machine_clear_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {
                                            {
                                                l2i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_page_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_block_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_cme_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_core_rename_bound_0,
                                {
                                    {
                                        rename_stall_vec_ratio_0,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_pred_ratio_0,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_flags_ratio_0,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_int_ratio_0,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_core_other_bound_1,
                                {
                                    {
                                        backend_core_spec_throttle_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        mcq_stall_percentage_0,
                                        {},
                                        metric_group_id_t::mcq_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {
                                    {
                                        backend_cme_busy_bound_0,
                                        {
                                            {
                                                backend_cme_cpu_bound_0,
                                                {},
                                                metric_group_id_t::topdown_backend,
                                                true,
                                            },
                                            {
                                                backend_cme_backpressure_bound_0,
                                                {},
                                                metric_group_id_t::topdown_cme,
                                                true,
                                            },
                                            {
                                                backend_cme_busy_arb_bound_0,
                                                {},
                                                metric_group_id_t::topdown_cme,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_cme,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cme_bound_0,
                                {
                                    {
                                        backend_mem_cme_hazard_cpu_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cpu_hazard_cme_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cme_lsrt_full_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_mem_cme_barrier_bound_0,
                                        {},
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_cache_bound_1,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2d_cache_miss_ratio_2,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_page_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_block_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                cas_near_fail_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_pass_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_far_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_atomics_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_load_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                lse_store_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                l1_prefetcher_coverage_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l1_prefetcher_accuracy_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l1_prefetcher_timeliness_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_coverage_l1hwprf_exclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_accuracy_l1hwprf_exclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_timeliness_l1hwprf_exclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_coverage_l1hwprf_inclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_accuracy_l1hwprf_inclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                            {
                                l2_prefetcher_timeliness_l1hwprf_inclusive_0,
                                {},
                                metric_group_id_t::prefetcher_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_2,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sme_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        vpu_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        branch_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        int_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        lsu_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        std_port_utilization_0,
                        {},
                        metric_group_id_t::port_utilization,
                        true,
                    },
                    {
                        iq_stall_lsu_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_sx_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_mx_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_vpu_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cme_frontend_bound_0,
                {
                    {
                        cme_frontend_cpu_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_frontend,
                        true,
                    },
                    {
                        cme_frontend_other_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                cme_backend_bound_0,
                {
                    {
                        cme_backend_prefetch_bound_0,
                        {},
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                    {
                        cme_backend_core_bound_0,
                        {
                            {
                                cme_iq_dp0_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_iq_dp1_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_iq_load_stall_percentage_0,
                                {},
                                metric_group_id_t::cme_iq_effectiveness,
                                true,
                            },
                            {
                                cme_st_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_alu_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mac_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mmdp_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_mmmv_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                            {
                                cme_perm_port_utilization_0,
                                {},
                                metric_group_id_t::cme_port_utilization,
                                true,
                            },
                        },
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                    {
                        cme_backend_mem_bound_0,
                        {
                            {
                                cme_backend_mem_cache_bound_0,
                                {
                                    {
                                        cme_l1d_cache_mpki_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l1d_cache_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l1d_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l1d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l3d_cache_mpki_0,
                                        {},
                                        metric_group_id_t::cme_l3d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_l3d_cache_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_l3d_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_mpki_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_miss_ratio_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_ll_cache_read_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_ll_cache_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_dram_mem_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_l3d_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                    {
                                        cme_system_ll_cache_hit_ratio_0,
                                        {},
                                        metric_group_id_t::cme_system_memory_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::cme_topdown_backend,
                                true,
                            },
                            {
                                cme_backend_mem_store_bound_0,
                                {},
                                metric_group_id_t::cme_topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::cme_topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                cme_retiring_0,
                {
                    {
                        cme_load_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        cme_store_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_int_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_fp_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_ld_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_st_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_ls_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        streaming_slow_inst_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_mopa_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_dot_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_int_other_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_op_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_mopa_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_fma_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_dot_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_addsub_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                    {
                        za_fp_other_percentage_0,
                        {},
                        metric_group_id_t::cme_operation_mix,
                        true,
                    },
                },
                metric_group_id_t::cme_topdown_l1,
                true,
            },
            {
                bus_access_average_count_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                bus_read_requests_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_alloc_cycles_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_arb_pending_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_bus_access_average_length_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_ipc_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_accuracy_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_coverage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l1_prefetcher_timeliness_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cme_l3d_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                frontend_core_spec_throttle_bound_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_dram_mem_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_l3_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_llc_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                system_peer_cluster_cache_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                za_active_cycles_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a32_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                branch_mpki_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                l1d_tlb_mpki_0,
                {},
                metric_group_id_t::dtlb_effectiveness,
                true,
            },
            {
                l1i_tlb_mpki_0,
                {},
                metric_group_id_t::itlb_effectiveness,
                true,
            },
            {
                l1d_cache_miss_ratio_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1d_cache_mpki_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1i_cache_miss_ratio_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                l1i_cache_mpki_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a34_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                branch_mpki_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                l1d_tlb_mpki_0,
                {},
                metric_group_id_t::dtlb_effectiveness,
                true,
            },
            {
                l1i_tlb_mpki_0,
                {},
                metric_group_id_t::itlb_effectiveness,
                true,
            },
            {
                l1d_cache_miss_ratio_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1d_cache_mpki_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1i_cache_miss_ratio_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                l1i_cache_mpki_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a35_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                branch_mpki_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                l1d_tlb_mpki_0,
                {},
                metric_group_id_t::dtlb_effectiveness,
                true,
            },
            {
                l1i_tlb_mpki_0,
                {},
                metric_group_id_t::itlb_effectiveness,
                true,
            },
            {
                l1d_cache_miss_ratio_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1d_cache_mpki_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1i_cache_miss_ratio_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                l1i_cache_mpki_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a53_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                branch_mpki_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                l1d_tlb_mpki_0,
                {},
                metric_group_id_t::dtlb_effectiveness,
                true,
            },
            {
                l1i_tlb_mpki_0,
                {},
                metric_group_id_t::itlb_effectiveness,
                true,
            },
            {
                l1d_cache_miss_ratio_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1d_cache_mpki_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1i_cache_miss_ratio_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                l1i_cache_mpki_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a55_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_0,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_0,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_1,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                branch_direct_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                branch_return_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                backend_stall_interlock_bound_0,
                {},
                metric_group_id_t::topdown_backend,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a57_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                branch_mpki_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                l1d_tlb_mpki_0,
                {},
                metric_group_id_t::dtlb_effectiveness,
                true,
            },
            {
                l1i_tlb_mpki_0,
                {},
                metric_group_id_t::itlb_effectiveness,
                true,
            },
            {
                l1d_cache_miss_ratio_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1d_cache_mpki_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1i_cache_miss_ratio_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                l1i_cache_mpki_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                l2_cache_miss_ratio_1,
                {},
                metric_group_id_t::l2_cache_effectiveness,
                true,
            },
            {
                l2_cache_mpki_1,
                {},
                metric_group_id_t::l2_cache_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a65ae_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                branch_direct_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                branch_return_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t neoverse_e1_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                branch_direct_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                branch_return_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a72_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                branch_mpki_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                l1d_tlb_mpki_0,
                {},
                metric_group_id_t::dtlb_effectiveness,
                true,
            },
            {
                l1i_tlb_mpki_0,
                {},
                metric_group_id_t::itlb_effectiveness,
                true,
            },
            {
                l1d_cache_miss_ratio_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1d_cache_mpki_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1i_cache_miss_ratio_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                l1i_cache_mpki_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                l2_cache_miss_ratio_1,
                {},
                metric_group_id_t::l2_cache_effectiveness,
                true,
            },
            {
                l2_cache_mpki_1,
                {},
                metric_group_id_t::l2_cache_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a73_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                branch_mpki_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                l1d_tlb_mpki_0,
                {},
                metric_group_id_t::dtlb_effectiveness,
                true,
            },
            {
                l1i_tlb_mpki_0,
                {},
                metric_group_id_t::itlb_effectiveness,
                true,
            },
            {
                l1d_cache_miss_ratio_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1d_cache_mpki_1,
                {},
                metric_group_id_t::l1d_cache_effectiveness,
                true,
            },
            {
                l1i_cache_miss_ratio_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                l1i_cache_mpki_0,
                {},
                metric_group_id_t::l1i_cache_effectiveness,
                true,
            },
            {
                l2_cache_miss_ratio_1,
                {},
                metric_group_id_t::l2_cache_effectiveness,
                true,
            },
            {
                l2_cache_mpki_1,
                {},
                metric_group_id_t::l2_cache_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a75_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                branch_direct_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                branch_return_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a76_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a77_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a78_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_mem_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {},
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a78ae_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_mem_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {},
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a78c_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_mem_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {},
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a320_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_busy_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_stall_interlock_bound_1,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cache_bound_1,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2d_cache_miss_ratio_2,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bus_read_requests_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a510_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_0,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_0,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_1,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_stall_interlock_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {},
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                branch_direct_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                branch_return_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a520_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_busy_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_stall_interlock_bound_1,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cache_bound_0,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_0,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bus_read_requests_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a520ae_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_busy_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_stall_interlock_bound_1,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cache_bound_0,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_0,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bus_read_requests_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a710_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_mem_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {},
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_x2_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_mem_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {},
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_x3_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_mem_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {},
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a715_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_mem_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {},
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a720_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_rename_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                cas_near_fail_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_pass_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1i_cache_miss_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1i_cache_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l3_cache_miss_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l3_cache_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                ll_cache_read_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                ll_cache_read_miss_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                ll_cache_read_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a720ae_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_rename_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                cas_near_fail_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_pass_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1i_cache_miss_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1i_cache_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l3_cache_miss_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l3_cache_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                ll_cache_read_hit_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                ll_cache_read_miss_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                ll_cache_read_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_a725_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {
                                            {
                                                l2i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_rename_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cache_bound_1,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2d_cache_miss_ratio_2,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                cas_near_fail_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_pass_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_x1_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_mem_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {},
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_x1c_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_mem_bound_0,
                        {},
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {},
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_x4_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_rename_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cache_bound_1,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_x925_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_rename_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cache_bound_1,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_r52__metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                retired_insns_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                branch_direct_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                branch_return_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_r82_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                branch_direct_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                branch_return_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t cortex_r82ae_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                retired_ops_percent_0,
                {
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                branch_direct_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                branch_return_ratio_0,
                {},
                metric_group_id_t::branch_effectiveness,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t neoverse_n1_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {
                    {
                        dtlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        dtlb_walk_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_mpki_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l2_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::dtlb_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_mpki_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_demand_mpki_0,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l1d_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l1d_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_mpki_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l2_cache_miss_ratio_1,
                        {},
                        metric_group_id_t::l2_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_mpki_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        l3_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l3_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_mpki_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_miss_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                    {
                        ll_cache_read_hit_ratio_0,
                        {},
                        metric_group_id_t::ll_cache_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                retired_insns_percent_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::general,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t neoverse_v1_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_2,
                {
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_mem_bound_0,
                        {
                            {
                                l1d_cache_mpki_1,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l1d_cache_demand_mpki_0,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l1d_cache_miss_ratio_1,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l2_cache_mpki_1,
                                {},
                                metric_group_id_t::l2_cache_effectiveness,
                                true,
                            },
                            {
                                l2_cache_miss_ratio_1,
                                {},
                                metric_group_id_t::l2_cache_effectiveness,
                                true,
                            },
                            {
                                l3_cache_mpki_0,
                                {},
                                metric_group_id_t::l3_cache_effectiveness,
                                true,
                            },
                            {
                                l3_cache_miss_ratio_0,
                                {},
                                metric_group_id_t::l3_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_mpki_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_miss_ratio_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_hit_ratio_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                dtlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                dtlb_walk_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l1d_tlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l1d_tlb_miss_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l2_tlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l2_tlb_miss_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_2,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t neoverse_n2_common_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_1,
                {
                    {
                        backend_mem_bound_0,
                        {
                            {
                                l1d_cache_mpki_1,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l1d_cache_demand_mpki_0,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l1d_cache_miss_ratio_1,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l2_cache_mpki_1,
                                {},
                                metric_group_id_t::l2_cache_effectiveness,
                                true,
                            },
                            {
                                l2_cache_miss_ratio_1,
                                {},
                                metric_group_id_t::l2_cache_effectiveness,
                                true,
                            },
                            {
                                l3_cache_mpki_0,
                                {},
                                metric_group_id_t::l3_cache_effectiveness,
                                true,
                            },
                            {
                                l3_cache_miss_ratio_0,
                                {},
                                metric_group_id_t::l3_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_mpki_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_miss_ratio_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_hit_ratio_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                dtlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                dtlb_walk_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l1d_tlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l1d_tlb_miss_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l2_tlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l2_tlb_miss_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                branch_misprediction_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                branch_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                itlb_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                itlb_walk_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1i_cache_miss_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1i_cache_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1i_tlb_miss_ratio_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l1i_tlb_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t neoverse_n2_tel_v0_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_1,
                {
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_1,
                {
                    {
                        backend_mem_bound_0,
                        {
                            {
                                l1d_cache_mpki_1,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l1d_cache_demand_mpki_0,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l1d_cache_miss_ratio_1,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l2_cache_mpki_1,
                                {},
                                metric_group_id_t::l2_cache_effectiveness,
                                true,
                            },
                            {
                                l2_cache_miss_ratio_1,
                                {},
                                metric_group_id_t::l2_cache_effectiveness,
                                true,
                            },
                            {
                                l3_cache_mpki_0,
                                {},
                                metric_group_id_t::l3_cache_effectiveness,
                                true,
                            },
                            {
                                l3_cache_miss_ratio_0,
                                {},
                                metric_group_id_t::l3_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_mpki_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_miss_ratio_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_hit_ratio_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                dtlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                dtlb_walk_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l1d_tlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l1d_tlb_miss_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l2_tlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l2_tlb_miss_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_1,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_1,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
        };
        const metric_cpu_events_t neoverse_n2_tel_v1_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_2,
                {
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_1,
                {
                    {
                        backend_mem_bound_0,
                        {
                            {
                                l1d_cache_mpki_1,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l1d_cache_demand_mpki_0,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l1d_cache_miss_ratio_1,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l2_cache_mpki_1,
                                {},
                                metric_group_id_t::l2_cache_effectiveness,
                                true,
                            },
                            {
                                l2_cache_miss_ratio_1,
                                {},
                                metric_group_id_t::l2_cache_effectiveness,
                                true,
                            },
                            {
                                l3_cache_mpki_0,
                                {},
                                metric_group_id_t::l3_cache_effectiveness,
                                true,
                            },
                            {
                                l3_cache_miss_ratio_0,
                                {},
                                metric_group_id_t::l3_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_mpki_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_miss_ratio_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_hit_ratio_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                dtlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                dtlb_walk_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l1d_tlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l1d_tlb_miss_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l2_tlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l2_tlb_miss_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_2,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
        };
        const metric_cpu_events_t neoverse_v2_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_2,
                {
                    {
                        l1i_cache_mpki_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        l1i_cache_miss_ratio_0,
                        {},
                        metric_group_id_t::l1i_cache_effectiveness,
                        true,
                    },
                    {
                        itlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        itlb_walk_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_mpki_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                    {
                        l1i_tlb_miss_ratio_0,
                        {},
                        metric_group_id_t::itlb_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_1,
                {
                    {
                        backend_mem_bound_0,
                        {
                            {
                                l1d_cache_mpki_1,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l1d_cache_demand_mpki_0,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l1d_cache_miss_ratio_1,
                                {},
                                metric_group_id_t::l1d_cache_effectiveness,
                                true,
                            },
                            {
                                l2_cache_mpki_1,
                                {},
                                metric_group_id_t::l2_cache_effectiveness,
                                true,
                            },
                            {
                                l2_cache_miss_ratio_1,
                                {},
                                metric_group_id_t::l2_cache_effectiveness,
                                true,
                            },
                            {
                                l3_cache_mpki_0,
                                {},
                                metric_group_id_t::l3_cache_effectiveness,
                                true,
                            },
                            {
                                l3_cache_miss_ratio_0,
                                {},
                                metric_group_id_t::l3_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_mpki_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_miss_ratio_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                ll_cache_read_hit_ratio_0,
                                {},
                                metric_group_id_t::ll_cache_effectiveness,
                                true,
                            },
                            {
                                dtlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                dtlb_walk_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l1d_tlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l1d_tlb_miss_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l2_tlb_mpki_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                            {
                                l2_tlb_miss_ratio_0,
                                {},
                                metric_group_id_t::dtlb_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_2,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_2,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t neoverse_n3_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {
                                            {
                                                l2i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l2i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_rename_bound_0,
                                {
                                    {
                                        rename_stall_vec_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_flags_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_int_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                mcq_stall_percentage_0,
                                {},
                                metric_group_id_t::mcq_effectiveness,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cache_bound_1,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2d_cache_miss_ratio_2,
                                                {},
                                                metric_group_id_t::l2d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l3_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l3_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                cas_near_fail_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                            {
                                cas_near_pass_ratio_0,
                                {},
                                metric_group_id_t::atomics_effectiveness,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_2,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        iq_stall_lsu_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_sx_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_mx_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                    {
                        iq_stall_vpu_percentage_0,
                        {},
                        metric_group_id_t::iq_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_miss_ratio_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t neoverse_v3_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_rename_bound_0,
                                {
                                    {
                                        rename_stall_vec_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_flags_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_int_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cache_bound_1,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_demand_mpki_0,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
        const metric_cpu_events_t neoverse_v3ae_metrics {
            {
                ipc_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                frontend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                frontend_bound_0,
                {
                    {
                        frontend_core_bound_0,
                        {
                            {
                                frontend_core_flush_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_core_flow_bound_0,
                                {},
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                    {
                        frontend_mem_bound_0,
                        {
                            {
                                frontend_mem_cache_bound_0,
                                {
                                    {
                                        frontend_cache_l1i_bound_0,
                                        {
                                            {
                                                l1i_cache_mpki_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1i_cache_miss_ratio_0,
                                                {},
                                                metric_group_id_t::l1i_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                    {
                                        frontend_cache_l2i_bound_0,
                                        {},
                                        metric_group_id_t::topdown_frontend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                            {
                                frontend_mem_tlb_bound_0,
                                {
                                    {
                                        itlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        itlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1i_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::itlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_frontend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_frontend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                backend_stalled_cycles_0,
                {},
                metric_group_id_t::cycle_accounting,
                true,
            },
            {
                backend_bound_0,
                {
                    {
                        backend_core_bound_0,
                        {
                            {
                                backend_core_rename_bound_0,
                                {
                                    {
                                        rename_stall_vec_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_flags_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                    {
                                        rename_stall_int_ratio_1,
                                        {},
                                        metric_group_id_t::rename_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_busy_bound_0,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                    {
                        backend_mem_bound_1,
                        {
                            {
                                backend_mem_cache_bound_1,
                                {
                                    {
                                        backend_cache_l1d_bound_0,
                                        {
                                            {
                                                l1d_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_demand_mpki_0,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l1d_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l1d_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                    {
                                        backend_cache_l2d_bound_0,
                                        {
                                            {
                                                l2_cache_mpki_1,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                l2_cache_miss_ratio_1,
                                                {},
                                                metric_group_id_t::l2_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_mpki_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_miss_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                            {
                                                ll_cache_read_hit_ratio_0,
                                                {},
                                                metric_group_id_t::ll_cache_effectiveness,
                                                true,
                                            },
                                        },
                                        metric_group_id_t::topdown_backend,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_tlb_bound_1,
                                {
                                    {
                                        dtlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_large_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_small_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_depth_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        dtlb_walk_average_latency_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l1d_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_mpki_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                    {
                                        l2_tlb_miss_ratio_0,
                                        {},
                                        metric_group_id_t::dtlb_effectiveness,
                                        true,
                                    },
                                },
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                            {
                                backend_mem_store_bound_1,
                                {},
                                metric_group_id_t::topdown_backend,
                                true,
                            },
                        },
                        metric_group_id_t::topdown_backend,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                retired_ops_percent_0,
                {},
                metric_group_id_t::general,
                true,
            },
            {
                retiring_0,
                {
                    {
                        barrier_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        branch_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        crypto_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp16_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp32_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        fp64_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        integer_dp_percentage_1,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        ldrex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        load_store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_ld_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        rc_st_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        scalar_fp_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        simd_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_ls_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        store_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        strex_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                    {
                        sve_all_percentage_0,
                        {},
                        metric_group_id_t::operation_mix,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                bad_speculation_0,
                {
                    {
                        branch_mpki_1,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_misprediction_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_direct_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_indirect_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                    {
                        branch_return_ratio_0,
                        {},
                        metric_group_id_t::branch_effectiveness,
                        true,
                    },
                },
                metric_group_id_t::topdown_l1,
                true,
            },
            {
                cpi_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                instruction_fetch_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_demand_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_miss_ratio_2,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                l2d_cache_mpki_1,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                load_average_latency_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                nonsve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_mpki_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                strex_fail_percent_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_fp_ops_per_cycle_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_empty_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_full_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_partial_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
            {
                sve_predicate_percentage_0,
                {},
                metric_group_id_t::other,
                false,
            },
        };
    }
    metric_cpu_events_map_t const cpu_metrics_table {
        {
            "ARMv9_C1_Nano",
            {
                0x000e,
                {
                    {{}, {c1_nano_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_C1_Premium",
            {
                0x000e,
                {
                    {{}, {c1_premium_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_C1_Pro",
            {
                0x000e,
                {
                    {{}, {c1_pro_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_C1_Ultra",
            {
                0x000e,
                {
                    {{}, {c1_ultra_metrics, 5}},
                },
            },
        },
        {
            "ARMv8_Cortex_A32",
            {
                0x000e,
                {
                    {{}, {cortex_a32_metrics, 2}},
                },
            },
        },
        {
            "ARMv8_Cortex_A34",
            {
                0x000e,
                {
                    {{}, {cortex_a34_metrics, 2}},
                },
            },
        },
        {
            "ARMv8_Cortex_A35",
            {
                0x000e,
                {
                    {{}, {cortex_a35_metrics, 2}},
                },
            },
        },
        {
            "ARMv8_Cortex_A53",
            {
                0x000e,
                {
                    {{}, {cortex_a53_metrics, 2}},
                },
            },
        },
        {
            "ARMv8_Cortex_A55",
            {
                0x000e,
                {
                    {{}, {cortex_a55_metrics, 3}},
                },
            },
        },
        {
            "ARMv8_Cortex_A57",
            {
                0x0079,
                {
                    {{}, {cortex_a57_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A65AE",
            {
                0x000e,
                {
                    {{}, {cortex_a65ae_metrics, 3}},
                },
            },
        },
        {
            "ARMv8_Neoverse_E1",
            {
                0x000e,
                {
                    {{}, {neoverse_e1_metrics, 3}},
                },
            },
        },
        {
            "ARMv8_Cortex_A72",
            {
                0x0079,
                {
                    {{}, {cortex_a72_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A73",
            {
                0x000e,
                {
                    {{}, {cortex_a73_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A75",
            {
                0x000e,
                {
                    {{}, {cortex_a75_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A76",
            {
                0x0079,
                {
                    {{}, {cortex_a76_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A77",
            {
                0x0079,
                {
                    {{}, {cortex_a77_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A78",
            {
                0x0079,
                {
                    {{}, {cortex_a78_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A78AE",
            {
                0x0079,
                {
                    {{}, {cortex_a78ae_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_A78C",
            {
                0x0079,
                {
                    {{}, {cortex_a78c_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_A320",
            {
                0x000e,
                {
                    {{}, {cortex_a320_metrics, 5}},
                },
            },
        },
        {
            "ARMv8_Cortex_A510",
            {
                0x000e,
                {
                    {{}, {cortex_a510_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_A520",
            {
                0x000e,
                {
                    {{}, {cortex_a520_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Cortex_A520AE",
            {
                0x000e,
                {
                    {{}, {cortex_a520ae_metrics, 5}},
                },
            },
        },
        {
            "ARMv8_Cortex_A710",
            {
                0x0079,
                {
                    {{}, {cortex_a710_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_X2",
            {
                0x0079,
                {
                    {{}, {cortex_x2_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_X3",
            {
                0x0079,
                {
                    {{}, {cortex_x3_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_A715",
            {
                0x0079,
                {
                    {{}, {cortex_a715_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_A720",
            {
                0x000e,
                {
                    {{}, {cortex_a720_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Cortex_A720AE",
            {
                0x000e,
                {
                    {{}, {cortex_a720ae_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Cortex_A725",
            {
                0x000e,
                {
                    {{}, {cortex_a725_metrics, 5}},
                },
            },
        },
        {
            "ARMv8_Cortex_X1",
            {
                0x0079,
                {
                    {{}, {cortex_x1_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Cortex_X1C",
            {
                0x0079,
                {
                    {{}, {cortex_x1c_metrics, 4}},
                },
            },
        },
        {
            "ARMv9_Cortex_X4",
            {
                0x000e,
                {
                    {{}, {cortex_x4_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Cortex_X925",
            {
                0x000e,
                {
                    {{}, {cortex_x925_metrics, 5}},
                },
            },
        },
        {
            "ARMv8R_Cortex_R52X",
            {
                0x000e,
                {
                    {{}, {cortex_r52__metrics, 2}},
                },
            },
        },
        {
            "ARMv8R_Cortex_R82",
            {
                0x000e,
                {
                    {{}, {cortex_r82_metrics, 3}},
                },
            },
        },
        {
            "ARMv8R_Cortex_R82AE",
            {
                0x000e,
                {
                    {{}, {cortex_r82ae_metrics, 3}},
                },
            },
        },
        {
            "ARMv8_Neoverse_N1",
            {
                0x0079,
                {
                    {{}, {neoverse_n1_metrics, 4}},
                },
            },
        },
        {
            "ARMv8_Neoverse_V1",
            {
                0x0079,
                {
                    {{}, {neoverse_v1_metrics, 5}},
                },
            },
        },
        {
            "ARMv8_Neoverse_N2",
            {
                0x0079,
                {
                    {{}, {neoverse_n2_common_metrics, 4}},
                    {{0, 0}, {neoverse_n2_tel_v0_metrics, 5}},
                    {{0, 3}, {neoverse_n2_tel_v1_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Neoverse_V2",
            {
                0x0079,
                {
                    {{}, {neoverse_v2_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Neoverse_N3",
            {
                0x000e,
                {
                    {{}, {neoverse_n3_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Neoverse_V3",
            {
                0x000e,
                {
                    {{}, {neoverse_v3_metrics, 5}},
                },
            },
        },
        {
            "ARMv9_Neoverse_V3AE",
            {
                0x000e,
                {
                    {{}, {neoverse_v3ae_metrics, 5}},
                },
            },
        },
    };

    std::string_view metric_group_title(metric_group_id_t id)
    {
        switch (id) {
            case metric_group_id_t::atomics_effectiveness:
                return "Atomics Effectiveness";
            case metric_group_id_t::average_latency:
                return "Average Latency";
            case metric_group_id_t::basic:
                return "Basic";
            case metric_group_id_t::branch_effectiveness:
                return "Branch Effectiveness";
            case metric_group_id_t::bus_effectiveness:
                return "Bus Effectiveness";
            case metric_group_id_t::cme_bus_effectiveness:
                return "SME Bus Effectiveness";
            case metric_group_id_t::cme_general:
                return "SME GENERAL";
            case metric_group_id_t::cme_iq_effectiveness:
                return "SME Issue Queue Effectiveness";
            case metric_group_id_t::cme_l1d_cache_effectiveness:
                return "SME L1 Data Cache Effectiveness";
            case metric_group_id_t::cme_l3d_cache_effectiveness:
                return "SME L3 cluster Cache Effectiveness";
            case metric_group_id_t::cme_ll_cache_effectiveness:
                return "SME Last Level Cache Effectiveness";
            case metric_group_id_t::cme_miss_ratio:
                return "SME Miss Ratio";
            case metric_group_id_t::cme_mpki:
                return "SME Misses Per Kilo Instructions";
            case metric_group_id_t::cme_operation_mix:
                return "SME Operation Mix";
            case metric_group_id_t::cme_port_utilization:
                return "Execution Unit Effectiveness";
            case metric_group_id_t::cme_prefetcher_effectiveness:
                return "SME Prefetcher Effectiveness";
            case metric_group_id_t::cme_system_memory_effectiveness:
                return "SME System Memory Effectiveness";
            case metric_group_id_t::cme_topdown_backend:
                return "SME Topdown Backend";
            case metric_group_id_t::cme_topdown_frontend:
                return "SME Topdown Frontend";
            case metric_group_id_t::cme_topdown_l1:
                return "SME Topdown Level 1";
            case metric_group_id_t::cycle_accounting:
                return "Cycle Accounting";
            case metric_group_id_t::dtlb_effectiveness:
                return "Data TLB Effectiveness";
            case metric_group_id_t::fp_arithmetic_intensity:
                return "Floating Point Arithmetic Intensity";
            case metric_group_id_t::fp_precision_mix:
                return "Floating Point Precision";
            case metric_group_id_t::general:
                return "General";
            case metric_group_id_t::iq_effectiveness:
                return "Issue Queue Effectiveness";
            case metric_group_id_t::itlb_effectiveness:
                return "Instruction TLB Effectiveness";
            case metric_group_id_t::l1d_cache_effectiveness:
                return "L1 Data Cache Effectiveness";
            case metric_group_id_t::l1i_cache_effectiveness:
                return "L1 Instruction Cache Effectiveness";
            case metric_group_id_t::l2_cache_effectiveness:
                return "L2 Unified Cache Effectiveness";
            case metric_group_id_t::l2d_cache_effectiveness:
                return "L2D Data Unified Cache Effectiveness";
            case metric_group_id_t::l2i_cache_effectiveness:
                return "L2 Instruction Unified Cache Effectiveness";
            case metric_group_id_t::l3_cache_effectiveness:
                return "L3 Unified Cache Effectiveness";
            case metric_group_id_t::ll_cache_effectiveness:
                return "Last Level Cache Effectiveness";
            case metric_group_id_t::mcq_effectiveness:
                return "Main Commit Queue Effectiveness";
            case metric_group_id_t::miss_ratio:
                return "Miss Ratio";
            case metric_group_id_t::mpki:
                return "Misses Per Kilo Instructions";
            case metric_group_id_t::operation_mix:
                return "Speculative Operation Mix";
            case metric_group_id_t::port_utilization:
                return "Execution Unit Effectiveness";
            case metric_group_id_t::prefetcher_effectiveness:
                return "Prefetcher Effectiveness";
            case metric_group_id_t::rename_effectiveness:
                return "Register Rename Effectiveness";
            case metric_group_id_t::sve_effectiveness:
                return "SVE Effectiveness";
            case metric_group_id_t::system_memory_effectiveness:
                return "System Memory Effectiveness";
            case metric_group_id_t::topdown_backend:
                return "Topdown Backend";
            case metric_group_id_t::topdown_cme:
                return "Topdown SME";
            case metric_group_id_t::topdown_frontend:
                return "Topdown Frontend";
            case metric_group_id_t::topdown_l1:
                return "Topdown Level 1";
            default:
                return "Other";
        };
    };
}

// NOLINTEND(cert-err58-cpp)
