// ------------------------------------------------------------
// AArch64 Generic Timer
//
// Copyright (C) 2017-2025 by Arm Limited (or its affiliates). All rights reserved.
// Use, modification and redistribution of this file is subject to your possession of a
// valid End User License Agreement for the Arm Product of which these examples are part of
// and your compliance with all applicable terms and conditions of such license agreement.
//
// Redistribution permitted only in object code form and only as
// part of Software Applications developed by you or your permitted users. If you
// choose to redistribute the whole or any part of Example Code, you agree: (a)
// to ensure that they are licensed for use only as part of Software Applications
// and only for execution on microprocessors manufactured or simulated under
// licence from Arm; (b) not to use Arm's or any of its licensors names, logos or
// trademarks to market Software Applications; (c) to include valid copyright
// notices on Software Applications, and preserve any copyright notices which are
// included with, or in, the Example Code; and (d) to ensure that any further
// redistribution is limited to redistribution by either or both your customers
// and your authorised distributors as part of Software Applications and that
// your customers and your authorised distributors comply with these terms.
//

// ------------------------------------------------------------


#ifndef INCLUDE_GENERIC_TIMER_H
#define INCLUDE_GENERIC_TIMER_H

#include <stdint.h>
#include <stdbool.h>

/**
 * Gets the system counter frequency
 *
 * @return The frequency in Hz
 */
uint64_t getSystemCounterFrequency(void);

/**
 * Gets the system counter
 *
 * @return The value of the system counter
 */
uint64_t getSystemCounter(void);

/**
 * Sets the EL1 physical timer TimerValue
 *
 * @param value The TimerValue to set
 */
void setEl1PhysicalTimerTimerValue(int32_t value);

/**
 * Sets the EL1 physical timer enabled or disabled
 *
 * @param enable true to enable, false to disable
 */
void setEl1PhysicalTimerEnabled(bool enable);

/**
 * Sets the EL1 physical timer interrupt enabled or disabled
 *
 * @param enable true to enable, false to disable
 */
void setEl1PhysicalTimerInterruptEnabled(bool enable);

#endif
