// ------------------------------------------------------------
// AArch64 Generic Timer
//
//
// Copyright (C) 2017-2025 by Arm Limited (or its affiliates). All rights reserved.
// Use, modification and redistribution of this file is subject to your possession of a
// valid End User License Agreement for the Arm Product of which these examples are part of
// and your compliance with all applicable terms and conditions of such license agreement.
//
// Redistribution permitted only in object code form and only as
// part of Software Applications developed by you or your permitted users. If you
// choose to redistribute the whole or any part of Example Code, you agree: (a)
// to ensure that they are licensed for use only as part of Software Applications
// and only for execution on microprocessors manufactured or simulated under
// licence from Arm; (b) not to use Arm's or any of its licensors names, logos or
// trademarks to market Software Applications; (c) to include valid copyright
// notices on Software Applications, and preserve any copyright notices which are
// included with, or in, the Example Code; and (d) to ensure that any further
// redistribution is limited to redistribution by either or both your customers
// and your authorised distributors as part of Software Applications and that
// your customers and your authorised distributors comply with these terms.

#include "generic_timer.h"

uint64_t getSystemCounterFrequency(void)
{
    uint64_t value;
    asm ("mrs %0, CNTFRQ_EL0" : "=r"(value));
    return value;
}

uint64_t getSystemCounter(void)
{
    uint64_t value;
    asm ("mrs %0, CNTPCT_EL0" : "=r"(value));
    return value;
}

void setEl1PhysicalTimerTimerValue(int32_t value)
{
    asm ("msr CNTP_TVAL_EL0, %0" : : "r"((uint64_t)value));
}

void setEl1PhysicalTimerEnabled(bool enable)
{
    uint64_t ctl_reg;
    asm ("mrs %0, CNTP_CTL_EL0" : "=r"(ctl_reg));
    if (enable)
    {
        ctl_reg |= UINT64_C(1);
    }
    else
    {
        ctl_reg &= ~UINT64_C(1);
    }
    asm ("msr CNTP_CTL_EL0, %0" : : "r"(ctl_reg));
}

void setEl1PhysicalTimerInterruptEnabled(bool enable)
{
    uint64_t ctl_reg;
    asm ("mrs %0, CNTP_CTL_EL0" : "=r"(ctl_reg));
    if (enable)
    {
        ctl_reg &= ~(UINT64_C(1) << 1);
    }
    else
    {
        ctl_reg |= (UINT64_C(1) << 1);
    }
    asm ("msr CNTP_CTL_EL0, %0" : : "r"(ctl_reg));
}



