/**
 * Copyright (C) 2016-2025 by Arm Limited (or its affiliates). All rights reserved.
 * Use, modification and redistribution of this file is subject to your possession of a
 * valid End User License Agreement for the Arm Product of which these examples are part of
 * and your compliance with all applicable terms and conditions of such license agreement.
 *
 * Redistribution permitted only in object code form and only as
 * part of Software Applications developed by you or your permitted users. If you
 * choose to redistribute the whole or any part of Example Code, you agree: (a)
 * to ensure that they are licensed for use only as part of Software Applications
 * and only for execution on microprocessors manufactured or simulated under
 * licence from Arm; (b) not to use Arm's or any of its licensors names, logos or
 * trademarks to market Software Applications; (c) to include valid copyright
 * notices on Software Applications, and preserve any copyright notices which are
 * included with, or in, the Example Code; and (d) to ensure that any further
 * redistribution is limited to redistribution by either or both your customers
 * and your authorised distributors as part of Software Applications and that
 * your customers and your authorised distributors comply with these terms.
 */

#ifndef INCLUDED_DEVICE_H
#define INCLUDED_DEVICE_H

/**
 * Gets the unique core number of this MPIDR value
 * from the set [0, NUM_CORES)
 *
 * Note: the implementation must not use the stack as this
 * is used to initialize the stack pointer
 */
unsigned long mpidr_to_core_number(unsigned long mpidr);

/**
 * Gets the cluster number of this MPIDR value
 * from the set [0, NUM_CLUSTERS)
 */
unsigned long mpidr_to_cluster_number(unsigned long mpidr);

#endif
