LOCAL_PATH := $(call my-dir)
SRC_PATH := $(abspath $(LOCAL_PATH)/..)
GATOR_PATH := $(abspath $(LOCAL_PATH)/../../../gator)

define examples_build_executable
  include $(CLEAR_VARS)

  LOCAL_SRC_FILES += $(GATOR_PATH)/annotate/streamline_annotate.c
  LOCAL_SRC_FILES += $(SRC_PATH)/$(strip $1).c

  LOCAL_CFLAGS += -I$(GATOR_PATH)/annotate -O0 -g3 -pthread -fPIE
  LOCAL_CFLAGS += -Wall -Wextra -Wc++-compat -Wpointer-arith -Wmissing-prototypes -Wstrict-prototypes
  LOCAL_LDFLAGS += -fPIE -pie
  LOCAL_LDLIBS += -pthread -llog

  LOCAL_C_INCLUDES := $(LOCAL_PATH)

  LOCAL_MODULE := $1
  LOCAL_MODULE_TAGS := optional

  include $(BUILD_EXECUTABLE)
endef

TARGETS = absolute text cam delta visual shared
$(foreach target, $(TARGETS), $(eval $(call examples_build_executable, $(target))))
