<?xml version="1.0" encoding="UTF-8"?>
<template expand_clusters="true" version="2">
    <chart title="SPE: Operation Mix" series_composition="overlay" rendering_type="line" percentage="yes">
        <series name="% Retire Rate" expression="$SPEArchitecturallyRetiredRetired / ($SPEArchitecturallyRetiredRetired + $SPEArchitecturallyRetiredNotRetired)" description="% of instructions that retire successfully (lower numbers indicate wasted work)" display="ACCUMULATE" color="120,210,136"/>
        <series name="% L1D Cache Accesses" expression="$SPELevel1DataCacheAccess / ($SPEArchitecturallyRetiredRetired + $SPEArchitecturallyRetiredNotRetired)" description="% of samples triggering L1D cache accesses" display="ACCUMULATE" color="114,159,207"/>
        <series name="% LL Cache Accesses" expression="$SPELastLevelCacheAccess / ($SPEArchitecturallyRetiredRetired + $SPEArchitecturallyRetiredNotRetired)" description="% of samples triggering LL cache accesses" display="ACCUMULATE" color="252,233,79"/>
        <series name="% Exceptions" expression="$SPEExceptionGeneratedException / ($SPEArchitecturallyRetiredRetired + $SPEArchitecturallyRetiredNotRetired)" description="% of samples triggering exceptions" display="ACCUMULATE" color="92,53,102"/>
    </chart>
    <chart title="SPE: Latency (%)" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="% Issue" expression="$SPELatencyIssueLatency / $SPELatencyTotalLatency" description="The Percentage of Latency due to Issue of Instructions" display="AVERAGE" color="242,62,78"/>
        <series name="% Translation" expression="$SPELatencyTranslationLatency / $SPELatencyTotalLatency" description="The Percentage of Latency due to Translation" display="AVERAGE" color="252,233,79"/>
        <series name="% Execution" expression="$SPELatencyAllOtherSources / $SPELatencyTotalLatency" description="The Percentage of Latency due to Execution of Instructions" display="AVERAGE" color="120,210,136"/>
    </chart>
    <chart title="SPE: Latency (Cycles, Max)" series_composition="overlay" rendering_type="line">
        <series name="Total latency" expression="$SPELatencyTotalLatency" description="Cycle count from the operation being dispatched for issue to the operation being complete. Included for all operations." display="MAXIMUM" color="114,159,207" units="cycles"/>
        <series name="Issue latency" expression="$SPELatencyIssueLatency" description="Cycle count from the operation being dispatched for issue to the operation being issued for execution. This counts any delay in waiting the operation being ready to issue. Included for all operations." display="MAXIMUM" color="239,41,41" units="cycles"/>
        <series name="Translation latency" expression="$SPELatencyTranslationLatency" description="Cycle count from a virtual address being passed to the MMU for translation to the result of the translation being available. Included for all load, store and atomic operations." display="MAXIMUM" color="252,233,79" units="cycles"/>
        <series name="Execution latency" expression="$SPELatencyAllOtherSources" description="All remaining latency cycles counted by the total latency counter but not attributed to other counts" display="MAXIMUM" color="138,226,52" units="cycles"/>
    </chart>
    <chart title="SPE: L1D Cache Utilisation" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="% L1D Misses" expression="$SPELevel1DataCacheAccessMiss/$SPELevel1DataCacheAccess" description="% L1 Data Cache Accesses that Miss" display="ACCUMULATE" color="239,41,41"/>
        <series name="% L1D Hits" expression="$SPELevel1DataCacheAccessHit/$SPELevel1DataCacheAccess" description="% L1 Data Cache Accesses that Hit" display="ACCUMULATE" color="138,226,52"/>
    </chart>
    <chart title="SPE: LL Cache Utilisation" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="% LL Misses" expression="$SPELastLevelCacheAccessMiss/$SPELastLevelCacheAccess" description="% Last Level Cache Accesses that Miss" display="ACCUMULATE" color="245,121,0"/>
        <series name="% LL Hits" expression="$SPELastLevelCacheAccessHit/$SPELastLevelCacheAccess" description="% Last Level Cache Accesses that Hit" display="ACCUMULATE" color="78,154,6"/>
    </chart>
    <chart title="SPE: L/S Data Source (Cumulative Accesses)" series_composition="stacked" rendering_type="bar">
        <series name="L1D Cache" expression="$SPEDataSourceLevel1DataCache" description="" display="ACCUMULATE" color="138,226,52"/>
        <series name="L2 Cache" expression="$SPEDataSourceLevel2Cache" description="" display="ACCUMULATE" color="78,154,6"/>
        <series name="Peer CPU" expression="$SPEDataSourcePeerCPU" description="" display="ACCUMULATE" color="114,159,207"/>
        <series name="Local Cluster" expression="$SPEDataSourceLocalCluster" description="" display="ACCUMULATE" color="52,101,164"/>
        <series name="System Cache" expression="$SPEDataSourceSystemCache" description="" display="ACCUMULATE" color="173,127,168"/>
        <series name="Peer Cluster" expression="$SPEDataSourcePeerCluster" description="" display="ACCUMULATE" color="245,121,0"/>
        <series name="Remote Cluster" expression="$SPEDataSourceRemote" description="" display="ACCUMULATE" color="239,41,41"/>
        <series name="DRAM" expression="$SPEDataSourceDRAM" description="" display="ACCUMULATE" color="164,0,0"/>
        <series name="Late Prefetch" expression="$SPEDataSourceLatePrefetch" description="" display="ACCUMULATE" color="105,73,47"/>
    </chart>
    <chart title="SPE: L/S Data Source (Cumulative Latency)" series_composition="stacked" rendering_type="bar">
        <series name="L1D Cache" expression="$SPEDataSourceLatencyLevel1DataCache" description="" display="ACCUMULATE" color="138,226,52" unit="cycles" />
        <series name="L2 Cache" expression="$SPEDataSourceLatencyLevel2Cache" description="" display="ACCUMULATE" color="78,154,6" unit="cycles" />
        <series name="Peer CPU" expression="$SPEDataSourceLatencyPeerCPU" description="" display="ACCUMULATE" color="114,159,207" unit="cycles" />
        <series name="Local Cluster" expression="$SPEDataSourceLatencyLocalCluster" description="" display="ACCUMULATE" color="52,101,164" unit="cycles" />
        <series name="System Cache" expression="$SPEDataSourceLatencySystemCache" description="" display="ACCUMULATE" color="173,127,168" unit="cycles" />
        <series name="Peer Cluster" expression="$SPEDataSourceLatencyPeerCluster" description="" display="ACCUMULATE" color="245,121,0" unit="cycles" />
        <series name="Remote Cluster" expression="$SPEDataSourceLatencyRemote" description="" display="ACCUMULATE" color="239,41,41" unit="cycles" />
        <series name="DRAM" expression="$SPEDataSourceLatencyDRAM" description="" display="ACCUMULATE" color="164,0,0" unit="cycles" />
        <series name="Late Prefetch" expression="$SPEDataSourceLatencyLatePrefetch" description="" display="ACCUMULATE" color="105,73,47" unit="cycles" />
    </chart>
    <chart title="SPE: L/S Data Source (% of Accesses)" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="L1D Cache" expression="$SPEDataSourceLevel1DataCache / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="138,226,52"/>
        <series name="L2 Cache" expression="$SPEDataSourceLevel2Cache / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="78,154,6"/>
        <series name="Peer CPU" expression="$SPEDataSourcePeerCPU / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="114,159,207"/>
        <series name="Local Cluster" expression="$SPEDataSourceLocalCluster / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="52,101,164"/>
        <series name="System Cache" expression="$SPEDataSourceSystemCache / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="173,127,168"/>
        <series name="Peer Cluster" expression="$SPEDataSourcePeerCluster / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="245,121,0"/>
        <series name="Remote Cluster" expression="$SPEDataSourceRemote / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="239,41,41"/>
        <series name="DRAM" expression="$SPEDataSourceDRAM / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="164,0,0"/>
        <series name="Late Prefetch" expression="$SPEDataSourceLatePrefetch / ($SPEDataSourceDRAM + $SPEDataSourceLevel1DataCache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel2Cache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCluster + $SPEDataSourcePeerCPU + $SPEDataSourceRemote + $SPEDataSourceSystemCache)" description="" display="ACCUMULATE" color="105,73,47"/>
    </chart>
    <chart title="SPE: L/S Data Source (% of Latency)" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="L1D Cache" expression="$SPEDataSourceLatencyLevel1DataCache / ($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyLevel1DataCache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencySystemCache)" description="" display="ACCUMULATE" color="138,226,52"/>
        <series name="L2 Cache" expression="$SPEDataSourceLatencyLevel2Cache / ($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyLevel1DataCache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencySystemCache)" description="" display="ACCUMULATE" color="78,154,6"/>
        <series name="Peer CPU" expression="$SPEDataSourceLatencyPeerCPU / ($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyLevel1DataCache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencySystemCache)" description="" display="ACCUMULATE" color="114,159,207"/>
        <series name="Local Cluster" expression="$SPEDataSourceLatencyLocalCluster / ($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyLevel1DataCache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencySystemCache)" description="" display="ACCUMULATE" color="52,101,164"/>
        <series name="System Cache" expression="$SPEDataSourceLatencySystemCache / ($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyLevel1DataCache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencySystemCache)" description="" display="ACCUMULATE" color="173,127,168"/>
        <series name="Peer Cluster" expression="$SPEDataSourceLatencyPeerCluster / ($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyLevel1DataCache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencySystemCache)" description="" display="ACCUMULATE" color="245,121,0"/>
        <series name="Remote Cluster" expression="$SPEDataSourceLatencyRemote / ($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyLevel1DataCache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencySystemCache)" description="" display="ACCUMULATE" color="239,41,41"/>
        <series name="DRAM" expression="$SPEDataSourceLatencyDRAM / ($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyLevel1DataCache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencySystemCache)" description="" display="ACCUMULATE" color="164,0,0"/>
        <series name="Late Prefetch" expression="$SPEDataSourceLatencyLatePrefetch / ($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyLevel1DataCache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencySystemCache)" description="" display="ACCUMULATE" color="105,73,47"/>
    </chart>
    <chart title="SPE: Load Performance" series_composition="overlay" rendering_type="line">
        <series name="Theoretical Peak Cycles" expression="($SPEDataSourceDRAM + $SPEDataSourceRemote + $SPEDataSourcePeerCluster + $SPEDataSourceSystemCache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCPU + $SPEDataSourceLevel2Cache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel1DataCache) * 4" description="Estimated theoretical peak cycle count if all loads were to hit in L1 cache." display="ACCUMULATE" color="138,226,52"/>
        <series name="Real Peak Cycles" expression="($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencySystemCache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel1DataCache)" description="The actual cumulative cycle count for all loads." display="ACCUMULATE" color="164,0,0"/>
    </chart>
    <chart title="SPE: Load Performance Cost" series_composition="stacked" rendering_type="bar">
        <series name="Load Cycles Slowdown" expression="($SPEDataSourceLatencyDRAM + $SPEDataSourceLatencyRemote + $SPEDataSourceLatencyPeerCluster + $SPEDataSourceLatencySystemCache + $SPEDataSourceLatencyLocalCluster + $SPEDataSourceLatencyPeerCPU + $SPEDataSourceLatencyLevel2Cache + $SPEDataSourceLatencyLatePrefetch + $SPEDataSourceLatencyLevel1DataCache) / (($SPEDataSourceDRAM + $SPEDataSourceRemote + $SPEDataSourcePeerCluster + $SPEDataSourceSystemCache + $SPEDataSourceLocalCluster + $SPEDataSourcePeerCPU + $SPEDataSourceLevel2Cache + $SPEDataSourceLatePrefetch + $SPEDataSourceLevel1DataCache) * 4)" description="The number of times slower the real load cycle count is as compared to the theoretical peak." display="ACCUMULATE" color="164,0,0"/>
    </chart>
    <chart title="SPE: Branch Prediction" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="% Predictions" expression="$SPEBranchPredictionPredicted / ($SPEBranchPredictionPredicted+$SPEBranchPredictionMispredicted)" description="" display="ACCUMULATE" color="120,210,136"/>
        <series name="% Mispredictions" expression="$SPEBranchPredictionMispredicted/($SPEBranchPredictionPredicted+$SPEBranchPredictionMispredicted)" description="Shows the percentage of branch instructions that were mispredicted" display="ACCUMULATE" color="245,121,0"/>
    </chart>
    <chart title="SPE: Conditional Instruction" series_composition="stacked" rendering_type="bar" percentage="yes">
        <series name="% Taken" expression="$SPEConditionalInstructionTaken / ($SPEConditionalInstructionTaken+$SPEConditionalInstructionNotTaken)" description="% of conditional branch instructions, where the conditional check passes" display="ACCUMULATE" color="138,226,52"/>
        <series name="% Not Taken" expression="$SPEConditionalInstructionNotTaken / ($SPEConditionalInstructionTaken+$SPEConditionalInstructionNotTaken)" description="" display="ACCUMULATE" color="242,62,78"/>
    </chart>
    <chart title="SPE: TLB Utilisation" series_composition="overlay" rendering_type="bar" percentage="yes">
        <series name="% No Walk" expression="$SPETLBRefillTranslationTableWalkNoWalk / $SPETLBAccess" description="% of Load/Store operations that were served from the TLB" display="ACCUMULATE" color="120,210,136"/>
        <series name="% Walk" expression="$SPETLBRefillTranslationTableWalkWalk / $SPETLBAccess" description="% of Load/Store operations that caused the TLB to perform a page table walk" display="ACCUMULATE" color="239,41,41"/>
    </chart>
    <chart title="SPE: Multi-socket Data Access" series_composition="overlay" rendering_type="bar" percentage="yes">
        <series name="% Local" expression="$SPEMultiSocketDataAccessLocalSocketAccess / ($SPEMultiSocketDataAccessLocalSocketAccess + $SPEMultiSocketDataAccessRemoteSocketAccess)" description="% of load/store operations that did not cause an access to another socket in a multi-socket system. " display="ACCUMULATE" color="120,210,136"/>
        <series name="% Remote" expression="$SPEMultiSocketDataAccessRemoteSocketAccess / ($SPEMultiSocketDataAccessLocalSocketAccess + $SPEMultiSocketDataAccessRemoteSocketAccess)" description="% of load/store operations that did caused an access to another socket in a multi-socket system. " display="ACCUMULATE" color="242,62,78"/>
    </chart>
</template>
