/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_examples;

import com.arm.databinding.ObservablesHelper;
import com.arm.streamline.wizard.import_examples.ExamplesXml;
import com.arm.streamline.wizard.import_examples.ImportExamplesWizardTreeNode;
import com.arm.streamline.wizard.import_examples.Messages;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public class ImportExamplesWizardViewModel {
    private static final @Nullable Image IMAGE_CAPTURE = null;
    private static final @Nullable Image IMAGE_CATEGORY = null;
    private final @NonNull WritableList<@NonNull ImportExamplesWizardTreeNode> propertyAllItems = new WritableList(new ArrayList(), ImportExamplesWizardTreeNode.class);
    private final @NonNull IObservableValue<@NonNull Boolean> propertyCanFinish;
    private final @NonNull IObservableSet<@NonNull ExamplesXml.Example> propertyCheckedExamples;
    private final @NonNull WritableSet<@NonNull ImportExamplesWizardTreeNode> propertyCheckedItems = new WritableSet(new HashSet(), ImportExamplesWizardTreeNode.class);
    private final @NonNull IObservableValue<@Nullable String> propertyTooltipText;

    private static @NonNull Set<@NonNull ImportExamplesWizardTreeNode> collectAllNodes(Collection<? extends @NonNull ImportExamplesWizardTreeNode> nodes) {
        HashSet<@NonNull ImportExamplesWizardTreeNode> result = new HashSet<ImportExamplesWizardTreeNode>();
        for (ImportExamplesWizardTreeNode importExamplesWizardTreeNode : nodes) {
            result.add(importExamplesWizardTreeNode);
            result.addAll(ImportExamplesWizardViewModel.collectAllNodes(importExamplesWizardTreeNode.getChildren()));
        }
        return result;
    }

    public ImportExamplesWizardViewModel(@NonNull List<@NonNull ExamplesXml.Category> categories) {
        this.propertyCheckedExamples = ObservablesHelper.createComputedSet(() -> this.propertyCheckedItems.stream().filter(n -> n.getExample() != null).map(n -> (ExamplesXml.Example)NullChecking.neverNull((Object)n.getExample())).collect(Collectors.toSet()));
        this.propertyCanFinish = ComputedValue.create(() -> !this.propertyCheckedExamples.isEmpty());
        this.propertyTooltipText = ComputedValue.create(() -> this.propertyAllItems.isEmpty() ? Messages.ImportExamplesWizardViewModel_NO_SUPPORTED_EXAMPLES_DUE_TO_LICENSE : null);
        HashSet<@NonNull ImportExamplesWizardTreeNode> itemsToCheck = new HashSet<ImportExamplesWizardTreeNode>();
        for (ExamplesXml.Category category : categories) {
            ImportExamplesWizardTreeNode categoryNode = null;
            for (ExamplesXml.Example example : category.getExamples()) {
                if (categoryNode == null) {
                    categoryNode = new ImportExamplesWizardTreeNode(null, null, category.getName(), null, IMAGE_CATEGORY);
                    this.propertyAllItems.add((Object)categoryNode);
                    itemsToCheck.add(categoryNode);
                }
                ImportExamplesWizardTreeNode exampleNode = new ImportExamplesWizardTreeNode(categoryNode, example, example.getName(), example.getDescription(), IMAGE_CAPTURE);
                itemsToCheck.add(exampleNode);
            }
        }
        this.propertyCheckedItems.addSetChangeListener(e -> {
            ImportExamplesWizardTreeNode parent;
            Set<@NonNull ImportExamplesWizardTreeNode> allToAdd = ImportExamplesWizardViewModel.collectAllNodes(e.diff.getAdditions());
            Set<@NonNull ImportExamplesWizardTreeNode> allToRemove = ImportExamplesWizardViewModel.collectAllNodes(e.diff.getRemovals());
            HashSet<@NonNull ImportExamplesWizardTreeNode> parentsOfAdded = new HashSet<ImportExamplesWizardTreeNode>();
            for (ImportExamplesWizardTreeNode toAdd : allToAdd) {
                parent = toAdd.getParent();
                if (parent == null) continue;
                boolean foundUnchecked = false;
                for (ImportExamplesWizardTreeNode child : parent.getChildren()) {
                    if (!allToRemove.contains(child) && this.propertyCheckedItems.contains((Object)child)) continue;
                    foundUnchecked = true;
                }
                if (foundUnchecked) continue;
                parentsOfAdded.add(parent);
            }
            allToAdd.addAll(parentsOfAdded);
            HashSet<@NonNull ImportExamplesWizardTreeNode> parentsOfRemoved = new HashSet<ImportExamplesWizardTreeNode>();
            for (ImportExamplesWizardTreeNode toRemove : allToRemove) {
                parent = toRemove.getParent();
                if (parent == null) continue;
                boolean foundChecked = false;
                for (ImportExamplesWizardTreeNode child : parent.getChildren()) {
                    if (allToRemove.contains(child) || !this.propertyCheckedItems.contains((Object)child)) continue;
                    foundChecked = true;
                }
                if (foundChecked) continue;
                parentsOfRemoved.add(parent);
            }
            allToRemove.addAll(parentsOfRemoved);
            allToAdd.removeAll(allToRemove);
            this.propertyCheckedItems.getRealm().asyncExec(() -> {
                this.propertyCheckedItems.addAll((Collection)allToAdd);
                this.propertyCheckedItems.removeAll((Collection)allToRemove);
            });
        });
        this.propertyCheckedItems.getRealm().asyncExec(() -> {
            boolean bl = this.propertyCheckedItems.addAll((Collection)itemsToCheck);
        });
    }

    public @NonNull ObservableList<@NonNull ImportExamplesWizardTreeNode> getPropertyAllItems() {
        return this.propertyAllItems;
    }

    public @NonNull IObservableValue<@NonNull Boolean> getPropertyCanFinish() {
        return this.propertyCanFinish;
    }

    public @NonNull IObservableSet<@NonNull ExamplesXml.Example> getPropertyCheckedExamples() {
        return this.propertyCheckedExamples;
    }

    public @NonNull ObservableSet<@NonNull ImportExamplesWizardTreeNode> getPropertyCheckedItems() {
        return this.propertyCheckedItems;
    }

    public @NonNull IObservableValue<@Nullable String> getPropertyTooltipText() {
        return this.propertyTooltipText;
    }
}

