/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_examples;

import com.arm.coresight.ds5_trace_dump.ITraceDumpDirectory;
import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.databrowser.trace_dump_import.TraceDumpImportClassification;
import com.arm.streamline.dataimport.IFileTypeChecker;
import com.arm.streamline.dataimport.ImportFileType;
import com.arm.streamline.dataimport.ImportJobFactory;
import com.arm.streamline.dataimport.OutputPathProvider;
import com.arm.streamline.widget.Error;
import com.arm.streamline.wizard.import_examples.ExamplesXml;
import com.arm.streamline.wizard.import_examples.ImportExamplesWizardPage;
import com.arm.streamline.wizard.import_examples.ImportExamplesWizardViewModel;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportExamplesWizard
extends Wizard
implements IImportWizard {
    private static final String EXAMPLES_APC_PATH_FORMAT = "%s/apcs/%s.apc.zip";
    private final @NonNull ImportExamplesWizardPage page;
    private final @NonNull ImportExamplesWizardViewModel viewModel;

    public ImportExamplesWizard() {
        @Nullable ExamplesXml examples = ExamplesXml.load();
        this.viewModel = new ImportExamplesWizardViewModel(examples != null ? examples.getCategories() : Collections.emptyList());
        this.viewModel.getPropertyCanFinish().addChangeListener(e -> this.getContainer().updateButtons());
        this.page = new ImportExamplesWizardPage(this.viewModel);
        this.addPage((IWizardPage)this.page);
    }

    public boolean canFinish() {
        return (Boolean)this.viewModel.getPropertyCanFinish().getValue();
    }

    public IWizardPage getStartingPage() {
        return this.page;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        HashSet<@NonNull ExamplesXml.Example> examples = new HashSet<ExamplesXml.Example>((Collection<ExamplesXml.Example>)this.viewModel.getPropertyCheckedExamples());
        String examplesPath = StreamlinePlugin.getExamplesPath().getAbsolutePath();
        @NonNull List<@NonNull T> files = examples.stream().map(e -> new File(String.format(EXAMPLES_APC_PATH_FORMAT, examplesPath, e.getID()))).collect(Collectors.toList());
        @NonNull ImportJobFactory.IImportJobConfigurationSupplier nopSelector = new ImportJobFactory.IImportJobConfigurationSupplier(){

            @Override
            public @Nullable ImportJobFactory.ITraceDumpImportConfiguration selectTraceDumpImportConfiguration(@NonNull ITraceDumpDirectory directory, @NonNull Map<@NonNull TraceDumpImportClassification, @NonNull Collection<@NonNull ITraceSourceStreamWrapper>> classifications) throws ImportJobFactory.ImportJobCreationException {
                throw new AssertionError();
            }
        };
        @NonNull IFileTypeChecker fileChecker = IFileTypeChecker.DEFAULT;
        @NonNull File apcOutputPath = OutputPathProvider.getApcOutputPath();
        @NonNull ImportFileType fileType = ImportFileType.ZIP_APC;
        this.getShell().getDisplay().asyncExec(() -> {
            try {
                @NonNull List<@NonNull Job> importJobs = ImportJobFactory.createImportJobs(nopSelector, fileChecker, files, apcOutputPath, fileType, false);
                for (Job importJob : importJobs) {
                    importJob.schedule();
                }
                Task.callOnAnotherThread(() -> {
                    for (Job importJob : importJobs) {
                        try {
                            importJob.join();
                        }
                        catch (InterruptedException exception) {
                            exception.printStackTrace();
                        }
                        IStatus status = importJob.getResult();
                        if (status.isOK()) continue;
                        Error.show(status.getMessage(), status.getException(), true);
                    }
                });
            }
            catch (ImportJobFactory.ImportJobCreationException exception) {
                Error.show(exception);
            }
        });
        return true;
    }
}

