/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_examples;

import com.arm.util.NumberUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root
public class ExamplesXml {
    private static final String XML_RESOURCE_PATH = "/resources/examples.xml";
    @ElementList(name="category", required=true, type=Category.class, inline=true)
    private final @NonNull List<@NonNull Category> categories;

    public static @Nullable ExamplesXml load() {
        Persister serializer = new Persister();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream inputStream = ExamplesXml.class.getResourceAsStream(XML_RESOURCE_PATH);){
                return (ExamplesXml)serializer.read(ExamplesXml.class, inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public ExamplesXml(@ElementList(name="category", required=true, type=Category.class, inline=true) @NonNull List<@NonNull Category> categories) {
        this.categories = categories;
    }

    public @NonNull List<@NonNull Category> getCategories() {
        return this.categories;
    }

    public static class Category {
        @ElementList(name="example", required=true, type=Example.class, inline=true)
        private final @NonNull List<@NonNull Example> examples;
        @Attribute(name="name", required=true)
        private final @NonNull String name;

        public Category(@Attribute(name="name", required=true) @NonNull String name, @ElementList(name="example", required=true, type=Example.class, inline=true) @NonNull List<@NonNull Example> examples) {
            this.name = name;
            this.examples = examples;
        }

        public @NonNull List<@NonNull Example> getExamples() {
            return Collections.unmodifiableList(this.examples);
        }

        public @NonNull String getName() {
            return this.name;
        }
    }

    public static class Example {
        @Attribute(name="description", required=false)
        private final @NonNull String description;
        @Attribute(name="id", required=true)
        private final @NonNull String id;
        @Attribute(name="name", required=true)
        private final @NonNull String name;
        @ElementList(name="cpuids", entry="cpuid", type=String.class, required=false, inline=true)
        private final @Nullable List<@NonNull String> cpuids;

        public Example(@Attribute(name="id", required=true) @NonNull String id, @Attribute(name="name", required=true) @NonNull String name, @Attribute(name="description", required=false) @Nullable String description, @ElementList(name="cpuids", entry="cpuid", type=String.class, required=false, inline=true) @Nullable List<@NonNull String> cpuids) {
            this.id = id;
            this.name = name;
            this.description = (String)NullChecking.neverNullOr((Object)description, (Object)"");
            this.cpuids = cpuids;
        }

        public @NonNull String getDescription() {
            return this.description;
        }

        public @NonNull String getID() {
            return this.id;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public int @NonNull [] getCupids() {
            return StreamUtils.emptyIfNullOfCollection(this.cpuids).mapToLong(NumberUtils::parseHex).mapToInt(Math::toIntExact).toArray();
        }
    }
}

