/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf.viewmodel;

import com.arm.streamline.wizard.import_astf.viewmodel.ASTFImportUtility;
import com.arm.utils.collections.Pair;
import java.io.File;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public final class ASTFImportFileModel {
    private final @NonNull File astf;
    private final @NonNull String name;
    private Integer clusterId;
    private Integer coreId;

    public ASTFImportFileModel(@NonNull File astfFile) {
        this.astf = astfFile;
        this.name = astfFile.getName();
        this.updateClusterCoreValuesFromFilename();
    }

    public @NonNull String getFilePath() {
        return this.astf.getPath();
    }

    public @NonNull String getFileName() {
        return this.name;
    }

    public @NonNull File getAstfFile() {
        return this.astf;
    }

    public Integer getClusterId() {
        return this.clusterId;
    }

    public Integer getCoreId() {
        return this.coreId;
    }

    public void setClusterId(Integer id) {
        this.clusterId = id;
    }

    public void setCoreId(Integer id) {
        this.coreId = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getFilePath().hashCode();
        result = 31 * result + this.getFileName().hashCode();
        result = 31 * result + this.getAstfFile().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ASTFImportFileModel other = (ASTFImportFileModel)obj;
        if (!this.getFileName().equals(other.getFileName())) {
            return false;
        }
        if (!this.getFilePath().equals(other.getFilePath())) {
            return false;
        }
        if (!this.getAstfFile().equals(other.getAstfFile())) {
            return false;
        }
        if (!Objects.equals(this.getClusterId(), other.getClusterId())) {
            return false;
        }
        return Objects.equals(this.getCoreId(), other.getCoreId());
    }

    @NonNull Pair<Integer, Integer> getClusterAndCore() {
        return new Pair((Object)this.clusterId, (Object)this.coreId);
    }

    void setClusterAndCore(@NonNull Pair<Integer, Integer> clusterCorePair) {
        this.clusterId = (Integer)clusterCorePair.first;
        this.coreId = (Integer)clusterCorePair.second;
    }

    public void updateClusterCoreValuesFromFilename() {
        Pair<Integer, Integer> clusterCorePair = ASTFImportUtility.parseClusterAndCoreFromFileName(this.name);
        this.setClusterAndCore(clusterCorePair);
    }

    void updateClusterAndCoreFromSavedOrFilename(Pair<Integer, Integer> savedClusterAndCore) {
        if (savedClusterAndCore == null) {
            this.updateClusterCoreValuesFromFilename();
        } else {
            this.setClusterAndCore(savedClusterAndCore);
        }
    }
}

