/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf;

import com.arm.streamline.wizard.import_astf.Messages;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFAdditionalOptionsViewModel;
import com.arm.utils.NullChecking;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class ASTFAdditionalOptionsWizardPage
extends WizardPage {
    private @NonNull ASTFAdditionalOptionsViewModel viewModel;
    private FileDialog openFiles;
    private Text pidTidMapPath;
    private Button pidTidMapBrowseButton;
    private Button collectLinuxSyscallsCheckBox;

    public ASTFAdditionalOptionsWizardPage(@NonNull ASTFAdditionalOptionsViewModel viewModel, int currentPageNumber, int totalPages) {
        super("", MessageFormat.format(Messages.ImportASTFWIzard_Additional_Options_Title, currentPageNumber, totalPages), null);
        this.setDescription(Messages.ImportASTFWizard_Additional_Options_Description);
        this.viewModel = viewModel;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createFileDialog();
        this.createPidTidMapGroup(composite);
        this.createCollectLinuxSyscallsGroup(composite);
        this.initDataBindings();
    }

    private void createFileDialog() {
        this.openFiles = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
    }

    private void createPidTidMapGroup(@NonNull Composite composite) {
        Composite pidTidMapContainer = new Composite(composite, 0);
        pidTidMapContainer.setLayout((Layout)new GridLayout(3, false));
        pidTidMapContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(pidTidMapContainer, 0);
        label.setText(Messages.ImportASTFCapture_PidTidMap_Label);
        label.setToolTipText(Messages.ImportASTFCapture_PidTidMap_ToolTip);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        this.pidTidMapPath = new Text(pidTidMapContainer, 0);
        assert (this.pidTidMapPath != null);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.pidTidMapPath);
        this.pidTidMapPath.setToolTipText(Messages.ImportASTFCapture_PidTidMap_ToolTip);
        this.pidTidMapBrowseButton = new Button(pidTidMapContainer, 8);
        assert (this.pidTidMapBrowseButton != null);
        this.pidTidMapBrowseButton.setText(Messages.ImportASTFWizard_Browse_button);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.pidTidMapBrowseButton);
    }

    private void createCollectLinuxSyscallsGroup(@NonNull Composite composite) {
        Composite checkBoxContainer = new Composite(composite, 0);
        checkBoxContainer.setLayout((Layout)new GridLayout(1, false));
        checkBoxContainer.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.collectLinuxSyscallsCheckBox = new Button(checkBoxContainer, 32);
        this.collectLinuxSyscallsCheckBox.setText(Messages.ImportASTFWizard_Collect_Linux_Syscalls_Checkbox);
        this.collectLinuxSyscallsCheckBox.setSelection(false);
        this.collectLinuxSyscallsCheckBox.setToolTipText(Messages.ImportASTFCapture_Collect_Linux_Syscalls_Tooltip);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.collectLinuxSyscallsCheckBox);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        @NonNull ISWTObservableValue observeText = WidgetProperties.text((int)24).observe((Widget)NullChecking.neverNull((Object)this.pidTidMapPath));
        bindingContext.bindValue((IObservableValue)observeText, this.viewModel.getObservablePidTidMapPath());
        bindingContext.addValidationStatusProvider(this.viewModel.getValidationStatusProvider());
        this.pidTidMapBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ASTFAdditionalOptionsWizardPage.this.openFiles.open() != null) {
                    String filterPath = ASTFAdditionalOptionsWizardPage.this.openFiles.getFilterPath();
                    String fileName = ASTFAdditionalOptionsWizardPage.this.openFiles.getFileName();
                    if (!fileName.isEmpty()) {
                        File file = new File(filterPath, fileName);
                        ASTFAdditionalOptionsWizardPage.this.pidTidMapPath.setText(file.getAbsolutePath());
                    }
                }
            }
        });
        bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)((Button)NullChecking.neverNull((Object)this.collectLinuxSyscallsCheckBox))), this.viewModel.getObservableCollectLinuxSyscalls());
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)bindingContext);
    }
}

