/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.wizard.import_astf.Messages;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFAddFileViewModel;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFImportFileModel;
import com.arm.utils.NullChecking;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.CellEditorProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public final class ASTFAddFileWizardPage
extends WizardPage {
    private TableViewer astfFilesTableViewer;
    private Button addAstfFileBtn;
    private Button removeAstfFileBtn;
    private Button moveUpAstfFileBtn;
    private Button moveDownAstfFileBtn;
    private Button singleCoreBtn;
    private Button multiCoreBtn;
    private FileDialog openFiles;
    private TableViewerColumn traceFilesColumn;
    private TableViewerColumn clusterColumn;
    private TableViewerColumn coreColumn;
    private Label autoSortExplanationLabel;
    private static final @NonNull String ASTF_EXTN_FILTER = "*.astf";
    private @NonNull ASTFAddFileViewModel viewModel;
    private static final int CORE_CLUSTER_COLUMN_WIDTH = 100;
    private static final int TRACE_FILE_COLUMN_WIDTH = 400;
    private static final int TABLE_HEIGHT = 300;
    private static final int TABLE_WIDTH = 600;

    public ASTFAddFileWizardPage(@NonNull ASTFAddFileViewModel viewModel, int currentPageNumber, int totalPages) {
        super("SingleCoreFileImport", MessageFormat.format(Messages.ImportASTFWizard_Add_ASTF_Title, currentPageNumber, totalPages), null);
        this.setDescription(Messages.ImportASTFWizard_Description);
        this.viewModel = viewModel;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSingleMultiCoreRadioButtons(composite);
        this.createImportElements(composite);
        this.initDataBindings();
    }

    private void createFileDialog() {
        this.openFiles = new FileDialog(Display.getCurrent().getActiveShell(), 4098);
        this.openFiles.setFilterExtensions(new String[]{ASTF_EXTN_FILTER});
    }

    private void createSingleMultiCoreRadioButtons(@NonNull Composite composite) {
        Composite radioButtonContainer = new Composite(composite, 0);
        radioButtonContainer.setLayout((Layout)new GridLayout(2, false));
        radioButtonContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.singleCoreBtn = new Button(radioButtonContainer, 16);
        this.singleCoreBtn.setText(Messages.ImportASTFWizard_Single_Core_Button);
        this.singleCoreBtn.setSelection(true);
        this.singleCoreBtn.setToolTipText(Messages.ImportASTFCapture_SingleCoreButton_Tooltip);
        this.multiCoreBtn = new Button(radioButtonContainer, 16);
        this.multiCoreBtn.setText(Messages.ImportASTFWizard_Multi_Core_Button);
        this.multiCoreBtn.setToolTipText(Messages.ImportASTFCapture_MultiCoreButton_Tooltip);
    }

    private void createImportElements(@NonNull Composite composite) {
        Composite fileTableContainer = new Composite(composite, 0);
        fileTableContainer.setLayout((Layout)new GridLayout(2, false));
        fileTableContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createASTFFilesLists(fileTableContainer);
        this.createButtonGroup(fileTableContainer);
        this.createMultiCoreAutoFillLabel(composite);
        this.createFileDialog();
    }

    private void createButtonGroup(@NonNull Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).applyTo(buttonComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)buttonComposite);
        this.addAstfFileBtn = new Button(buttonComposite, 8);
        this.addAstfFileBtn.setText(Messages.ImportASTFFile_Add_Button);
        this.addAstfFileBtn.setToolTipText(Messages.ImportASTFFile_Add_Button_tooltip);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.addAstfFileBtn);
        this.removeAstfFileBtn = new Button(buttonComposite, 8);
        this.removeAstfFileBtn.setText(Messages.ImportASTFFile_Remove_Button);
        this.removeAstfFileBtn.setToolTipText(Messages.ImportASTFFile_Remove_Button_tooltip);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.removeAstfFileBtn);
        Label label = new Label(buttonComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.moveUpAstfFileBtn = new Button(buttonComposite, 8);
        this.moveUpAstfFileBtn.setText(Messages.ImportASTFFile_Up_Button);
        this.moveUpAstfFileBtn.setToolTipText(Messages.ImportASTFFile_Up_Button_tooltip);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.moveUpAstfFileBtn);
        this.moveDownAstfFileBtn = new Button(buttonComposite, 8);
        this.moveDownAstfFileBtn.setText(Messages.ImportASTFFile_Down_Button);
        this.moveDownAstfFileBtn.setToolTipText(Messages.ImportASTFFile_Down_Button_tooltip);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.moveDownAstfFileBtn);
    }

    private void createASTFFilesLists(@NonNull Composite composite) {
        Composite fileListComposite = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).applyTo(fileListComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fileListComposite);
        this.astfFilesTableViewer = new TableViewer(fileListComposite, 2818);
        assert (this.astfFilesTableViewer != null);
        Table astfFilesTable = this.astfFilesTableViewer.getTable();
        astfFilesTable.setHeaderVisible(true);
        astfFilesTable.setLinesVisible(true);
        this.traceFilesColumn = new TableViewerColumn(this.astfFilesTableViewer, 0);
        this.traceFilesColumn.getColumn().setText(Messages.ImportASTFWizard_Trace_File_Title);
        this.traceFilesColumn.getColumn().setWidth(400);
        this.clusterColumn = new TableViewerColumn(this.astfFilesTableViewer, 0);
        this.clusterColumn.getColumn().setText(Messages.ImportASTFWizard_ClusterId_Title);
        this.clusterColumn.getColumn().setWidth(0);
        this.coreColumn = new TableViewerColumn(this.astfFilesTableViewer, 0);
        this.coreColumn.getColumn().setText(Messages.ImportASTFWizard_CoreId_Title);
        this.coreColumn.getColumn().setWidth(0);
        if (((Boolean)this.viewModel.getMultiCoreMode().getValue()).booleanValue()) {
            this.astfFilesTableViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    ASTFImportFileModel file1 = (ASTFImportFileModel)e1;
                    ASTFImportFileModel file2 = (ASTFImportFileModel)e2;
                    return file1.getFilePath().compareTo(file2.getFilePath());
                }
            });
        } else {
            this.astfFilesTableViewer.setComparator(null);
        }
        GridDataFactory.fillDefaults().grab(true, true).hint(600, 300).applyTo((Control)this.astfFilesTableViewer.getTable());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.astfFilesTableViewer, (int)1);
    }

    private void createMultiCoreAutoFillLabel(Composite composite) {
        this.autoSortExplanationLabel = new Label(composite, 64);
        GridData explanationLabelGridData = new GridData(4, 0x1000000, true, false);
        explanationLabelGridData.widthHint = 400;
        this.autoSortExplanationLabel.setLayoutData((Object)explanationLabelGridData);
        this.autoSortExplanationLabel.setText(Messages.ImportASTFWizard_MultiCore_AutoFill_Explanation);
    }

    private void updateTableColumns(Boolean multiCoreMode) {
        if (multiCoreMode.booleanValue()) {
            this.clusterColumn.getColumn().setWidth(100);
            this.coreColumn.getColumn().setWidth(100);
            this.setDescription(Messages.ImportASTFWizard_MultiCore_Description);
        } else {
            this.clusterColumn.getColumn().setWidth(0);
            this.coreColumn.getColumn().setWidth(0);
            this.setDescription(Messages.ImportASTFWizard_Description);
        }
        this.viewModel.resetAllFileClusterCoreValues();
        this.astfFilesTableViewer.refresh();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)((Button)NullChecking.neverNull((Object)this.multiCoreBtn))), this.viewModel.getMultiCoreMode());
        this.viewModel.getMultiCoreMode().addValueChangeListener(event -> Task.callOnUIThread(() -> this.updateTableColumns((Boolean)valueChangeEvent.diff.getNewValue())));
        ISWTObservableValue autoSortLabelObserver = WidgetProperties.visible().observe((Widget)this.autoSortExplanationLabel);
        bindingContext.bindValue((IObservableValue)autoSortLabelObserver, this.viewModel.getMultiCoreMode());
        ISWTObservableValue observeUpButtonVisible = WidgetProperties.visible().observe((Widget)NullChecking.neverNull((Object)this.moveUpAstfFileBtn));
        bindingContext.bindValue((IObservableValue)observeUpButtonVisible, this.viewModel.canEnableUpDownButton());
        ISWTObservableValue observeDownButtonVisible = WidgetProperties.visible().observe((Widget)NullChecking.neverNull((Object)this.moveDownAstfFileBtn));
        bindingContext.bindValue((IObservableValue)observeDownButtonVisible, this.viewModel.canEnableUpDownButton());
        @NonNull ComputedList<@NonNull ASTFImportFileModel> itemsObservable = this.viewModel.getPropertyAllItems();
        this.astfFilesTableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.astfFilesTableViewer.setInput(itemsObservable);
        IValueProperty<ASTFImportFileModel, String> valueProperty = ASTFAddFileViewModel.getFileInputProperty();
        IValueProperty<ASTFImportFileModel, Integer> clusterIdProperty = this.viewModel.getClusterIdProperty();
        IValueProperty<ASTFImportFileModel, Integer> coreIdProperty = this.viewModel.getCoreIdProperty();
        ViewerSupport.bind((StructuredViewer)this.astfFilesTableViewer, this.viewModel.getPropertyAllItems(), (IValueProperty[])new IValueProperty[]{valueProperty, clusterIdProperty, coreIdProperty});
        IViewerObservableList observeMultipleSelection = ViewerProperties.multipleSelection().observe((Viewer)this.astfFilesTableViewer);
        bindingContext.bindList((IObservableList)observeMultipleSelection, this.viewModel.getPropertySelectedASTFFiles(), null, null);
        @NonNull IValueProperty cellEditorControlText = CellEditorProperties.control().value((IValueProperty)WidgetProperties.text((int)24));
        this.clusterColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.astfFilesTableViewer, (DataBindingContext)bindingContext, (CellEditor)new TextCellEditor((Composite)this.astfFilesTableViewer.getTable()), (IValueProperty)cellEditorControlText, clusterIdProperty));
        this.coreColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this.astfFilesTableViewer, (DataBindingContext)bindingContext, (CellEditor)new TextCellEditor((Composite)this.astfFilesTableViewer.getTable()), (IValueProperty)cellEditorControlText, coreIdProperty));
        bindingContext.bindList(this.viewModel.getPropertyNewFilesAdded(), this.viewModel.getAstfFilesFromDialogList());
        bindingContext.addValidationStatusProvider(this.viewModel.getValidationStatusProvider());
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)bindingContext);
        ISWTObservableValue observeRemoveButtonEnable = WidgetProperties.enabled().observe((Widget)NullChecking.neverNull((Object)this.removeAstfFileBtn));
        bindingContext.bindValue((IObservableValue)observeRemoveButtonEnable, this.viewModel.canEnableRemoveButton());
        this.addAstfFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ASTFAddFileWizardPage.this.openFiles.open() != null) {
                    String[] fileNames = ASTFAddFileWizardPage.this.openFiles.getFileNames();
                    String filterPath = ASTFAddFileWizardPage.this.openFiles.getFilterPath();
                    @NonNull ArrayList<@NonNull ASTFImportFileModel> astfFiles = new ArrayList<ASTFImportFileModel>();
                    String[] stringArray = fileNames;
                    int n = fileNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String astf = stringArray[n2];
                        File astfFile = new File(filterPath, astf);
                        if (astfFile.isFile()) {
                            astfFiles.add(new ASTFImportFileModel(astfFile));
                        }
                        ++n2;
                    }
                    if (!astfFiles.isEmpty()) {
                        ASTFAddFileWizardPage.this.viewModel.addFilesFromDialog(astfFiles);
                    }
                }
                ASTFAddFileWizardPage.this.viewModel.setFileActionMode(ASTFAddFileViewModel.ASTFFileActions.ADD);
            }
        });
        this.moveUpAstfFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASTFAddFileWizardPage.this.viewModel.setFileActionMode(ASTFAddFileViewModel.ASTFFileActions.UP);
            }
        });
        this.moveDownAstfFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASTFAddFileWizardPage.this.viewModel.setFileActionMode(ASTFAddFileViewModel.ASTFFileActions.DOWN);
            }
        });
        this.removeAstfFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASTFAddFileWizardPage.this.viewModel.setFileActionMode(ASTFAddFileViewModel.ASTFFileActions.REMOVE);
            }
        });
    }
}

