/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.ICellMouseHandler;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.ILinkProvider;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.utils.NullChecking;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;

public class TextCell<C extends Column<C>>
implements ICell<C>,
ICellMouseHandler<C> {
    public static final int H_MARGIN = 4;
    public static final int V_MARGIN = 1;
    private @NonNull String mBrowserViewId = "com.arm.eclipse.toolkit.link";
    private @NonNull IColumnCompareType<C> mCompareType;
    private @Nullable URL mCurrentLink;
    private int mHAlignment;
    private int mIconHAlignment = 16384;
    private @Nullable C mLinkColumn;
    private boolean mLinkPressed;
    private @Nullable ILinkProvider<C> mLinkProvider;
    private @Nullable Row<C> mLinkRow;
    private int mTruncationType;
    private int mVAlignment;

    public static void drawTextCellSimple(GC gc, Font font, @NonNull Rectangle bounds, @NonNull String text, boolean selected, boolean active) {
        TextCell.drawTextCell(gc, font, bounds, text, selected, active, null, new Rectangle(0, 0, 0, 0), 131072, 16384, -1, 16384, Colors.getBlack(), 0, false);
    }

    public static void drawTextCell(GC gc, Font font, @NonNull Rectangle bounds, @NonNull String originalText, boolean selected, boolean active, @Nullable Image icon, @NonNull Rectangle imageBounds, int truncationType, int vAlignment, int hAlignment, int iconHAlignment, Color foregroundColour, int iconGap, boolean drawAsLink) {
        Font savedFont = gc.getFont();
        FontInfo fontInfo = FontInfo.get(font);
        gc.setFont(font);
        int cellWidth = bounds.width - (4 + imageBounds.width + 4);
        int cellHeight = bounds.height - 2;
        int x = bounds.x + 4;
        int y = bounds.y + 1;
        String text = TextDrawing.truncateText(font, originalText, cellWidth, truncationType);
        Point textSize = fontInfo.getExtent(text);
        if (vAlignment != 128) {
            int yDelta = cellHeight - textSize.y;
            if (vAlignment == 0x1000000) {
                yDelta /= 2;
            }
            y += yDelta;
        }
        textSize.x += imageBounds.width;
        if (hAlignment == 16384) {
            if (iconHAlignment == 16384) {
                x += imageBounds.width;
            }
        } else {
            int hDelta = cellWidth - textSize.x;
            if (hAlignment == 0x1000000) {
                hDelta /= 2;
            }
            x += hDelta;
        }
        gc.setForeground(foregroundColour);
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
        int lineHeight = fontInfo.getHeight();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("\n".equals(token)) {
                y += lineHeight;
                continue;
            }
            int tx = bounds.x + 4;
            if (hAlignment == 16384) {
                if (iconHAlignment == 16384) {
                    tx += imageBounds.width;
                }
            } else {
                int hDelta = cellWidth - fontInfo.getWidth(token);
                if (hAlignment == 0x1000000) {
                    hDelta /= 2;
                }
                tx += hDelta;
            }
            TextDrawing.drawString(gc, token, tx, y, 16384);
            if (!drawAsLink) continue;
            int yy = y + 1 + fontInfo.getLeading() + fontInfo.getAscent();
            gc.drawLine(tx, yy, tx + fontInfo.getWidth(token), yy);
        }
        gc.setFont(savedFont);
        if (icon != null) {
            int iy = bounds.y + 1;
            if (vAlignment != 128) {
                int ivDelta = cellHeight - imageBounds.height;
                if (vAlignment == 0x1000000) {
                    ivDelta /= 2;
                }
                iy += ivDelta;
            }
            x = iconHAlignment == 16384 ? (x -= imageBounds.width) : (x += textSize.x + iconGap - imageBounds.width);
            gc.drawImage(icon, x, iy);
        }
    }

    public TextCell() {
        this(-1, -1, IColumnCompareType.TEXT());
    }

    public TextCell(int alignment) {
        this(alignment, -1, IColumnCompareType.TEXT());
    }

    public TextCell(int alignment, @NonNull IColumnCompareType<C> compareType) {
        this(alignment, -1, compareType);
    }

    public TextCell(int hAlignment, int vAlignment, @NonNull IColumnCompareType<C> compareType) {
        this.mCompareType = compareType;
        this.mTruncationType = 131072;
        this.setHAlignment(hAlignment);
        this.setVAlignment(vAlignment);
    }

    @Override
    public int compare(C column, Row<C> one, Row<C> two) {
        return this.mCompareType.compare(column, one, two);
    }

    public void drawBackground(GC gc, Rectangle bounds, Row<C> row, C column, boolean selected, boolean active, Device device) {
        Color bg = this.getBackgroundColor(device, selected, active, row, column);
        if (bg != null) {
            gc.setBackground(bg);
            gc.fillRectangle(bounds);
        }
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, @Nullable Row<C> row, @NonNull C column, boolean selected, boolean active) {
        @NonNull Device device = gc.getDevice();
        int vAlignment = this.getVAlignment();
        int hAlignment = this.getHAlignment();
        int iconHAlignment = this.getIconHAlignment();
        @Nullable Image icon = row == null ? ((Column)column).getIcon() : row.getImage(column);
        @NonNull Rectangle imageBounds = this.getDesiredImageBoundsWithGap(icon);
        @NonNull Font font = this.getFont(row, column);
        @NonNull String text = this.getData(row, column, false);
        @NonNull Color foregroundColour = this.getForegroundColor(device, selected, active, row, column);
        int iconGap = this.getIconGap();
        boolean drawAsLink = this.mLinkProvider != null && this.mLinkProvider.hasLink(row, column);
        this.drawBackground(gc, bounds, row, column, selected, active, device);
        TextCell.drawTextCell(gc, font, bounds, text, selected, active, icon, imageBounds, this.mTruncationType, vAlignment, hAlignment, iconHAlignment, foregroundColour, iconGap, drawAsLink);
    }

    public Color getBackgroundColor(Device device, boolean selected, boolean active, Row<C> row, C column) {
        return null;
    }

    public String getBrowserViewId() {
        return this.mBrowserViewId;
    }

    public IColumnCompareType<C> getCompareType() {
        return this.mCompareType;
    }

    public Font getFont() {
        return Fonts.getNormal();
    }

    public Font getFont(Row<C> row, C column) {
        return this.getFont();
    }

    public Color getForegroundColor(Device device, boolean selected, boolean active, Row<C> row, C column) {
        if (!selected && this.mLinkProvider != null && this.mLinkProvider.hasLink(row, column)) {
            return this.mLinkPressed && row == this.mLinkRow && column == this.mLinkColumn ? Colors.getLinkPressed() : Colors.getLink();
        }
        return Colors.getText(selected && active);
    }

    public int getHAlignment() {
        return this.mHAlignment;
    }

    public int getIconGap() {
        return 4;
    }

    public int getIconHAlignment() {
        return this.mIconHAlignment;
    }

    public ILinkProvider<C> getLinkProvider() {
        return this.mLinkProvider;
    }

    @Override
    public int getMinimumContentWidth() {
        return 0;
    }

    @Override
    public Point getPreferredSize(@Nullable Row<C> row, @NonNull C column) {
        Image icon;
        Font font = this.getFont(row, column);
        String data = this.getData(row, column, true);
        Point size = data != null ? FontInfo.get(font).getExtent(data) : new Point(0, 0);
        Image image = icon = row == null ? ((Column)column).getIcon() : row.getImage(column);
        if (icon != null) {
            Rectangle bounds = icon.getBounds();
            size.x += bounds.width + this.getIconGap();
            if (size.y < bounds.height) {
                size.y = bounds.height;
            }
        }
        size.x += 8;
        size.y += 2;
        return size;
    }

    public Rectangle getTextAreaBounds(Rectangle cellBounds, @Nullable Row<C> row, @NonNull C column) {
        Image icon;
        Image image = icon = row == null ? ((Column)column).getIcon() : row.getImage(column);
        if (icon == null) {
            return cellBounds;
        }
        int iconWidth = icon.getBounds().width + this.getIconGap();
        int width = cellBounds.width - iconWidth;
        int x = cellBounds.x;
        int iconHAlignment = this.getIconHAlignment();
        if (iconHAlignment == 16384) {
            x += iconWidth;
        }
        Rectangle out = new Rectangle(x, cellBounds.y, width, cellBounds.height);
        return out;
    }

    @Override
    public String getToolTipText(Outline<C> outline, Point where, @Nullable Row<C> row, @NonNull C column) {
        String tooltip;
        int width = ((Column)column).getWidth() - 8;
        if (row != null) {
            OutlineModel<C> model;
            Image icon = row.getImage(column);
            if (icon != null) {
                width -= icon.getBounds().width;
            }
            if ((model = row.getOwner()).showIndent() && ((Column)column).isPrimary()) {
                width -= model.getIndentWidth(row, column);
            }
            String data = this.getData(row, column, false);
            String text = TextDrawing.truncateText(this.getFont(row, column), data, width, this.mTruncationType);
            tooltip = text.equals(data) ? row.getToolTipText(column) : row.getToolTipTextWhenTruncated(column);
        } else {
            tooltip = ((Column)column).getToolTipText();
        }
        return tooltip;
    }

    public int getTruncationType() {
        return this.mTruncationType;
    }

    public int getVAlignment() {
        return this.mVAlignment;
    }

    @Override
    public boolean handleCellMouseDoubleClick(Outline<C> outline, Point where, int stateMask, int button, Row<C> row, C column) {
        return false;
    }

    @Override
    public boolean handleCellMouseDown(Outline<C> outline, Point where, int stateMask, int button, @NonNull Row<C> row, @NonNull C column) {
        @Nullable ILinkProvider<C> mLinkProvider = this.mLinkProvider;
        if (button == 1 && mLinkProvider != null && mLinkProvider.hasLink(row, column) && this.getLinkBounds(outline, row, column).contains(where)) {
            try {
                this.mCurrentLink = mLinkProvider.getLink(row, column);
                if (this.mCurrentLink != null) {
                    this.mLinkRow = row;
                    this.mLinkColumn = column;
                    this.mLinkPressed = true;
                    outline.redraw();
                    return true;
                }
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        return false;
    }

    @Override
    public void handleCellMouseMove(Outline<C> outline, Point where, int stateMask) {
        if (this.mCurrentLink != null) {
            boolean wasPressed = this.mLinkPressed;
            this.mLinkPressed = this.getLinkBounds(outline, (Row)NullChecking.neverNull(this.mLinkRow), (Column)NullChecking.neverNull(this.mLinkColumn)).contains(where);
            if (wasPressed != this.mLinkPressed) {
                outline.redraw();
            }
        }
    }

    @Override
    public void handleCellMouseUp(Outline<C> outline, Point where, int stateMask) {
        if (this.mCurrentLink != null && this.getLinkBounds(outline, (Row)NullChecking.neverNull(this.mLinkRow), (Column)NullChecking.neverNull(this.mLinkColumn)).contains(where)) {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser(this.mBrowserViewId).openURL(this.mCurrentLink);
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        if (this.mLinkPressed) {
            this.mLinkPressed = false;
            this.mLinkRow = null;
            this.mLinkColumn = null;
            outline.redraw();
        }
    }

    public void setBrowserViewId(@NonNull String id) {
        this.mBrowserViewId = id;
    }

    public void setCompareType(@NonNull IColumnCompareType<C> compareType) {
        this.mCompareType = compareType;
    }

    public void setHAlignment(int alignment) {
        this.mHAlignment = alignment == -1 ? 16384 : alignment;
    }

    public void setIconHAlignment(int alignment) {
        this.mIconHAlignment = alignment == -1 ? 16384 : alignment;
    }

    public void setLinkProvider(ILinkProvider<C> linkProvider) {
        this.mLinkProvider = linkProvider;
    }

    public void setTruncationType(int truncationType) {
        this.mTruncationType = truncationType;
    }

    public void setVAlignment(int alignment) {
        this.mVAlignment = alignment == -1 ? 0x1000000 : alignment;
    }

    protected String getData(@Nullable Row<C> row, @NonNull C column, boolean nullOK) {
        if (row != null) {
            String text = row.getDataAsText(column);
            if (text == null && !nullOK) {
                text = "";
            }
            return text;
        }
        return ((Column)column).toString();
    }

    protected Rectangle getDesiredImageBoundsWithGap(Image image) {
        if (image != null) {
            Rectangle bounds = image.getBounds();
            bounds.width += this.getIconGap();
            return bounds;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private Rectangle getLinkBounds(Outline<C> outline, @NonNull Row<C> row, @NonNull C column) {
        int width = FontInfo.get(this.getFont(row, column)).getWidth(this.getData(row, column, false));
        Rectangle bounds = this.getTextAreaBounds(outline.getAdjustedCellBounds(row, column), row, column);
        if (bounds.width > width) {
            bounds.width = width;
        }
        return bounds;
    }
}

