/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public abstract class Row<C extends Column<C>> {
    private @Nullable OutlineModel<C> mOwner;
    private boolean mOpen;
    private @Nullable Row<C> mParent;
    private @Nullable List<@NonNull Row<C>> mChildren;

    public boolean addChild(@NonNull Row<C> row) {
        @Nullable List<@NonNull Row<C>> children = this.mChildren;
        if (children != null) {
            row.removeFromParent();
            children.add(row);
            row.mParent = this;
            return true;
        }
        return false;
    }

    public final boolean canHaveChildren() {
        return this.mChildren != null;
    }

    public void disclose() {
        Row<C> parent = this.getParent();
        while (parent != null) {
            parent.setOpen(true);
            parent = parent.getParent();
        }
    }

    public Color getBackgroundColor(Device device, boolean selected, boolean active) {
        return null;
    }

    public @Nullable Row<C> getChild(int index) {
        @Nullable List<@NonNull Row<C>> children = this.mChildren;
        return children != null && index >= 0 && index < children.size() ? children.get(index) : null;
    }

    public final int getChildCount() {
        @Nullable List<@NonNull Row<C>> children = this.mChildren;
        return children != null ? children.size() : 0;
    }

    public @Nullable List<@NonNull Row<C>> getChildren() {
        @Nullable List<@NonNull Row<C>> children = this.mChildren;
        return children != null ? Collections.unmodifiableList(children) : null;
    }

    public abstract double getDataAsDouble(@NonNull C var1);

    public abstract long getDataAsLong(@NonNull C var1);

    public abstract String getDataAsText(@NonNull C var1);

    public int getDepth() {
        Row<C> parent = this.mParent;
        int depth = 0;
        while (parent != null) {
            ++depth;
            parent = parent.mParent;
        }
        return depth;
    }

    public @Nullable Image getImage(@NonNull C column) {
        return null;
    }

    public int getIndexOfChild(@NonNull Row<C> row) {
        @Nullable List<@NonNull Row<C>> children = this.mChildren;
        if (children != null) {
            return children.indexOf(row);
        }
        return -1;
    }

    public @NonNull OutlineModel<C> getOwner() {
        if (this.mOwner == null && this.mParent != null) {
            return this.mParent.getOwner();
        }
        return (OutlineModel)NullChecking.neverNull(this.mOwner);
    }

    public @Nullable Row<C> getParent() {
        return this.mParent;
    }

    public @NonNull Row<C> @NonNull [] getPath() {
        @NonNull ArrayList<@NonNull Row<C>> list = new ArrayList<Row<C>>();
        list.add(this);
        Row<C> parent = this.mParent;
        while (parent != null) {
            list.add(0, parent);
            parent = parent.mParent;
        }
        return list.toArray(new Row[0]);
    }

    public int getPreferredHeight(@NonNull List<@NonNull C> columns) {
        int preferredHeight = 0;
        for (Column column : columns) {
            int height = column.getRowCell(this).getPreferredSize(this, column).y;
            if (height <= preferredHeight) continue;
            preferredHeight = height;
        }
        return preferredHeight;
    }

    public int getRecursiveChildCount() {
        @Nullable List<@NonNull Row<C>> children = this.mChildren;
        int count = 0;
        if (children != null) {
            count += children.size();
            for (Row<C> row : children) {
                count += row.getRecursiveChildCount();
            }
        }
        return count;
    }

    public String getToolTipText(@NonNull C column) {
        return ((Column)column).getToolTipText();
    }

    public String getToolTipTextWhenTruncated(@NonNull C column) {
        String content = this.getDataAsText(column);
        Object tooltip = this.getToolTipText(column);
        if (content == null) {
            return tooltip;
        }
        if (tooltip != null) {
            if (((String)tooltip).length() > 0) {
                tooltip = (String)tooltip + "\n\n";
            }
            tooltip = (String)tooltip + content;
        } else {
            tooltip = content;
        }
        return tooltip;
    }

    public @NonNull Row<C> getTopParentOrSelf() {
        @NonNull Row<C> row = this;
        @Nullable Row<C> parent = this.mParent;
        while (parent != null) {
            row = parent;
            parent = parent.mParent;
        }
        return row;
    }

    public boolean hasChildren() {
        @Nullable List<@NonNull Row<C>> children = this.mChildren;
        return children != null && !children.isEmpty();
    }

    public boolean insertChild(int index, @NonNull Row<C> row) {
        @Nullable List<@NonNull Row<C>> children = this.mChildren;
        if (children != null) {
            int max;
            row.removeFromParent();
            if (index < 0) {
                index = 0;
            }
            if (index > (max = children.size())) {
                index = max;
            }
            children.add(index, row);
            row.mParent = this;
            return true;
        }
        return false;
    }

    public boolean isChildOf(@NonNull Row<C> parent) {
        return this.mParent == parent;
    }

    public boolean isDescendentOf(@NonNull Row<C> row) {
        Row<C> parent = this.mParent;
        while (parent != null) {
            if (parent == row) {
                return true;
            }
            parent = parent.mParent;
        }
        return false;
    }

    public boolean isOpen() {
        return this.mOpen;
    }

    public void removeAllChildren() {
        @Nullable List<@NonNull Row<C>> children = this.mChildren;
        if (children != null) {
            for (Row<C> child : children) {
                child.mParent = null;
            }
            children.clear();
        }
    }

    public boolean removeChild(@NonNull Row<C> row) {
        @Nullable List<@NonNull Row<C>> children = this.mChildren;
        if (children != null && row.isChildOf(this)) {
            children.remove(row);
            row.mParent = null;
            return true;
        }
        return false;
    }

    public void removeFromParent() {
        if (this.mParent != null) {
            this.mParent.removeChild(this);
        }
    }

    public void setCanHaveChildren(boolean canHaveChildren) {
        if (canHaveChildren != this.canHaveChildren()) {
            if (canHaveChildren) {
                this.mChildren = new ArrayList<Row<C>>();
            } else {
                this.setOpen(false);
                this.mChildren = null;
            }
        }
    }

    public abstract void setData(@NonNull C var1, Object var2);

    public void setOpen(boolean open) {
        if (this.mOpen != open && (!open || open && this.canHaveChildren())) {
            this.mOpen = open;
            if (this.mOwner != null) {
                this.mOwner.rowOpenStateChanged(this, this.mOpen);
            }
        }
    }

    protected final @Nullable List<@NonNull Row<C>> getChildList() {
        return this.mChildren;
    }

    void setOwner(@Nullable OutlineModel<C> owner) {
        this.mOwner = owner;
    }
}

