/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.editortabs.AbstractInstructionCounterColumn;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.jni.reportmodel.icounters.RatioValue;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.BoxCell;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.Row;
import com.arm.utils.StreamUtils;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToLongFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class RatioCell<C extends Column<C>>
implements ICell<C> {
    private final @NonNull Function<Row<C>, @NonNull RatioValue @Nullable []> rowToValueMapper;

    public static void drawBarsAndText(GC gc, Rectangle bounds, @NonNull RatioValue @Nullable [] ratioValues, boolean selected, boolean active) {
        if (ratioValues != null) {
            RatioCell.drawBarsAndText(gc, bounds, selected, active, ratioValues.length, i -> ratioValueArray[i].value, i -> ratioValueArray[i].rgb);
        }
    }

    public static void drawBarsAndText(GC gc, Rectangle bounds, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.ColourPreference colourPreference, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IColumnDescriptor.IRatioColumnDescriptor.RatioItem @NonNull [] ratioItems, long @Nullable [] ratioValues, boolean selected, boolean active) {
        if (ratioValues != null) {
            assert (ratioValues.length == ratioItems.length);
            Integer[] colours = AbstractInstructionCounterColumn.makeColourSpread(colourPreference, ratioItems);
            assert (ratioValues.length == colours.length);
            RatioCell.drawBarsAndText(gc, bounds, selected, active, ratioValues.length, i -> ratioValues[i], i -> colours[i]);
        }
    }

    private static void drawBarsAndText(GC gc, Rectangle bounds, boolean selected, boolean active, int nItems, @NonNull IntToLongFunction valueSupplier, @NonNull IntFunction<@Nullable Integer> rgbSupplier) {
        BoxCell.drawBorderAround(bounds, innerBounds -> {
            long total = 0L;
            int i = 0;
            while (i < nItems) {
                total += Math.max(0L, valueSupplier.applyAsLong(i));
                ++i;
            }
            if (total <= 0L) {
                return;
            }
            Font font = Fonts.getNormal();
            gc.setFont(font);
            FontInfo fi = FontInfo.get(font);
            int left = innerBounds.x;
            int top = innerBounds.y;
            int textTop = innerBounds.y + (innerBounds.height - fi.getHeight()) / 2;
            int barHeight = innerBounds.height;
            int boxWidth = innerBounds.width;
            int last = 0;
            long runningTotal = 0L;
            int index = 0;
            while (index < nItems) {
                long value = valueSupplier.applyAsLong(index);
                Integer rgb = (Integer)rgbSupplier.apply(index);
                int portion = (int)((double)boxWidth * (double)(runningTotal += value) / (double)total);
                int thisLeft = left + last;
                int thisWidth = portion - last;
                last = portion;
                @NonNull Color colour = RatioCell.mapColour(rgb, index);
                gc.setBackground(colour);
                gc.fillRectangle(thisLeft, top, thisWidth, barHeight);
                String text = Long.toUnsignedString(value);
                int textWidth = fi.getWidth(text);
                if (thisWidth >= textWidth) {
                    int textHorizontalCenter = thisLeft + thisWidth / 2;
                    gc.setForeground(Colors.getText(selected && active));
                    TextDrawing.drawString(gc, text, textHorizontalCenter, textTop, 0x1000000);
                }
                ++index;
            }
        });
    }

    private static @NonNull Color mapColour(@Nullable Integer rgb, int index) {
        if (rgb != null) {
            return Colors.create(rgb);
        }
        return Colors.create(AnnotationColour.LIGHT_COLOR_PALETTE[index % AnnotationColour.LIGHT_COLOR_PALETTE.length]);
    }

    public RatioCell(@NonNull Function<Row<C>, @NonNull RatioValue @Nullable []> rowToValueMapper) {
        this.rowToValueMapper = rowToValueMapper;
    }

    @Override
    public int compare(C column, Row<C> one, Row<C> two) {
        long oneTotal = StreamUtils.emptyIfNullOfArray((Object[])this.rowToValueMapper.apply(one)).mapToLong(x -> x.value).sum();
        long twoTotal = StreamUtils.emptyIfNullOfArray((Object[])this.rowToValueMapper.apply(two)).mapToLong(x -> x.value).sum();
        return Long.compare(oneTotal, twoTotal);
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, Row<C> row, C column, boolean selected, boolean active) {
        RatioCell.drawBarsAndText(gc, bounds, this.rowToValueMapper.apply(row), selected, active);
    }

    @Override
    public int getMinimumContentWidth() {
        return 0;
    }

    @Override
    public Point getPreferredSize(Row<C> row, C column) {
        Font font = Fonts.getNormal();
        Point size = FontInfo.get(font).getExtent("100");
        size.x += 8;
        size.y += 4;
        return size;
    }

    @Override
    public String getToolTipText(Outline<C> outline, Point where, Row<C> row, C column) {
        return row.getToolTipText(column);
    }
}

