/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineMessages;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.selection.StdSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;

public class OutlineContributor
implements IContextMenuContributor {
    @Override
    public void cleanup(ContextMenu cm) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
        if (OutlineMessages.OPEN.equals(commandID)) {
            ((Outline)cm.getClickControl()).openSelectedRows(true);
        } else if (OutlineMessages.CLOSE.equals(commandID)) {
            ((Outline)cm.getClickControl()).closeSelectedRows(true);
        }
    }

    @Override
    public void prepareMenu(ContextMenu cm) {
        Control target = cm.getClickControl();
        if (target instanceof Outline) {
            Outline outline = (Outline)target;
            OutlineModel model = outline.getModel();
            StdSelection selection = model.getSelection();
            boolean needOpen = false;
            boolean needClose = false;
            int i = -1;
            while (!needOpen || !needClose) {
                if ((i = selection.nextSelectedIndex(i + 1)) == -1) break;
                Row row = model.getRowAtIndex(i);
                if (!row.canHaveChildren()) continue;
                if (row.isOpen()) {
                    needClose = true;
                    continue;
                }
                needOpen = true;
            }
            if (needOpen || needClose) {
                cm.createConditionalSeparator();
                if (needOpen) {
                    cm.createMenuItem(this, OutlineMessages.OPEN, OutlineMessages.OPEN, true);
                }
                if (needClose) {
                    cm.createMenuItem(this, OutlineMessages.CLOSE, OutlineMessages.CLOSE, true);
                }
            }
        }
    }
}

