/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.Geometry;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.DirectScrollCanvas;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.outline.CellEditor;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.Header;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.ICellMouseHandler;
import com.arm.streamline.widget.outline.IOutlineListener;
import com.arm.streamline.widget.outline.IOutlineModelListener;
import com.arm.streamline.widget.outline.OutlineMessages;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.selection.ReadOnlyStdSelection;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.text.BasicNumberUtils;
import com.arm.utils.text.SWTLabelFilter;
import gnu.trove.list.array.TIntArrayList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.actions.ActionFactory;

public class Outline<C extends Column<C>>
extends DirectScrollCanvas
implements DragSourceListener,
ISelectionProvider,
IOutlineModelListener<C>,
Runnable {
    private static final int MORE_H_MARGIN = 4;
    private static final int MORE_V_MARGIN = 0;
    private static final int MORE_OFFSET = 4;
    private static final int DIVIDER_SLOP = 5;
    private static final int CONFIG_VERSION = 1;
    private static final String CONFIG_MARKER = "OutlineConfig";
    private final @NonNull List<@NonNull IOutlineListener<C>> mListeners = new ArrayList<IOutlineListener<C>>();
    private final @NonNull Set<ISelectionChangedListener> mSelectionListeners = new HashSet<ISelectionChangedListener>();
    private Rectangle mMoreUpArea = new Rectangle(0, 0, 0, 0);
    private Rectangle mMoreDownArea = new Rectangle(0, 0, 0, 0);
    private final @NonNull OutlineModel<C> mModel;
    private Header<C> mHeader;
    private String mDefaultConfig;
    private boolean mShowColumnLines = true;
    private boolean mAllowColumnResize = true;
    private int mResizeColumn = -1;
    private int mResizeColumnBaseline;
    private int mResizeColumnSize;
    private int mSelectOnMouseUp;
    private boolean mPermitDragSelect = true;
    private boolean mDragSelectOK;
    private boolean mWasSelectedBeforeDrag;
    private int mInitialMouseY;
    private long mInitialMouseTime;
    private StdSelection mPreservedSelection;
    private boolean mAdjustPending;
    private boolean mNoScrollOnSelect;
    private boolean mAllowLazyAdjust = true;
    private CellEditor<C> mEditor;
    private boolean mCanEdit;
    private boolean mIgnoreMouse;
    private ICellMouseHandler<C> mCellMouseHandler;
    private MouseState mMouseHandlingState = MouseState.NORMAL;
    private Row<C> mDropParentRow;
    private int mDropChildInsertIndex = -1;
    private boolean mColumnFill;
    private boolean mDropHighlight;

    public Outline(Composite parent, @NonNull OutlineModel<C> model, boolean border, boolean showIndent) {
        super(parent, 0x20040000 | (border ? 2048 : 0));
        this.mModel = model;
        this.mModel.setShowIndent(showIndent);
        this.mModel.setIndentWidth(15);
        this.addListener(1, this);
        this.addListener(31, this);
        this.addListener(15, this);
        this.addListener(16, this);
        this.addListener(3, this);
        this.addListener(4, this);
        this.addListener(8, this);
        this.addListener(5, this);
        this.addListener(6, this);
        this.addListener(12, this);
        ControlHacks.setBackground((Control)this, Colors.getListBackground());
        this.mModel.addListener(this);
    }

    public void addOutlineListener(@NonNull IOutlineListener<C> listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionListeners.add(listener);
    }

    public void adjust() {
        this.sizeColumnsToFit();
        this.adjustScrollBarsForContent();
        this.notifyOfSelectionChange();
    }

    public void adjustScrollBarsForContent() {
        this.getHorizontalSlider().setIncrement(50);
        this.getVerticalSlider().setIncrement(this.mModel.getRowHeight() + 1);
        this.adjustSliders();
    }

    public boolean allowLazyAdjust() {
        return this.mAllowLazyAdjust;
    }

    public void applyConfig(String config, boolean sortOnly, boolean forcePreferredWidth) {
        if (config != null && config.startsWith(CONFIG_MARKER)) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(config, "\t");
                if (BasicNumberUtils.getNonLocalizedInteger((String)tokenizer.nextToken().substring(CONFIG_MARKER.length()), (int)0) == 1) {
                    int count = BasicNumberUtils.getNonLocalizedInteger((String)tokenizer.nextToken(), (int)0);
                    boolean needSort = false;
                    boolean sortWasCleared = this.mModel.clearSortWithoutNotify();
                    int i = 0;
                    while (i < count) {
                        @Nullable C column = this.mModel.getColumnWithID(BasicNumberUtils.getNonLocalizedInteger((String)tokenizer.nextToken(), (int)0));
                        if (column == null) {
                            throw new Exception();
                        }
                        this.mModel.removeColumn(column);
                        this.mModel.addColumn(i, column);
                        if (sortOnly) {
                            tokenizer.nextToken();
                            tokenizer.nextToken();
                        } else {
                            ((Column)column).setVisible(BasicNumberUtils.getBoolean((String)tokenizer.nextToken()));
                            if (forcePreferredWidth) {
                                tokenizer.nextToken();
                                ((Column)column).setPreferredWidth(((Column)column).getDefaultPreferredWidth());
                                ((Column)column).setWidth(((Column)column).getPreferredWidth(this));
                            } else {
                                ((Column)column).setWidth(BasicNumberUtils.getNonLocalizedInteger((String)tokenizer.nextToken(), (int)((Column)column).getWidth()));
                            }
                        }
                        ((Column)column).setSortCriteria(BasicNumberUtils.getNonLocalizedInteger((String)tokenizer.nextToken(), (int)-1), BasicNumberUtils.getBoolean((String)tokenizer.nextToken()));
                        if (((Column)column).getSortSequence() != -1) {
                            needSort = true;
                        }
                        ++i;
                    }
                    if (needSort) {
                        this.mModel.sort();
                    } else if (sortWasCleared) {
                        this.mModel.notifyOfSortCleared();
                    }
                    this.lazyAdjust();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean areUnselectedRowsClosable() {
        Set<Row<C>> exclude = this.getSelectedRowExclusionSet();
        for (Row<C> row : this.mModel.getTopLevelRows()) {
            if (!this.hasOpenState(row, exclude)) continue;
            return true;
        }
        return false;
    }

    public boolean areUnselectedRowsOpenable() {
        Set<Row<C>> exclude = this.getSelectedRowExclusionSet();
        for (Row<C> row : this.mModel.getTopLevelRows()) {
            if (!this.hasClosedState(row, exclude)) continue;
            return true;
        }
        return false;
    }

    public boolean canEdit() {
        return this.mCanEdit;
    }

    public void cellMouseHandlingFinished() {
        this.finishMouseHandling();
    }

    public void clearInsertionMarker() {
        Row<C> row = this.mDropParentRow;
        int index = this.mDropChildInsertIndex;
        this.mDropParentRow = null;
        this.mDropChildInsertIndex = -1;
        if (index != -1) {
            this.redrawVirtual(this.getDragRowInsertionMarkerBounds(row, index));
        }
    }

    public void closeAllRows() {
        this.prepareForRowStateChange();
        try {
            for (Row<C> row : this.mModel.getTopLevelRows()) {
                this.setOpenRecursively(row, false);
            }
        }
        finally {
            this.finishRowStateChange();
        }
    }

    public void closeSelectedRows(boolean all) {
        this.prepareForRowStateChange();
        try {
            if (all) {
                for (Row<C> row : this.mModel.getSelectionAsList(true)) {
                    this.setOpenRecursively(row, false);
                }
            } else {
                for (Row<C> row : this.mModel.getSelectionAsList(false)) {
                    row.setOpen(false);
                }
            }
        }
        finally {
            this.finishRowStateChange();
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void closeUnselectedRows() {
        selection = this.mModel.getSelectionAsList();
        openRows = new ArrayList<Row<C>>();
        for (Row<C> row : this.mModel.getSelectionAsList()) {
            if (!row.canHaveChildren() || !row.isOpen()) continue;
            openRows.add(row);
        }
        this.prepareForRowStateChange();
        try {
            for (Row<C> row : this.mModel.getTopLevelRows()) {
                this.setOpenRecursively(row, false);
            }
        }
        finally {
            ** for (row : selection)
        }
lbl-1000:
        // 1 sources

        {
            row.disclose();
            continue;
        }
lbl18:
        // 2 sources

        for (Row<Object> row : openRows) {
            row.setOpen(true);
        }
        this.finishRowStateChange();
        Task.callOnUIThread((Runnable)new Runnable(selection){
            private final /* synthetic */ List val$selection;
            {
                this.val$selection = list;
            }

            @Override
            public void run() {
                Outline.this.getModel().select(this.val$selection, false);
                Outline.this.scrollSelectionIntoView(true);
            }
        });
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = new Point(0, this.mModel.getRowCount());
        int minX = 0;
        int minY = 0;
        @NonNull List<@NonNull C> columns = this.mModel.getColumns();
        for (Column col : columns) {
            int width = col.getWidth();
            if (width == -1) {
                width = col.getPreferredWidth(this);
                col.setWidth(width);
            }
            if (!col.isVisible()) continue;
            size.x = size.x + (width + (this.mShowColumnLines ? 1 : 0));
        }
        size.x += this.getSliderSize().x;
        if (size.x < minX) {
            size.x = minX;
        }
        if (size.y > 0) {
            int extra = size.y;
            int height = this.mModel.getRowHeight();
            if (height == 0) {
                height = this.mModel.getRowAtIndex(0).getPreferredHeight(columns);
                this.mModel.setRowHeight(height);
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!Outline.this.isDisposed()) {
                            Outline.this.adjustScrollBarsForContent();
                        }
                    }
                });
            }
            size.y *= height;
            size.y += extra;
            size.y += this.getSliderSize().y;
        }
        if (size.y < minY) {
            size.y = minY;
        }
        return size;
    }

    public void copy() {
        List<@NonNull C> columns = this.mModel.getColumns();
        StringBuilder buffer = new StringBuilder();
        for (Row<Column> row : this.mModel.getSelectionAsList()) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            boolean needTab = false;
            for (Column column : columns) {
                if (!column.isVisible()) continue;
                if (needTab) {
                    buffer.append('\t');
                } else {
                    needTab = true;
                }
                buffer.append(row.getDataAsText(column));
            }
        }
        if (buffer.length() > 0) {
            Clipboard clipboard = new Clipboard(this.getDisplay());
            clipboard.setContents(new Object[]{buffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    public void dragFinished(DragSourceEvent event) {
        this.finishMouseHandling();
    }

    public void dragSetData(DragSourceEvent event) {
        String text;
        if (TextTransfer.getInstance().isSupportedType(event.dataType) && (text = this.getSelectionAsText()) != null && !text.isEmpty()) {
            event.data = text;
            return;
        }
        event.doit = false;
    }

    public void dragStart(DragSourceEvent event) {
        if (this.mMouseHandlingState == MouseState.NORMAL && (this.mWasSelectedBeforeDrag || !this.mPermitDragSelect)) {
            this.mIgnoreMouse = true;
            this.mCellMouseHandler = null;
            this.disableMouseTracking();
            event.doit = true;
        } else {
            event.doit = false;
        }
    }

    public Rectangle getAdjustedCellBounds(@NonNull Row<C> row, @NonNull C column) {
        Rectangle bounds = this.getCellBounds(row, column);
        if (((Column)column).isPrimary()) {
            int indent = this.mModel.getIndentWidth(row, column);
            bounds.x += indent;
            bounds.width -= indent;
            if (bounds.width < 1) {
                bounds.width = 1;
            }
        }
        return bounds;
    }

    public Color getBackground(int rowIndex, boolean selected, boolean active) {
        Color color = this.mModel.getRowAtIndex(rowIndex).getBackgroundColor((Device)this.getDisplay(), selected, active);
        if (color != null) {
            return color;
        }
        if (selected) {
            return Colors.getSelection(active);
        }
        return this.getBackgroundBandingColor(rowIndex);
    }

    public Color getBackgroundBandingColor(int rowIndex) {
        return rowIndex % 2 == 0 ? Colors.getPrimaryBanding() : Colors.getSecondaryBanding();
    }

    public ICell<C> getCellAt(int x, int y) {
        Row<C> row;
        ObjIntPair<C> colAndXOffset = this.overColumnWithOffset(x);
        if (colAndXOffset != null && (row = this.overRow(y)) != null) {
            return ((Column)colAndXOffset.first).getRowCell(row);
        }
        return null;
    }

    public ICell<C> getCellAt(Point viewPt) {
        return this.getCellAt(viewPt.x, viewPt.y);
    }

    public @NonNull Rectangle getCellBounds(@NonNull Row<C> row, @NonNull C column) {
        Rectangle bounds = this.getRowBounds(row);
        bounds.x = this.getColumnStart(column);
        bounds.width = this.getColumnWidth(column);
        return bounds;
    }

    public Color getColumnDividerColor(int columnID) {
        return Colors.getOutlineDivider();
    }

    public int getColumnIndexStart(int columnIndex) {
        int pos = 0;
        int i = 0;
        while (i < columnIndex) {
            C column = this.mModel.getColumnAtIndex(i);
            if (((Column)column).isVisible()) {
                pos += this.getColumnWidth(column) + (this.mShowColumnLines ? 1 : 0);
            }
            ++i;
        }
        return pos;
    }

    public int getColumnStart(C column) {
        int pos = 0;
        int count = this.mModel.getColumnCount();
        int i = 0;
        while (i < count) {
            C col = this.mModel.getColumnAtIndex(i);
            if (col == column) break;
            if (((Column)col).isVisible()) {
                pos += this.getColumnWidth(col) + (this.mShowColumnLines ? 1 : 0);
            }
            ++i;
        }
        return pos;
    }

    public int getColumnWidth(@NonNull C column) {
        int total;
        int width = ((Column)column).getWidth();
        if (this.mColumnFill && (total = this.getClientArea().width) > width) {
            width = total;
        }
        return width;
    }

    public @NonNull String getConfig() {
        StringBuilder buffer = new StringBuilder();
        int count = this.mModel.getColumnCount();
        buffer.append(CONFIG_MARKER);
        buffer.append(1);
        buffer.append('\t');
        buffer.append(count);
        int i = 0;
        while (i < count) {
            C column = this.mModel.getColumnAtIndex(i);
            buffer.append('\t');
            buffer.append(((Column)column).getID());
            buffer.append('\t');
            buffer.append(((Column)column).isVisible());
            buffer.append('\t');
            buffer.append(((Column)column).getWidth());
            buffer.append('\t');
            buffer.append(((Column)column).getSortSequence());
            buffer.append('\t');
            buffer.append(((Column)column).isSortAscending());
            ++i;
        }
        return buffer.toString();
    }

    public String getDefaultConfig() {
        if (this.mDefaultConfig == null) {
            this.mDefaultConfig = this.getConfig();
        }
        return this.mDefaultConfig;
    }

    public Image getDisclosureControl(Row<C> row) {
        return StreamlinePlugin.getImage(row.isOpen() ? "Collapse.gif" : "Expand.gif");
    }

    public CellEditor<C> getEditor() {
        return this.mEditor;
    }

    public Header<C> getHeader() {
        return this.mHeader;
    }

    public @NonNull OutlineModel<C> getModel() {
        return this.mModel;
    }

    public Rectangle getRowBounds(@NonNull Row<C> row) {
        Rectangle bounds = this.toVirtual(this.getClientArea());
        bounds.y = this.getRowStart(row);
        bounds.height = this.mModel.getRowHeight();
        return bounds;
    }

    public Color getRowDividerColor(int rowIndex) {
        return Colors.getOutlineDivider();
    }

    public Rectangle getRowIndexBounds(int rowIndex) {
        Rectangle bounds = this.toVirtual(this.getClientArea());
        bounds.y = this.getRowIndexStart(rowIndex);
        bounds.height = this.mModel.getRowHeight();
        return bounds;
    }

    public int getRowIndexStart(int index) {
        return index * (this.mModel.getRowHeight() + 1);
    }

    public int getRowStart(@NonNull Row<C> row) {
        return this.getRowIndexStart(this.mModel.getRows().indexOf(row));
    }

    public IStructuredSelection getSelection() {
        return new ReadOnlyStdSelection(this.mModel.getSelection());
    }

    public String getSelectionAsText() {
        String lineSeperator = System.lineSeparator();
        List<@NonNull C> columns = this.mModel.getColumns();
        StringBuilder buffer = new StringBuilder();
        for (Row<Column> row : this.mModel.getSelectionAsList(false)) {
            boolean needTab = false;
            for (Column column : columns) {
                if (!column.isVisible()) continue;
                if (needTab) {
                    buffer.append('\t');
                } else {
                    needTab = true;
                }
                String text = row.getDataAsText(column);
                if (text == null) continue;
                buffer.append(text);
            }
            buffer.append(lineSeperator);
        }
        return buffer.toString();
    }

    @Override
    public void handleEvent(Event event) {
        super.handleEvent(event);
        block0 : switch (event.type) {
            case 1: {
                this.handleKeyDown(event);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        event.doit = true;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                this.mMouseHandlingState = this.determineMouseState(event.x, event.y, event.stateMask);
                if (this.mMouseHandlingState != MouseState.NORMAL) break;
                this.handleMouseDown(this.toVirtual(new Point(event.x, event.y)), event.stateMask, event.button);
                break;
            }
            case 4: {
                switch (this.mMouseHandlingState) {
                    default: {
                        this.handleMouseUp(this.toVirtual(new Point(event.x, event.y)), event.stateMask);
                        break block0;
                    }
                    case MORE_UP: {
                        this.scrollMoreUp();
                        break block0;
                    }
                    case MORE_DOWN: {
                        this.scrollMoreDown();
                        break block0;
                    }
                    case CUSTOM: 
                }
                this.handleCustomMouseUp(this.toVirtual(new Point(event.x, event.y)), event.stateMask);
                break;
            }
            case 5: 
            case 6: {
                if (!this.mIgnoreMouse) {
                    this.checkOverCustomArea(this.toVirtual(new Point(event.x, event.y)), event.stateMask);
                }
                this.handleMouseMove(this.toVirtual(new Point(event.x, event.y)), event.stateMask);
                break;
            }
            case 8: {
                if (this.mMouseHandlingState != MouseState.NORMAL) break;
                this.handleDoubleClick(this.toVirtual(new Point(event.x, event.y)), event.stateMask, event.button);
                break;
            }
            case 13: {
                this.redrawHeader();
                break;
            }
            case 15: {
                this.setEditor(null);
                this.repaintSelection();
                break;
            }
            case 16: {
                this.repaintSelection();
                break;
            }
            case 37: {
                if ((event.stateMask & 0x20000) != 131072) break;
                Point size = this.getSize();
                if (event.x < 0 || event.x >= size.x || event.y < 0 || event.y >= size.y) break;
                this.redrawHeader();
                break;
            }
            case 12: {
                this.mListeners.clear();
                this.mSelectionListeners.clear();
                this.mHeader = null;
                this.mDefaultConfig = null;
                this.mPreservedSelection = null;
                break;
            }
        }
    }

    @Override
    public void handleMouseWheel(boolean vertical, int amount) {
        super.handleMouseWheel(vertical, amount);
        if (!vertical) {
            this.redrawHeader();
        }
    }

    public boolean hasDropHighlight() {
        return this.mDropHighlight;
    }

    public boolean isColumnFill() {
        return this.mColumnFill;
    }

    public boolean isColumnResizeAllowed() {
        return this.mAllowColumnResize;
    }

    public boolean isDragSelectedPermitted() {
        return this.mPermitDragSelect;
    }

    public void lazyAdjust() {
        if (this.mAllowLazyAdjust && !this.mAdjustPending) {
            this.mAdjustPending = true;
            this.getDisplay().asyncExec((Runnable)this);
        }
    }

    public void notifyOfSelectionChange() {
        IOutlineListener<C>[] iOutlineListenerArray = this.getCurrentOutlineListeners();
        int n = iOutlineListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOutlineListener<C> listener = iOutlineListenerArray[n2];
            listener.selectionChanged(this);
            ++n2;
        }
        if (!this.mSelectionListeners.isEmpty()) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getSelection());
            for (ISelectionChangedListener listener : new ArrayList<ISelectionChangedListener>(this.mSelectionListeners)) {
                listener.selectionChanged(event);
            }
        }
    }

    public boolean obeyCommand(CommandAction action) {
        String command = action.getCommand();
        if (command.equals(ActionFactory.SELECT_ALL.getId())) {
            this.mModel.select();
            return true;
        }
        if (command.equals(ActionFactory.COPY.getId())) {
            this.copy();
            return true;
        }
        return false;
    }

    public void openAllRows() {
        this.prepareForRowStateChange();
        this.mModel.setAccumulateRowOpens(true);
        try {
            for (Row<C> row : this.mModel.getTopLevelRows()) {
                this.setOpenRecursively(row, true);
            }
        }
        finally {
            this.mModel.setAccumulateRowOpens(false);
            this.finishRowStateChange();
        }
    }

    public void openSelectedRows(boolean all) {
        this.prepareForRowStateChange();
        if (all) {
            this.mModel.setAccumulateRowOpens(true);
        }
        try {
            if (all) {
                for (Row<C> row : this.mModel.getSelectionAsList(true)) {
                    this.setOpenRecursively(row, true);
                }
            } else {
                for (Row<C> row : this.mModel.getSelectionAsList(false)) {
                    row.setOpen(true);
                }
            }
        }
        finally {
            if (all) {
                this.mModel.setAccumulateRowOpens(false);
            }
            this.finishRowStateChange();
        }
    }

    public void openUnselectedRows() {
        Set<Row<C>> exclude = this.getSelectedRowExclusionSet();
        this.prepareForRowStateChange();
        try {
            for (Row<C> row : this.mModel.getTopLevelRows()) {
                this.open(row, exclude);
            }
        }
        finally {
            this.finishRowStateChange();
        }
    }

    public @Nullable ObjIntPair<@NonNull C> overColumnWithOffset(int x) {
        int pos = 0;
        int count = this.mModel.getColumnCount();
        int i = 0;
        while (i < count) {
            int base;
            C col = this.mModel.getColumnAtIndex(i);
            if (((Column)col).isVisible() && x >= (base = pos) && x < (pos += this.getColumnWidth(col) + (this.mShowColumnLines ? 1 : 0))) {
                return new ObjIntPair(col, x - base);
            }
            ++i;
        }
        return null;
    }

    public int overColumnIndex(int x) {
        int pos = 0;
        int count = this.mModel.getColumnCount();
        int i = 0;
        while (i < count) {
            C col = this.mModel.getColumnAtIndex(i);
            if (((Column)col).isVisible() && x < (pos += this.getColumnWidth(col) + (this.mShowColumnLines ? 1 : 0))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean overDisclosureControl(int x, int y, C column, Row<C> row) {
        if (this.showIndent() && this.showOutline() && column != null && row != null && row.canHaveChildren() && ((Column)column).isPrimary()) {
            int right = this.getCellBounds(row, column).x + this.mModel.getIndentWidth(row, column);
            int left = right - this.mModel.getIndentWidth();
            return x >= left && x <= right;
        }
        return false;
    }

    public Row<C> overRow(int y) {
        int which = this.overRowIndex(y);
        if (which != -1) {
            return this.mModel.getRowAtIndex(which);
        }
        return null;
    }

    public @Nullable Row<C> overRow(MouseEvent event) {
        if (event.widget == this) {
            return this.overRow(this.toVirtual((Point)new Point((int)event.x, (int)event.y)).y);
        }
        return null;
    }

    public int overRowIndex(int y) {
        int which;
        if (y >= 0 && (which = y / (this.mModel.getRowHeight() + 1)) < this.mModel.getRowCount()) {
            return which;
        }
        return -1;
    }

    public void redrawAll() {
        SafeUpdate.redraw((Control)this);
        this.redrawHeader();
    }

    public void redrawHeader() {
        if (this.mHeader != null) {
            SafeUpdate.redraw(this.mHeader);
        }
    }

    public void redrawRow(@NonNull Row<C> row) {
        this.redrawVirtual(this.getRowBounds(row));
    }

    public void removeOutlineListener(IOutlineListener<C> listener) {
        this.mListeners.remove(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionListeners.remove(listener);
    }

    public void repaintSelection() {
        this.repaintSelectionInternal();
    }

    @Override
    public void rowsAdded(OutlineModel<C> model, Row<C>[] rows) {
        this.lazyAdjust();
    }

    @Override
    public void rowsWereRemoved(OutlineModel<C> model, Row<C>[] rows) {
        this.lazyAdjust();
    }

    @Override
    public void rowsWillBeRemoved(OutlineModel<C> model, Row<C>[] rows) {
    }

    @Override
    public void run() {
        this.mAdjustPending = false;
        if (!this.isDisposed()) {
            this.adjust();
        }
    }

    public void scrollRowsIntoView(Collection<? extends @NonNull Row<C>> rows, boolean verticalOnly) {
        Rectangle clientArea = this.toVirtual(this.getClientArea());
        Rectangle bounds = null;
        for (Row<C> row : rows) {
            Rectangle rect = new Rectangle(clientArea.x, this.getRowStart(row), clientArea.width, this.mModel.getRowHeight());
            if (bounds == null) {
                bounds = rect;
            } else {
                bounds.add(rect);
            }
            if (rect.height > clientArea.height) break;
        }
        if (bounds != null && !bounds.isEmpty()) {
            this.scrollRectIntoView(bounds, verticalOnly);
        }
    }

    public void scrollRowsIntoView(int first, int last, boolean verticalOnly) {
        if (first >= 0 && first <= this.mModel.getRowCount() - 1) {
            Rectangle bounds = this.getRowIndexBounds(first);
            if (first != last) {
                bounds = Geometry.union(bounds, this.getRowIndexBounds(last));
            }
            this.scrollRectIntoView(bounds, verticalOnly);
        }
    }

    public void scrollSelectionIntoView(boolean verticalOnly) {
        int first = this.mModel.getFirstSelectedRowIndex();
        if (first >= 0 && first <= this.mModel.getRowCount() - 1) {
            this.scrollSelectionIntoViewInternal(verticalOnly);
        }
    }

    @Override
    public void selectionDidChange(OutlineModel<C> model) {
        Rectangle bounds = this.repaintSelectionInternal();
        if (!this.mDragSelectOK && !this.mNoScrollOnSelect && !bounds.isEmpty() && this.isFocusControl()) {
            boolean needScroll = true;
            Point where = this.toVirtual(new Point(0, 5));
            StdSelection selection = model.getSelection();
            int row = this.overRowIndex(where.y);
            if (row != -1 && selection.isSelected(row)) {
                where.x = 0;
                where.y = this.getBounds().height - 5;
                where = this.toVirtual(where);
                row = this.overRowIndex(where.y);
                if (row != -1) {
                    boolean bl = needScroll = !selection.isSelected(row);
                }
            }
            if (needScroll) {
                this.scrollRectIntoView(bounds, true);
            }
        }
        this.notifyOfSelectionChange();
    }

    @Override
    public void selectionWillChange(OutlineModel<C> model) {
        this.repaintSelectionInternal();
    }

    public void setAllowColumnResize(boolean allow) {
        this.mAllowColumnResize = allow;
    }

    public void setAllowLazyAdjust(boolean allowLazyAdjust) {
        this.mAllowLazyAdjust = allowLazyAdjust;
    }

    public void setCanEdit(boolean canEdit) {
        if (canEdit != this.mCanEdit) {
            this.setEditor(null);
            this.mCanEdit = canEdit;
        }
    }

    public void setColumnFill(boolean fill) {
        this.mColumnFill = fill;
    }

    public void setColumnOrder(List<C> columns) {
        ArrayList<C> list = new ArrayList<C>(columns);
        List<C> cols = this.mModel.getColumns();
        cols.removeAll(columns);
        list.addAll(cols);
        cols.clear();
        cols.addAll(list);
        this.redrawAll();
    }

    public void setDefaultConfig(String config) {
        this.mDefaultConfig = config;
    }

    public void setDropHighlight(boolean highlight) {
        if (this.mDropHighlight != highlight) {
            this.mDropHighlight = highlight;
            this.redraw();
        }
    }

    public void setEditor(CellEditor<C> editor) {
        if (this.mCanEdit) {
            boolean wasNull;
            boolean bl = wasNull = this.mEditor == null;
            if (!wasNull) {
                this.mEditor.dispose();
            }
            this.mEditor = editor;
            if (this.mEditor != null) {
                this.mModel.deselect();
                this.scrollRectIntoView(this.getCellBounds(this.mEditor.getRow(), this.mEditor.getColumn()), false);
                this.mEditor.adjustToOutline();
            }
            if (!wasNull || this.mEditor != null) {
                this.notifyOfEditorChange();
            }
        }
    }

    public void setHeader(Header<C> header) {
        this.mHeader = header;
        if (header != null) {
            header.setOwner(this);
        }
    }

    public void setInsertionMarker(Row<C> parentRow, int childIndex) {
        Row<C> row = this.mDropParentRow;
        int index = this.mDropChildInsertIndex;
        this.mDropParentRow = parentRow;
        this.mDropChildInsertIndex = childIndex;
        if (index != -1) {
            this.redrawVirtual(this.getDragRowInsertionMarkerBounds(row, index));
        }
        if (this.mDropChildInsertIndex != -1) {
            this.redrawVirtual(this.getDragRowInsertionMarkerBounds(this.mDropParentRow, this.mDropChildInsertIndex));
        }
    }

    public void setPermitDragSelect(boolean permit) {
        this.mPermitDragSelect = permit;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof ReadOnlyStdSelection) {
            this.mModel.getSelection().select((ReadOnlyStdSelection)selection);
        }
    }

    public void setShowColumnLines(boolean show) {
        if (this.mShowColumnLines != show) {
            this.mShowColumnLines = show;
            this.redraw();
        }
    }

    public void setSort(@NonNull C column, boolean ascending, boolean add) {
        int count = this.mModel.getColumnCount();
        if (!add) {
            int i = 0;
            while (i < count) {
                C col = this.mModel.getColumnAtIndex(i);
                if (column == col) {
                    ((Column)col).setSortCriteria(0, ascending);
                } else {
                    ((Column)col).setSortCriteria(-1, ((Column)col).isSortAscending());
                }
                ++i;
            }
        } else if (((Column)column).getSortSequence() == -1) {
            int highest = -1;
            int i = 0;
            while (i < count) {
                int sortOrder = ((Column)this.mModel.getColumnAtIndex(i)).getSortSequence();
                if (sortOrder > highest) {
                    highest = sortOrder;
                }
                ++i;
            }
            ((Column)column).setSortCriteria(highest + 1, ascending);
        } else {
            ((Column)column).setSortCriteria(((Column)column).getSortSequence(), ascending);
        }
        this.mModel.sort();
    }

    public boolean showColumnLines() {
        return this.mShowColumnLines;
    }

    public boolean showIndent() {
        return this.mModel.showIndent();
    }

    public boolean showOutline() {
        return this.mModel.showOutline();
    }

    public void sizeColumnsToFit() {
        Header<C> mHeader = this.mHeader;
        try {
            for (Column column : this.mModel.getColumns()) {
                int width;
                if (!column.isVisible() || (width = column.getPreferredWidth(this)) == column.getWidth()) continue;
                column.setWidth(width);
            }
            if (mHeader != null) {
                mHeader.requestLayout();
            }
        }
        finally {
            this.redrawAll();
        }
    }

    @Override
    public void sortCleared(OutlineModel<C> model) {
        this.redrawHeader();
    }

    @Override
    public void sorted(OutlineModel<C> model, boolean restoring) {
        if (!restoring && this.isFocusControl()) {
            this.scrollSelectionIntoView(true);
        }
        this.redrawAll();
    }

    protected void checkOverCustomArea(Point where, int stateMask) {
    }

    protected String computeTooltip(Point where) {
        String tip = null;
        ObjIntPair<C> colAndXOffset = this.overColumnWithOffset(where.x);
        if (colAndXOffset != null) {
            Column column = (Column)colAndXOffset.first;
            Row<C> row = this.overRow(where.y);
            if (row != null) {
                tip = SWTLabelFilter.filterForToolTip((String)column.getRowCell(row).getToolTipText(this, where, row, column));
            }
        }
        return tip;
    }

    protected MouseState determineMouseState(int x, int y, int stateMask) {
        Point where = this.toVirtual(new Point(x, y));
        if (this.mMoreUpArea.contains(where)) {
            return MouseState.MORE_UP;
        }
        if (this.mMoreDownArea.contains(where)) {
            return MouseState.MORE_DOWN;
        }
        return MouseState.NORMAL;
    }

    protected void drawMore(GC gc, boolean up, int amt) {
        Rectangle clientArea = this.toVirtual(this.getClientAreaExcludingSliders());
        Image img = StreamlinePlugin.getImage(up ? StreamlineImages.UP_ARROW : StreamlineImages.DOWN_ARROW);
        Rectangle imgBounds = img.getBounds();
        Font font = Fonts.getSmall();
        gc.setFont(font);
        String text = MessageFormat.format(OutlineMessages.MORE, NumberUtils.format((long)amt));
        FontInfo fontInfo = FontInfo.get(font);
        int fontHeight = fontInfo.getHeight();
        int w = 4 + fontInfo.getWidth(text) + 4 + imgBounds.width + 4;
        int x = clientArea.x + clientArea.width - (w + 4);
        int h = Math.max(imgBounds.height, fontHeight) + 0;
        int y = clientArea.y + (up ? 4 : clientArea.height - (h + 4));
        if (up) {
            this.mMoreUpArea.x = x;
            this.mMoreUpArea.y = y;
            this.mMoreUpArea.width = w + 1;
            this.mMoreUpArea.height = h + 1;
        } else {
            this.mMoreDownArea.x = x;
            this.mMoreDownArea.y = y;
            this.mMoreDownArea.width = w + 1;
            this.mMoreDownArea.height = h + 1;
        }
        gc.setBackground(Colors.getInfoBackground());
        gc.fillRectangle(x, y, w, h);
        gc.setForeground(Colors.getBlack());
        gc.drawRectangle(x, y, w, h);
        gc.setForeground(Colors.getInfoForeground());
        TextDrawing.drawString(gc, text, x + 4, y + 1 + (h - fontHeight) / 2, 16384);
        gc.drawImage(img, x + w - (imgBounds.width + 4), y + (h - imgBounds.height) / 2);
    }

    protected void drawRowBackground(GC gc, Rectangle bounds, @NonNull Row<C> row, boolean selected, boolean active) {
        gc.setBackground(this.getBackground(this.mModel.getIndexOfRow(row), selected, active));
        gc.fillRectangle(bounds);
    }

    protected void handleCustomMouseUp(Point where, int stateMask) {
    }

    protected void handleKeyDown(Event event) {
        boolean doit = false;
        boolean shiftDown = (event.stateMask & 0x20000) != 0;
        switch (event.keyCode) {
            case 0x1000003: {
                if (!this.showOutline()) break;
                this.closeSelectedRows(shiftDown);
                break;
            }
            case 0x1000004: {
                if (!this.showOutline()) break;
                this.openSelectedRows(shiftDown);
                break;
            }
            case 0x1000001: {
                this.keyScroll(this.mModel.getSelection().selectUp(shiftDown, false));
                break;
            }
            case 0x1000002: {
                this.keyScroll(this.mModel.getSelection().selectDown(shiftDown, false));
                break;
            }
            case 0x1000007: {
                this.keyScroll(this.mModel.getSelection().selectToHome(shiftDown));
                break;
            }
            case 0x1000008: {
                this.keyScroll(this.mModel.getSelection().selectToEnd(shiftDown));
                break;
            }
            case 0x1000005: {
                this.keyScroll(this.mModel.getSelection().selectToPageUp(Math.max(1, this.getClientArea().height / (this.mModel.getRowHeight() + 1) - 2), shiftDown));
                break;
            }
            case 0x1000006: {
                this.keyScroll(this.mModel.getSelection().selectToPageDown(Math.max(1, this.getClientArea().height / (this.mModel.getRowHeight() + 1) - 2), shiftDown));
                break;
            }
            case 10: 
            case 13: 
            case 0x1000050: {
                if (!this.mModel.hasSelection()) break;
                this.notifyOfOpenSelectionRequest();
                break;
            }
            case 8: 
            case 127: {
                if (!this.mModel.hasSelection()) break;
                this.notifyOfDeleteSelectionRequest();
                break;
            }
            default: {
                doit = true;
            }
        }
        event.doit = doit;
    }

    protected void keyScroll(int scrollTo) {
        if (scrollTo != -1) {
            this.setFocus();
            this.scrollRectIntoView(this.getRowIndexBounds(scrollTo), true);
        }
    }

    @Override
    protected void paintCanvas(GC gc) {
        StdSelection selection;
        Rectangle clipBounds;
        block23: {
            if (this.mEditor != null) {
                this.mEditor.adjustToOutline();
            }
            boolean active = this.isFocusControl();
            int rowHeight = this.mModel.getRowHeight();
            boolean showIndent = this.showIndent();
            boolean showOutline = this.showOutline();
            clipBounds = gc.getClipping();
            int last = this.overRowIndex(clipBounds.y + clipBounds.height - 1) + 1;
            int rowIndex = this.overRowIndex(clipBounds.y);
            gc.fillRectangle(clipBounds);
            if (last == 0) {
                last = this.mModel.getRowCount();
            }
            if (rowIndex <= -1) break block23;
            List<Row<C>> topLevelRows = this.mModel.getTopLevelRows();
            Row<C> lastTopParent = topLevelRows.get(topLevelRows.size() - 1);
            Row<C> firstRow = this.mModel.getRowAtIndex(0);
            int indentWidth = this.mModel.getIndentWidth();
            int top = this.getRowIndexBounds((int)rowIndex).y;
            while (rowIndex < last) {
                Row<C> row = this.mModel.getRowAtIndex(rowIndex);
                boolean rowSelected = this.mModel.isRowSelected(row);
                Rectangle colBounds = new Rectangle(0, top, 0, rowHeight);
                int shift = 0;
                gc.setForeground(this.getRowDividerColor(rowIndex));
                gc.drawLine(clipBounds.x, top + rowHeight, clipBounds.x + clipBounds.width, top + rowHeight);
                for (Column col : this.mModel.getColumns()) {
                    block24: {
                        block25: {
                            if (!col.isVisible()) continue;
                            colBounds.width = this.getColumnWidth(col);
                            if (!clipBounds.intersects(colBounds)) break block24;
                            this.drawRowBackground(gc, colBounds, row, rowSelected, active);
                            if (!showIndent || !col.isPrimary()) break block25;
                            int depth = row.getDepth();
                            shift = this.mModel.getIndentWidth(row, col);
                            colBounds.x += shift;
                            colBounds.width -= shift;
                            if (!showOutline) break block25;
                            Image image = this.getDisclosureControl(row);
                            Rectangle imageBounds = image.getBounds();
                            int disclosureLeft = colBounds.x - ((indentWidth - imageBounds.width) / 2 + imageBounds.width);
                            int x = disclosureLeft + imageBounds.width / 2;
                            int y = colBounds.y + colBounds.height / 2;
                            gc.setForeground(Colors.getOutlineHierarchy());
                            gc.drawLine(x, y, colBounds.x - 1, y);
                            x += indentWidth;
                            int lastY = y;
                            y = colBounds.y + colBounds.height;
                            Row<C> parent = row.getParent();
                            Row<C> child = row;
                            int i = 0;
                            while (i <= depth) {
                                block27: {
                                    int yend;
                                    block26: {
                                        yend = y;
                                        boolean isLastChild = false;
                                        x -= indentWidth;
                                        if (parent != null) {
                                            isLastChild = parent.getChild(parent.getChildCount() - 1) == child;
                                            child = parent;
                                            parent = parent.getParent();
                                        } else {
                                            boolean bl = isLastChild = lastTopParent == child;
                                        }
                                        if (!isLastChild) break block26;
                                        if (i != 0) break block27;
                                        yend = lastY;
                                    }
                                    int ys = colBounds.y;
                                    if (firstRow == row) {
                                        ys += colBounds.height / 2;
                                    }
                                    gc.drawLine(x, ys, x, yend);
                                }
                                ++i;
                            }
                            if (row.canHaveChildren()) {
                                gc.drawImage(image, disclosureLeft, colBounds.y + (colBounds.height - imageBounds.height) / 2);
                            }
                        }
                        col.drawRowCell(gc, colBounds, row, rowSelected, active);
                        if (showIndent && col.isPrimary()) {
                            colBounds.x -= shift;
                            colBounds.width += shift;
                        }
                    }
                    colBounds.x = colBounds.x + (colBounds.width + (this.mShowColumnLines ? 1 : 0));
                }
                if (clipBounds.x + clipBounds.width > colBounds.x) {
                    this.drawRowBackground(gc, new Rectangle(colBounds.x, colBounds.y, clipBounds.x + clipBounds.width - colBounds.x, colBounds.height), row, rowSelected, active);
                }
                top += rowHeight + 1;
                ++rowIndex;
            }
        }
        this.drawColumnDividers(gc, clipBounds);
        if (this.mDropChildInsertIndex != -1) {
            this.drawDragRowInsertionMarker(gc, this.mDropParentRow, this.mDropChildInsertIndex);
        }
        Rectangle bounds = this.toVirtual(this.getClientArea());
        if (this.mDropHighlight) {
            gc.setForeground(Colors.getSelection(true));
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            ++bounds.x;
            ++bounds.y;
            bounds.width -= 2;
            bounds.height -= 2;
            if (bounds.width > 0 && bounds.height > 0) {
                gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }
            --bounds.x;
            --bounds.y;
            bounds.width += 2;
            bounds.height += 2;
        }
        if (!(selection = this.mModel.getSelection()).isEmpty()) {
            int remaining;
            int index = this.overRowIndex(bounds.y);
            int n = remaining = index > -1 ? selection.getCountOfSelectedIndexesBefore(index) : 0;
            if (remaining > 0) {
                this.drawMore(gc, true, remaining);
            } else {
                this.mMoreUpArea.width = 0;
            }
            index = this.overRowIndex(bounds.y + bounds.height);
            int n2 = remaining = index > -1 ? selection.getCountOfSelectedIndexesAfter(index) : 0;
            if (remaining > 0) {
                this.drawMore(gc, false, remaining);
            } else {
                this.mMoreDownArea.width = 0;
            }
        } else {
            this.mMoreUpArea.width = 0;
            this.mMoreDownArea.width = 0;
        }
    }

    protected Rectangle repaintSelectionInternal() {
        Rectangle area = this.toVirtual(this.getClientArea());
        int top = area.y;
        int max = area.height;
        int bottom = area.y + max;
        StdSelection selection = this.mModel.getSelection();
        int index = selection.firstSelectedIndex();
        area.y = 0;
        area.height = 0;
        Rectangle bounds = new Rectangle(area.x, 0, area.width, this.mModel.getRowHeight() + 1);
        while (index != -1) {
            bounds.y = this.getRowIndexStart(index);
            if (bounds.y + bounds.height >= top && bounds.y < bottom) {
                this.redrawVirtual(bounds);
            }
            area = Geometry.union(area, bounds);
            if (bounds.y > bottom && area.height > max) break;
            index = selection.nextSelectedIndex(index + 1);
        }
        if (this.mMoreUpArea.width > 0) {
            this.redrawVirtual(this.mMoreUpArea);
        }
        if (this.mMoreDownArea.width > 0) {
            this.redrawVirtual(this.mMoreDownArea);
        }
        return area;
    }

    private void drawColumnDividers(GC gc, Rectangle bounds) {
        if (this.mShowColumnLines) {
            int x = 0;
            int y = bounds.y;
            int bottom = y + bounds.height;
            int right = bounds.x + bounds.width;
            for (Column col : this.mModel.getColumns()) {
                if (col.isVisible()) {
                    if ((x += this.getColumnWidth(col)) >= bounds.x) {
                        gc.setForeground(this.getColumnDividerColor(col.getID()));
                        gc.drawLine(x, y, x, bottom);
                    }
                    ++x;
                }
                if (x >= right) break;
            }
        }
    }

    private void drawDragRowInsertionMarker(GC gc, Row<C> parent, int insertAtIndex) {
        Rectangle bounds = this.getDragRowInsertionMarkerBounds(parent, insertAtIndex);
        gc.setForeground(Colors.getRed());
        int x1 = bounds.x;
        int x2 = x1 + bounds.width;
        int y1 = bounds.y + bounds.height / 2 - 1;
        int i = 0;
        while (i < 3) {
            gc.drawLine(x1, y1, x2, y1);
            ++i;
            ++y1;
        }
        gc.setForeground(Colors.getDarkRed());
        x1 = this.getDragRowInsertionMarkerIndent(parent, insertAtIndex);
        y1 = bounds.y;
        int y2 = y1 + bounds.height;
        int max = bounds.height / 2 + 1;
        int i2 = 0;
        while (i2 < max) {
            gc.drawLine(x1 + i2, y1 + i2, x1 + i2, y2 - (1 + i2));
            ++i2;
        }
        ++x1;
        y1 += 2;
        y2 -= 2;
        max -= 2;
        gc.setForeground(Colors.getYellow());
        i2 = 0;
        while (i2 < max) {
            gc.drawLine(x1 + i2, y1 + i2, x1 + i2, y2 - (1 + i2));
            ++i2;
        }
    }

    private void finishMouseHandling() {
        this.mNoScrollOnSelect = false;
        this.mDragSelectOK = false;
        this.mPreservedSelection = null;
        if (!(this.mIgnoreMouse || this.mSelectOnMouseUp == -1 || this.mAllowColumnResize && this.mResizeColumn != -1)) {
            this.mModel.select(this.mSelectOnMouseUp, false);
            this.mSelectOnMouseUp = -1;
        }
        if (this.mIgnoreMouse) {
            this.enableMouseTracking();
        }
        this.mIgnoreMouse = false;
        this.mCellMouseHandler = null;
        this.mResizeColumn = -1;
    }

    private void finishRowStateChange() {
        this.adjust();
        this.setAllowLazyAdjust(true);
        Header<C> header = this.getHeader();
        if (header != null) {
            header.pack();
            header.redraw();
        }
        this.setRedraw(true);
    }

    private int getAbsoluteInsertionIndex(@Nullable Row<C> parent, int childInsertIndex) {
        int insertAt;
        if (parent == null) {
            int count = this.mModel.getRowCount();
            insertAt = childInsertIndex;
            while (insertAt < count && this.mModel.getRowAtIndex(insertAt).getParent() != null) {
                ++insertAt;
            }
        } else {
            int i = parent.getChildCount();
            if (i == 0 || !parent.isOpen()) {
                insertAt = this.mModel.getIndexOfRow(parent) + 1;
            } else if (childInsertIndex < i) {
                insertAt = this.mModel.getIndexOfRow((Row)NullChecking.neverNull(parent.getChild(childInsertIndex)));
            } else {
                @NonNull Row row = (Row)NullChecking.neverNull(parent.getChild(i - 1));
                int count = this.mModel.getRowCount();
                insertAt = this.mModel.getIndexOfRow(row) + 1;
                while (insertAt < count && this.mModel.getRowAtIndex(insertAt).isDescendentOf(row)) {
                    ++insertAt;
                }
            }
        }
        return insertAt;
    }

    private IOutlineListener<C>[] getCurrentOutlineListeners() {
        return this.mListeners.toArray(new IOutlineListener[0]);
    }

    private Rectangle getDragRowInsertionMarkerBounds(Row<C> parent, int insertAtIndex) {
        Rectangle bounds;
        int rowCount = this.mModel.getRowCount();
        if (insertAtIndex < 0 || rowCount == 0) {
            bounds = new Rectangle(0, 0, 0, 0);
        } else {
            int insertAt = this.getAbsoluteInsertionIndex(parent, insertAtIndex);
            if (insertAt < rowCount) {
                bounds = this.getRowBounds(this.mModel.getRowAtIndex(insertAt));
                if (insertAt != 0) {
                    --bounds.y;
                }
            } else {
                bounds = this.getRowBounds(this.mModel.getRowAtIndex(rowCount - 1));
                bounds.y += bounds.height;
            }
        }
        bounds.y -= 5;
        bounds.height = 11;
        return bounds;
    }

    private int getDragRowInsertionMarkerIndent(Row<C> parent, int insertAtIndex) {
        if (this.mModel.showIndent()) {
            int rowCount = this.mModel.getRowCount();
            if (insertAtIndex >= 0 && rowCount > 0) {
                C primary = this.getPrimaryColumn();
                int indent = this.getColumnStart(primary);
                if (this.mModel.showOutline()) {
                    indent += this.mModel.getIndentWidth();
                }
                if (parent != null) {
                    indent += this.mModel.getIndentWidth() * (1 + parent.getDepth());
                }
                return indent;
            }
        }
        return 0;
    }

    private C getPrimaryColumn() {
        Column primary = (Column)this.mModel.getColumns().get(0);
        if (!primary.isPrimary()) {
            for (Column column : this.mModel.getColumns()) {
                if (!column.isPrimary()) continue;
                primary = column;
                break;
            }
        }
        return (C)primary;
    }

    private Set<Row<C>> getSelectedRowExclusionSet() {
        HashSet<Row<C>> exclude = new HashSet<Row<C>>();
        for (Row<C> row : this.mModel.getSelectionAsList()) {
            exclude.add(row);
            Row<C> parent = row.getParent();
            while (parent != null) {
                exclude.add(parent);
                parent = parent.getParent();
            }
        }
        return exclude;
    }

    private void handleDoubleClick(Point where, int stateMask, int button) {
        if (!this.mIgnoreMouse) {
            if (this.mAllowColumnResize && this.mResizeColumn != -1) {
                Column column = (Column)this.mModel.getColumns().get(this.mResizeColumn);
                int maxWidth = column.getMaxWidth();
                column.setNoMaxWidth();
                column.setPreferredWidth(column.getDefaultPreferredWidth());
                column.setWidth(column.getPreferredWidth(this));
                column.setMaxWidth(maxWidth);
                this.adjustScrollBarsForContent();
                this.redrawAll();
            } else {
                Row<C> row = this.overRow(where.y);
                if (row != null) {
                    Column column;
                    ICell<C> cell;
                    ObjIntPair<C> colAndXOffset = this.overColumnWithOffset(where.x);
                    if (colAndXOffset != null && (cell = (column = (Column)colAndXOffset.first).getRowCell(row)) instanceof ICellMouseHandler) {
                        ICellMouseHandler cmh;
                        this.mCellMouseHandler = cmh = (ICellMouseHandler)((Object)cell);
                        if (this.mCellMouseHandler.handleCellMouseDoubleClick(this, where, stateMask, button, row, column)) {
                            this.mIgnoreMouse = true;
                            this.disableMouseTracking();
                            return;
                        }
                        this.mCellMouseHandler = null;
                    }
                    if ((colAndXOffset == null || !this.overDisclosureControl(where.x, where.y, (Column)colAndXOffset.first, row)) && this.mModel.isRowSelected(row)) {
                        this.notifyOfOpenSelectionRequest();
                        this.finishMouseHandling();
                    }
                }
            }
        }
    }

    private void handleMouseDown(Point where, int stateMask, int button) {
        ICell<C> cell;
        Column column;
        if (this.mEditor != null) {
            this.mEditor.commit(false);
        }
        this.setEditor(null);
        this.setFocus();
        this.mSelectOnMouseUp = -1;
        ObjIntPair<C> colAndXOffset = this.overColumnWithOffset(where.x);
        Row<C> row = this.overRow(where.y);
        boolean bl = this.mWasSelectedBeforeDrag = row != null ? this.mModel.isRowSelected(row) : false;
        if (button == 1) {
            if (colAndXOffset != null && row != null && this.overDisclosureControl(where.x, where.y, column = (Column)colAndXOffset.first, row)) {
                Rectangle bounds = this.getCellBounds(row, column);
                bounds.width = this.mModel.getIndentWidth(row, column);
                this.redrawVirtual(bounds);
                row.setOpen(!row.isOpen());
                return;
            }
            if (this.mAllowColumnResize) {
                this.mResizeColumn = this.overColumnDivider(where.x);
                if (this.mResizeColumn != -1) {
                    this.mResizeColumnBaseline = where.x;
                    this.mResizeColumnSize = this.getColumnWidth((Column)this.mModel.getColumns().get(this.mResizeColumn));
                    return;
                }
            }
        }
        if (colAndXOffset != null && row != null && (cell = (column = (Column)colAndXOffset.first).getRowCell(row)) instanceof ICellMouseHandler) {
            ICellMouseHandler cmh;
            this.mCellMouseHandler = cmh = (ICellMouseHandler)((Object)cell);
            if (this.mCellMouseHandler.handleCellMouseDown(this, where, stateMask, button, row, column)) {
                this.mIgnoreMouse = true;
                this.disableMouseTracking();
                return;
            }
            this.mCellMouseHandler = null;
        }
        int method = 0;
        int rowIndexHit = this.overRowIndex(where.y);
        if ((stateMask & 0x20000) != 0) {
            method |= 1;
        }
        if (button == 1 && (stateMask & WorkspaceUtils.getCommandKey()) != 0) {
            method |= 2;
        }
        this.mNoScrollOnSelect = true;
        this.mSelectOnMouseUp = this.mModel.getSelection().selectByMouse(rowIndexHit, method);
        if (button != 1) {
            this.mSelectOnMouseUp = -1;
        }
        boolean bl2 = this.mDragSelectOK = this.mPermitDragSelect && button == 1;
        if (this.mDragSelectOK) {
            this.mInitialMouseY = where.y;
            this.mInitialMouseTime = System.currentTimeMillis();
        }
    }

    private void handleMouseMove(Point where, int stateMask) {
        if (this.mIgnoreMouse) {
            if (this.mCellMouseHandler != null) {
                this.mCellMouseHandler.handleCellMouseMove(this, where, stateMask);
            }
        } else {
            if (this.mDragSelectOK && (stateMask & WorkspaceUtils.getCommandKey()) == 0) {
                if (this.mInitialMouseTime != 0L) {
                    if (Math.abs(this.mInitialMouseY - where.y) < 4 && System.currentTimeMillis() - this.mInitialMouseTime < 250L) {
                        return;
                    }
                    this.mInitialMouseTime = 0L;
                }
                if (this.mPreservedSelection == null) {
                    this.mPreservedSelection = new StdSelection(this.mModel.getSelection());
                    this.mPreservedSelection.setNotify(false);
                }
                StdSelection newSel = new StdSelection(this.mPreservedSelection);
                int line = this.overRowIndex(where.y);
                if (line == -1) {
                    line = where.y < 0 ? 0 : this.mModel.getRowCount() - 1;
                }
                this.mSelectOnMouseUp = newSel.selectByMouse(line, 1);
                this.mModel.getSelection().select(newSel);
            } else if (this.mAllowColumnResize && (this.mResizeColumn != -1 || this.overColumnDivider(where.x) != -1)) {
                this.setCursor(this.getDisplay().getSystemCursor(9));
                if (this.mResizeColumn != -1) {
                    int size = Math.max(this.mResizeColumnSize + where.x - this.mResizeColumnBaseline, 10);
                    Column column = (Column)this.mModel.getColumns().get(this.mResizeColumn);
                    column.setPreferredWidth(size);
                    column.setWidth(size);
                    this.adjustScrollBarsForContent();
                    this.redrawAll();
                }
            } else {
                this.setCursor(this.getDisplay().getSystemCursor(0));
            }
            String tip = this.computeTooltip(where);
            String oldTip = this.getToolTipText();
            if (tip == null ? oldTip != null : !tip.equals(oldTip)) {
                this.setToolTipText(tip);
            }
        }
    }

    private void handleMouseUp(Point where, int stateMask) {
        ICellMouseHandler<C> handler = this.mCellMouseHandler;
        Rectangle bounds = this.getBounds();
        if (this.mPermitDragSelect || bounds.contains(where)) {
            this.finishMouseHandling();
            if (handler != null) {
                handler.handleCellMouseUp(this, where, stateMask);
            }
        }
    }

    private boolean hasClosedState(Row<C> row, Set<Row<C>> exclude) {
        if (row.canHaveChildren() && !exclude.contains(row)) {
            if (!row.isOpen()) {
                return true;
            }
            int count = row.getChildCount();
            int i = 0;
            while (i < count) {
                if (this.hasClosedState(row.getChild(i), exclude)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean hasOpenState(Row<C> row, Set<Row<C>> exclude) {
        if (row.canHaveChildren() && !exclude.contains(row)) {
            if (row.isOpen()) {
                return true;
            }
            int count = row.getChildCount();
            int i = 0;
            while (i < count) {
                if (this.hasOpenState(row.getChild(i), exclude)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void notifyOfDeleteSelectionRequest() {
        IOutlineListener<C>[] iOutlineListenerArray = this.getCurrentOutlineListeners();
        int n = iOutlineListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOutlineListener<C> listener = iOutlineListenerArray[n2];
            listener.deleteSelectionRequested(this);
            ++n2;
        }
    }

    private void notifyOfEditorChange() {
        IOutlineListener<C>[] iOutlineListenerArray = this.getCurrentOutlineListeners();
        int n = iOutlineListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOutlineListener<C> listener = iOutlineListenerArray[n2];
            listener.editorChanged(this);
            ++n2;
        }
    }

    private void notifyOfOpenSelectionRequest() {
        IOutlineListener<C>[] iOutlineListenerArray = this.getCurrentOutlineListeners();
        int n = iOutlineListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOutlineListener<C> listener = iOutlineListenerArray[n2];
            listener.openSelectionRequested(this);
            ++n2;
        }
    }

    private void open(Row<C> row, Set<Row<C>> exclude) {
        if (row.canHaveChildren() && !exclude.contains(row)) {
            row.setOpen(true);
            int count = row.getChildCount();
            int i = 0;
            while (i < count) {
                this.open(row.getChild(i), exclude);
                ++i;
            }
        }
    }

    private void prepareForRowStateChange() {
        this.setRedraw(false);
        this.setAllowLazyAdjust(false);
    }

    private void scrollMoreDown() {
        StdSelection selection = this.mModel.getSelection();
        if (!selection.isEmpty()) {
            int first;
            Rectangle bounds = this.toVirtual(this.getClientArea());
            int max = this.getClientArea().height / (this.mModel.getRowHeight() + 1);
            int last = first = selection.nextSelectedIndex(this.overRowIndex(bounds.y + bounds.height) + 1);
            int index = first;
            while ((index = selection.nextSelectedIndex(index + 1)) != -1 && index - first <= max) {
                last = index;
            }
            bounds = this.getRowIndexBounds(first);
            bounds = bounds.union(this.getRowIndexBounds(last));
            this.scrollRectIntoView(bounds, true);
        }
    }

    private void scrollMoreUp() {
        StdSelection selection = this.mModel.getSelection();
        if (!selection.isEmpty()) {
            int rangeEnd;
            int rangeStart;
            int first = this.overRowIndex(this.toVirtual((Rectangle)this.getClientArea()).y);
            int index = -1;
            TIntArrayList list = new TIntArrayList();
            while ((index = selection.nextSelectedIndex(index + 1)) != -1 && index < first) {
                list.add(index);
            }
            int max = this.getClientArea().height / (this.mModel.getRowHeight() + 1);
            int last = list.size() - 1;
            first = rangeStart = (rangeEnd = list.get(last--));
            while (last >= 0) {
                if (rangeEnd - (first = list.get(last--)) > max) break;
                rangeStart = first;
            }
            Rectangle bounds = this.getRowIndexBounds(rangeStart);
            bounds = bounds.union(this.getRowIndexBounds(rangeEnd));
            this.scrollRectIntoView(bounds, true);
        }
    }

    private void scrollSelectionIntoViewInternal(boolean verticalOnly) {
        StdSelection selection = this.mModel.getSelection();
        int first = selection.nextSelectedIndex(0);
        int max = this.mModel.getRowCount() - 1;
        if (first != -1 && first <= max) {
            int last;
            Rectangle bounds = this.getRowIndexBounds(first);
            int tmp = first;
            while ((tmp = selection.nextSelectedIndex((last = tmp) + 1)) != -1 && tmp <= max) {
            }
            if (first != last) {
                bounds = Geometry.union(bounds, this.getRowIndexBounds(last));
            }
            this.scrollRectIntoView(bounds, verticalOnly);
        }
    }

    int overColumnDivider(int x) {
        if (this.mShowColumnLines) {
            int pos = 0;
            int count = this.mModel.getColumnCount();
            int i = 0;
            while (i < count) {
                C col = this.mModel.getColumnAtIndex(i);
                if (((Column)col).isVisible() && x > (pos += this.getColumnWidth(col) + 1) - 5 && x < pos + 5) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    void setOpenRecursively(Row<C> row, boolean open) {
        row.setOpen(open);
        if (row.hasChildren()) {
            for (Row child : (List)NullChecking.neverNull(row.getChildren())) {
                this.setOpenRecursively(child, open);
            }
        }
    }

    public static enum MouseState {
        NORMAL,
        MORE_UP,
        MORE_DOWN,
        CUSTOM;

    }
}

