/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.ColumnStructureProperties;
import com.arm.utils.collections.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public record MappedHeaderDetails<C extends Column<C>>(@Nullable List<@NonNull String> hierarchyPrefix, @Nullable List<@NonNull String> groupPrefix, @NonNull C column, boolean internal) {
    public static final @NonNull String INTERNAL_LABEL = "Internal";
    public static final @NonNull String TAGS_LABEL = "Tags";

    public static <C extends Column<C>> @NonNull List<@NonNull Pair<@NonNull String, @NonNull C>> getExportableColumnsList(@NonNull List<@NonNull C> columns, boolean forCliExport) {
        ArrayList flattenedColumns = new ArrayList();
        MappedHeaderDetails.flattenHierarchyRecursive(flattenedColumns, columns.stream().filter(c -> c.getHierarchicalParentColumn() == null).toList(), forCliExport);
        @NonNull List<@NonNull Pair<@NonNull String, @NonNull C>> result = flattenedColumns.stream().map(c -> new Pair((Object)c.getExportName(), c)).toList();
        return result;
    }

    public static <C extends Column<C>> @NonNull MappedHeaderDetails<C> make(@NonNull C column) {
        List<String> groupPrefix;
        ColumnStructureProperties properties = column.getColumnStructureProperties();
        if (properties == null) {
            return new MappedHeaderDetails<C>(Collections.emptyList(), null, column, false);
        }
        boolean useClusterLabel = column.isUseClusterLabel();
        boolean isSpe = properties.hierarchyfilterGroupLabel.equalsIgnoreCase("SPE");
        boolean topLevelItem = properties.hierarchyfilterGroupLabel.isBlank();
        boolean ignoredFilterGroup = properties.filterGroupLabel.isBlank() || properties.filterGroupLabel.equalsIgnoreCase("Periodic Samples") || properties.filterGroupLabel.equalsIgnoreCase("Off-CPU") || properties.filterGroupLabel.equalsIgnoreCase("Metrics");
        boolean specialFilterGroup = properties.filterGroupLabel.equalsIgnoreCase("Percent of Total") || properties.filterGroupLabel.equalsIgnoreCase("Raw Counters");
        boolean internalItem = (properties.internal || properties.hierarchyfilterGroupLabel.equalsIgnoreCase(INTERNAL_LABEL)) && !specialFilterGroup;
        List<String> list = groupPrefix = ignoredFilterGroup || specialFilterGroup || internalItem ? null : MappedHeaderDetails.makePrefix(useClusterLabel, properties.clusterLabel, TAGS_LABEL, properties.filterGroupLabel);
        if (isSpe && !internalItem) {
            if (specialFilterGroup) {
                return new MappedHeaderDetails<C>(MappedHeaderDetails.makePrefix(useClusterLabel, properties.clusterLabel, properties.filterGroupLabel), null, column, false);
            }
            return new MappedHeaderDetails<C>(MappedHeaderDetails.makePrefix(useClusterLabel, properties.clusterLabel, new String[0]), groupPrefix, column, false);
        }
        if (topLevelItem && !internalItem) {
            if (specialFilterGroup) {
                return new MappedHeaderDetails<C>(MappedHeaderDetails.makePrefix(useClusterLabel, properties.clusterLabel, properties.filterGroupLabel), null, column, false);
            }
            return new MappedHeaderDetails<C>(Collections.emptyList(), groupPrefix, column, false);
        }
        if (internalItem) {
            return new MappedHeaderDetails<C>(MappedHeaderDetails.makePrefix(useClusterLabel, properties.clusterLabel, INTERNAL_LABEL), null, column, true);
        }
        if (specialFilterGroup) {
            return new MappedHeaderDetails<C>(MappedHeaderDetails.makePrefix(useClusterLabel, properties.clusterLabel, properties.filterGroupLabel), null, column, false);
        }
        return new MappedHeaderDetails<C>(MappedHeaderDetails.makePrefix(useClusterLabel, properties.clusterLabel, properties.hierarchyfilterGroupLabel), groupPrefix, column, false);
    }

    private static <C extends Column<C>> void flattenHierarchyRecursive(@NonNull List<@NonNull C> result, @NonNull List<@NonNull C> columns, boolean forCliExport) {
        MappedHeaderDetails.flattenHierarchyRecursiveOne(result, columns.stream().filter(c -> !MappedHeaderDetails.isShowLast(c.getColumnStructureProperties())).toList(), forCliExport);
        MappedHeaderDetails.flattenHierarchyRecursiveOne(result, columns.stream().filter(c -> MappedHeaderDetails.isShowLast(c.getColumnStructureProperties())).toList(), forCliExport);
    }

    private static <C extends Column<C>> void flattenHierarchyRecursiveOne(@NonNull List<@NonNull C> result, @NonNull List<@NonNull C> columns, boolean forCliExport) {
        for (Column c : columns) {
            if (!(!forCliExport && c.isHiddenFromUi() || c.isHiddenFromExport())) {
                result.add(c);
            }
            List children = c.getHierarchicalChildColumns();
            MappedHeaderDetails.flattenHierarchyRecursive(result, children, forCliExport);
        }
    }

    private static boolean isShowLast(@Nullable ColumnStructureProperties properties) {
        if (properties == null) {
            return false;
        }
        return properties.internal || properties.hierarchyfilterGroupLabel.equalsIgnoreCase(INTERNAL_LABEL) || properties.filterGroupLabel.equalsIgnoreCase("Raw Counters");
    }

    private static @NonNull List<@NonNull String> makePrefix(boolean useClusterLabel, @NonNull String clusterLabel, String ... parts) {
        if (clusterLabel.isBlank() || !useClusterLabel) {
            return Arrays.asList(parts);
        }
        if (parts.length == 0) {
            return Arrays.asList(clusterLabel);
        }
        String[] result = new String[1 + parts.length];
        result[0] = clusterLabel;
        System.arraycopy(parts, 0, result, 1, parts.length);
        return Arrays.asList(result);
    }
}

