/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class HeaderCell<C extends Column<C>>
extends TextCell<C> {
    public static final int EXPANDER_WIDTH = 12;
    public static final int SORTER_WIDTH = 12;
    public static final int ICON_GAP = 8;
    private boolean mAllowSort;
    private boolean mDisplaySort;
    private boolean mExpandable;
    private int mMinimumContentWidth;
    private OutlineModel<C> mModel;
    private boolean mSortAscending;
    private int mSortSequence;
    private final @NonNull C column;

    public HeaderCell(@NonNull C column) {
        super(0x1000000, 0x1000000, IColumnCompareType.TEXT());
        this.column = column;
        this.mSortSequence = -1;
        this.mSortAscending = true;
        this.mAllowSort = true;
        this.mDisplaySort = true;
        this.mExpandable = false;
    }

    @Override
    public void drawCell(GC gc, Rectangle originalBounds, Row<C> ignored, C column, boolean selected, boolean active) {
        assert (ignored == null);
        boolean allowSortIcon = this.mAllowSort && this.mDisplaySort;
        boolean showExpandIcon = this.mExpandable;
        boolean showSortIcon = allowSortIcon && this.mSortSequence == 0;
        int heightAdjust = allowSortIcon || showExpandIcon ? 2 : 0;
        int expandWidth = showExpandIcon ? 20 : 0;
        int sortWidth = showSortIcon ? 20 : 0;
        int widthAdjust = showExpandIcon || showSortIcon ? expandWidth + sortWidth + 4 : 0;
        Rectangle adjustedBounds = new Rectangle(originalBounds.x + heightAdjust / 2, originalBounds.y, Math.max(0, originalBounds.width - widthAdjust), Math.max(0, originalBounds.height - heightAdjust));
        super.drawCell(gc, adjustedBounds, null, column, selected, active);
        if (showSortIcon) {
            gc.setForeground(Colors.getDarkBlue());
            int x = adjustedBounds.x + adjustedBounds.width + 12 + 8;
            int y = adjustedBounds.y + adjustedBounds.height;
            if (this.shouldDisplaySequenceMarker()) {
                int i = 0;
                while (i <= this.mSortSequence) {
                    gc.drawLine(x - (1 + i * 3), y, x - i * 3, y);
                    ++i;
                }
            }
            int sorterHeight = 5;
            x -= 6;
            y = adjustedBounds.y + (adjustedBounds.height - 6) / 2;
            int i = 0;
            while (i < 5) {
                int x1 = this.mSortAscending ? x - i : x + i - 4;
                int x2 = this.mSortAscending ? x + i : x + 4 - i;
                gc.drawLine(x1, y + i, x2 + 1, y + i);
                ++i;
            }
        }
        if (showExpandIcon) {
            int size = Math.max(0, Math.min(8, adjustedBounds.height - 2));
            gc.setForeground(Colors.getDarkBlue());
            int xs = originalBounds.x + originalBounds.width - 16;
            int ys = adjustedBounds.y + (adjustedBounds.height - size) / 2;
            int xm = xs + size / 2;
            int ym = ys + size / 2;
            int xe = xs + size;
            int ye = ys + size;
            switch (this.isExpanded()) {
                case FALSE: {
                    gc.drawLine(xs, ym, xe, ym);
                    gc.drawLine(xm, ys, xm, ye);
                    break;
                }
                case MAYBE: {
                    gc.drawLine(xs, ys, xe, ys);
                    gc.drawLine(xe, ys, xe, ye);
                    gc.drawLine(xe, ye, xs, ye);
                    gc.drawLine(xs, ye, xs, ys);
                    break;
                }
                case TRUE: {
                    gc.drawLine(xs, ys, xe, ye);
                    gc.drawLine(xe, ys, xs, ye);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public int getMinimumContentWidth() {
        return this.mMinimumContentWidth;
    }

    @Override
    public Point getPreferredSize(Row<C> row, C column) {
        Point size = super.getPreferredSize(row, column);
        if (this.mAllowSort && this.mDisplaySort) {
            size.x += 20;
        }
        if (this.mExpandable) {
            size.x += 20;
        }
        if (this.mAllowSort && this.mDisplaySort || this.mExpandable) {
            size.x += 4;
            size.y += 2;
        }
        if (this.mMinimumContentWidth > size.x) {
            size.x = this.mMinimumContentWidth;
        }
        return size;
    }

    public int getSortSequence() {
        return this.mSortSequence;
    }

    @Override
    public String getToolTipText(Outline<C> outline, Point where, Row<C> row, C column) {
        return ((Column)column).getToolTipText();
    }

    public boolean isExpandable() {
        return this.mExpandable;
    }

    public @NonNull Ternary isExpanded() {
        if (!this.mExpandable) {
            return Ternary.FALSE;
        }
        return (Ternary)NullChecking.neverNullOr((Object)HeaderCell.allChildVisible(this.column), (Object)Ternary.FALSE);
    }

    private static <C extends Column<C>> @Nullable Ternary allChildVisible(@NonNull C column) {
        Ternary result = null;
        for (Column child : column.getHierarchicalChildColumns()) {
            if (!child.isHiddenFromUi() && (result = HeaderCell.combineVisible(result, child.isVisible() || child.isPrimary() ? Ternary.TRUE : Ternary.FALSE)) == Ternary.MAYBE) {
                return Ternary.MAYBE;
            }
            if ((result = HeaderCell.combineVisible(result, HeaderCell.allChildVisible(child))) != Ternary.MAYBE) continue;
            return Ternary.MAYBE;
        }
        return result;
    }

    private static @Nullable Ternary combineVisible(@Nullable Ternary current, @Nullable Ternary next) {
        if (next == null) {
            return current;
        }
        if (current == null) {
            return next;
        }
        if (current != next) {
            return Ternary.MAYBE;
        }
        return current;
    }

    public boolean isSortAllowed() {
        return this.mAllowSort;
    }

    public boolean isSortAscending() {
        return this.mSortAscending;
    }

    public boolean isSortDisplayAllowed() {
        return this.mAllowSort && this.mDisplaySort;
    }

    public void setAllowSort(boolean allow) {
        if (allow != this.mAllowSort) {
            this.mAllowSort = allow;
            if (!this.mAllowSort) {
                this.mSortSequence = -1;
            }
        }
    }

    public void setDisplaySort(boolean display) {
        this.mDisplaySort = display;
    }

    public void setExpandable(boolean expandable) {
        this.mExpandable = expandable;
    }

    public void setMinimumContentWidth(int width) {
        this.mMinimumContentWidth = width;
    }

    public void setOutlineModel(OutlineModel<C> model) {
        this.mModel = model;
    }

    public void setSortCriteria(int sequence, boolean ascending) {
        if (this.mAllowSort) {
            this.mSortSequence = sequence;
            this.mSortAscending = ascending;
        }
    }

    private boolean shouldDisplaySequenceMarker() {
        if (this.mModel == null) {
            return true;
        }
        for (Column column : this.mModel.getColumns()) {
            if (column.getSortSequence() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getData(@Nullable Row<C> ignored, @NonNull C column, boolean nullOK) {
        assert (ignored == null);
        return ((Column)column).getName();
    }
}

