/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import com.arm.streamline.widget.contextmenu.IContextMenuSelectionResolver;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.MappedHeaderDetails;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineMessages;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.collections.Pair;
import com.arm.utils.text.BasicNumberUtils;
import com.arm.utils.text.SWTLabelFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;

public class Header<C extends Column<C>>
extends Canvas
implements IContextMenuSelectionResolver,
IContextMenuContributor,
ControlListener,
PaintListener,
MouseListener,
MouseMoveListener,
MouseTrackListener {
    private static final String ID_ACTION_MENU = "ACTION_MENU";
    private static final String ID_PARENT_COLUMN = "PARENT_COLUMN_";
    private static final String ID_RESET_COLUMNS = "RESET_COLUMNS";
    private static final String ID_SHOW_ALL_COLUMNS = "SHOW_ALL_COLUMNS";
    private static final String ID_SHOW_COLUMN = "SHOW_COLUMN_";
    private @Nullable C mExpandColumn;
    private @Nullable Outline<C> mOwner;
    private int mResizeColumn = -1;
    private int mResizeColumnBaseline;
    private int mResizeColumnSize;
    private @Nullable C mSortColumn;

    private static <C extends Column<C>> boolean isMouseInHeaderExpanderClickArea(@NonNull Outline<C> mOwner, @NonNull C column, int offset) {
        if (column.getHeaderCell().isExpandable()) {
            int width = mOwner.getColumnWidth(column);
            int from = width - 16;
            int to = from + 12;
            if (offset >= from && offset < to) {
                return true;
            }
        }
        return false;
    }

    private static <C extends Column<C>> void setColumnsHidden(@NonNull VirtualHierarchyTreeNode<C> node) {
        for (VirtualHierarchyTreeNode nested : node.nestedHierarchy.values()) {
            Header.setColumnsHidden(nested);
        }
        Iterator iterator = node.childColumns.iterator();
        while (iterator.hasNext()) {
            Column child;
            child.setVisible((child = (Column)((Object)iterator.next())).isPrimary() && !child.isHiddenFromUi());
        }
    }

    private static <C extends Column<C>> void setColumnsVisible(@NonNull VirtualHierarchyTreeNode<C> node) {
        for (VirtualHierarchyTreeNode nested : node.nestedHierarchy.values()) {
            Iterator iterator = nested.childColumns.iterator();
            while (iterator.hasNext()) {
                Column child;
                child.setVisible(((child = (Column)iterator.next()).isVisible() || child.isPrimary() || !child.isComponentOfParent()) && !child.isHiddenFromUi());
            }
        }
        Iterator iterator = node.childColumns.iterator();
        while (iterator.hasNext()) {
            Column child;
            child.setVisible(!(child = (Column)((Object)iterator.next())).isHiddenFromUi());
        }
    }

    public Header(Composite parent) {
        super(parent, 0x20000000);
        ControlHacks.setBackground((Control)this, Colors.getWidgetBackground());
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        new ContextMenu((Control)this).add(this);
    }

    @Override
    public void cleanup(ContextMenu cm) {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        @Nullable Outline<C> mOwner = this.mOwner;
        Point size = new Point(wHint, hHint);
        if (mOwner != null && (wHint == -1 || hHint == -1)) {
            size.y = 0;
            for (Column col : mOwner.getModel().getColumns()) {
                if (!col.isVisible()) continue;
                int width = col.getWidth();
                if (width == -1) {
                    width = col.getPreferredWidth(mOwner);
                    col.setWidth(width);
                }
                if ((width = col.getPreferredHeaderSize().y) <= size.y) continue;
                size.y = width;
            }
            size.y += 2;
            size.x = mOwner.getClientArea().width;
        }
        return size;
    }

    public void controlMoved(ControlEvent event) {
    }

    public void controlResized(ControlEvent event) {
        SafeUpdate.pack((Composite)this);
    }

    public Rectangle getColumnBounds(@NonNull C column) {
        @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
        Rectangle bounds = this.getClientArea();
        bounds.x = mOwner.fromVirtual((Point)new Point((int)mOwner.getColumnStart(column), (int)0)).x;
        bounds.width = mOwner.getColumnWidth(column);
        return bounds;
    }

    public @Nullable Outline<C> getOwner() {
        return this.mOwner;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public @NonNull ISelection getSelection(Control control, Point where) {
        return new StructuredSelection((Object)this);
    }

    @Override
    public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
        @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
        if (ID_SHOW_ALL_COLUMNS.equals(commandID)) {
            for (Column column : mOwner.getModel().getColumns()) {
                if (column.isHiddenFromUi()) continue;
                column.setVisible(true);
            }
            this.requestLayout();
            mOwner.lazyAdjust();
        } else if (ID_RESET_COLUMNS.equals(commandID)) {
            mOwner.applyConfig(mOwner.getDefaultConfig(), false, true);
            this.requestLayout();
            mOwner.lazyAdjust();
        } else if (commandID.startsWith(ID_SHOW_COLUMN)) {
            @Nullable C column = mOwner.getModel().getColumnWithID(BasicNumberUtils.getNonLocalizedInteger((String)commandID.substring(ID_SHOW_COLUMN.length()), (int)0));
            if (column != null) {
                ((Column)column).setVisible(!((Column)column).isVisible());
                this.requestLayout();
                mOwner.lazyAdjust();
            }
        } else if (commandID.startsWith(ID_ACTION_MENU)) {
            Runnable runnable = (Runnable)NullChecking.neverNull((Object)((Runnable)menuItem.getData()));
            runnable.run();
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
        if (this.mResizeColumn != -1) {
            @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
            @NonNull Column column = (Column)mOwner.getModel().getColumns().get(this.mResizeColumn);
            int maxWidth = column.getMaxWidth();
            column.setNoMaxWidth();
            column.setPreferredWidth(column.getDefaultPreferredWidth());
            column.setWidth(column.getPreferredWidth(mOwner));
            column.setMaxWidth(maxWidth);
            mOwner.adjustScrollBarsForContent();
            mOwner.redrawAll();
        }
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1) {
            @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
            int x = mOwner.toVirtual((Point)new Point((int)event.x, (int)event.y)).x;
            this.mResizeColumn = mOwner.overColumnDivider(x);
            if (this.mResizeColumn != -1) {
                this.mResizeColumnBaseline = x;
                this.mResizeColumnSize = mOwner.getColumnWidth((Column)mOwner.getModel().getColumns().get(this.mResizeColumn));
            } else {
                ObjIntPair colAndXOffset = mOwner.overColumnWithOffset(x);
                this.mSortColumn = null;
                this.mExpandColumn = null;
                if (colAndXOffset != null) {
                    Column column = (Column)colAndXOffset.first;
                    int offset = colAndXOffset.second;
                    if (Header.isMouseInHeaderExpanderClickArea(mOwner, column, offset)) {
                        this.mExpandColumn = column;
                    } else if (column.getHeaderCell().isSortAllowed()) {
                        this.mSortColumn = column;
                    }
                }
            }
        }
    }

    public void mouseEnter(MouseEvent event) {
        this.mouseMove(event);
    }

    public void mouseExit(MouseEvent event) {
    }

    public void mouseHover(MouseEvent event) {
    }

    public void mouseMove(MouseEvent event) {
        Point point = new Point(event.x, event.y);
        @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
        int x = mOwner.toVirtual((Point)point).x;
        if (this.mResizeColumn != -1 || mOwner.overColumnDivider(x) != -1) {
            this.setCursor(this.getDisplay().getSystemCursor(9));
            if (this.mResizeColumn != -1) {
                int size = Math.max(this.mResizeColumnSize + x - this.mResizeColumnBaseline, 10);
                Column column = (Column)mOwner.getModel().getColumns().get(this.mResizeColumn);
                column.setPreferredWidth(size);
                column.setWidth(size);
                mOwner.adjustScrollBarsForContent();
                mOwner.redrawAll();
            }
        } else {
            this.setCursor(this.getDisplay().getSystemCursor(0));
        }
        String tip = null;
        ObjIntPair colAndXOffset = mOwner.overColumnWithOffset(x);
        if (colAndXOffset != null) {
            Column column = (Column)colAndXOffset.first;
            tip = column.getHeaderCell().getToolTipText(mOwner, point, null, column);
        }
        String oldTip = this.getToolTipText();
        if (tip == null ? oldTip != null : !tip.equals(oldTip)) {
            this.setToolTipText(SWTLabelFilter.filterForToolTip((String)tip));
        }
    }

    public void mouseUp(MouseEvent event) {
        if (event.button == 1) {
            Outline mOwner;
            ObjIntPair colAndXOffset;
            this.mResizeColumn = -1;
            C mSortColumn = this.mSortColumn;
            C mExpandColumn = this.mExpandColumn;
            this.mExpandColumn = null;
            this.mSortColumn = null;
            if ((mSortColumn != null || mExpandColumn != null) && (colAndXOffset = (mOwner = (Outline)NullChecking.neverNull(this.mOwner)).overColumnWithOffset(mOwner.toVirtual((Point)new Point((int)event.x, (int)event.y)).x)) != null) {
                Column column = (Column)colAndXOffset.first;
                int offset = colAndXOffset.second;
                if (Header.isMouseInHeaderExpanderClickArea(mOwner, column, offset)) {
                    if (column == mExpandColumn) {
                        boolean setVisible = column.getHeaderCell().isExpanded() == Ternary.FALSE;
                        OutlineModel model = mOwner.getModel();
                        List columns = model.getColumns();
                        HashSet children = new HashSet();
                        HashSet descendants = new HashSet();
                        boolean allChildenAreComponents = true;
                        boolean modified = true;
                        while (modified) {
                            modified = false;
                            block1: for (Column col : columns) {
                                Column currentCol = col;
                                Object parentCol = col.getHierarchicalParentColumn();
                                while (parentCol != null) {
                                    if (parentCol == column) {
                                        modified |= descendants.add(currentCol);
                                        if (currentCol != col) continue block1;
                                        children.add(currentCol);
                                        allChildenAreComponents &= currentCol.isComponentOfParent();
                                        continue block1;
                                    }
                                    if (descendants.contains(parentCol)) {
                                        modified |= descendants.add(currentCol);
                                        continue block1;
                                    }
                                    currentCol = parentCol;
                                    parentCol = ((Column)parentCol).getHierarchicalParentColumn();
                                }
                            }
                        }
                        if (descendants.isEmpty()) {
                            column.getHeaderCell().setExpandable(false);
                        } else if (setVisible) {
                            boolean childenAreComponents = allChildenAreComponents;
                            children.forEach(c -> {
                                if (childenAreComponents || !c.isComponentOfParent()) {
                                    c.setVisible(true);
                                }
                            });
                        } else {
                            descendants.forEach(c -> c.setVisible(false));
                        }
                        this.requestLayout();
                        mOwner.lazyAdjust();
                    }
                } else if (column == mSortColumn) {
                    boolean sortAscending = column.isSortAscending();
                    if (column.getSortSequence() != -1) {
                        sortAscending = !sortAscending;
                    }
                    mOwner.setSort(column, sortAscending, (event.stateMask & 0x20000) != 0);
                }
            }
        }
    }

    public void paintControl(PaintEvent event) {
        @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
        Rectangle bounds = this.getClientArea();
        Color dividerColor = Colors.getDivider();
        int left = event.x;
        int right = left + event.width;
        int bottom = bounds.y + bounds.height - 1;
        int origWidth = bounds.width;
        Point offset = mOwner.toVirtual(new Point(0, 0));
        GC gc = new GC(event.gc);
        bounds.x = -offset.x;
        --bounds.height;
        for (Column col : mOwner.getModel().getColumns()) {
            if (!col.isVisible()) continue;
            bounds.width = mOwner.getColumnWidth(col);
            if (bounds.x <= right && bounds.x + bounds.width >= left) {
                ++bounds.y;
                col.drawHeaderCell(gc, bounds);
                --bounds.y;
            }
            bounds.x += bounds.width;
            gc.setForeground(dividerColor);
            gc.drawLine(bounds.x, bounds.y, bounds.x, bottom);
            ++bounds.x;
        }
        gc.setForeground(dividerColor);
        gc.drawLine(0, bottom, origWidth, bottom);
    }

    @Override
    public void prepareMenu(ContextMenu cm) {
        assert (cm != null);
        @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
        OutlineModel model = mOwner.getModel();
        int count = model.getVisibleColumnCount();
        List columns = model.getColumns();
        List<MappedHeaderDetails> columnHeaderDetails = columns.stream().filter(c -> !c.isHiddenFromUi()).map(c -> MappedHeaderDetails.make(c)).toList();
        ArrayList rootColumnsByPrimaryGroupLabel = new ArrayList(columnHeaderDetails.stream().filter(c -> ((Column)c.column()).getHierarchicalParentColumn() == null && c.hierarchyPrefix() != null).map(c -> new Pair((Object)((List)NullChecking.neverNull(c.hierarchyPrefix())), c.column())).collect(Collectors.toMap(p -> (List)p.first, p -> List.of((Column)p.second), (a, b) -> {
            ArrayList result = new ArrayList();
            result.addAll(a);
            result.addAll(b);
            return result;
        }, LinkedHashMap::new)).entrySet());
        ArrayList columnsByVirtualHierarchy = new ArrayList(columnHeaderDetails.stream().filter(c -> {
            List<String> g = c.groupPrefix();
            return g != null && !g.isEmpty();
        }).map(c -> new Pair((Object)((List)NullChecking.neverNull(c.groupPrefix())), c.column())).collect(Collectors.toMap(p -> (List)p.first, p -> List.of((Column)p.second), (a, b) -> {
            ArrayList result = new ArrayList();
            result.addAll(a);
            result.addAll(b);
            return result;
        }, LinkedHashMap::new)).entrySet());
        boolean tagsJustInternal = columnHeaderDetails.stream().filter(c -> {
            List<String> g = c.groupPrefix();
            return g != null && !g.isEmpty();
        }).allMatch(c -> c.internal());
        VirtualHierarchyTreeNode root = new VirtualHierarchyTreeNode();
        rootColumnsByPrimaryGroupLabel.forEach(e -> root.add((List)e.getKey(), (List)e.getValue(), true));
        if (columnsByVirtualHierarchy.size() > 1 && !tagsJustInternal) {
            columnsByVirtualHierarchy.forEach(e -> root.add((List)e.getKey(), (List)e.getValue(), false));
        }
        HashMap<@NonNull K, @NonNull V> allMenus = new HashMap();
        this.prepareMenu(cm, null, "", "", root.nestedHierarchy, allMenus, count);
        boolean first = true;
        for (Column column : root.childColumns) {
            if (first) {
                cm.createConditionalSeparator();
                first = false;
            }
            @NonNull String newMenuItemID = ID_SHOW_COLUMN + column.getID();
            boolean primary = column.isPrimary();
            boolean visible = column.isVisible();
            cm.createMenuItem((IContextMenuContributor)this, column.getSanitizedName(), newMenuItemID, !primary, visible);
        }
        cm.createConditionalSeparator();
        cm.createMenuItem(this, OutlineMessages.SHOW_ALL_COLUMNS, ID_SHOW_ALL_COLUMNS, count != model.getColumnCount());
        cm.createMenuItem(this, OutlineMessages.RESET_COLUMNS, ID_RESET_COLUMNS, !mOwner.getConfig().equals(mOwner.getDefaultConfig()));
    }

    public void setOwner(@Nullable Outline<C> outline) {
        @Nullable Outline<C> mOwner = this.mOwner;
        if (mOwner != outline) {
            if (mOwner != null) {
                mOwner.removeControlListener(this);
            }
            this.mOwner = outline;
            if (outline != null) {
                outline.addControlListener(this);
                SafeUpdate.pack((Composite)this);
            }
        }
    }

    private void prepareMenu(@NonNull ContextMenu cm, @Nullable String parentMenuID, @NonNull String parentIDPath, @NonNull String prefix, @NonNull Map<@NonNull String, @NonNull VirtualHierarchyTreeNode<C>> nodes, @NonNull Map<@NonNull C, @NonNull MenuItem> allMenus, int count) {
        for (Map.Entry<String, VirtualHierarchyTreeNode<C>> entry : nodes.entrySet()) {
            String nestedName;
            String name = entry.getKey();
            final VirtualHierarchyTreeNode<C> node = entry.getValue();
            String thisIDPath = parentIDPath + "." + name.replaceAll("[^0-9A-Za-z_\\-]", "_");
            String string = nestedName = prefix.isBlank() ? name : String.format("%s -> %s", prefix, name);
            if (node.childColumns.isEmpty() && node.nestedHierarchy.size() == 1) {
                this.prepareMenu(cm, parentMenuID, thisIDPath, nestedName, node.nestedHierarchy, allMenus, count);
                continue;
            }
            Ternary groupChildrenVisible = node.allChildrenVisible();
            @NonNull String newNestedParentID = ID_PARENT_COLUMN + thisIDPath;
            if (parentMenuID != null) {
                cm.createCascadeMenu(nestedName, parentMenuID, newNestedParentID, true);
            } else {
                cm.createCascadeMenu(nestedName, newNestedParentID, true);
            }
            this.prepareMenu(cm, newNestedParentID, thisIDPath, "", node.nestedHierarchy, allMenus, count);
            if (!node.childColumns.isEmpty()) {
                cm.createConditionalSeparator(newNestedParentID);
                int MAX_ITEMS_CASCADE_SINGLE = 5;
                int MAX_ITEMS_CASCADE = 20;
                String menuID = newNestedParentID;
                if (!node.nestedHierarchy.isEmpty() && node.childColumns.size() > 5 && node.nestedHierarchy.size() + node.childColumns.size() > 20) {
                    menuID = newNestedParentID + "._.nested_hierarchy";
                    cm.createCascadeMenu("Columns", newNestedParentID, menuID, true);
                }
                for (Column column : node.childColumns) {
                    @NonNull String newMenuItemID = ID_SHOW_COLUMN + column.getID();
                    boolean primary = column.isPrimary();
                    boolean visible = column.isVisible();
                    cm.createCascadeMenuItem(this, menuID, column.getSanitizedName(), newMenuItemID, !primary, visible);
                }
            }
            if (groupChildrenVisible == null) continue;
            cm.createConditionalSeparator(newNestedParentID);
            if (groupChildrenVisible == Ternary.FALSE || groupChildrenVisible == Ternary.MAYBE) {
                MenuItem toggleAll = cm.createCascadeMenuItem(this, newNestedParentID, "Show All", ID_ACTION_MENU + thisIDPath + "._.show_all", true);
                toggleAll.setData((Object)new Runnable(){

                    @Override
                    public void run() {
                        Header.setColumnsVisible(node);
                        Header.this.requestLayout();
                        ((Outline)NullChecking.neverNull(Header.this.mOwner)).lazyAdjust();
                    }
                });
            }
            if (groupChildrenVisible != Ternary.TRUE && groupChildrenVisible != Ternary.MAYBE) continue;
            MenuItem toggleAll = cm.createCascadeMenuItem(this, newNestedParentID, "Hide All", ID_ACTION_MENU + thisIDPath + "._.hide_all", true);
            toggleAll.setData((Object)new Runnable(){

                @Override
                public void run() {
                    Header.setColumnsHidden(node);
                    Header.this.requestLayout();
                    ((Outline)NullChecking.neverNull(Header.this.mOwner)).lazyAdjust();
                }
            });
        }
    }

    private record VirtualHierarchyTreeNode<C extends Column<C>>(@NonNull Map<@NonNull String, @NonNull VirtualHierarchyTreeNode<C>> nestedHierarchy, @NonNull Set<@NonNull C> childColumns) {
        public VirtualHierarchyTreeNode() {
            this(new LinkedHashMap<String, VirtualHierarchyTreeNode<C>>(), new LinkedHashSet());
        }

        public void add(@NonNull List<@NonNull String> path, @NonNull List<@NonNull C> columns, boolean hierarchy) {
            assert (hierarchy || !path.isEmpty());
            VirtualHierarchyTreeNode node = this;
            while (!path.isEmpty()) {
                String key = path.get(0);
                node = node.nestedHierarchy.computeIfAbsent(key, k -> new VirtualHierarchyTreeNode());
                path = path.subList(1, path.size());
            }
            if (hierarchy) {
                VirtualHierarchyTreeNode.addColumnsRecursive(node, columns);
            } else {
                node.childColumns.addAll(columns);
            }
        }

        private static <C extends Column<C>> void addColumnsRecursive(@NonNull VirtualHierarchyTreeNode<C> node, @NonNull List<@NonNull C> columns) {
            for (Column column : columns) {
                if (column.isHiddenFromUi()) {
                    VirtualHierarchyTreeNode.addColumnsRecursive(node, column.getHierarchicalChildColumns());
                    continue;
                }
                if (column.getHierarchicalChildColumns().isEmpty()) {
                    node.childColumns.add(column);
                    continue;
                }
                VirtualHierarchyTreeNode childNode = node.nestedHierarchy.computeIfAbsent(column.getSanitizedName(), k -> new VirtualHierarchyTreeNode());
                childNode.childColumns.add(column);
                VirtualHierarchyTreeNode.addColumnsRecursive(childNode, column.getHierarchicalChildColumns());
            }
        }

        public @Nullable Ternary allChildrenVisible() {
            Ternary result = null;
            for (Column column : this.childColumns) {
                if ((result = VirtualHierarchyTreeNode.mergeVisible(result, column.isVisible() ? Ternary.TRUE : Ternary.FALSE)) != Ternary.MAYBE) continue;
                return Ternary.MAYBE;
            }
            for (VirtualHierarchyTreeNode virtualHierarchyTreeNode : this.nestedHierarchy.values()) {
                if ((result = VirtualHierarchyTreeNode.mergeVisible(result, virtualHierarchyTreeNode.allChildrenVisible())) != Ternary.MAYBE) continue;
                return Ternary.MAYBE;
            }
            return result;
        }

        private static @Nullable Ternary mergeVisible(@Nullable Ternary current, @Nullable Ternary next) {
            if (next == null) {
                return current;
            }
            if (current == null) {
                return next;
            }
            if (current != next) {
                return Ternary.MAYBE;
            }
            return current;
        }
    }
}

