/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.outline.ColumnStructureProperties;
import com.arm.streamline.widget.outline.HeaderCell;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.MappedHeaderDetails;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class Column<C extends Column<C>> {
    private static final @NonNull String SPACE = " ";
    private boolean componentOfParent;
    private @NonNull Collection<@NonNull C> derivedFrom = new ArrayList<C>();
    private boolean isHiddenFromExport;
    private boolean isHiddenFromUi;
    private int mDefaultPreferredWidth;
    private HeaderCell<C> mHeaderCell;
    private Image mIcon;
    private int mID;
    private int mMaxWidth = 450;
    private String mName;
    private int mPreferredWidth;
    private boolean mPrimary;
    private ICell<C> mRowCell;
    private String mToolTipText;
    private Object mUserRef;
    private boolean mVisible;
    private int mWidth;
    private boolean useClusterLabel;
    private @NonNull Collection<@NonNull C> requiredBy = new ArrayList<C>();

    protected Column(@NonNull Class<? extends C> clazz, int id, String name) {
        this(clazz, id, name, (Image)null);
    }

    protected Column(@NonNull Class<? extends C> clazz, int id, String name, ICell<C> rowCell) {
        this(clazz, id, name, null, rowCell);
    }

    protected Column(@NonNull Class<? extends C> clazz, int id, String name, Image icon) {
        this(clazz, id, name, icon, name);
    }

    protected Column(@NonNull Class<? extends C> clazz, int id, String name, Image icon, String toolTipText) {
        this(clazz, id, name, icon, toolTipText, new TextCell());
    }

    protected Column(@NonNull Class<? extends C> clazz, int id, String name, Image icon, String toolTipText, ICell<C> rowCell) {
        assert (clazz.isAssignableFrom(this.getClass()));
        this.mName = (name == null || name.length() == 0 ? SPACE : name).replace(": Periodic Samples", ": Samples").replace(": Sample Count", ": Samples");
        this.mIcon = icon;
        this.mToolTipText = toolTipText;
        this.mRowCell = rowCell;
        this.mPrimary = false;
        this.mVisible = true;
        this.mWidth = -1;
        this.mID = id;
        this.setHeaderCell(new HeaderCell<C>(this.thisC()));
    }

    protected Column(@NonNull Class<? extends C> clazz, int id, String name, String toolTipText) {
        this(clazz, id, name, null, toolTipText);
    }

    protected Column(@NonNull Class<? extends C> clazz, int id, String name, String toolTipText, ICell<C> rowCell) {
        this(clazz, id, name, null, toolTipText, rowCell);
    }

    protected Column(@NonNull Class<? extends C> clazz, int ordinal, @NonNull String header, String toolTip, ICell<C> cell, boolean isHiddenFromUi, boolean isHiddenFromExport, boolean isVisible, boolean componentOfParent, boolean useClusterLabel) {
        this(clazz, ordinal, header, null, toolTip, cell);
        this.isHiddenFromUi = isHiddenFromUi;
        this.isHiddenFromExport = isHiddenFromExport;
        this.componentOfParent = componentOfParent;
        this.useClusterLabel = useClusterLabel;
        this.setVisible(isVisible);
    }

    public void drawHeaderCell(GC gc, Rectangle bounds) {
        this.getHeaderCell().drawCell(gc, bounds, null, this.thisC(), false, true);
    }

    public void drawRowCell(GC gc, Rectangle bounds, @NonNull Row<C> row, boolean selected, boolean active) {
        this.getRowCell(row).drawCell(gc, bounds, row, this.thisC(), selected, active);
    }

    public @Nullable ColumnStructureProperties getColumnStructureProperties() {
        return null;
    }

    public @NonNull String getExportName() {
        ColumnStructureProperties properties = this.getColumnStructureProperties();
        if (properties == null) {
            StringBuilder parentName = new StringBuilder();
            C hierarchicalParentColumn = this.getHierarchicalParentColumn();
            if (hierarchicalParentColumn != null) {
                parentName.append(((Column)hierarchicalParentColumn).getSanitizedName());
                parentName.append(" : ");
            }
            parentName.append(this.getSanitizedName());
            return parentName.toString();
        }
        MappedHeaderDetails<Column> result = MappedHeaderDetails.make(this);
        List<String> hierarchyPrefix = result.hierarchyPrefix();
        if (hierarchyPrefix == null || hierarchyPrefix.isEmpty()) {
            return this.getSanitizedName();
        }
        StringBuilder completeName = new StringBuilder();
        for (String l : hierarchyPrefix) {
            if (!completeName.isEmpty()) {
                completeName.append(": ");
            }
            completeName.append(l);
        }
        if (!completeName.isEmpty()) {
            completeName.append(": ");
        }
        completeName.append(this.getSanitizedName());
        return completeName.toString();
    }

    public int getDefaultPreferredWidth() {
        return this.mDefaultPreferredWidth;
    }

    public @NonNull Collection<@NonNull C> getDerivedFromColumns() {
        return this.derivedFrom;
    }

    public HeaderCell<C> getHeaderCell() {
        return this.mHeaderCell;
    }

    public @NonNull List<@NonNull C> getHierarchicalChildColumns() {
        return Collections.emptyList();
    }

    public @Nullable C getHierarchicalParentColumn() {
        return null;
    }

    public Image getIcon() {
        return this.mIcon;
    }

    public int getID() {
        return this.mID;
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public Point getPreferredHeaderSize() {
        return this.getHeaderCell().getPreferredSize(null, this.thisC());
    }

    public int getPreferredWidth(Outline<C> outline) {
        int prefWidth = this.mPreferredWidth < 1 ? this.mDefaultPreferredWidth : this.mPreferredWidth;
        int desiredWidth = Math.max(this.getPreferredHeaderSize().x, prefWidth);
        if (prefWidth < 1) {
            OutlineModel<C> model = outline.getModel();
            for (Row<C> row : model.getRows()) {
                int indentWidth = model.getIndentWidth(row, this.thisC());
                int width = this.getRowCell(row).getPreferredSize(row, this.thisC()).x + indentWidth;
                if (width <= desiredWidth) continue;
                if (this.mMaxWidth > 0 && this.mMaxWidth < width) {
                    width = this.mMaxWidth;
                    break;
                }
                desiredWidth = width;
            }
        }
        return desiredWidth;
    }

    public @NonNull Collection<@NonNull C> getRequredByColumns() {
        return this.requiredBy;
    }

    public ICell<C> getRowCell(Row<C> row) {
        return this.mRowCell;
    }

    public @NonNull String getSanitizedName() {
        return this.mName.replaceAll("\n", SPACE);
    }

    public int getSortSequence() {
        return this.getHeaderCell().getSortSequence();
    }

    public String getToolTipText() {
        return this.mToolTipText;
    }

    public Object getUserRef() {
        return this.mUserRef;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public boolean isComponentOfParent() {
        return this.componentOfParent;
    }

    public boolean isHiddenFromExport() {
        return this.isHiddenFromExport;
    }

    public boolean isHiddenFromUi() {
        return this.isHiddenFromUi;
    }

    public boolean isPrimary() {
        return this.mPrimary;
    }

    public boolean isSortAscending() {
        return this.getHeaderCell().isSortAscending();
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setDefaultPreferredWidth(int width) {
        this.mDefaultPreferredWidth = width;
    }

    public void setDerivedFromColumns(@NonNull Collection<@NonNull C> derivedColumns) {
        this.derivedFrom = derivedColumns;
    }

    public void setHeaderCell(HeaderCell<C> cell) {
        this.mHeaderCell = cell;
        this.mHeaderCell.setMinimumContentWidth(this.mRowCell.getMinimumContentWidth());
    }

    public void setIcon(Image icon) {
        this.mIcon = icon;
    }

    public void setID(int id) {
        this.mID = id;
    }

    public void setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    public void setName(String name) {
        this.mName = name == null || name.length() == 0 ? SPACE : name;
    }

    public void setNoMaxWidth() {
        this.mMaxWidth = -1;
    }

    public void setPreferredWidth(int width) {
        this.mPreferredWidth = width;
    }

    public void setPrimary(boolean primary) {
        this.mPrimary = primary;
    }

    public void setRequredByColumns(@NonNull Collection<@NonNull C> requiredColumns) {
        this.requiredBy = requiredColumns;
    }

    public void setRowCell(ICell<C> cell) {
        this.mRowCell = cell;
    }

    public void setSortCriteria(int sequence, boolean ascending) {
        this.getHeaderCell().setSortCriteria(sequence, ascending);
    }

    public void setToolTipText(String text) {
        this.mToolTipText = text;
    }

    public void setUserRef(Object userRef) {
        this.mUserRef = userRef;
    }

    public void setVisible(boolean visible) {
        this.mVisible = (visible || this.mPrimary) && !this.isHiddenFromUi;
    }

    public void setWidth(int width) {
        int minWidth = this.getPreferredHeaderSize().x;
        if (width < minWidth && width != -1) {
            width = minWidth;
        }
        this.mWidth = width;
    }

    public String toString() {
        return this.mName;
    }

    private @NonNull C thisC() {
        return (C)this;
    }

    public boolean isUseClusterLabel() {
        return this.useClusterLabel;
    }

    public @NonNull String getName() {
        C parent = this.getHierarchicalParentColumn();
        String name = ((String)NullChecking.neverNullOr((Object)this.mName, (Object)"")).strip();
        if (parent == null) {
            ColumnStructureProperties properties = this.getColumnStructureProperties();
            if (properties == null || !this.useClusterLabel || properties.clusterLabel.isBlank()) {
                return name;
            }
            if (name.isBlank()) {
                return properties.clusterLabel.strip();
            }
            return String.format("%s\n%s", properties.clusterLabel.strip(), name);
        }
        String parentName = ((Column)parent).getName();
        if (parentName.isBlank()) {
            return name;
        }
        if (name.isBlank()) {
            return parentName;
        }
        return String.format("%s\n%s", parentName, name);
    }
}

