/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.Colors;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class BoxCell {
    public static final @NonNull RGB BOX_BACKGROUND = new RGB(248, 248, 248);
    public static final @NonNull RGB BOX_BORDER = new RGB(176, 176, 192);

    public static @NonNull Rectangle getBoxBounds(Rectangle bounds) {
        return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
    }

    public static void drawBoxAround(GC gc, Rectangle bounds, @NonNull Predicate<@NonNull Rectangle> drawInner) {
        Rectangle innerBounds;
        @NonNull Rectangle boxBounds = BoxCell.getBoxBounds(bounds);
        if (boxBounds.width > 2 && boxBounds.height > 2 && drawInner.test(innerBounds = new Rectangle(boxBounds.x + 1, boxBounds.y + 1, boxBounds.width - 2, boxBounds.height - 2))) {
            gc.setBackground(Colors.create(BOX_BACKGROUND));
            gc.setForeground(Colors.create(BOX_BORDER));
            gc.drawRectangle(boxBounds.x, boxBounds.y, boxBounds.width - 1, boxBounds.height - 1);
        }
    }

    public static void drawBorderAround(Rectangle bounds, @NonNull Consumer<@NonNull Rectangle> drawInner) {
        if (bounds.width > 2 && bounds.height > 2) {
            @NonNull Rectangle innerBounds = new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            drawInner.accept(innerBounds);
        }
    }
}

