/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import com.arm.streamline.widget.lightweight.outline.IBlockCell;
import com.arm.streamline.widget.lightweight.outline.IBlockCellMouseHandler;
import com.arm.streamline.widget.lightweight.outline.IBlockColumnCompareType;
import com.arm.streamline.widget.lightweight.outline.IBlockLinkProvider;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;

public class BlockTextCell
implements IBlockCell,
IBlockCellMouseHandler {
    public static final int H_MARGIN = 4;
    public static final int V_MARGIN = 1;
    private int mHAlignment;
    private int mIconHAlignment = 16384;
    private int mVAlignment;
    private IBlockColumnCompareType mCompareType;
    private int mTruncationType;
    private IBlockLinkProvider mLinkProvider;
    private boolean mLinkPressed;
    private BlockRow mLinkRow;
    private BlockColumn mLinkColumn;
    private URL mCurrentLink;
    private String mBrowserViewId = "com.arm.eclipse.toolkit.link";

    public BlockTextCell() {
        this(-1, -1, IBlockColumnCompareType.TEXT);
    }

    public BlockTextCell(int alignment) {
        this(alignment, -1, IBlockColumnCompareType.TEXT);
    }

    public BlockTextCell(int alignment, IBlockColumnCompareType compareType) {
        this(alignment, -1, compareType);
    }

    public BlockTextCell(int hAlignment, int vAlignment, IBlockColumnCompareType compareType) {
        this.setCompareType(compareType);
        this.setHAlignment(hAlignment);
        this.setVAlignment(vAlignment);
        this.mTruncationType = 131072;
    }

    @Override
    public int compare(BlockColumn column, BlockRow one, BlockRow two) {
        return this.mCompareType.compare(column, one, two);
    }

    public void drawBackground(GC gc, Rectangle bounds, BlockRow row, BlockColumn column, boolean selected, boolean active, Device device) {
        Color bg = this.getBackgroundColor(device, selected, active, row, column);
        if (bg != null) {
            gc.setBackground(bg);
            gc.fillRectangle(bounds);
        }
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, BlockRow row, BlockColumn column, boolean selected, boolean active) {
        Device device = gc.getDevice();
        this.drawBackground(gc, bounds, row, column, selected, active, device);
        int vAlignment = this.getVAlignment();
        int hAlignment = this.getHAlignment();
        int iconHAlignment = this.getIconHAlignment();
        Font savedFont = gc.getFont();
        Font font = this.getFont(row, column);
        FontInfo fontInfo = FontInfo.get(font);
        gc.setFont(font);
        Image icon = row == null ? column.getIcon() : row.getImage(column);
        Rectangle imageBounds = this.getDesiredImageBoundsWithGap(icon);
        int cellWidth = bounds.width - (4 + imageBounds.width + 4);
        int cellHeight = bounds.height - 2;
        int x = bounds.x + 4;
        int y = bounds.y + 1;
        String text = TextDrawing.truncateText(gc, this.getData(row, column, false), cellWidth, this.mTruncationType);
        Point textSize = gc.textExtent(text);
        if (vAlignment != 128) {
            int yDelta = cellHeight - textSize.y;
            if (vAlignment == 0x1000000) {
                yDelta /= 2;
            }
            y += yDelta;
        }
        textSize.x += imageBounds.width;
        if (hAlignment == 16384) {
            if (iconHAlignment == 16384) {
                x += imageBounds.width;
            }
        } else {
            int hDelta = cellWidth - textSize.x;
            if (hAlignment == 0x1000000) {
                hDelta /= 2;
            }
            x += hDelta;
        }
        gc.setForeground(this.getForegroundColor(device, selected, active, row, column));
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
        int lineHeight = fontInfo.getHeight();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("\n".equals(token)) {
                y += lineHeight;
                continue;
            }
            int tx = bounds.x + 4;
            if (hAlignment == 16384) {
                if (iconHAlignment == 16384) {
                    tx += imageBounds.width;
                }
            } else {
                int hDelta = cellWidth - gc.stringExtent((String)token).x;
                if (hAlignment == 0x1000000) {
                    hDelta /= 2;
                }
                tx += hDelta;
            }
            TextDrawing.drawString(gc, token, tx, y, 16384);
            if (this.mLinkProvider == null || !this.mLinkProvider.hasLink(row, column)) continue;
            int yy = y + 1 + fontInfo.getLeading() + fontInfo.getAscent();
            gc.drawLine(tx, yy, tx + gc.stringExtent((String)token).x, yy);
        }
        gc.setFont(savedFont);
        if (icon != null) {
            int iy = bounds.y + 1;
            if (vAlignment != 128) {
                int ivDelta = cellHeight - imageBounds.height;
                if (vAlignment == 0x1000000) {
                    ivDelta /= 2;
                }
                iy += ivDelta;
            }
            x = iconHAlignment == 16384 ? (x -= imageBounds.width) : (x += textSize.x + this.getIconGap() - imageBounds.width);
            gc.drawImage(icon, x, iy);
        }
    }

    public Color getBackgroundColor(Device device, boolean selected, boolean active, BlockRow row, BlockColumn column) {
        return null;
    }

    public String getBrowserViewId() {
        return this.mBrowserViewId;
    }

    public IBlockColumnCompareType getCompareType() {
        return this.mCompareType;
    }

    public Font getFont() {
        return Fonts.getNormal();
    }

    public Font getFont(BlockRow row, BlockColumn column) {
        return this.getFont();
    }

    public Color getForegroundColor(Device device, boolean selected, boolean active, BlockRow row, BlockColumn column) {
        if (!selected && this.mLinkProvider != null && this.mLinkProvider.hasLink(row, column)) {
            return this.mLinkPressed && row == this.mLinkRow && column == this.mLinkColumn ? Colors.getLinkPressed() : Colors.getLink();
        }
        return Colors.getText(selected && active);
    }

    public int getHAlignment() {
        return this.mHAlignment;
    }

    public int getIconGap() {
        return 4;
    }

    public int getIconHAlignment() {
        return this.mIconHAlignment;
    }

    public IBlockLinkProvider getLinkProvider() {
        return this.mLinkProvider;
    }

    @Override
    public int getMinimumContentWidth() {
        return 0;
    }

    @Override
    public Point getPreferredSize(GC gc, BlockRow row, BlockColumn column) {
        Point size;
        String data = this.getData(row, column, true);
        if (data != null) {
            gc.setFont(this.getFont(row, column));
            size = gc.textExtent(data);
        } else {
            size = new Point(0, 0);
        }
        Rectangle bounds = this.getDesiredImageBoundsWithGap(row == null ? column.getIcon() : row.getImage(column));
        size.x += bounds.width;
        if (size.y < bounds.height) {
            size.y = bounds.height;
        }
        size.x += 8;
        size.y += 2;
        return size;
    }

    public Rectangle getTextAreaBounds(Rectangle cellBounds, BlockRow row, BlockColumn column) {
        Image icon;
        Image image = icon = row == null ? column.getIcon() : row.getImage(column);
        if (icon == null) {
            return cellBounds;
        }
        int iconWidth = icon.getBounds().width + this.getIconGap();
        int width = cellBounds.width - iconWidth;
        int x = cellBounds.x;
        int iconHAlignment = this.getIconHAlignment();
        if (iconHAlignment == 16384) {
            x += iconWidth;
        }
        Rectangle out = new Rectangle(x, cellBounds.y, width, cellBounds.height);
        return out;
    }

    @Override
    public String getToolTipText(BlockOutline outline, BlockRow row, BlockColumn column) {
        String tooltip;
        int width = column.getWidth() - 8;
        if (row != null) {
            BlockOutlineModel model;
            Image icon = row.getImage(column);
            if (icon != null) {
                width -= icon.getBounds().width;
            }
            if ((model = row.getOwner()).showIndent() && column.isPrimary()) {
                width -= model.getIndentWidth(row, column);
            }
            String data = this.getData(row, column, false);
            String text = TextDrawing.truncateText(this.getFont(row, column), data, width, this.mTruncationType);
            tooltip = text.equals(data) ? row.getToolTipText(column) : row.getToolTipTextWhenTruncated(column);
        } else {
            tooltip = column.getToolTipText();
        }
        return tooltip;
    }

    public int getTruncationType() {
        return this.mTruncationType;
    }

    public int getVAlignment() {
        return this.mVAlignment;
    }

    @Override
    public boolean handleCellMouseDoubleClick(BlockOutline outline, Point where, int stateMask, int button, BlockRow row, BlockColumn column) {
        return false;
    }

    @Override
    public boolean handleCellMouseDown(BlockOutline outline, Point where, int stateMask, int button, BlockRow row, BlockColumn column) {
        if (button == 1 && this.mLinkProvider != null && this.mLinkProvider.hasLink(row, column) && this.getLinkBounds(outline, row, column).contains(where)) {
            try {
                this.mCurrentLink = this.mLinkProvider.getLink(row, column);
                if (this.mCurrentLink != null) {
                    this.mLinkRow = row;
                    this.mLinkColumn = column;
                    this.mLinkPressed = true;
                    outline.repaint();
                    return true;
                }
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        return false;
    }

    @Override
    public boolean handleCellMouseMove(BlockOutline outline, Point where, int stateMask) {
        if (this.mCurrentLink != null) {
            boolean wasPressed = this.mLinkPressed;
            this.mLinkPressed = this.getLinkBounds(outline, this.mLinkRow, this.mLinkColumn).contains(where);
            if (wasPressed != this.mLinkPressed) {
                outline.repaint();
            }
        }
        return true;
    }

    @Override
    public void handleCellMouseUp(BlockOutline outline, Point where, int stateMask) {
        if (this.mCurrentLink != null && this.getLinkBounds(outline, this.mLinkRow, this.mLinkColumn).contains(where)) {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser(this.mBrowserViewId).openURL(this.mCurrentLink);
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        if (this.mLinkPressed) {
            this.mLinkPressed = false;
            this.mLinkRow = null;
            this.mLinkColumn = null;
            outline.repaint();
        }
    }

    public void setBrowserViewId(String id) {
        this.mBrowserViewId = id;
    }

    public void setCompareType(IBlockColumnCompareType compareType) {
        this.mCompareType = compareType;
    }

    public void setHAlignment(int alignment) {
        this.mHAlignment = alignment == -1 ? 16384 : alignment;
    }

    public void setIconHAlignment(int alignment) {
        this.mIconHAlignment = alignment == -1 ? 16384 : alignment;
    }

    public void setLinkProvider(IBlockLinkProvider linkProvider) {
        this.mLinkProvider = linkProvider;
    }

    public void setTruncationType(int truncationType) {
        this.mTruncationType = truncationType;
    }

    public void setVAlignment(int alignment) {
        this.mVAlignment = alignment == -1 ? 0x1000000 : alignment;
    }

    protected String getData(BlockRow row, BlockColumn column, boolean nullOK) {
        if (row != null) {
            String text = row.getDataAsText(column);
            if (text == null && !nullOK) {
                text = "";
            }
            return text;
        }
        return column.toString();
    }

    protected Rectangle getDesiredImageBoundsWithGap(Image image) {
        if (image != null) {
            Rectangle bounds = image.getBounds();
            bounds.width += this.getIconGap();
            return bounds;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private Rectangle getLinkBounds(BlockOutline outline, BlockRow row, BlockColumn column) {
        int width = FontInfo.get(this.getFont(row, column)).getWidth(this.getData(row, column, false));
        Rectangle bounds = this.getTextAreaBounds(outline.getAdjustedCellBounds(row, column), row, column);
        if (bounds.width > width) {
            bounds.width = width;
        }
        return bounds;
    }
}

