/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.Geometry;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.DragTracker;
import com.arm.streamline.widget.lightweight.IScrollableBlock;
import com.arm.streamline.widget.lightweight.outline.BlockCellEditor;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockColumnResizeTracker;
import com.arm.streamline.widget.lightweight.outline.BlockHeader;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineMessages;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import com.arm.streamline.widget.lightweight.outline.IBlockCell;
import com.arm.streamline.widget.lightweight.outline.IBlockCellMouseHandler;
import com.arm.streamline.widget.lightweight.outline.IBlockOutlineListener;
import com.arm.streamline.widget.lightweight.outline.IBlockOutlineModelListener;
import com.arm.streamline.widget.selection.ReadOnlyStdSelection;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.text.BasicNumberUtils;
import com.arm.utils.text.SWTLabelFilter;
import gnu.trove.list.array.TIntArrayList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.ActionFactory;

public class BlockOutline
extends Block
implements ISelectionProvider,
IBlockOutlineModelListener,
IScrollableBlock {
    private static final int MORE_H_MARGIN = 4;
    private static final int MORE_V_MARGIN = 0;
    private static final int MORE_OFFSET = 4;
    private static final int DIVIDER_SLOP = 5;
    private static final int CONFIG_VERSION = 1;
    private static final String CONFIG_MARKER = "OutlineConfig";
    private List<IBlockOutlineListener> mListeners = new ArrayList<IBlockOutlineListener>();
    private Set<ISelectionChangedListener> mSelectionListeners = new HashSet<ISelectionChangedListener>();
    private Rectangle mMoreUpArea = new Rectangle(0, 0, 0, 0);
    private Rectangle mMoreDownArea = new Rectangle(0, 0, 0, 0);
    private BlockOutlineModel mModel;
    private BlockHeader mHeader;
    private String mDefaultConfig;
    private DragTracker mTracker;
    private boolean mShowColumnLines = true;
    private boolean mAllowColumnResize = true;
    private boolean mPermitDragSelect = true;
    private boolean mAdjustPending;
    private boolean mAllowLazyAdjust = true;
    private BlockCellEditor mEditor;
    private boolean mCanEdit;
    private BlockRow mDropParentRow;
    private int mDropChildInsertIndex = -1;
    private boolean mColumnFill;
    private boolean mDropHighlight;
    private boolean mAllowScrollOnSelect = true;

    public BlockOutline(BlockOutlineModel model, boolean showIndent) {
        this.setBackgroundColor(Colors.getListBackground());
        this.setFocusable(true);
        this.mModel = model;
        this.mModel.setShowIndent(showIndent);
        this.mModel.setIndentWidth(15);
        this.mModel.addListener(this);
    }

    public void addOutlineListener(IBlockOutlineListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionListeners.add(listener);
    }

    public void adjust() {
        this.sizeColumnsToFit();
        this.notifyOfSelectionChange();
    }

    public boolean allowLazyAdjust() {
        return this.mAllowLazyAdjust;
    }

    public void applyConfig(String config, boolean sortOnly, boolean forcePreferredWidth) {
        if (config != null && config.startsWith(CONFIG_MARKER)) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(config, "\t");
                if (BasicNumberUtils.getNonLocalizedInteger((String)tokenizer.nextToken().substring(CONFIG_MARKER.length()), (int)0) == 1) {
                    int count = BasicNumberUtils.getNonLocalizedInteger((String)tokenizer.nextToken(), (int)0);
                    boolean needSort = false;
                    boolean sortWasCleared = this.mModel.clearSortWithoutNotify();
                    int i = 0;
                    while (i < count) {
                        BlockColumn column = this.mModel.getColumnWithID(BasicNumberUtils.getNonLocalizedInteger((String)tokenizer.nextToken(), (int)0));
                        if (column == null) {
                            throw new Exception();
                        }
                        this.mModel.removeColumn(column);
                        this.mModel.addColumn(i, column);
                        if (sortOnly) {
                            tokenizer.nextToken();
                            tokenizer.nextToken();
                        } else {
                            column.setVisible(BasicNumberUtils.getBoolean((String)tokenizer.nextToken()));
                            if (forcePreferredWidth) {
                                tokenizer.nextToken();
                                column.setPreferredWidth(column.getDefaultPreferredWidth());
                                column.setWidth(this, column.getPreferredWidth(this));
                            } else {
                                column.setWidth(this, BasicNumberUtils.getNonLocalizedInteger((String)tokenizer.nextToken(), (int)column.getWidth()));
                            }
                        }
                        column.setSortCriteria(BasicNumberUtils.getNonLocalizedInteger((String)tokenizer.nextToken(), (int)-1), BasicNumberUtils.getBoolean((String)tokenizer.nextToken()));
                        if (column.getSortSequence() != -1) {
                            needSort = true;
                        }
                        ++i;
                    }
                    if (needSort) {
                        this.mModel.sort();
                    } else if (sortWasCleared) {
                        this.mModel.notifyOfSortCleared();
                    }
                    this.lazyAdjust();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean areUnselectedRowsClosable() {
        Set<BlockRow> exclude = this.getSelectedRowExclusionSet();
        for (BlockRow row : this.mModel.getTopLevelRows()) {
            if (!this.hasOpenState(row, exclude)) continue;
            return true;
        }
        return false;
    }

    public boolean areUnselectedRowsOpenable() {
        Set<BlockRow> exclude = this.getSelectedRowExclusionSet();
        for (BlockRow row : this.mModel.getTopLevelRows()) {
            if (!this.hasClosedState(row, exclude)) continue;
            return true;
        }
        return false;
    }

    public boolean canEdit() {
        return this.mCanEdit;
    }

    public void clearInsertionMarker() {
        BlockRow row = this.mDropParentRow;
        int index = this.mDropChildInsertIndex;
        this.mDropParentRow = null;
        this.mDropChildInsertIndex = -1;
        if (index != -1) {
            this.repaint(this.getDragRowInsertionMarkerBounds(row, index));
        }
    }

    public void closeAllRows() {
        this.prepareForRowStateChange();
        try {
            for (BlockRow row : this.mModel.getTopLevelRows()) {
                this.setOpenRecursively(row, false);
            }
        }
        finally {
            this.finishRowStateChange();
        }
    }

    public void closeSelectedRows(boolean all) {
        this.prepareForRowStateChange();
        try {
            if (all) {
                for (BlockRow row : this.mModel.getSelectionAsList(true)) {
                    this.setOpenRecursively(row, false);
                }
            } else {
                for (BlockRow row : this.mModel.getSelectionAsList(false)) {
                    row.setOpen(false);
                }
            }
        }
        finally {
            this.finishRowStateChange();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void closeUnselectedRows() {
        selection = this.mModel.getSelectionAsList();
        openRows = new ArrayList<BlockRow>();
        for (BlockRow row : this.mModel.getSelectionAsList()) {
            if (!row.canHaveChildren() || !row.isOpen()) continue;
            openRows.add(row);
        }
        this.prepareForRowStateChange();
        try {
            for (BlockRow row : this.mModel.getTopLevelRows()) {
                this.setOpenRecursively(row, false);
            }
        }
        finally {
            ** for (row : selection)
        }
lbl-1000:
        // 1 sources

        {
            row.disclose();
            continue;
        }
lbl18:
        // 2 sources

        for (BlockRow row : openRows) {
            row.setOpen(true);
        }
        this.finishRowStateChange();
        Task.callOnUIThread((Runnable)new Runnable(selection){
            private final /* synthetic */ List val$selection;
            {
                this.val$selection = list;
            }

            @Override
            public void run() {
                BlockOutline.this.getModel().select(this.val$selection, false);
                BlockOutline.this.scrollSelectionIntoView(true);
            }
        });
    }

    public void copy() {
        List<BlockColumn> columns = this.mModel.getColumns();
        StringBuilder buffer = new StringBuilder();
        for (BlockRow row : this.mModel.getSelectionAsList()) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            boolean needTab = false;
            for (BlockColumn column : columns) {
                if (!column.isVisible()) continue;
                if (needTab) {
                    buffer.append('\t');
                } else {
                    needTab = true;
                }
                buffer.append(row.getDataAsText(column));
            }
        }
        if (buffer.length() > 0) {
            Clipboard clipboard = new Clipboard(this.getDisplay());
            clipboard.setContents(new Object[]{buffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    @Override
    public final void focusGained(boolean fromKeyboard) {
        super.focusGained(fromKeyboard);
        this.setEditor(null);
    }

    public Rectangle getAdjustedCellBounds(BlockRow row, BlockColumn column) {
        Rectangle bounds = this.getCellBounds(row, column);
        if (column.isPrimary()) {
            int indent = this.mModel.getIndentWidth(row, column);
            bounds.x += indent;
            bounds.width -= indent;
            if (bounds.width < 1) {
                bounds.width = 1;
            }
        }
        return bounds;
    }

    public Color getBackground(int rowIndex, boolean selected, boolean active) {
        Color color = this.mModel.getRowAtIndex(rowIndex).getBackgroundColor((Device)this.getDisplay(), selected, active);
        if (color != null) {
            return color;
        }
        if (selected) {
            return Colors.getSelection(active);
        }
        return this.getBackgroundBandingColor(rowIndex);
    }

    public Color getBackgroundBandingColor(int rowIndex) {
        return rowIndex % 2 == 0 ? Colors.getPrimaryBanding() : Colors.getSecondaryBanding();
    }

    public IBlockCell getCellAt(int x, int y) {
        BlockRow row;
        BlockColumn column = this.overColumn(x);
        if (column != null && (row = this.overRow(y)) != null) {
            return column.getRowCell(row);
        }
        return null;
    }

    public IBlockCell getCellAt(Point viewPt) {
        return this.getCellAt(viewPt.x, viewPt.y);
    }

    public Rectangle getCellBounds(BlockRow row, BlockColumn column) {
        Rectangle bounds = this.getRowBounds(row);
        bounds.x = this.getColumnStart(column);
        bounds.width = this.getColumnWidth(column);
        return bounds;
    }

    public Color getColumnDividerColor(int columnID) {
        return Colors.getOutlineDivider();
    }

    public int getColumnIndexStart(int columnIndex) {
        int pos = 0;
        int i = 0;
        while (i < columnIndex) {
            BlockColumn column = this.mModel.getColumnAtIndex(i);
            if (column.isVisible()) {
                pos += this.getColumnWidth(column) + (this.mShowColumnLines ? 1 : 0);
            }
            ++i;
        }
        return pos;
    }

    public int getColumnStart(BlockColumn column) {
        int pos = 0;
        int count = this.mModel.getColumnCount();
        int i = 0;
        while (i < count) {
            BlockColumn col = this.mModel.getColumnAtIndex(i);
            if (col == column) break;
            if (col.isVisible()) {
                pos += this.getColumnWidth(col) + (this.mShowColumnLines ? 1 : 0);
            }
            ++i;
        }
        return pos;
    }

    public int getColumnWidth(BlockColumn column) {
        int total;
        int width = column.getWidth();
        if (this.mColumnFill && (total = this.getViewPortBounds().width) > width) {
            width = total;
        }
        return width;
    }

    public String getConfig() {
        StringBuilder buffer = new StringBuilder();
        int count = this.mModel.getColumnCount();
        buffer.append(CONFIG_MARKER);
        buffer.append(1);
        buffer.append('\t');
        buffer.append(count);
        int i = 0;
        while (i < count) {
            BlockColumn column = this.mModel.getColumnAtIndex(i);
            buffer.append('\t');
            buffer.append(column.getID());
            buffer.append('\t');
            buffer.append(column.isVisible());
            buffer.append('\t');
            buffer.append(column.getWidth());
            buffer.append('\t');
            buffer.append(column.getSortSequence());
            buffer.append('\t');
            buffer.append(column.isSortAscending());
            ++i;
        }
        return buffer.toString();
    }

    public String getDefaultConfig() {
        if (this.mDefaultConfig == null) {
            this.mDefaultConfig = this.getConfig();
        }
        return this.mDefaultConfig;
    }

    public Image getDisclosureControl(BlockRow row) {
        return StreamlinePlugin.getImage(row.isOpen() ? "Collapse.gif" : "Expand.gif");
    }

    public BlockCellEditor getEditor() {
        return this.mEditor;
    }

    public BlockHeader getHeader() {
        return this.mHeader;
    }

    @Override
    public int getHorizontalIncrement() {
        return 16;
    }

    public BlockOutlineModel getModel() {
        return this.mModel;
    }

    @Override
    public Point getPreferredSize(int widthHint, int heightHint) {
        Point size = new Point(0, this.mModel.getRowCount());
        List<BlockColumn> columns = this.mModel.getColumns();
        for (BlockColumn col : columns) {
            int width = col.getWidth();
            if (width == -1) {
                width = col.getPreferredWidth(this);
                col.setWidth(this, width);
            }
            if (!col.isVisible()) continue;
            size.x = size.x + (width + (this.mShowColumnLines ? 1 : 0));
        }
        if (size.x < 0) {
            size.x = 0;
        }
        if (size.y > 0) {
            int extra = size.y;
            int height = this.mModel.getRowHeight();
            if (height == 0) {
                height = this.mModel.getRowAtIndex(0).getPreferredHeight(this, columns);
                this.mModel.setRowHeight(height);
            }
            size.y *= height;
            size.y += extra;
        }
        if (size.y < 0) {
            size.y = 0;
        }
        return size;
    }

    public Rectangle getRowBounds(BlockRow row) {
        Rectangle bounds = this.getLocalBounds();
        bounds.y = this.getRowStart(row);
        bounds.height = this.mModel.getRowHeight();
        return bounds;
    }

    public Color getRowDividerColor(int rowIndex) {
        return Colors.getOutlineDivider();
    }

    public Rectangle getRowIndexBounds(int rowIndex) {
        Rectangle bounds = this.getLocalBounds();
        bounds.y = this.getRowIndexStart(rowIndex);
        bounds.height = this.mModel.getRowHeight();
        return bounds;
    }

    public int getRowIndexStart(int index) {
        return index * (this.mModel.getRowHeight() + 1);
    }

    public final int getRowPageSize() {
        return Math.max(1, this.getViewPortBounds().height / (this.mModel.getRowHeight() + 1) - 2);
    }

    public int getRowStart(BlockRow row) {
        return this.getRowIndexStart(this.mModel.getRows().indexOf(row));
    }

    public IStructuredSelection getSelection() {
        return new ReadOnlyStdSelection(this.mModel.getSelection());
    }

    public String getSelectionAsText() {
        String lineSeperator = System.getProperty("line.separator");
        List<BlockColumn> columns = this.mModel.getColumns();
        StringBuilder buffer = new StringBuilder();
        for (BlockRow row : this.mModel.getSelectionAsList(false)) {
            boolean needTab = false;
            for (BlockColumn column : columns) {
                if (!column.isVisible()) continue;
                if (needTab) {
                    buffer.append('\t');
                } else {
                    needTab = true;
                }
                String text = row.getDataAsText(column);
                if (text == null) continue;
                buffer.append(text);
            }
            buffer.append(lineSeperator);
        }
        return buffer.toString();
    }

    @Override
    public int getVerticalIncrement() {
        int rowHeight = this.mModel.getRowHeight();
        return rowHeight > 0 ? rowHeight : 16;
    }

    public boolean hasDropHighlight() {
        return this.mDropHighlight;
    }

    public boolean isColumnFill() {
        return this.mColumnFill;
    }

    public boolean isColumnResizeAllowed() {
        return this.mAllowColumnResize;
    }

    public boolean isDragSelectedPermitted() {
        return this.mPermitDragSelect;
    }

    public void lazyAdjust() {
        if (this.mAllowLazyAdjust && !this.mAdjustPending) {
            this.mAdjustPending = true;
            Task.scheduleOnUIThread(() -> {
                this.mAdjustPending = false;
                this.adjust();
            });
        }
    }

    public void notifyOfSelectionChange() {
        IBlockOutlineListener[] iBlockOutlineListenerArray = this.getCurrentOutlineListeners();
        int n = iBlockOutlineListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBlockOutlineListener listener = iBlockOutlineListenerArray[n2];
            listener.selectionChanged(this);
            ++n2;
        }
        if (!this.mSelectionListeners.isEmpty()) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getSelection());
            for (ISelectionChangedListener listener : new ArrayList<ISelectionChangedListener>(this.mSelectionListeners)) {
                listener.selectionChanged(event);
            }
        }
    }

    @Override
    public boolean obeyCommand(CommandAction action) {
        String command = action.getCommand();
        if (command.equals(ActionFactory.SELECT_ALL.getId())) {
            this.mModel.select();
            return true;
        }
        if (command.equals(ActionFactory.COPY.getId())) {
            this.copy();
            return true;
        }
        return super.obeyCommand(action);
    }

    public void openAllRows() {
        this.prepareForRowStateChange();
        this.mModel.setAccumulateRowOpens(true);
        try {
            for (BlockRow row : this.mModel.getTopLevelRows()) {
                this.setOpenRecursively(row, true);
            }
        }
        finally {
            this.mModel.setAccumulateRowOpens(false);
            this.finishRowStateChange();
        }
    }

    public void openSelectedRows(boolean all) {
        this.prepareForRowStateChange();
        if (all) {
            this.mModel.setAccumulateRowOpens(true);
        }
        try {
            if (all) {
                for (BlockRow row : this.mModel.getSelectionAsList(true)) {
                    this.setOpenRecursively(row, true);
                }
            } else {
                for (BlockRow row : this.mModel.getSelectionAsList(false)) {
                    row.setOpen(true);
                }
            }
        }
        finally {
            if (all) {
                this.mModel.setAccumulateRowOpens(false);
            }
            this.finishRowStateChange();
        }
    }

    public void openUnselectedRows() {
        Set<BlockRow> exclude = this.getSelectedRowExclusionSet();
        this.prepareForRowStateChange();
        try {
            for (BlockRow row : this.mModel.getTopLevelRows()) {
                this.open(row, exclude);
            }
        }
        finally {
            this.finishRowStateChange();
        }
    }

    public BlockColumn overColumn(int x) {
        int pos = 0;
        int count = this.mModel.getColumnCount();
        int i = 0;
        while (i < count) {
            BlockColumn col = this.mModel.getColumnAtIndex(i);
            if (col.isVisible() && x < (pos += this.getColumnWidth(col) + (this.mShowColumnLines ? 1 : 0))) {
                return col;
            }
            ++i;
        }
        return null;
    }

    public int overColumnIndex(int x) {
        int pos = 0;
        int count = this.mModel.getColumnCount();
        int i = 0;
        while (i < count) {
            BlockColumn col = this.mModel.getColumnAtIndex(i);
            if (col.isVisible() && x < (pos += this.getColumnWidth(col) + (this.mShowColumnLines ? 1 : 0))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean overDisclosureControl(int x, int y, BlockColumn column, BlockRow row) {
        if (this.showIndent() && this.showOutline() && column != null && row != null && row.canHaveChildren() && column.isPrimary()) {
            int right = this.getCellBounds((BlockRow)row, (BlockColumn)column).x + this.mModel.getIndentWidth(row, column);
            int left = right - this.mModel.getIndentWidth();
            return x >= left && x <= right;
        }
        return false;
    }

    public BlockRow overRow(int y) {
        int which = this.overRowIndex(y);
        if (which != -1) {
            return this.mModel.getRowAtIndex(which);
        }
        return null;
    }

    public int overRowIndex(int y) {
        int which;
        if (y >= 0 && (which = y / (this.mModel.getRowHeight() + 1)) < this.mModel.getRowCount()) {
            return which;
        }
        return -1;
    }

    public void redrawAll() {
        this.repaint();
        this.redrawHeader();
    }

    public void redrawHeader() {
        if (this.mHeader != null) {
            this.mHeader.repaint();
        }
    }

    public void redrawRow(BlockRow row) {
        this.repaint(this.getRowBounds(row));
    }

    public void removeOutlineListener(IBlockOutlineListener listener) {
        this.mListeners.remove(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionListeners.remove(listener);
    }

    public void repaintSelection() {
        this.repaintSelectionInternal();
    }

    @Override
    public void rowsAdded(BlockOutlineModel model, BlockRow[] rows) {
        this.lazyAdjust();
    }

    @Override
    public void rowsWereRemoved(BlockOutlineModel model, BlockRow[] rows) {
        this.lazyAdjust();
    }

    @Override
    public void rowsWillBeRemoved(BlockOutlineModel model, BlockRow[] rows) {
    }

    public void scrollRowsIntoView(Collection<? extends BlockRow> rows, boolean verticalOnly) {
        Rectangle bounds = this.getLocalBounds();
        Rectangle showBounds = null;
        for (BlockRow blockRow : rows) {
            Rectangle rect = new Rectangle(bounds.x, this.getRowStart(blockRow), bounds.width, this.mModel.getRowHeight());
            if (showBounds == null) {
                showBounds = rect;
            } else {
                showBounds.add(rect);
            }
            if (rect.height > bounds.height) break;
        }
        if (showBounds != null && !showBounds.isEmpty()) {
            if (verticalOnly) {
                this.verticallyScrollIntoView(showBounds);
            } else {
                this.scrollIntoView(showBounds);
            }
        }
    }

    public void scrollRowsIntoView(int first, int last, boolean verticalOnly) {
        if (first >= 0 && first <= this.mModel.getRowCount() - 1) {
            Rectangle bounds = this.getRowIndexBounds(first);
            if (first != last) {
                bounds = Geometry.union(bounds, this.getRowIndexBounds(last));
            }
            if (verticalOnly) {
                this.verticallyScrollIntoView(bounds);
            } else {
                this.scrollIntoView(bounds);
            }
        }
    }

    public void scrollSelectionIntoView(boolean verticalOnly) {
        int first = this.mModel.getFirstSelectedRowIndex();
        if (first >= 0 && first <= this.mModel.getRowCount() - 1) {
            this.scrollSelectionIntoViewInternal(verticalOnly);
        }
    }

    @Override
    public void selectionDidChange(BlockOutlineModel model) {
        Rectangle bounds = this.repaintSelectionInternal();
        if (this.isScrollOnSelectAllowed() && !bounds.isEmpty() && this.hasFocus()) {
            boolean needScroll = true;
            Rectangle viewBounds = this.getViewPortBounds();
            StdSelection selection = model.getSelection();
            int row = this.overRowIndex(viewBounds.y + 5);
            if (row != -1 && selection.isSelected(row) && (row = this.overRowIndex(viewBounds.x + viewBounds.height - 5)) != -1) {
                boolean bl = needScroll = !selection.isSelected(row);
            }
            if (needScroll) {
                this.verticallyScrollIntoView(bounds);
            }
        }
        this.notifyOfSelectionChange();
    }

    @Override
    public void selectionWillChange(BlockOutlineModel model) {
        this.repaintSelectionInternal();
    }

    public void setAllowColumnResize(boolean allow) {
        this.mAllowColumnResize = allow;
    }

    public void setAllowLazyAdjust(boolean allowLazyAdjust) {
        this.mAllowLazyAdjust = allowLazyAdjust;
    }

    public void setCanEdit(boolean canEdit) {
        if (canEdit != this.mCanEdit) {
            this.setEditor(null);
            this.mCanEdit = canEdit;
        }
    }

    public void setColumnFill(boolean fill) {
        this.mColumnFill = fill;
    }

    public void setColumnOrder(List<BlockColumn> columns) {
        ArrayList<BlockColumn> list = new ArrayList<BlockColumn>(columns);
        List<BlockColumn> cols = this.mModel.getColumns();
        cols.removeAll(columns);
        list.addAll(cols);
        cols.clear();
        cols.addAll(list);
        this.redrawAll();
    }

    public void setDefaultConfig(String config) {
        this.mDefaultConfig = config;
    }

    public void setDropHighlight(boolean highlight) {
        if (this.mDropHighlight != highlight) {
            this.mDropHighlight = highlight;
            this.repaint();
        }
    }

    public void setEditor(BlockCellEditor editor) {
        if (this.mCanEdit) {
            boolean wasNull;
            boolean bl = wasNull = this.mEditor == null;
            if (!wasNull) {
                this.mEditor.dispose();
            }
            this.mEditor = editor;
            if (this.mEditor != null) {
                this.mModel.deselect();
                this.scrollIntoView(this.getCellBounds(this.mEditor.getRow(), this.mEditor.getColumn()));
                this.mEditor.adjustToOutline();
            }
            if (!wasNull || this.mEditor != null) {
                this.notifyOfEditorChange();
            }
        }
    }

    public void setHeader(BlockHeader header) {
        this.mHeader = header;
        if (header != null) {
            header.setOutline(this);
        }
    }

    public void setInsertionMarker(BlockRow parentRow, int childIndex) {
        BlockRow row = this.mDropParentRow;
        int index = this.mDropChildInsertIndex;
        this.mDropParentRow = parentRow;
        this.mDropChildInsertIndex = childIndex;
        if (index != -1) {
            this.repaint(this.getDragRowInsertionMarkerBounds(row, index));
        }
        if (this.mDropChildInsertIndex != -1) {
            this.repaint(this.getDragRowInsertionMarkerBounds(this.mDropParentRow, this.mDropChildInsertIndex));
        }
    }

    public void setPermitDragSelect(boolean permit) {
        this.mPermitDragSelect = permit;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof ReadOnlyStdSelection) {
            this.mModel.getSelection().select((ReadOnlyStdSelection)selection);
        }
    }

    public void setShowColumnLines(boolean show) {
        if (this.mShowColumnLines != show) {
            this.mShowColumnLines = show;
            this.repaint();
        }
    }

    public void setSort(BlockColumn column, boolean ascending, boolean add) {
        int count = this.mModel.getColumnCount();
        if (!add) {
            int i = 0;
            while (i < count) {
                BlockColumn col = this.mModel.getColumnAtIndex(i);
                if (column == col) {
                    col.setSortCriteria(0, ascending);
                } else {
                    col.setSortCriteria(-1, col.isSortAscending());
                }
                ++i;
            }
        } else if (column.getSortSequence() == -1) {
            int highest = -1;
            int i = 0;
            while (i < count) {
                int sortOrder = this.mModel.getColumnAtIndex(i).getSortSequence();
                if (sortOrder > highest) {
                    highest = sortOrder;
                }
                ++i;
            }
            column.setSortCriteria(highest + 1, ascending);
        } else {
            column.setSortCriteria(column.getSortSequence(), ascending);
        }
        this.mModel.sort();
    }

    public boolean showColumnLines() {
        return this.mShowColumnLines;
    }

    public boolean showIndent() {
        return this.mModel.showIndent();
    }

    public boolean showOutline() {
        return this.mModel.showOutline();
    }

    public void sizeColumnsToFit() {
        try {
            for (BlockColumn column : this.mModel.getColumns()) {
                int width;
                if (!column.isVisible() || (width = column.getPreferredWidth(this)) == column.getWidth()) continue;
                column.setWidth(this, width);
            }
        }
        finally {
            this.pack();
            this.redrawAll();
        }
    }

    @Override
    public void sortCleared(BlockOutlineModel model) {
        this.redrawHeader();
    }

    @Override
    public void sorted(BlockOutlineModel model, boolean restoring) {
        if (!restoring && this.hasFocus()) {
            this.scrollSelectionIntoView(true);
        }
        this.redrawAll();
    }

    protected void createContextMenuContent(Point where, Menu menu) {
        BlockOutlineModel model = this.getModel();
        StdSelection selection = model.getSelection();
        boolean needOpen = false;
        boolean needClose = false;
        int i = -1;
        while (!needOpen || !needClose) {
            if ((i = selection.nextSelectedIndex(i + 1)) == -1) break;
            BlockRow row = model.getRowAtIndex(i);
            if (!row.canHaveChildren()) continue;
            if (row.isOpen()) {
                needClose = true;
                continue;
            }
            needOpen = true;
        }
        if (needOpen || needClose) {
            MenuItem item;
            ContextMenu.createConditionalSeparator(menu);
            if (needOpen) {
                item = new MenuItem(menu, 8);
                item.setText(BlockOutlineMessages.OPEN);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        BlockOutline.this.openSelectedRows(true);
                    }
                });
            }
            if (needClose) {
                item = new MenuItem(menu, 8);
                item.setText(BlockOutlineMessages.CLOSE);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        BlockOutline.this.closeSelectedRows(true);
                    }
                });
            }
        }
    }

    protected void drawMore(GC gc, boolean up, int amt) {
        Rectangle viewBounds = this.getViewPortBounds();
        Image img = StreamlinePlugin.getImage(up ? StreamlineImages.UP_ARROW : StreamlineImages.DOWN_ARROW);
        Rectangle imgBounds = img.getBounds();
        Font font = Fonts.getSmall();
        gc.setFont(font);
        String text = MessageFormat.format(BlockOutlineMessages.MORE, NumberUtils.format((long)amt));
        FontInfo fontInfo = FontInfo.get(font);
        int fontHeight = fontInfo.getHeight();
        int w = 4 + fontInfo.getWidth(text) + 4 + imgBounds.width + 4;
        int x = viewBounds.x + viewBounds.width - (w + 4);
        int h = Math.max(imgBounds.height, fontHeight) + 0;
        int y = viewBounds.y + (up ? 4 : viewBounds.height - (h + 4));
        if (up) {
            this.mMoreUpArea.x = x;
            this.mMoreUpArea.y = y;
            this.mMoreUpArea.width = w + 1;
            this.mMoreUpArea.height = h + 1;
        } else {
            this.mMoreDownArea.x = x;
            this.mMoreDownArea.y = y;
            this.mMoreDownArea.width = w + 1;
            this.mMoreDownArea.height = h + 1;
        }
        gc.setBackground(Colors.getInfoBackground());
        gc.fillRectangle(x, y, w, h);
        gc.setForeground(Colors.getBlack());
        gc.drawRectangle(x, y, w, h);
        gc.setForeground(Colors.getInfoForeground());
        TextDrawing.drawString(gc, text, x + 4, y + 1 + (h - fontHeight) / 2, 16384);
        gc.drawImage(img, x + w - (imgBounds.width + 4), y + (h - imgBounds.height) / 2);
    }

    protected void drawRowBackground(GC gc, Rectangle bounds, BlockRow row, boolean selected, boolean active) {
        gc.setBackground(this.getBackground(this.mModel.getIndexOfRow(row), selected, active));
        gc.fillRectangle(bounds);
    }

    protected boolean isScrollOnSelectAllowed() {
        return this.mAllowScrollOnSelect;
    }

    @Override
    protected boolean keyPressed(int code, char ch, int location, int stateMask) {
        boolean shiftDown = (stateMask & 0x20000) != 0;
        switch (code) {
            case 0x1000003: {
                if (!this.showOutline()) break;
                this.closeSelectedRows(shiftDown);
                return true;
            }
            case 0x1000004: {
                if (!this.showOutline()) break;
                this.openSelectedRows(shiftDown);
                return true;
            }
            case 0x1000001: {
                this.keyScroll(this.mModel.getSelection().selectUp(shiftDown, false));
                return true;
            }
            case 0x1000002: {
                this.keyScroll(this.mModel.getSelection().selectDown(shiftDown, false));
                return true;
            }
            case 0x1000007: {
                this.keyScroll(this.mModel.getSelection().selectToHome(shiftDown));
                return true;
            }
            case 0x1000008: {
                this.keyScroll(this.mModel.getSelection().selectToEnd(shiftDown));
                return true;
            }
            case 0x1000005: {
                this.keyScroll(this.mModel.getSelection().selectToPageUp(this.getRowPageSize(), shiftDown));
                return true;
            }
            case 0x1000006: {
                this.keyScroll(this.mModel.getSelection().selectToPageDown(this.getRowPageSize(), shiftDown));
                return true;
            }
            case 10: 
            case 13: 
            case 0x1000050: {
                if (this.mModel.hasSelection()) {
                    this.notifyOfOpenSelectionRequest();
                }
                return true;
            }
            case 8: 
            case 127: {
                if (this.mModel.hasSelection()) {
                    this.notifyOfDeleteSelectionRequest();
                }
                return true;
            }
        }
        return false;
    }

    protected void keyScroll(int scrollTo) {
        if (scrollTo != -1) {
            this.verticallyScrollIntoView(this.getRowIndexBounds(scrollTo));
        }
    }

    @Override
    protected void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 3) {
            this.showContextMenu(where);
        } else {
            BlockColumn column = this.overColumn(where.x);
            BlockRow row = this.overRow(where.y);
            if (button == 1) {
                int colDivider;
                if (this.mMoreUpArea.contains(where)) {
                    this.mTracker = new MoreUpTracker();
                } else if (this.mMoreDownArea.contains(where)) {
                    this.mTracker = new MoreDownTracker();
                } else if (column != null && row != null && this.overDisclosureControl(where.x, where.y, column, row)) {
                    this.mTracker = new DisclosureTracker(row, column);
                } else if (this.mAllowColumnResize && (colDivider = this.overColumnDivider(where.x)) != -1) {
                    this.mTracker = new BlockColumnResizeTracker(this, where.x, colDivider, count);
                }
            }
            if (this.mTracker == null) {
                IBlockCell cell;
                if (this.mEditor != null) {
                    this.mEditor.commit(false);
                }
                this.setEditor(null);
                if (column != null && row != null && (cell = column.getRowCell(row)) instanceof IBlockCellMouseHandler) {
                    IBlockCellMouseHandler handler = (IBlockCellMouseHandler)((Object)cell);
                    if (count == 1 && handler.handleCellMouseDown(this, where, stateMask, button, row, column)) {
                        this.mTracker = new CellTracker(handler);
                    } else if (count == 2 && handler.handleCellMouseDoubleClick(this, where, stateMask, button, row, column)) {
                        this.mTracker = new CellTracker(handler);
                    }
                }
                if (this.mTracker == null) {
                    if (count == 2 && row != null && (column == null || !this.overDisclosureControl(where.x, where.y, column, row) && this.mModel.isRowSelected(row))) {
                        this.notifyOfOpenSelectionRequest();
                    } else {
                        this.mTracker = new SelectionTracker(where.y, button, stateMask);
                    }
                }
            }
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mTracker != null) {
            this.mTracker.mouseDrag(where, stateMask);
        }
    }

    @Override
    protected void mouseEnter(Point where, int stateMask) {
        this.adjustCursorAndTooltip(where, stateMask);
    }

    @Override
    protected void mouseMove(Point where, int stateMask) {
        this.adjustCursorAndTooltip(where, stateMask);
    }

    @Override
    protected final boolean mouseScrolled(Point where, int stateMask, int amount, boolean vertical) {
        super.mouseScrolled(where, stateMask, amount, vertical);
        if (!vertical) {
            this.redrawHeader();
        }
        return false;
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mTracker != null) {
            this.mTracker.mouseUp(where, button, stateMask, count);
            this.mTracker = null;
        }
    }

    @Override
    protected void paintSelf(GC gc) {
        StdSelection selection;
        Rectangle clipBounds;
        block23: {
            super.paintSelf(gc);
            if (this.mEditor != null) {
                this.mEditor.adjustToOutline();
            }
            boolean active = this.hasFocus();
            int rowHeight = this.mModel.getRowHeight();
            boolean showIndent = this.showIndent();
            boolean showOutline = this.showOutline();
            clipBounds = gc.getClipping();
            int last = this.overRowIndex(clipBounds.y + clipBounds.height - 1) + 1;
            int rowIndex = this.overRowIndex(clipBounds.y);
            gc.fillRectangle(clipBounds);
            if (last == 0) {
                last = this.mModel.getRowCount();
            }
            if (rowIndex <= -1) break block23;
            List<BlockRow> topLevelRows = this.mModel.getTopLevelRows();
            BlockRow lastTopParent = topLevelRows.get(topLevelRows.size() - 1);
            BlockRow firstRow = this.mModel.getRowAtIndex(0);
            int indentWidth = this.mModel.getIndentWidth();
            int top = this.getRowIndexBounds((int)rowIndex).y;
            while (rowIndex < last) {
                BlockRow row = this.mModel.getRowAtIndex(rowIndex);
                boolean rowSelected = this.mModel.isRowSelected(row);
                Rectangle colBounds = new Rectangle(0, top, 0, rowHeight);
                int shift = 0;
                gc.setForeground(this.getRowDividerColor(rowIndex));
                gc.drawLine(clipBounds.x, top + rowHeight, clipBounds.x + clipBounds.width, top + rowHeight);
                for (BlockColumn col : this.mModel.getColumns()) {
                    block24: {
                        block25: {
                            if (!col.isVisible()) continue;
                            colBounds.width = this.getColumnWidth(col);
                            if (!clipBounds.intersects(colBounds)) break block24;
                            this.drawRowBackground(gc, colBounds, row, rowSelected, active);
                            if (!showIndent || !col.isPrimary()) break block25;
                            int depth = row.getDepth();
                            shift = this.mModel.getIndentWidth(row, col);
                            colBounds.x += shift;
                            colBounds.width -= shift;
                            if (!showOutline) break block25;
                            Image image = this.getDisclosureControl(row);
                            Rectangle imageBounds = image.getBounds();
                            int disclosureLeft = colBounds.x - ((indentWidth - imageBounds.width) / 2 + imageBounds.width);
                            int x = disclosureLeft + imageBounds.width / 2;
                            int y = colBounds.y + colBounds.height / 2;
                            gc.setForeground(Colors.getOutlineHierarchy());
                            gc.drawLine(x, y, colBounds.x - 1, y);
                            x += indentWidth;
                            int lastY = y;
                            y = colBounds.y + colBounds.height;
                            BlockRow parent = row.getParent();
                            BlockRow child = row;
                            int i = 0;
                            while (i <= depth) {
                                block27: {
                                    int yend;
                                    block26: {
                                        yend = y;
                                        boolean isLastChild = false;
                                        x -= indentWidth;
                                        if (parent != null) {
                                            isLastChild = parent.getChild(parent.getChildCount() - 1) == child;
                                            child = parent;
                                            parent = parent.getParent();
                                        } else {
                                            boolean bl = isLastChild = lastTopParent == child;
                                        }
                                        if (!isLastChild) break block26;
                                        if (i != 0) break block27;
                                        yend = lastY;
                                    }
                                    int ys = colBounds.y;
                                    if (firstRow == row) {
                                        ys += colBounds.height / 2;
                                    }
                                    gc.drawLine(x, ys, x, yend);
                                }
                                ++i;
                            }
                            if (row.canHaveChildren()) {
                                gc.drawImage(image, disclosureLeft, colBounds.y + (colBounds.height - imageBounds.height) / 2);
                            }
                        }
                        col.drawRowCell(gc, colBounds, row, rowSelected, active);
                        if (showIndent && col.isPrimary()) {
                            colBounds.x -= shift;
                            colBounds.width += shift;
                        }
                    }
                    colBounds.x = colBounds.x + (colBounds.width + (this.mShowColumnLines ? 1 : 0));
                }
                if (clipBounds.x + clipBounds.width > colBounds.x) {
                    this.drawRowBackground(gc, new Rectangle(colBounds.x, colBounds.y, clipBounds.x + clipBounds.width - colBounds.x, colBounds.height), row, rowSelected, active);
                }
                top += rowHeight + 1;
                ++rowIndex;
            }
        }
        this.drawColumnDividers(gc, clipBounds);
        if (this.mDropChildInsertIndex != -1) {
            this.drawDragRowInsertionMarker(gc, this.mDropParentRow, this.mDropChildInsertIndex);
        }
        Rectangle bounds = this.getViewPortBounds();
        if (this.mDropHighlight) {
            gc.setForeground(Colors.getSelection(true));
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            ++bounds.x;
            ++bounds.y;
            bounds.width -= 2;
            bounds.height -= 2;
            if (bounds.width > 0 && bounds.height > 0) {
                gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            }
            --bounds.x;
            --bounds.y;
            bounds.width += 2;
            bounds.height += 2;
        }
        if (!(selection = this.mModel.getSelection()).isEmpty()) {
            int remaining;
            int index = this.overRowIndex(bounds.y);
            int n = remaining = index > -1 ? selection.getCountOfSelectedIndexesBefore(index) : 0;
            if (remaining > 0) {
                this.drawMore(gc, true, remaining);
            } else {
                this.mMoreUpArea.width = 0;
            }
            index = this.overRowIndex(bounds.y + bounds.height);
            int n2 = remaining = index > -1 ? selection.getCountOfSelectedIndexesAfter(index) : 0;
            if (remaining > 0) {
                this.drawMore(gc, false, remaining);
            } else {
                this.mMoreDownArea.width = 0;
            }
        } else {
            this.mMoreUpArea.width = 0;
            this.mMoreDownArea.width = 0;
        }
    }

    protected Rectangle repaintSelectionInternal() {
        Rectangle area = this.getViewPortBounds();
        int top = area.y;
        int max = area.height;
        int bottom = area.y + max;
        StdSelection selection = this.mModel.getSelection();
        int index = selection.firstSelectedIndex();
        area.y = 0;
        area.height = 0;
        Rectangle bounds = new Rectangle(area.x, 0, area.width, this.mModel.getRowHeight() + 1);
        while (index != -1) {
            bounds.y = this.getRowIndexStart(index);
            if (bounds.y + bounds.height >= top && bounds.y < bottom) {
                this.repaint(bounds);
            }
            area = Geometry.union(area, bounds);
            if (bounds.y > bottom && area.height > max) break;
            index = selection.nextSelectedIndex(index + 1);
        }
        if (!this.mMoreUpArea.isEmpty()) {
            this.repaint(this.mMoreUpArea);
        }
        if (!this.mMoreDownArea.isEmpty()) {
            this.repaint(this.mMoreDownArea);
        }
        return area;
    }

    protected void setAllowScrollOnSelect(boolean allow) {
        this.mAllowScrollOnSelect = allow;
    }

    protected final void showContextMenu(Point where) {
        Menu menu = new Menu((Control)this.getOwner());
        this.createContextMenuContent(where, menu);
        this.showContextMenu(menu, where);
    }

    protected final void verticallyScrollIntoView(Rectangle bounds) {
        Rectangle viewBounds = this.getViewPortBounds();
        viewBounds.y = bounds.y;
        viewBounds.height = bounds.height;
        this.scrollIntoView(viewBounds);
    }

    private void adjustCursorAndTooltip(Point where, int stateMask) {
        int cursor;
        String tip = null;
        if (this.mMoreUpArea.contains(where) || this.mMoreDownArea.contains(where)) {
            cursor = 0;
        } else {
            BlockColumn column = this.overColumn(where.x);
            BlockRow row = this.overRow(where.y);
            if (column != null && row != null) {
                tip = SWTLabelFilter.filterForToolTip((String)column.getRowCell(row).getToolTipText(this, row, column));
            }
            if (column != null && row != null && this.overDisclosureControl(where.x, where.y, column, row)) {
                cursor = 0;
            } else if (this.mAllowColumnResize && this.overColumnDivider(where.x) != -1) {
                cursor = 9;
            } else {
                IBlockCell cell;
                cursor = 0;
                if (column != null && row != null && (cell = column.getRowCell(row)) instanceof IBlockCellMouseHandler && !((IBlockCellMouseHandler)((Object)cell)).handleCellMouseMove(this, where, stateMask)) {
                    return;
                }
            }
        }
        this.setCursor(this.getDisplay().getSystemCursor(cursor));
        this.setToolTip(tip);
    }

    private void drawColumnDividers(GC gc, Rectangle bounds) {
        if (this.mShowColumnLines) {
            int x = 0;
            int y = bounds.y;
            int bottom = y + bounds.height;
            int right = bounds.x + bounds.width;
            for (BlockColumn col : this.mModel.getColumns()) {
                if (col.isVisible()) {
                    if ((x += this.getColumnWidth(col)) >= bounds.x) {
                        gc.setForeground(this.getColumnDividerColor(col.getID()));
                        gc.drawLine(x, y, x, bottom);
                    }
                    ++x;
                }
                if (x >= right) break;
            }
        }
    }

    private void drawDragRowInsertionMarker(GC gc, BlockRow parent, int insertAtIndex) {
        Rectangle bounds = this.getDragRowInsertionMarkerBounds(parent, insertAtIndex);
        gc.setForeground(Colors.getRed());
        int x1 = bounds.x;
        int x2 = x1 + bounds.width;
        int y1 = bounds.y + bounds.height / 2 - 1;
        int i = 0;
        while (i < 3) {
            gc.drawLine(x1, y1, x2, y1);
            ++i;
            ++y1;
        }
        gc.setForeground(Colors.getDarkRed());
        x1 = this.getDragRowInsertionMarkerIndent(parent, insertAtIndex);
        y1 = bounds.y;
        int y2 = y1 + bounds.height;
        int max = bounds.height / 2 + 1;
        int i2 = 0;
        while (i2 < max) {
            gc.drawLine(x1 + i2, y1 + i2, x1 + i2, y2 - (1 + i2));
            ++i2;
        }
        ++x1;
        y1 += 2;
        y2 -= 2;
        max -= 2;
        gc.setForeground(Colors.getYellow());
        i2 = 0;
        while (i2 < max) {
            gc.drawLine(x1 + i2, y1 + i2, x1 + i2, y2 - (1 + i2));
            ++i2;
        }
    }

    private void finishRowStateChange() {
        this.adjust();
        this.setAllowLazyAdjust(true);
        BlockHeader header = this.getHeader();
        if (header != null) {
            header.pack();
        }
    }

    private int getAbsoluteInsertionIndex(BlockRow parent, int childInsertIndex) {
        int insertAt;
        if (parent == null) {
            int count = this.mModel.getRowCount();
            insertAt = childInsertIndex;
            while (insertAt < count && this.mModel.getRowAtIndex(insertAt).getParent() != null) {
                ++insertAt;
            }
        } else {
            int i = parent.getChildCount();
            if (i == 0 || !parent.isOpen()) {
                insertAt = this.mModel.getIndexOfRow(parent) + 1;
            } else if (childInsertIndex < i) {
                insertAt = this.mModel.getIndexOfRow(parent.getChild(childInsertIndex));
            } else {
                BlockRow row = parent.getChild(i - 1);
                int count = this.mModel.getRowCount();
                insertAt = this.mModel.getIndexOfRow(row) + 1;
                while (insertAt < count && this.mModel.getRowAtIndex(insertAt).isDescendentOf(row)) {
                    ++insertAt;
                }
            }
        }
        return insertAt;
    }

    private IBlockOutlineListener[] getCurrentOutlineListeners() {
        return this.mListeners.toArray(new IBlockOutlineListener[0]);
    }

    private Rectangle getDragRowInsertionMarkerBounds(BlockRow parent, int insertAtIndex) {
        Rectangle bounds;
        int rowCount = this.mModel.getRowCount();
        if (insertAtIndex < 0 || rowCount == 0) {
            bounds = new Rectangle(0, 0, 0, 0);
        } else {
            int insertAt = this.getAbsoluteInsertionIndex(parent, insertAtIndex);
            if (insertAt < rowCount) {
                bounds = this.getRowBounds(this.mModel.getRowAtIndex(insertAt));
                if (insertAt != 0) {
                    --bounds.y;
                }
            } else {
                bounds = this.getRowBounds(this.mModel.getRowAtIndex(rowCount - 1));
                bounds.y += bounds.height;
            }
        }
        bounds.y -= 5;
        bounds.height = 11;
        return bounds;
    }

    private int getDragRowInsertionMarkerIndent(BlockRow parent, int insertAtIndex) {
        if (this.mModel.showIndent()) {
            int rowCount = this.mModel.getRowCount();
            if (insertAtIndex >= 0 && rowCount > 0) {
                BlockColumn primary = this.getPrimaryColumn();
                int indent = this.getColumnStart(primary);
                if (this.mModel.showOutline()) {
                    indent += this.mModel.getIndentWidth();
                }
                if (parent != null) {
                    indent += this.mModel.getIndentWidth() * (1 + parent.getDepth());
                }
                return indent;
            }
        }
        return 0;
    }

    private BlockColumn getPrimaryColumn() {
        BlockColumn primary = this.mModel.getColumns().get(0);
        if (!primary.isPrimary()) {
            for (BlockColumn column : this.mModel.getColumns()) {
                if (!column.isPrimary()) continue;
                primary = column;
                break;
            }
        }
        return primary;
    }

    private Set<BlockRow> getSelectedRowExclusionSet() {
        HashSet<BlockRow> exclude = new HashSet<BlockRow>();
        for (BlockRow row : this.mModel.getSelectionAsList()) {
            exclude.add(row);
            BlockRow parent = row.getParent();
            while (parent != null) {
                exclude.add(parent);
                parent = parent.getParent();
            }
        }
        return exclude;
    }

    private boolean hasClosedState(BlockRow row, Set<BlockRow> exclude) {
        if (row.canHaveChildren() && !exclude.contains(row)) {
            if (!row.isOpen()) {
                return true;
            }
            int count = row.getChildCount();
            int i = 0;
            while (i < count) {
                if (this.hasClosedState(row.getChild(i), exclude)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean hasOpenState(BlockRow row, Set<BlockRow> exclude) {
        if (row.canHaveChildren() && !exclude.contains(row)) {
            if (row.isOpen()) {
                return true;
            }
            int count = row.getChildCount();
            int i = 0;
            while (i < count) {
                if (this.hasOpenState(row.getChild(i), exclude)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void notifyOfDeleteSelectionRequest() {
        IBlockOutlineListener[] iBlockOutlineListenerArray = this.getCurrentOutlineListeners();
        int n = iBlockOutlineListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBlockOutlineListener listener = iBlockOutlineListenerArray[n2];
            listener.deleteSelectionRequested(this);
            ++n2;
        }
    }

    private void notifyOfEditorChange() {
        IBlockOutlineListener[] iBlockOutlineListenerArray = this.getCurrentOutlineListeners();
        int n = iBlockOutlineListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBlockOutlineListener listener = iBlockOutlineListenerArray[n2];
            listener.editorChanged(this);
            ++n2;
        }
    }

    private void notifyOfOpenSelectionRequest() {
        IBlockOutlineListener[] iBlockOutlineListenerArray = this.getCurrentOutlineListeners();
        int n = iBlockOutlineListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBlockOutlineListener listener = iBlockOutlineListenerArray[n2];
            listener.openSelectionRequested(this);
            ++n2;
        }
    }

    private void open(BlockRow row, Set<BlockRow> exclude) {
        if (row.canHaveChildren() && !exclude.contains(row)) {
            row.setOpen(true);
            int count = row.getChildCount();
            int i = 0;
            while (i < count) {
                this.open(row.getChild(i), exclude);
                ++i;
            }
        }
    }

    private void prepareForRowStateChange() {
        this.setAllowLazyAdjust(false);
    }

    private void scrollSelectionIntoViewInternal(boolean verticalOnly) {
        StdSelection selection = this.mModel.getSelection();
        int first = selection.nextSelectedIndex(0);
        int max = this.mModel.getRowCount() - 1;
        if (first != -1 && first <= max) {
            int last;
            Rectangle bounds = this.getRowIndexBounds(first);
            int tmp = first;
            while ((tmp = selection.nextSelectedIndex((last = tmp) + 1)) != -1 && tmp <= max) {
            }
            if (first != last) {
                bounds = Geometry.union(bounds, this.getRowIndexBounds(last));
            }
            if (verticalOnly) {
                this.verticallyScrollIntoView(bounds);
            } else {
                this.scrollIntoView(bounds);
            }
        }
    }

    int overColumnDivider(int x) {
        if (this.mShowColumnLines) {
            int pos = 0;
            int count = this.mModel.getColumnCount();
            int i = 0;
            while (i < count) {
                BlockColumn col = this.mModel.getColumnAtIndex(i);
                if (col.isVisible() && x > (pos += this.getColumnWidth(col) + 1) - 5 && x < pos + 5) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    void setOpenRecursively(BlockRow row, boolean open) {
        row.setOpen(open);
        if (row.hasChildren()) {
            for (BlockRow child : row.getChildren()) {
                this.setOpenRecursively(child, open);
            }
        }
    }

    private class CellTracker
    extends DragTracker {
        private IBlockCellMouseHandler mHandler;

        CellTracker(IBlockCellMouseHandler handler) {
            super(BlockOutline.this);
            this.mHandler = handler;
        }

        @Override
        public final void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            this.mHandler.handleCellMouseMove(BlockOutline.this, where, stateMask);
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            super.mouseUp(where, button, stateMask, count);
            this.mHandler.handleCellMouseUp(BlockOutline.this, where, stateMask);
        }
    }

    private class DisclosureTracker
    extends DragTracker {
        DisclosureTracker(BlockRow row, BlockColumn column) {
            super(BlockOutline.this);
            Rectangle bounds = BlockOutline.this.getCellBounds(row, column);
            bounds.width = BlockOutline.this.getModel().getIndentWidth(row, column);
            BlockOutline.this.repaint(bounds);
            row.setOpen(!row.isOpen());
        }
    }

    private class MoreDownTracker
    extends DragTracker {
        protected MoreDownTracker() {
            super(BlockOutline.this);
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            super.mouseUp(where, button, stateMask, count);
            BlockOutlineModel model = BlockOutline.this.getModel();
            StdSelection selection = model.getSelection();
            if (!selection.isEmpty()) {
                int first;
                Rectangle viewBounds = BlockOutline.this.getViewPortBounds();
                int max = viewBounds.height / (model.getRowHeight() + 1);
                int last = first = selection.nextSelectedIndex(BlockOutline.this.overRowIndex(viewBounds.y + viewBounds.height) + 1);
                int index = first;
                while ((index = selection.nextSelectedIndex(index + 1)) != -1 && index - first <= max) {
                    last = index;
                }
                BlockOutline.this.verticallyScrollIntoView(BlockOutline.this.getRowIndexBounds(first).union(BlockOutline.this.getRowIndexBounds(last)));
            }
        }
    }

    private class MoreUpTracker
    extends DragTracker {
        protected MoreUpTracker() {
            super(BlockOutline.this);
        }

        @Override
        public final void mouseUp(Point where, int button, int stateMask, int count) {
            super.mouseUp(where, button, stateMask, count);
            BlockOutlineModel model = BlockOutline.this.getModel();
            StdSelection selection = model.getSelection();
            if (!selection.isEmpty()) {
                int rangeEnd;
                int rangeStart;
                Rectangle viewBounds = BlockOutline.this.getViewPortBounds();
                int first = BlockOutline.this.overRowIndex(viewBounds.y);
                int index = -1;
                TIntArrayList list = new TIntArrayList();
                while ((index = selection.nextSelectedIndex(index + 1)) != -1 && index < first) {
                    list.add(index);
                }
                int max = viewBounds.height / (model.getRowHeight() + 1);
                int last = list.size() - 1;
                first = rangeStart = (rangeEnd = list.get(last--));
                while (last >= 0) {
                    if (rangeEnd - (first = list.get(last--)) > max) break;
                    rangeStart = first;
                }
                BlockOutline.this.verticallyScrollIntoView(BlockOutline.this.getRowIndexBounds(rangeStart).union(BlockOutline.this.getRowIndexBounds(rangeEnd)));
            }
        }
    }

    private class SelectionTracker
    extends DragTracker {
        private long mInitialMouseTime;
        private int mInitialMouseY;
        private int mSelectOnMouseUp;
        private StdSelection mPreservedSelection;
        private boolean mDragSelectOK;

        SelectionTracker(int y, int button, int stateMask) {
            super(BlockOutline.this);
            BlockOutlineModel model = BlockOutline.this.getModel();
            this.mSelectOnMouseUp = -1;
            int method = 0;
            int rowIndexHit = BlockOutline.this.overRowIndex(y);
            if ((stateMask & 0x20000) != 0) {
                method |= 1;
            }
            if (button == 1 && (stateMask & WorkspaceUtils.getCommandKey()) != 0) {
                method |= 2;
            }
            BlockOutline.this.setAllowScrollOnSelect(false);
            this.mSelectOnMouseUp = model.getSelection().selectByMouse(rowIndexHit, method);
            if (button != 1) {
                this.mSelectOnMouseUp = -1;
            }
            boolean bl = this.mDragSelectOK = BlockOutline.this.isDragSelectedPermitted() && button == 1;
            if (this.mDragSelectOK) {
                this.mInitialMouseY = y;
                this.mInitialMouseTime = System.currentTimeMillis();
            }
        }

        @Override
        public void mouseDrag(Point where, int stateMask) {
            super.mouseDrag(where, stateMask);
            if (this.mDragSelectOK && (stateMask & SWT.MOD1) == 0) {
                if (this.mInitialMouseTime != 0L) {
                    if (Math.abs(this.mInitialMouseY - where.y) < 4 && System.currentTimeMillis() - this.mInitialMouseTime < 250L) {
                        return;
                    }
                    this.mInitialMouseTime = 0L;
                }
                BlockOutlineModel model = BlockOutline.this.getModel();
                if (this.mPreservedSelection == null) {
                    this.mPreservedSelection = new StdSelection(model.getSelection());
                    this.mPreservedSelection.setNotify(false);
                }
                StdSelection newSel = new StdSelection(this.mPreservedSelection);
                int line = BlockOutline.this.overRowIndex(where.y);
                if (line == -1) {
                    line = where.y < 0 ? 0 : model.getRowCount() - 1;
                }
                this.mSelectOnMouseUp = newSel.selectByMouse(line, 1);
                model.getSelection().select(newSel);
            }
        }

        @Override
        public void mouseUp(Point where, int button, int stateMask, int count) {
            super.mouseUp(where, button, stateMask, count);
            BlockOutline.this.setAllowScrollOnSelect(true);
            if (this.mSelectOnMouseUp != -1) {
                BlockOutline.this.getModel().select(this.mSelectOnMouseUp, false);
            }
        }
    }
}

