/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.lightweight.outline.BlockHeaderCell;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import com.arm.streamline.widget.lightweight.outline.BlockTextCell;
import com.arm.streamline.widget.lightweight.outline.IBlockCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class BlockColumn {
    private static final String SPACE = " ";
    private BlockHeaderCell mHeaderCell;
    private IBlockCell mRowCell;
    private int mMaxWidth = 450;
    private int mWidth;
    private int mPreferredWidth;
    private int mDefaultPreferredWidth;
    private String mName;
    private Image mIcon;
    private int mID;
    private String mToolTipText;
    private Object mUserRef;
    private boolean mPrimary;
    private boolean mVisible;

    public BlockColumn(int id, String name) {
        this(id, name, (Image)null);
    }

    public BlockColumn(int id, String name, IBlockCell rowCell) {
        this(id, name, null, null, rowCell);
    }

    public BlockColumn(int id, String name, Image icon) {
        this(id, name, icon, name);
    }

    public BlockColumn(int id, String name, Image icon, String toolTipText) {
        this(id, name, icon, toolTipText, new BlockTextCell());
    }

    public BlockColumn(int id, String name, Image icon, String toolTipText, IBlockCell rowCell) {
        this.mName = name == null || name.length() == 0 ? SPACE : name;
        this.mIcon = icon;
        this.mToolTipText = toolTipText;
        this.mRowCell = rowCell;
        this.mPrimary = false;
        this.mVisible = true;
        this.mWidth = -1;
        this.mID = id;
        this.setHeaderCell(new BlockHeaderCell());
    }

    public BlockColumn(int id, String name, String toolTipText) {
        this(id, name, null, toolTipText);
    }

    public BlockColumn(int id, String name, String toolTipText, IBlockCell rowCell) {
        this(id, name, null, toolTipText, rowCell);
    }

    public void drawHeaderCell(GC gc, Rectangle bounds) {
        this.getHeaderCell().drawCell(gc, bounds, null, this, false, true);
    }

    public void drawRowCell(GC gc, Rectangle bounds, BlockRow row, boolean selected, boolean active) {
        this.getRowCell(row).drawCell(gc, bounds, row, this, selected, active);
    }

    public int getDefaultPreferredWidth() {
        return this.mDefaultPreferredWidth;
    }

    public BlockHeaderCell getHeaderCell() {
        return this.mHeaderCell;
    }

    public Image getIcon() {
        return this.mIcon;
    }

    public int getID() {
        return this.mID;
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public Point getPreferredHeaderSize(BlockOutline outline) {
        GC gc = outline.createTemporaryGC();
        Point size = this.getHeaderCell().getPreferredSize(gc, null, this);
        gc.dispose();
        return size;
    }

    public int getPreferredWidth(BlockOutline outline) {
        int prefWidth = this.mPreferredWidth < 1 ? this.mDefaultPreferredWidth : this.mPreferredWidth;
        int desiredWidth = Math.max(this.getPreferredHeaderSize((BlockOutline)outline).x, prefWidth);
        if (prefWidth < 1) {
            BlockOutlineModel model = outline.getModel();
            GC gc = null;
            for (BlockRow row : model.getRows()) {
                int width;
                int indentWidth = model.getIndentWidth(row, this);
                if (gc == null) {
                    gc = outline.createTemporaryGC();
                }
                if ((width = this.getRowCell((BlockRow)row).getPreferredSize((GC)gc, (BlockRow)row, (BlockColumn)this).x + indentWidth) <= desiredWidth) continue;
                if (this.mMaxWidth > 0 && this.mMaxWidth < width) {
                    width = this.mMaxWidth;
                    break;
                }
                desiredWidth = width;
            }
            if (gc != null) {
                gc.dispose();
            }
        }
        return desiredWidth;
    }

    public IBlockCell getRowCell(BlockRow row) {
        return this.mRowCell;
    }

    public String getSanitizedName() {
        return this.mName.replaceAll("\n", SPACE);
    }

    public int getSortSequence() {
        return this.getHeaderCell().getSortSequence();
    }

    public String getToolTipText() {
        return this.mToolTipText;
    }

    public Object getUserRef() {
        return this.mUserRef;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public boolean isPrimary() {
        return this.mPrimary;
    }

    public boolean isSortAscending() {
        return this.getHeaderCell().isSortAscending();
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setDefaultPreferredWidth(int width) {
        this.mDefaultPreferredWidth = width;
    }

    public void setHeaderCell(BlockHeaderCell cell) {
        this.mHeaderCell = cell;
        this.mHeaderCell.setMinimumContentWidth(this.mRowCell.getMinimumContentWidth());
    }

    public void setIcon(Image icon) {
        this.mIcon = icon;
    }

    public void setID(int id) {
        this.mID = id;
    }

    public void setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    public void setName(String name) {
        this.mName = name == null || name.length() == 0 ? SPACE : name;
    }

    public void setNoMaxWidth() {
        this.mMaxWidth = -1;
    }

    public void setPreferredWidth(int width) {
        this.mPreferredWidth = width;
    }

    public void setPrimary(boolean primary) {
        this.mPrimary = primary;
    }

    public void setRowCell(IBlockCell cell) {
        this.mRowCell = cell;
    }

    public void setSortCriteria(int sequence, boolean ascending) {
        this.getHeaderCell().setSortCriteria(sequence, ascending);
    }

    public void setToolTipText(String text) {
        this.mToolTipText = text;
    }

    public void setUserRef(Object userRef) {
        this.mUserRef = userRef;
    }

    public void setVisible(boolean visible) {
        this.mVisible = visible || this.mPrimary;
    }

    public void setWidth(BlockOutline outline, int width) {
        int minWidth = this.getPreferredHeaderSize((BlockOutline)outline).x;
        if (width < minWidth && width != -1) {
            width = minWidth;
        }
        this.mWidth = width;
    }

    public String toString() {
        return this.mName;
    }
}

