/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.widget.lightweight.Block;
import org.eclipse.swt.graphics.Point;

public final class PrecisionLayoutData {
    private int mCacheMinWidth;
    private int mCacheWidth;
    private int mCacheHeight;
    private int mVAlign = 0x1000000;
    private int mHAlign = 16384;
    private int mMarginTop;
    private int mMarginLeft;
    private int mMarginBottom;
    private int mMarginRight;
    private int mWidthHint = -1;
    private int mHeightHint = -1;
    private int mHSpan = 1;
    private int mVSpan = 1;
    private int mMinWidth = -1;
    private int mMinHeight = -1;
    private boolean mHGrab;
    private boolean mVGrab;
    private boolean mExclude;

    public final int getBottomMargin() {
        return this.mMarginBottom;
    }

    public final int getHeightHint() {
        return this.mHeightHint;
    }

    public final int getHorizontalAlignment() {
        return this.mHAlign;
    }

    public final int getHorizontalSpan() {
        return this.mHSpan;
    }

    public final int getLeftMargin() {
        return this.mMarginLeft;
    }

    public final int getMinimumHeight() {
        return this.mMinHeight;
    }

    public final int getMinimumWidth() {
        return this.mMinWidth;
    }

    public final int getRightMargin() {
        return this.mMarginRight;
    }

    public final int getTopMargin() {
        return this.mMarginTop;
    }

    public final int getVerticalAlignment() {
        return this.mVAlign;
    }

    public final int getVerticalSpan() {
        return this.mVSpan;
    }

    public final int getWidthHint() {
        return this.mWidthHint;
    }

    public final PrecisionLayoutData setAlignment(int horizontal, int vertical) {
        this.mHAlign = horizontal;
        this.mVAlign = vertical;
        return this;
    }

    public final PrecisionLayoutData setBottomMargin(int bottom) {
        this.mMarginBottom = bottom;
        return this;
    }

    public final PrecisionLayoutData setExclude(boolean exclude) {
        this.mExclude = exclude;
        return this;
    }

    public final PrecisionLayoutData setFill() {
        return this.setAlignment(4, 4);
    }

    public final PrecisionLayoutData setGrabHorizontalSpace(boolean grab) {
        this.mHGrab = grab;
        return this;
    }

    public final PrecisionLayoutData setGrabSpace(boolean grab) {
        this.mHGrab = grab;
        this.mVGrab = grab;
        return this;
    }

    public final PrecisionLayoutData setGrabVerticalSpace(boolean grab) {
        this.mVGrab = grab;
        return this;
    }

    public final PrecisionLayoutData setHeightHint(int height) {
        this.mHeightHint = height;
        return this;
    }

    public final PrecisionLayoutData setHorizontalAlignment(int alignment) {
        this.mHAlign = alignment;
        return this;
    }

    public final PrecisionLayoutData setHorizontalSpan(int span) {
        this.mHSpan = span;
        return this;
    }

    public final PrecisionLayoutData setLeftMargin(int left) {
        this.mMarginLeft = left;
        return this;
    }

    public final PrecisionLayoutData setMargins(int margins) {
        this.mMarginTop = margins;
        this.mMarginLeft = margins;
        this.mMarginBottom = margins;
        this.mMarginRight = margins;
        return this;
    }

    public final PrecisionLayoutData setMargins(int top, int left, int bottom, int right) {
        this.mMarginTop = top;
        this.mMarginLeft = left;
        this.mMarginBottom = bottom;
        this.mMarginRight = right;
        return this;
    }

    public final PrecisionLayoutData setMinimumHeight(int height) {
        this.mMinHeight = height;
        return this;
    }

    public final PrecisionLayoutData setMinimumWidth(int width) {
        this.mMinWidth = width;
        return this;
    }

    public final PrecisionLayoutData setRightMargin(int right) {
        this.mMarginRight = right;
        return this;
    }

    public final PrecisionLayoutData setTopMargin(int top) {
        this.mMarginTop = top;
        return this;
    }

    public final PrecisionLayoutData setVerticalAlignment(int alignment) {
        this.mVAlign = alignment;
        return this;
    }

    public final PrecisionLayoutData setVerticalSpan(int span) {
        this.mVSpan = span;
        return this;
    }

    public final PrecisionLayoutData setWidthHint(int width) {
        this.mWidthHint = width;
        return this;
    }

    public final boolean shouldExclude() {
        return this.mExclude;
    }

    public final boolean shouldGrabHorizontalSpace() {
        return this.mHGrab;
    }

    public final boolean shouldGrabVerticalSpace() {
        return this.mVGrab;
    }

    final void clearCache() {
        this.mCacheMinWidth = 0;
        this.mCacheWidth = 0;
        this.mCacheHeight = 0;
    }

    final void computeSize(Block block, int wHint, int hHint, boolean useMinimumSize) {
        Point size = null;
        if (wHint != -1 || hHint != -1) {
            int minHeight;
            size = block.getMinimumSize(wHint, hHint);
            int n = this.mCacheMinWidth = this.mMinWidth != -1 ? this.mMinWidth : size.x;
            if (wHint != -1 && wHint < this.mCacheMinWidth) {
                wHint = this.mCacheMinWidth;
            }
            int n2 = minHeight = this.mMinHeight != -1 ? this.mMinHeight : size.y;
            if (hHint != -1 && hHint < minHeight) {
                hHint = minHeight;
            }
        }
        if (useMinimumSize) {
            size = block.getMinimumSize(wHint, hHint);
            this.mCacheMinWidth = this.mMinWidth != -1 ? this.mMinWidth : size.x;
        } else {
            size = block.getPreferredSize(wHint, hHint);
        }
        if (this.mWidthHint != -1) {
            size.x = this.mWidthHint;
        }
        if (this.mMinWidth != -1 && size.x < this.mMinWidth) {
            size.x = this.mMinWidth;
        }
        if (this.mHeightHint != -1) {
            size.y = this.mHeightHint;
        }
        if (this.mMinHeight != -1 && size.y < this.mMinHeight) {
            size.y = this.mMinHeight;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        this.mCacheWidth = size.x;
        this.mCacheHeight = size.y;
    }

    final int getCachedHeight() {
        return this.mCacheHeight;
    }

    final int getCachedMinimumWidth() {
        return this.mCacheMinWidth;
    }

    final int getCachedWidth() {
        return this.mCacheWidth;
    }

    final void setCachedHeight(int height) {
        this.mCacheHeight = height;
    }
}

