/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockImageButton;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class BlockToolbar
extends Block
implements IBlockLayout {
    public static final int DEFAULT_H_MARGIN = 3;
    public static final int DEFAULT_V_SPACING = 1;
    private int mLeftMargin = 3;
    private int mRightMargin = 3;
    private int mVSpacing = 1;
    private boolean mShowsBorderLines = true;

    private static final int layoutRow(Block[] children, int top, int left, int width) {
        Point[] sizes = new Point[children.length];
        LayoutData[] layout = new LayoutData[children.length];
        int x = left;
        int y = top;
        int fillCount = 0;
        int flexibleGapCount = 0;
        int minCount = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Object ld = children[i].getLayoutData();
            if (ld instanceof LayoutData) {
                layout[i] = (LayoutData)ld;
                if (layout[i].mFill) {
                    ++fillCount;
                }
                if (layout[i].mFlexibleGap) {
                    ++flexibleGapCount;
                }
                if (layout[i].mMinimumWidth > 0) {
                    ++minCount;
                }
            } else {
                layout[i] = new LayoutData();
            }
            sizes[i] = children[i].getPreferredSize(-1, -1);
            if (layout[i].mMinimumWidth > 0 && sizes[i].x < layout[i].mMinimumWidth) {
                sizes[i].x = layout[i].mMinimumWidth;
                --minCount;
            }
            x += sizes[i].x;
            if (i != children.length - 1) {
                x += layout[i].mGap;
            }
            if (sizes[i].y > height) {
                height = sizes[i].y;
            }
            ++i;
        }
        int[] extraGap = new int[children.length];
        int remaining = width - (x - left);
        if (remaining > 0) {
            if (fillCount > 0) {
                extra = remaining / fillCount;
                leftover = remaining - extra * fillCount;
                i = 0;
                while (i < children.length) {
                    if (layout[i].mFill) {
                        sizes[i].x += extra;
                        if (leftover > 0) {
                            ++sizes[i].x;
                            --leftover;
                        }
                    }
                    ++i;
                }
            } else if (flexibleGapCount > 0) {
                extra = remaining / flexibleGapCount;
                leftover = remaining - extra * flexibleGapCount;
                i = 0;
                while (i < children.length) {
                    if (layout[i].mFlexibleGap) {
                        int n = i;
                        extraGap[n] = extraGap[n] + extra;
                        if (leftover > 0) {
                            int n2 = i;
                            extraGap[n2] = extraGap[n2] + 1;
                            --leftover;
                        }
                    }
                    ++i;
                }
            }
        } else if (remaining < 0 && minCount > 0) {
            remaining = -remaining;
            if (fillCount > 0) {
                remaining = BlockToolbar.trimSpace(children, layout, sizes, remaining, true);
            }
            if (remaining > 0) {
                remaining = BlockToolbar.trimSpace(children, layout, sizes, remaining, false);
            }
        }
        x = left;
        int i2 = 0;
        while (i2 < children.length) {
            int vSize = layout[i2].mFillRowHeight ? height + 2 : sizes[i2].y;
            children[i2].setBounds(x, y + (height - vSize) / 2, sizes[i2].x, vSize);
            x += sizes[i2].x + layout[i2].mGap + extraGap[i2];
            ++i2;
        }
        return height;
    }

    private static final int trimSpace(Block[] children, LayoutData[] layout, Point[] sizes, int remaining, boolean fillOnly) {
        int[] excess = new int[children.length];
        int total = 0;
        int i = 0;
        while (i < children.length) {
            int amt;
            if ((!fillOnly || layout[i].mFill) && layout[i].mMinimumWidth > 0 && (amt = sizes[i].x - layout[i].mMinimumWidth) > 0) {
                excess[i] = amt;
                total += amt;
            }
            ++i;
        }
        if (total <= remaining) {
            i = 0;
            while (i < children.length) {
                if (excess[i] > 0) {
                    sizes[i].x -= excess[i];
                    remaining -= excess[i];
                }
                ++i;
            }
        } else {
            int base = remaining;
            int i2 = 0;
            while (i2 < children.length) {
                if (excess[i2] > 0) {
                    double ratio = (double)excess[i2] / (double)total;
                    int amt = (int)((double)base * ratio);
                    if (amt > excess[i2]) {
                        amt = excess[i2];
                    }
                    sizes[i2].x -= amt;
                    remaining -= amt;
                }
                ++i2;
            }
        }
        return remaining;
    }

    public BlockToolbar() {
        this.setBackgroundColor(Colors.getWidgetBackground());
        this.setLayout(this);
    }

    public final BlockImageButton addAction(Action action) {
        BlockImageButton button = new BlockImageButton(action);
        this.add(button);
        return button;
    }

    public final void addFlexibleSpace() {
        Block block = new Block();
        block.setLayoutData(new LayoutData().setFlexibleGap());
        this.add(block);
    }

    public final void forceAllImageButtonsToSameSize() {
        BlockImageButton button;
        Block child;
        int width = 0;
        int height = 0;
        int i = this.getChildCount();
        while (--i >= 0) {
            child = this.getChild(i);
            if (!(child instanceof BlockImageButton)) continue;
            button = (BlockImageButton)child;
            width = Math.max(button.getPreferredImageWidth(), width);
            height = Math.max(button.getPreferredImageHeight(), height);
        }
        i = this.getChildCount();
        while (--i >= 0) {
            child = this.getChild(i);
            if (!(child instanceof BlockImageButton)) continue;
            button = (BlockImageButton)child;
            button.setPreferredImageSize(width, height);
        }
        this.layout();
    }

    public final int getLeftMargin() {
        return this.mLeftMargin;
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        return this.getSize(false);
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        return this.getSize(true);
    }

    public final int getRightMargin() {
        return this.mRightMargin;
    }

    public final int getVSpacing() {
        return this.mVSpacing;
    }

    @Override
    public final void layout(Block target) {
        Block[] children = this.getChildren();
        ArrayList<Block[]> rows = new ArrayList<Block[]>();
        int next = 0;
        int i = 1;
        while (i < children.length) {
            Object ld = children[i].getLayoutData();
            if (ld instanceof LayoutData && ((LayoutData)ld).mStartNewRow) {
                Block[] row = new Block[i - next];
                System.arraycopy(children, next, row, 0, i - next);
                rows.add(row);
                next = i;
            }
            ++i;
        }
        if (children.length > 0) {
            Block[] row = new Block[children.length - next];
            System.arraycopy(children, next, row, 0, children.length - next);
            rows.add(row);
        }
        Rectangle bounds = this.getLocalBounds();
        ++bounds.y;
        bounds.height -= 2;
        int vSpacing = this.getVSpacing();
        int top = bounds.y + vSpacing;
        int left = bounds.x + this.getLeftMargin();
        int width = bounds.width - (this.getLeftMargin() + this.getRightMargin());
        for (Block[] row : rows) {
            top += BlockToolbar.layoutRow(row, top, left, width) + vSpacing;
        }
    }

    public final void setLeftMargin(int width) {
        this.mLeftMargin = width;
    }

    public final void setRightMargin(int width) {
        this.mRightMargin = width;
    }

    public final void setShowsBorderLines(boolean show) {
        this.mShowsBorderLines = show;
    }

    public final void setVSpacing(int vSpacing) {
        this.mVSpacing = vSpacing;
    }

    public final boolean showsBorderLines() {
        return this.mShowsBorderLines;
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        if (this.mShowsBorderLines) {
            Rectangle bounds = this.getLocalBounds();
            gc.setForeground(Colors.getWidgetNormalShadow());
            int right = bounds.x + bounds.width - 1;
            gc.drawLine(bounds.x, bounds.y, right, bounds.y);
            int bottom = bounds.y + bounds.height - 1;
            gc.drawLine(bounds.x, bottom, right, bottom);
        }
    }

    private final Point getSize(boolean preferred) {
        int width = 0;
        int height = 0;
        int rowWidth = 0;
        int rowHeight = 0;
        int rows = 1;
        int columns = 0;
        int lastGap = 0;
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            Block child = this.getChild(i);
            int gap = 0;
            Object ld = child.getLayoutData();
            if (ld instanceof LayoutData) {
                LayoutData layout = (LayoutData)ld;
                if (layout.mStartNewRow) {
                    height += rowHeight;
                    if ((rowWidth -= lastGap) > width) {
                        width = rowWidth;
                    }
                    if (rows != 1 || columns != 0) {
                        ++rows;
                    }
                    columns = 0;
                    rowHeight = 0;
                    rowWidth = 0;
                    lastGap = 0;
                }
                gap = layout.mGap;
            }
            Point size = preferred ? child.getPreferredSize(-1, -1) : child.getMinimumSize(-1, -1);
            rowWidth += size.x + gap;
            if (rowHeight < size.y) {
                rowHeight = size.y;
            }
            ++columns;
            lastGap = gap;
            ++i;
        }
        if (rowWidth > width) {
            width = rowWidth;
        }
        Point size = new Point(this.getLeftMargin() + (width -= lastGap) + this.getRightMargin(), height + rowHeight + this.getVSpacing() * (1 + rows));
        if (this.mShowsBorderLines) {
            size.y += 2;
        }
        return size;
    }

    public static class LayoutData {
        public int mGap;
        public int mMinimumWidth;
        public boolean mFillRowHeight;
        public boolean mFill;
        public boolean mFlexibleGap;
        public boolean mStartNewRow;

        public final LayoutData setFill() {
            this.mFill = true;
            return this;
        }

        public final LayoutData setFillRowHeight() {
            this.mFillRowHeight = true;
            return this;
        }

        public final LayoutData setFlexibleGap() {
            this.mFlexibleGap = true;
            return this;
        }

        public final LayoutData setGap(int gap) {
            this.mGap = gap;
            return this;
        }

        public final LayoutData setMinimumWidth(int width) {
            this.mMinimumWidth = width;
            return this;
        }

        public final LayoutData setStartNewRow() {
            this.mStartNewRow = true;
            return this;
        }
    }
}

