/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockComposite;
import com.arm.streamline.widget.lightweight.PrecisionLayout;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class BlockRoot
extends Block {
    private BlockComposite mOwner;
    private TIntObjectHashMap<Runnable> mCharacterMap = new TIntObjectHashMap();
    private List<KeyInfo> mKeyInfoList = new ArrayList<KeyInfo>();
    private BlockRoot mKeyDestination;

    public BlockRoot(BlockComposite owner) {
        this.mOwner = owner;
        this.setBackgroundColor(Colors.getWidgetBackground());
        this.setLayout(new PrecisionLayout());
    }

    public final void addKeyCodeHandler(Runnable handler, int code, int modifiers) {
        if (this.mKeyDestination != null) {
            this.mKeyDestination.addKeyCodeHandler(handler, code, modifiers);
        } else {
            this.mKeyInfoList.add(new KeyInfo(code, modifiers, handler));
        }
    }

    public final void addKeyHandler(Runnable handler, char ... ch) {
        if (this.mKeyDestination != null) {
            this.mKeyDestination.addKeyHandler(handler, ch);
        } else {
            char[] cArray = ch;
            int n = ch.length;
            int n2 = 0;
            while (n2 < n) {
                char one = cArray[n2];
                this.mCharacterMap.put((int)one, (Object)handler);
                ++n2;
            }
        }
    }

    public final BlockRoot getKeyDestination() {
        return this.mKeyDestination;
    }

    @Override
    public final BlockComposite getOwner() {
        return this.mOwner;
    }

    public final boolean isKeyHandlerUsed(char ch) {
        return this.mKeyDestination != null ? this.mKeyDestination.isKeyHandlerUsed(ch) : this.mCharacterMap.contains((int)ch);
    }

    @Override
    public final void repaint(int x, int y, int width, int height) {
        if (Display.getCurrent() == null) {
            SafeUpdate.redraw((Control)this.mOwner, x, y, width, height);
        } else if (this.mOwner != null && !this.mOwner.isDisposed()) {
            this.mOwner.redraw(x, y, width, height, false);
        }
    }

    public final void setKeyDestination(BlockRoot other) {
        if (other != this) {
            this.mKeyDestination = other;
        }
    }

    @Override
    protected final boolean keyPressed(int code, char ch, int location, int stateMask) {
        Runnable runnable;
        if (this.mKeyDestination != null) {
            return this.mKeyDestination.keyPressed(code, ch, location, stateMask);
        }
        if ((stateMask & SWT.MODIFIER_MASK & ~SWT.MOD2) == 0 && (runnable = (Runnable)this.mCharacterMap.get((int)ch)) != null) {
            runnable.run();
            return true;
        }
        for (KeyInfo keyInfo : this.mKeyInfoList) {
            if (keyInfo.mCode != code || keyInfo.mModifiers != (stateMask & SWT.MODIFIER_MASK)) continue;
            keyInfo.mRunnable.run();
            return true;
        }
        return super.keyPressed(code, ch, location, stateMask);
    }

    private static class KeyInfo {
        int mCode;
        int mModifiers;
        Runnable mRunnable;

        KeyInfo(int code, int modifiers, Runnable runnable) {
            this.mCode = code;
            this.mModifiers = modifiers;
            this.mRunnable = runnable;
        }
    }
}

