/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.utility.text.TextDrawingState;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class BlockLabel
extends Block {
    private String mText = "";
    private Font mFont = Fonts.getNormal();
    private Color mForegroundColor = Colors.getWidgetForeground();
    private int mAlignment = 16384;

    public BlockLabel() {
    }

    public BlockLabel(String text) {
        this.mText = text;
    }

    public BlockLabel(String text, int alignment) {
        this.mText = text;
        this.mAlignment = alignment;
    }

    public BlockLabel(String text, String tooltip) {
        this.mText = text;
        this.setToolTip(tooltip);
    }

    public BlockLabel(String text, String tooltip, int alignment) {
        this.mText = text;
        this.mAlignment = alignment;
        this.setToolTip(tooltip);
    }

    public final Font getFont() {
        return this.mFont;
    }

    public final Color getForegroundColor() {
        return this.mForegroundColor;
    }

    @Override
    public final Point getMinimumSize(int widthHint, int heightHint) {
        GC gc = this.createTemporaryGC();
        TextDrawingState state = new TextDrawingState(gc);
        gc.setFont(this.mFont);
        Point size = gc.stringExtent(this.mText);
        state.restore();
        gc.dispose();
        return size;
    }

    @Override
    public final Point getPreferredSize(int widthHint, int heightHint) {
        return this.getMinimumSize(widthHint, heightHint);
    }

    public final void setFont(Font font) {
        if (!this.mFont.equals((Object)font)) {
            this.mFont = font;
            this.repaint();
        }
    }

    public final void setForegroundColor(Color color) {
        if (this.mForegroundColor == null ? color != null : !this.mForegroundColor.equals((Object)color)) {
            this.mForegroundColor = color;
            this.repaint();
        }
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        Rectangle bounds = this.getLocalBounds();
        gc.setFont(this.mFont);
        gc.setForeground(this.getForegroundColor());
        TextDrawing.drawString(gc, this.mText, bounds.x, bounds.y, bounds.width, bounds.height, this.mAlignment, 0x1000000);
    }
}

