/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;

public class BlockColorWell
extends Block {
    private RGB mRGB;
    private List<IColorChangedListener> mListeners = new ArrayList<IColorChangedListener>();

    public BlockColorWell(RGB color) {
        this.mRGB = new RGB(color.red, color.green, color.blue);
    }

    public final synchronized void addColorChangedListener(IColorChangedListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public final Point getMinimumSize(int widthHint, int heightHint) {
        return new Point(16, 16);
    }

    @Override
    public final Point getPreferredSize(int widthHint, int heightHint) {
        return this.getMinimumSize(widthHint, heightHint);
    }

    public RGB getRGB() {
        return new RGB(this.mRGB.red, this.mRGB.green, this.mRGB.blue);
    }

    public final synchronized void removeColorChangedListener(IColorChangedListener listener) {
        this.mListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRGB(RGB rgb) {
        IColorChangedListener[] listeners;
        this.mRGB.red = rgb.red;
        this.mRGB.green = rgb.green;
        this.mRGB.blue = rgb.blue;
        this.repaint();
        BlockColorWell blockColorWell = this;
        synchronized (blockColorWell) {
            listeners = this.mListeners.toArray(new IColorChangedListener[this.mListeners.size()]);
        }
        IColorChangedListener[] iColorChangedListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IColorChangedListener listener = iColorChangedListenerArray[n2];
            listener.colorChanged(this.getRGB());
            ++n2;
        }
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (button == 1) {
            ColorDialog dialog = new ColorDialog(this.getShell());
            dialog.setRGB(this.mRGB);
            RGB rgb = dialog.open();
            if (rgb != null) {
                this.setRGB(rgb);
            }
        }
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        Rectangle bounds = this.getLocalBounds();
        gc.setBackground(Colors.create(this.mRGB));
        gc.fillRectangle(bounds);
        gc.setForeground(Colors.getBlack());
        gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        gc.setForeground(Colors.getWhite());
        gc.drawRectangle(bounds.x + 1, bounds.y + 1, bounds.width - 3, bounds.height - 3);
    }

    public static interface IColorChangedListener {
        public void colorChanged(RGB var1);
    }
}

