/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class BlockCheckBox
extends Block {
    private static final Rectangle IMG_BOUNDS;
    private static final Image DISABLED_CHECKBOX_BACKGROUND;
    private static final Image DISABLED_CHECKBOX_BACKGROUND_PRESSED;
    private static final Image DISABLED_CHECKMARK;
    private static final int MARGIN = 2;
    private String mText;
    private Font mFont = Fonts.getNormal();
    private Color mForegroundColor = Colors.getWidgetForeground();
    private boolean mInMouseDown;
    protected boolean mPressed;
    private boolean mChecked;
    private Set<ICheckBoxListener> mCheckBoxListeners = new HashSet<ICheckBoxListener>();

    static {
        Image image = StreamlinePlugin.getImage("CheckBoxBackground.png");
        IMG_BOUNDS = image.getBounds();
        DISABLED_CHECKBOX_BACKGROUND = new Image(image.getDevice(), image, 1);
        image = StreamlinePlugin.getImage("CheckBoxBackgroundPressed.png");
        DISABLED_CHECKBOX_BACKGROUND_PRESSED = new Image(image.getDevice(), image, 1);
        image = StreamlinePlugin.getImage("Checkmark.png");
        DISABLED_CHECKMARK = new Image(image.getDevice(), image, 1);
    }

    public BlockCheckBox() {
    }

    public BlockCheckBox(String title) {
        this.mText = title;
    }

    public BlockCheckBox(String title, String tooltip) {
        this.mText = title;
        this.setToolTip(tooltip);
    }

    public final synchronized void addCheckBoxListener(ICheckBoxListener listener) {
        this.mCheckBoxListeners.add(listener);
    }

    public final Font getFont() {
        return this.mFont;
    }

    public final Color getForegroundColor() {
        return this.mForegroundColor;
    }

    @Override
    public final Point getMinimumSize(int widthHint, int heightHint) {
        Point size;
        if (this.mText != null && !this.mText.isEmpty()) {
            GC gc = this.createTemporaryGC();
            gc.setFont(this.mFont);
            size = gc.stringExtent(this.mText);
            gc.dispose();
            size.x += 2;
        } else {
            size = new Point(0, 0);
        }
        size.x += BlockCheckBox.IMG_BOUNDS.width + 4;
        if (size.y < BlockCheckBox.IMG_BOUNDS.height) {
            size.y = BlockCheckBox.IMG_BOUNDS.height;
        }
        size.y += 4;
        return size;
    }

    @Override
    public final Point getPreferredSize(int widthHint, int heightHint) {
        return this.getMinimumSize(widthHint, heightHint);
    }

    public final boolean isChecked() {
        return this.mChecked;
    }

    public final synchronized void removeCheckBoxListener(ICheckBoxListener listener) {
        this.mCheckBoxListeners.remove(listener);
    }

    public final void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.repaint();
        }
    }

    public final void setFont(Font font) {
        if (!this.mFont.equals((Object)font)) {
            this.mFont = font;
            this.repaint();
        }
    }

    public final void setForegroundColor(Color color) {
        if (this.mForegroundColor == null ? color != null : !this.mForegroundColor.equals((Object)color)) {
            this.mForegroundColor = color;
            this.repaint();
        }
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1) {
            this.mInMouseDown = true;
            this.mPressed = true;
            this.repaint();
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mInMouseDown) {
            boolean wasPressed = this.mPressed;
            this.mPressed = this.getLocalBounds().contains(where);
            if (this.mPressed != wasPressed) {
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mInMouseDown) {
            this.mInMouseDown = false;
            this.mPressed = false;
            this.repaint();
            if (this.getLocalBounds().contains(where)) {
                ICheckBoxListener[] listeners;
                this.mChecked = !this.mChecked;
                BlockCheckBox blockCheckBox = this;
                synchronized (blockCheckBox) {
                    listeners = this.mCheckBoxListeners.toArray(new ICheckBoxListener[this.mCheckBoxListeners.size()]);
                }
                ICheckBoxListener[] iCheckBoxListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ICheckBoxListener listener = iCheckBoxListenerArray[n2];
                    listener.checkBoxClicked(this);
                    ++n2;
                }
            }
        }
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        boolean enabled = this.isEnabled();
        Rectangle bounds = this.getLocalBounds();
        int savedAA = gc.getAntialias();
        gc.setAntialias(1);
        Image img = enabled ? StreamlinePlugin.getImage(this.mPressed ? "CheckBoxBackgroundPressed.png" : "CheckBoxBackground.png") : (this.mPressed ? DISABLED_CHECKBOX_BACKGROUND_PRESSED : DISABLED_CHECKBOX_BACKGROUND);
        gc.drawImage(img, bounds.x + 2, bounds.y + (bounds.height - BlockCheckBox.IMG_BOUNDS.height) / 2);
        if (this.mChecked) {
            img = enabled ? StreamlinePlugin.getImage("Checkmark.png") : DISABLED_CHECKMARK;
            gc.drawImage(img, bounds.x + 2, bounds.y + (bounds.height - BlockCheckBox.IMG_BOUNDS.height) / 2);
        }
        gc.setAntialias(savedAA);
        int advance = BlockCheckBox.IMG_BOUNDS.width + 4;
        int width = bounds.width - advance;
        if (width > 0) {
            gc.setFont(this.mFont);
            gc.setForeground(this.getForegroundColor());
            TextDrawing.drawString(gc, this.mText, bounds.x + advance, bounds.y, width, bounds.height, 16384, 0x1000000);
        }
    }

    public static interface ICheckBoxListener {
        public void checkBoxClicked(BlockCheckBox var1);
    }
}

