/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.categorybrowser;

import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.widget.categorybrowser.CategoryBrowserMessages;
import com.arm.streamline.widget.categorybrowser.CategoryRow;
import com.arm.streamline.widget.categorybrowser.ConnectionOutline;
import com.arm.streamline.widget.outline.IOutlineListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class BaseBrowser
extends TitleAreaDialog
implements IOutlineListener<SimpleColumn> {
    private IDialogSettings mSettings;
    private Composite mContent;
    private ConnectionOutline mOutline;
    private String mFailureMsg;
    private Row<SimpleColumn> mSelection;

    protected BaseBrowser(IDialogSettings settings) {
        super(WorkspaceUtils.getShell());
        this.setShellStyle(0x10 | this.getShellStyle());
        this.mSettings = settings;
    }

    @Override
    public void deleteSelectionRequested(Outline<SimpleColumn> outline) {
    }

    @Override
    public void editorChanged(Outline<SimpleColumn> outline) {
    }

    public Outline<SimpleColumn> getOutline() {
        return this.mOutline;
    }

    @Override
    public void openSelectionRequested(Outline<SimpleColumn> outline) {
        List selection = this.mOutline.getModel().getSelectionAsList();
        if (!selection.isEmpty() && selection.size() == 1 && this.isSelectedRowValid(selection.get(0))) {
            this.okPressed();
        }
    }

    @Override
    public void selectionChanged(Outline<SimpleColumn> outline) {
        Row<SimpleColumn> row;
        this.mSelection = null;
        OutlineModel model = this.mOutline.getModel();
        if (model.getSelectionCount() == 1 && this.isSelectedRowValid(row = model.getSelectionAsList().get(0))) {
            this.mSelection = row;
            this.clearDefaultSelection();
        }
        this.adjustAcceptance();
    }

    protected void adjustAcceptance() {
        String msg = this.mFailureMsg;
        if (msg == null) {
            OutlineModel model = this.mOutline.getModel();
            if (model.getSelectionCount() == 1) {
                Row<SimpleColumn> row = model.getSelectionAsList().get(0);
                if (!this.isSelectedRowValid(row)) {
                    msg = this.getReasonForInvalidRow(row);
                }
            } else {
                msg = CategoryBrowserMessages.MUST_SELECT_ONE;
            }
        }
        this.setErrorMessage(msg);
        this.getButton(0).setEnabled(msg == null);
    }

    protected abstract void clearDefaultSelection();

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected abstract void configureSort();

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.getButton(0).setText(CategoryBrowserMessages.SELECT);
        this.adjustAcceptance();
        return control;
    }

    protected Composite createDialogArea(Composite parent) {
        this.setTitle(this.getTitle());
        this.setMessage(this.getDefaultMessage());
        this.mContent = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayoutFactory.swtDefaults().applyTo(this.mContent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mContent);
        OutlineModel<SimpleColumn> model = new OutlineModel<SimpleColumn>();
        model.addColumns(this.getColumns());
        this.mOutline = new ConnectionOutline(this.mContent, model);
        this.loadInitialData();
        this.configureSort();
        model.sort();
        this.mOutline.addOutlineListener(this);
        GridDataFactory.fillDefaults().minSize(150, 50).grab(true, true).applyTo((Control)this.mOutline);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.mContent, this.getHelpID());
        return this.mContent;
    }

    protected CategoryRow findCategoryRow(String name) {
        for (Row one : this.mOutline.getModel().getTopLevelRows()) {
            CategoryRow cr;
            if (!(one instanceof CategoryRow) || !name.equals((cr = (CategoryRow)one).getName())) continue;
            return cr;
        }
        return null;
    }

    protected abstract @NonNull List<@NonNull SimpleColumn> getColumns();

    protected Composite getContent() {
        return this.mContent;
    }

    protected abstract String getDefaultMessage();

    protected IDialogSettings getDialogBoundsSettings() {
        return this.mSettings;
    }

    protected abstract String getHelpID();

    protected abstract String getReasonForInvalidRow(Row<SimpleColumn> var1);

    protected Row<SimpleColumn> getSelectedRow() {
        return this.mSelection;
    }

    protected abstract String getTitle();

    protected void initializeBounds() {
        this.adjustAcceptance();
        super.initializeBounds();
    }

    protected abstract boolean isSelectedRowValid(Row<SimpleColumn> var1);

    protected abstract void loadInitialData();

    protected void setFailureMessage(String msg) {
        this.mFailureMsg = msg;
    }

    protected void updateOutline() {
        this.configureSort();
        this.mOutline.getModel().sort();
        this.mOutline.sizeColumnsToFit();
        this.mOutline.adjustScrollBarsForContent();
        this.mOutline.scrollSelectionIntoView(true);
        this.mOutline.redraw();
    }
}

