/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import java.util.ArrayList;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WidgetUtils {
    public static void disposeAllChildren(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public static Composite getAncestorOfType(Control control, Class<?> type) {
        Composite parent = control.getParent();
        while (parent != null && !type.isAssignableFrom(parent.getClass())) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static int getChildIndex(Composite parent, Control child) {
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Monitor getClosestMonitor(Display display, Point location) {
        int closest = Integer.MAX_VALUE;
        Monitor[] monitors = display.getMonitors();
        Monitor result = null;
        Monitor[] monitorArray = monitors;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor current = monitorArray[n2];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(location)) {
                return current;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)location);
            if (distance < closest) {
                closest = distance;
                result = current;
            }
            ++n2;
        }
        return result != null ? result : monitors[0];
    }

    public static Composite getCommonAncestor(Control one, Control two) {
        ArrayList<Composite> parents = new ArrayList<Composite>();
        Composite parent = one.getParent();
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        parent = two.getParent();
        while (parent != null) {
            if (parents.contains(parent)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static Rectangle getConstrainedShellBounds(Display display, Rectangle preferredSize) {
        Rectangle result = new Rectangle(preferredSize.x, preferredSize.y, preferredSize.width, preferredSize.height);
        Monitor mon = WidgetUtils.getClosestMonitor(display, Geometry.centerPoint((Rectangle)result));
        Rectangle bounds = mon.getClientArea();
        if (result.height > bounds.height) {
            result.height = bounds.height;
        }
        if (result.width > bounds.width) {
            result.width = bounds.width;
        }
        result.x = Math.max(bounds.x, Math.min(result.x, bounds.x + bounds.width - result.width));
        result.y = Math.max(bounds.y, Math.min(result.y, bounds.y + bounds.height - result.height));
        return result;
    }

    public static boolean isChildOf(Composite composite, Control child) {
        Composite parent = child.getParent();
        while (parent != null && parent != composite) {
            parent = parent.getParent();
        }
        return parent == composite;
    }

    public static final boolean isModalDialogShowing() {
        return WidgetUtils.isModalDialogShowing(PlatformUI.getWorkbench().getDisplay().getShells());
    }

    public static final boolean isModalDialogShowing(Shell[] shells) {
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (shell.isVisible() && (shell.getStyle() & 0x38000) != 0) {
                return true;
            }
            if (WidgetUtils.isModalDialogShowing(shell.getShells())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void layoutCommonAncestor(Control one, Control two) {
        Composite commonParent = WidgetUtils.getCommonAncestor(one, two);
        if (commonParent != null) {
            commonParent.layout();
        }
    }
}

