/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.widget.ConsolidatedUIExec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SafeUpdate
implements Runnable {
    private static Map<Control, Data> PENDING = new HashMap<Control, Data>();
    private static boolean PROCESSING;

    public static final void immediate() {
        new SafeUpdate().run();
    }

    public static final void layout(Composite composite) {
        SafeUpdate.post((Control)composite, new Data(Op.LAYOUT));
    }

    public static final void pack(Composite composite) {
        SafeUpdate.post((Control)composite, new Data(Op.PACK));
    }

    public static final void pack(Composite composite, int width, int height) {
        SafeUpdate.post((Control)composite, new Data(Op.PACK, new Point(width, height)));
    }

    public static final void redraw(Control control) {
        SafeUpdate.post(control, new Data(Op.REDRAW));
    }

    public static final void redraw(Control control, int x, int y, int width, int height) {
        SafeUpdate.post(control, new Data(Op.REDRAW, new Rectangle(x, y, width, height)));
    }

    private static final void execute(Control control, Data data, Set<Display> displays) {
        if (!control.isDisposed()) {
            if (displays != null) {
                displays.add(control.getDisplay());
            }
            if (data.mBounds != null) {
                control.redraw(data.mBounds.x, data.mBounds.y, data.mBounds.width, data.mBounds.height, true);
            } else {
                Point size = control.getSize();
                control.redraw(0, 0, size.x, size.y, true);
            }
            if (control instanceof Composite) {
                Composite comp = (Composite)control;
                switch (data.mOp) {
                    case PACK: {
                        if (data.mSize != null) {
                            comp.setSize(comp.computeSize(data.mSize.x, data.mSize.y, true));
                        } else {
                            comp.setSize(comp.computeSize(-1, -1, true));
                        }
                    }
                    case LAYOUT: {
                        comp.layout(true, true);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void post(Control control, Data data) {
        if (PROCESSING && Display.getCurrent() != null) {
            SafeUpdate.execute(control, data, null);
            return;
        }
        boolean needExec = false;
        Class<SafeUpdate> clazz = SafeUpdate.class;
        synchronized (SafeUpdate.class) {
            Data existing = PENDING.get(control);
            if (existing == null) {
                needExec = PENDING.isEmpty();
                PENDING.put(control, data);
            } else {
                switch (data.mOp) {
                    case REDRAW: {
                        if (existing.mOp != Op.REDRAW) break;
                        if (data.mBounds == null) {
                            existing.mBounds = null;
                            break;
                        }
                        if (existing.mBounds == null) break;
                        existing.mBounds.add(data.mBounds);
                        break;
                    }
                    case LAYOUT: {
                        if (existing.mOp != Op.REDRAW) break;
                        existing.mOp = data.mOp;
                        break;
                    }
                    case PACK: {
                        if (existing.mOp != Op.PACK) {
                            existing.mSize = data.mSize;
                        } else if (data.mSize == null) {
                            existing.mSize = null;
                        } else if (existing.mSize != null) {
                            existing.mSize = data.mSize;
                        }
                        existing.mOp = data.mOp;
                        break;
                    }
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (needExec) {
                ConsolidatedUIExec.exec(control, SafeUpdate.class, new SafeUpdate(), true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SSD_DO_NOT_USE_INSTANCE_LOCK_ON_SHARED_STATIC_DATA"})
    private static final void runStatic() {
        Class<SafeUpdate> clazz = SafeUpdate.class;
        synchronized (SafeUpdate.class) {
            Map<Control, Data> map = PENDING;
            PENDING = new HashMap<Control, Data>();
            // ** MonitorExit[var1] (shouldn't be in output)
            PROCESSING = true;
            HashSet<Display> displays = new HashSet<Display>();
            for (Map.Entry<Control, Data> entry : map.entrySet()) {
                SafeUpdate.execute(entry.getKey(), entry.getValue(), displays);
            }
            PROCESSING = false;
            for (Display display : displays) {
                display.update();
            }
            return;
        }
    }

    private SafeUpdate() {
    }

    @Override
    public final void run() {
        SafeUpdate.runStatic();
    }

    private static class Data {
        Op mOp;
        Point mSize;
        Rectangle mBounds;

        Data(Op op) {
            this.mOp = op;
        }

        Data(Op op, Point size) {
            this.mOp = op;
            this.mSize = size;
        }

        Data(Op op, Rectangle bounds) {
            this.mOp = op;
            this.mBounds = bounds;
        }
    }

    private static enum Op {
        REDRAW,
        LAYOUT,
        PACK;

    }
}

