/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.widget.FontInfo;
import com.arm.utils.Platform;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class Fonts
implements IPropertyChangeListener {
    private static Font NORMAL = null;
    private static Font STANDOUT = null;
    private static Font SMALL = null;
    private static Font SOURCE = null;
    private static final Map<FontData, Font> SIMPLE_CACHE = new HashMap<FontData, Font>();
    private static final Map<FontKey, Font> EXACT_CACHE = new HashMap<FontKey, Font>();

    static {
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)new Fonts());
        Fonts.generateDialogFonts();
        Fonts.generateEditorFonts();
    }

    public static final Font createFontWithPixelHeight(String name, int pixelHeight, int style) {
        FontData data = new FontData(name, pixelHeight, style);
        Device device = JFaceResources.getDefaultFont().getDevice();
        Font font = new Font(device, data);
        FontInfo info = FontInfo.get(font);
        if (info.getHeight() <= pixelHeight) {
            do {
                data.setHeight(data.getHeight() + 1);
                font.dispose();
            } while ((info = FontInfo.get(font = new Font(device, data))).getHeight() <= pixelHeight);
            data.setHeight(data.getHeight() - 1);
        } else {
            do {
                data.setHeight(data.getHeight() - 1);
                font.dispose();
            } while ((info = FontInfo.get(font = new Font(device, data))).getHeight() > pixelHeight);
        }
        font.dispose();
        return new Font(device, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Font getFontWithPixelHeight(Font font, int pixelHeight) {
        Font result;
        FontKey key = new FontKey(font, pixelHeight);
        Map<FontKey, Font> map = EXACT_CACHE;
        synchronized (map) {
            result = EXACT_CACHE.get(key);
            if (result == null) {
                result = Fonts.createFontWithPixelHeight(key.mName, key.mPixelHeight, key.mStyle);
                EXACT_CACHE.put(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Font getFontWithStyle(Font font, int style, double scale) {
        Font result;
        FontData[] fontData = font.getFontData();
        if (scale == 1.0 && Arrays.stream(fontData).allMatch(f -> f.getStyle() == style)) {
            return font;
        }
        FontData[] fontDataArray = fontData;
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setStyle(style & 3);
            element.setHeight((int)Math.ceil((double)element.getHeight() * scale));
            ++n2;
        }
        Map<FontData, Font> map = SIMPLE_CACHE;
        synchronized (map) {
            result = SIMPLE_CACHE.get(fontData[0]);
            if (result == null) {
                result = new Font(font.getDevice(), fontData);
                SIMPLE_CACHE.put(fontData[0], result);
            }
        }
        return result;
    }

    public static final synchronized Font getNormal() {
        return NORMAL;
    }

    public static final synchronized Font getNormalStandout() {
        return STANDOUT;
    }

    public static final synchronized Font getSmall() {
        return SMALL;
    }

    public static final Font getSource() {
        return SOURCE;
    }

    private static final synchronized void generateDialogFonts() {
        double smallScale = Platform.isWindows() ? 0.875 : 0.75;
        Font font = JFaceResources.getDialogFont();
        NORMAL = Fonts.getFontWithStyle(font, 0, 1.0);
        STANDOUT = Fonts.getFontWithStyle(font, 1, 1.0);
        SMALL = Fonts.getFontWithStyle(font, 0, smallScale);
    }

    private static final synchronized void generateEditorFonts() {
        double smallScale = 0.875;
        SOURCE = Fonts.getFontWithStyle(JFaceResources.getTextFont(), 0, 0.875);
    }

    private Fonts() {
    }

    public final void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("org.eclipse.jface.dialogfont".equals(property)) {
            Fonts.generateDialogFonts();
        } else if ("org.eclipse.jface.textfont".equals(property)) {
            Fonts.generateEditorFonts();
        }
    }

    private static class FontKey {
        String mName;
        int mPixelHeight;
        int mStyle;

        FontKey(Font font, int pixelHeight) {
            FontData fontData = font.getFontData()[0];
            this.mName = fontData.getName();
            this.mPixelHeight = pixelHeight;
            this.mStyle = fontData.getStyle();
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FontKey) {
                FontKey other = (FontKey)obj;
                return this.mPixelHeight == other.mPixelHeight && this.mStyle == other.mStyle && this.mName.equals(other.mName);
            }
            return false;
        }

        public final int hashCode() {
            return this.mName.hashCode() ^ this.mPixelHeight << 8 ^ this.mStyle;
        }
    }
}

