/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.utility.text.TextDrawingState;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class FontInfo {
    private static final Map<FontData, FontInfo> CACHE = new HashMap<FontData, FontInfo>();
    private GC mMeasurementGC = new GC((Drawable)new Image(null, 8, 8));
    private FontData mFontData;
    private int mLeading;
    private int mAscent;
    private int mDescent;
    private double mAverageCharWidth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final @NonNull FontInfo get(Font font) {
        FontInfo result;
        FontData fontData = font.getFontData()[0];
        Map<FontData, FontInfo> map = CACHE;
        synchronized (map) {
            result = CACHE.get(fontData);
            if (result == null) {
                result = new FontInfo(font, fontData);
                CACHE.put(fontData, result);
            }
        }
        return result;
    }

    private static final int findFirstPixel(ImageData data, int width, int height) {
        int pattern = data.getPixel(0, 0);
        int y = 2;
        while (y < height) {
            int x = 0;
            while (x < width) {
                if ((data.getPixel(x, y) & pattern) != pattern) {
                    return y - 2;
                }
                ++x;
            }
            ++y;
        }
        return 2;
    }

    private static final int findLastPixel(ImageData data, int width, int height) {
        int pattern = data.getPixel(0, 0);
        int y = height - 1;
        while (y >= 2) {
            int x = 0;
            while (x < width) {
                if ((data.getPixel(x, y) & pattern) != pattern) {
                    return y - 2;
                }
                ++x;
            }
            --y;
        }
        return height - 3;
    }

    private static final ImageData getImageData(Image img, int width, int height, Font font, String text) {
        GC gc = new GC((Drawable)img);
        TextDrawingState.enable(gc);
        Device device = gc.getDevice();
        Color white = new Color(device, 255, 255, 255);
        gc.setBackground(white);
        gc.fillRectangle(0, 0, width, height);
        Color black = new Color(device, 0, 0, 0);
        gc.setForeground(black);
        gc.setFont(font);
        gc.drawString(text, 2, 2);
        gc.dispose();
        white.dispose();
        black.dispose();
        return img.getImageData();
    }

    private FontInfo(Font font, FontData fontData) {
        this.mMeasurementGC.setFont(new Font(this.mMeasurementGC.getDevice(), fontData));
        this.mAverageCharWidth = this.mMeasurementGC.getFontMetrics().getAverageCharacterWidth();
        TextDrawingState.enable(this.mMeasurementGC);
        this.mFontData = fontData;
        int size = this.mFontData.getHeight();
        int width = size * 5;
        int height = size * 4;
        Image img = new Image(null, width, height);
        ImageData data = FontInfo.getImageData(img, width, height, font, "MTyg");
        this.mLeading = FontInfo.findFirstPixel(data, width, height);
        int last = FontInfo.findLastPixel(data, width, height);
        int baseline = FontInfo.findLastPixel(FontInfo.getImageData(img, width, height, font, "MT"), width, height);
        this.mAscent = 1 + baseline - this.mLeading;
        this.mDescent = last - baseline;
        img.dispose();
    }

    public final int getAscent() {
        return this.mAscent;
    }

    public final double getAverageCharWidth() {
        return this.mAverageCharWidth;
    }

    public final int getBaseline() {
        return this.mLeading + this.mAscent - 1;
    }

    public final int getCharOffset(String text, int position) {
        if (position <= 0) {
            return 0;
        }
        int count = text.length();
        if (count > 0) {
            int lastWidth = 0;
            int i = 1;
            while (i <= count) {
                int width = this.getWidth(text.substring(0, i));
                int half = lastWidth + (width - lastWidth) / 2;
                if (position >= lastWidth && position <= half) {
                    return i - 1;
                }
                if (position < width && position > half) {
                    return i;
                }
                lastWidth = width;
                ++i;
            }
        }
        return count;
    }

    public final int getDescent() {
        return this.mDescent;
    }

    public final Point getExtent(String text) {
        if (text != null) {
            boolean lastWasReturn = true;
            int width = 0;
            int height = 0;
            int fontHeight = this.getHeight();
            StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    if (lastWasReturn) {
                        height += fontHeight;
                        continue;
                    }
                    lastWasReturn = true;
                    continue;
                }
                lastWasReturn = false;
                height += fontHeight;
                int tokenWidth = this.getWidth(token);
                if (tokenWidth <= width) continue;
                width = tokenWidth;
            }
            return new Point(width, height);
        }
        return new Point(0, 0);
    }

    public final int getHeight() {
        return this.mLeading + this.mAscent + this.mDescent;
    }

    public final int getLeading() {
        return this.mLeading;
    }

    public final int getMaxWidth() {
        return this.getWidth("M");
    }

    public final GC getMeasurementGC() {
        return this.mMeasurementGC;
    }

    public final int getWidth(String text) {
        return this.mMeasurementGC.stringExtent((String)text).x;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FontInfo[name: ");
        buffer.append(this.mFontData.getName());
        buffer.append(", point size: ");
        buffer.append(this.mFontData.getHeight());
        buffer.append(", style: ");
        buffer.append(this.mFontData.getStyle());
        buffer.append(", leading: ");
        buffer.append(this.mLeading);
        buffer.append(", ascent: ");
        buffer.append(this.mAscent);
        buffer.append(", descent: ");
        buffer.append(this.mDescent);
        buffer.append(", baseline: ");
        buffer.append(this.getBaseline());
        buffer.append(", height: ");
        buffer.append(this.getHeight());
        buffer.append(", maximum character width: ");
        buffer.append(this.getMaxWidth());
        buffer.append("]");
        return buffer.toString();
    }
}

