/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.Filler;
import com.arm.streamline.widget.ImageButton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CustomToolbar
extends Composite
implements PaintListener {
    public static final int DEFAULT_H_MARGIN = 3;
    public static final int DEFAULT_V_SPACING = 1;
    private int mLeftMargin = 3;
    private int mRightMargin = 3;
    private int mVSpacing = 1;
    private boolean mDrawBorder;

    public CustomToolbar(Composite parent) {
        this(parent, true);
    }

    public CustomToolbar(Composite parent, boolean drawBorders) {
        super(parent, 0x20000000);
        super.setLayout((Layout)new CustomToolbarLayout());
        this.addPaintListener(this);
        this.mDrawBorder = drawBorders;
    }

    public ImageButton addAction(Action action) {
        return new ImageButton((Composite)this, action);
    }

    public void addFlexibleSpace() {
        new Filler(this).setLayoutData(new LayoutData().setFlexibleGap());
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle bounds = super.computeTrim(x, y, width, height);
        --bounds.y;
        bounds.height = bounds.height + (this.mDrawBorder ? 2 : 0);
        return bounds;
    }

    public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
        Region region = new Region();
        gc.getClipping(region);
        gc.setClipping(x, y, width, height);
        Rectangle bounds = this.getClientArea();
        Color color = Colors.getWidgetBackground();
        gc.setBackground(color);
        gc.fillRectangle(bounds);
        gc.setClipping(region);
        region.dispose();
    }

    public void forceAllImageButtonsToSameSize() {
        ImageButton button;
        Control child;
        int width = 0;
        int height = 0;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            if (child instanceof ImageButton) {
                button = (ImageButton)child;
                width = Math.max(button.getPreferredImageWidth(), width);
                height = Math.max(button.getPreferredImageHeight(), height);
            }
            ++n2;
        }
        controlArray = this.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            if (child instanceof ImageButton) {
                button = (ImageButton)child;
                button.setPreferredImageSize(width, height);
            }
            ++n2;
        }
        this.layout();
        this.redraw();
    }

    public Rectangle getClientArea() {
        Rectangle bounds = super.getClientArea();
        ++bounds.y;
        bounds.height = bounds.height - (this.mDrawBorder ? 2 : 0);
        return bounds;
    }

    public int getLeftMargin() {
        return this.mLeftMargin;
    }

    public int getRightMargin() {
        return this.mRightMargin;
    }

    public int getVSpacing() {
        return this.mVSpacing;
    }

    public void paintControl(PaintEvent event) {
        com.arm.streamline.gcwrapper.GC gc = new com.arm.streamline.gcwrapper.GC(event.gc);
        Rectangle bounds = this.getClientArea();
        Color color = Colors.getWidgetBackground();
        gc.setBackground(color);
        gc.fillRectangle(bounds);
        if (this.mDrawBorder) {
            int y = bounds.y - 1;
            gc.setForeground(Colors.getWidgetNormalShadow());
            gc.drawLine(bounds.x, y, bounds.x + bounds.width - 1, y);
            y = bounds.y + bounds.height;
            gc.drawLine(bounds.x, y, bounds.x + bounds.width - 1, y);
        }
    }

    public void setLayout(Layout layout) {
    }

    public void setLeftMargin(int width) {
        this.mLeftMargin = width;
    }

    public void setRightMargin(int width) {
        this.mRightMargin = width;
    }

    public void setVSpacing(int vSpacing) {
        this.mVSpacing = vSpacing;
    }

    class CustomToolbarLayout
    extends Layout {
        CustomToolbarLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int width = 0;
            int height = 0;
            int rowWidth = 0;
            int rowHeight = 0;
            int rows = 1;
            int columns = 0;
            int lastGap = 0;
            Control[] controlArray = CustomToolbar.this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    Point size;
                    int gap;
                    block9: {
                        Control control = controlArray[n2];
                        gap = 0;
                        size = control.computeSize(-1, -1);
                        Object ld = control.getLayoutData();
                        if (!(ld instanceof LayoutData)) break block9;
                        LayoutData layout = (LayoutData)ld;
                        if (layout.mExcludeHidden && !control.getVisible()) break block10;
                        if (layout.mStartNewRow) {
                            height += rowHeight;
                            if ((rowWidth -= lastGap) > width) {
                                width = rowWidth;
                            }
                            if (rows != 1 || columns != 0) {
                                ++rows;
                            }
                            columns = 0;
                            rowHeight = 0;
                            rowWidth = 0;
                            lastGap = 0;
                        }
                        if (layout.mPreferredWidth > 0) {
                            size.x = layout.mPreferredWidth;
                        }
                        gap = layout.mGap;
                    }
                    rowWidth += size.x + gap;
                    if (rowHeight < size.y) {
                        rowHeight = size.y;
                    }
                    ++columns;
                    lastGap = gap;
                }
                ++n2;
            }
            return new Point(CustomToolbar.this.getLeftMargin() + (width -= lastGap) + CustomToolbar.this.getRightMargin(), height + rowHeight + CustomToolbar.this.getVSpacing() * (1 + rows));
        }

        protected void layout(Composite composite, boolean flushCache) {
            @NonNull ArrayList<@NonNull ArrayList<@NonNull E>> rows = new ArrayList();
            Control[] children = CustomToolbar.this.getChildren();
            ArrayList<@NonNull Control> currentRow = new ArrayList<Control>();
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                @Nullable Object _ld = element.getLayoutData();
                LayoutData layout = _ld instanceof LayoutData ? (LayoutData)_ld : null;
                Control control = element;
                if (layout == null || !layout.mExcludeHidden || control.getVisible()) {
                    if (layout != null && layout.mStartNewRow && !currentRow.isEmpty()) {
                        rows.add(currentRow);
                        currentRow = new ArrayList();
                    }
                    currentRow.add(control);
                }
                ++n2;
            }
            if (!currentRow.isEmpty()) {
                rows.add(currentRow);
            }
            Rectangle bounds = CustomToolbar.this.getClientArea();
            int vSpacing = CustomToolbar.this.getVSpacing();
            int top = bounds.y + vSpacing;
            int left = bounds.x + CustomToolbar.this.getLeftMargin();
            int width = bounds.width - (CustomToolbar.this.getLeftMargin() + CustomToolbar.this.getRightMargin());
            for (List list : rows) {
                top += this.layoutRow(list, top, left, width) + vSpacing;
            }
        }

        private int layoutRow(@NonNull List<@NonNull Control> children, int top, int left, int width) {
            Point[] sizes = new Point[children.size()];
            LayoutData[] layout = new LayoutData[children.size()];
            int x = left;
            int y = top;
            int fillCount = 0;
            int flexibleGapCount = 0;
            int minCount = 0;
            int height = 0;
            int i = 0;
            while (i < children.size()) {
                LayoutData layoutData;
                @NonNull Control control = children.get(i);
                @Nullable Object _ld = control.getLayoutData();
                LayoutData layoutData2 = layoutData = _ld instanceof LayoutData ? (LayoutData)_ld : null;
                if (layoutData != null) {
                    assert (control.getVisible() || !layoutData.mExcludeHidden);
                    layout[i] = layoutData;
                    if (layoutData.mFill) {
                        ++fillCount;
                    }
                    if (layoutData.mFlexibleGap) {
                        ++flexibleGapCount;
                    }
                    if (layoutData.mMinimumWidth > 0) {
                        ++minCount;
                    }
                } else {
                    layout[i] = new LayoutData();
                }
                sizes[i] = control.computeSize(-1, -1);
                if (layout[i].mPreferredWidth > 0) {
                    sizes[i].x = layout[i].mPreferredWidth;
                }
                if (layout[i].mMinimumWidth > 0 && sizes[i].x < layout[i].mMinimumWidth) {
                    sizes[i].x = layout[i].mMinimumWidth;
                    --minCount;
                }
                x += sizes[i].x;
                if (i != children.size() - 1) {
                    x += layout[i].mGap;
                }
                if (sizes[i].y > height) {
                    height = sizes[i].y;
                }
                ++i;
            }
            int[] extraGap = new int[children.size()];
            int remaining = width - (x - left);
            if (remaining > 0) {
                if (fillCount > 0) {
                    int extra = remaining / fillCount;
                    int leftover = remaining - extra * fillCount;
                    i = 0;
                    while (i < children.size()) {
                        if (layout[i].mFill) {
                            sizes[i].x += extra;
                            if (leftover > 0) {
                                ++sizes[i].x;
                                --leftover;
                            }
                        }
                        ++i;
                    }
                } else if (flexibleGapCount > 0) {
                    int extra = remaining / flexibleGapCount;
                    int leftover = remaining - extra * flexibleGapCount;
                    i = 0;
                    while (i < children.size()) {
                        if (layout[i].mFlexibleGap) {
                            int n = i;
                            extraGap[n] = extraGap[n] + extra;
                            if (leftover > 0) {
                                int n2 = i;
                                extraGap[n2] = extraGap[n2] + 1;
                                --leftover;
                            }
                        }
                        ++i;
                    }
                }
            } else if (remaining < 0 && minCount > 0) {
                remaining = -remaining;
                if (fillCount > 0) {
                    remaining = this.trimSpace(children, layout, sizes, remaining, true);
                }
                if (remaining > 0) {
                    remaining = this.trimSpace(children, layout, sizes, remaining, false);
                }
            }
            x = left;
            int i2 = 0;
            while (i2 < children.size()) {
                int vSize = layout[i2].mFillRowHeight ? height + 2 : sizes[i2].y;
                children.get(i2).setBounds(x, y + (height - vSize) / 2, sizes[i2].x, vSize);
                x += sizes[i2].x + layout[i2].mGap + extraGap[i2];
                ++i2;
            }
            return height;
        }

        private int trimSpace(@NonNull List<@NonNull Control> children, LayoutData[] layout, Point[] sizes, int remaining, boolean fillOnly) {
            int[] excess = new int[children.size()];
            int total = 0;
            int i = 0;
            while (i < children.size()) {
                int amt;
                if ((!fillOnly || layout[i].mFill) && layout[i].mMinimumWidth > 0 && (amt = sizes[i].x - layout[i].mMinimumWidth) > 0) {
                    excess[i] = amt;
                    total += amt;
                }
                ++i;
            }
            if (total <= remaining) {
                i = 0;
                while (i < children.size()) {
                    if (excess[i] > 0) {
                        sizes[i].x -= excess[i];
                        remaining -= excess[i];
                    }
                    ++i;
                }
            } else {
                int base = remaining;
                int i2 = 0;
                while (i2 < children.size()) {
                    if (excess[i2] > 0) {
                        double ratio = (double)excess[i2] / (double)total;
                        int amt = (int)((double)base * ratio);
                        if (amt > excess[i2]) {
                            amt = excess[i2];
                        }
                        sizes[i2].x -= amt;
                        remaining -= amt;
                    }
                    ++i2;
                }
            }
            return remaining;
        }
    }

    public static class LayoutData {
        public int mGap;
        public int mMinimumWidth;
        public int mPreferredWidth;
        public boolean mFillRowHeight;
        public boolean mFill;
        public boolean mFlexibleGap;
        public boolean mStartNewRow;
        public boolean mExcludeHidden;

        public LayoutData setFill() {
            this.mFill = true;
            return this;
        }

        public LayoutData setFillRowHeight() {
            this.mFillRowHeight = true;
            return this;
        }

        public LayoutData setFlexibleGap() {
            this.mFlexibleGap = true;
            return this;
        }

        public LayoutData setGap(int gap) {
            this.mGap = gap;
            return this;
        }

        public LayoutData setMinimumWidth(int width) {
            this.mMinimumWidth = width;
            return this;
        }

        public LayoutData setPreferredWidth(int width) {
            this.mPreferredWidth = width;
            return this;
        }

        public LayoutData setStartNewRow() {
            this.mStartNewRow = true;
            return this;
        }

        public LayoutData setExcludeHidden() {
            this.mExcludeHidden = true;
            return this;
        }
    }
}

