/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.SafeUpdate;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BusyIndicator
extends Canvas
implements PaintListener,
DisposeListener,
Runnable {
    private int mBusyLevel;
    private int mIndex;

    public BusyIndicator(Composite parent) {
        super(parent, 0x20040000);
        this.addPaintListener(this);
        this.addDisposeListener(this);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Rectangle bounds = StreamlinePlugin.getBusyImage(0).getBounds();
        return new Point(bounds.width, bounds.height);
    }

    public void decrementBusy() {
        --this.mBusyLevel;
        SafeUpdate.redraw((Control)this);
    }

    public void incrementBusy() {
        ++this.mBusyLevel;
        SafeUpdate.redraw((Control)this);
    }

    public void paintControl(PaintEvent event) {
        GC gc = new GC(event.gc);
        Rectangle bounds = this.getClientArea();
        gc.setBackground(Colors.getWidgetBackground());
        gc.fillRectangle(bounds);
        if (this.mBusyLevel > 0) {
            Image img = StreamlinePlugin.getBusyImage(this.mIndex);
            Rectangle imgBounds = img.getBounds();
            gc.drawImage(img, bounds.x + (bounds.width - imgBounds.width) / 2, bounds.y + (bounds.height - imgBounds.height) / 2);
            this.schedule();
        }
    }

    @Override
    public void run() {
        if (this.mBusyLevel > 0) {
            this.mIndex = (this.mIndex + 1) % StreamlinePlugin.getBusyImageCount();
            this.schedule();
            SafeUpdate.redraw((Control)this);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        this.mBusyLevel = 0;
    }

    private void schedule() {
        Task.scheduleOnAnotherThread((Runnable)this, (String)("bi" + this.hashCode()), (long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

