/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.ui;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.utils.collections.Pair;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class StreamlineUIUtils {
    private static int ANNOTATION_TB_BLANK_WIDTH = -1;
    private static int ANNOTATION_TB_BLANK_HEIGHT = -1;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull Pair<@NonNull Integer, @NonNull Integer> getImageWidthHeight(final @NonNull String imageName) {
        final Rectangle bounds = new Rectangle(0, 0, 1, 1);
        Display display = Display.getDefault();
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Image image = StreamlinePlugin.getImage(imageName);
                        Rectangle imageBounds = image.getBounds();
                        bounds.width = imageBounds.width;
                        bounds.height = imageBounds.height;
                        bounds.x = imageBounds.x;
                        bounds.y = imageBounds.y;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }
        @NonNull @NonNull @NonNull Pair pair = new Pair((Object)bounds.width, (Object)bounds.height);
        return pair;
    }

    public static int getAnnotationBlankImageWidth() {
        if (ANNOTATION_TB_BLANK_WIDTH == -1) {
            Pair<@NonNull Integer, @NonNull Integer> imageWidthHeight = StreamlineUIUtils.getImageWidthHeight("VisualAnnotationBlank.png");
            ANNOTATION_TB_BLANK_WIDTH = (Integer)imageWidthHeight.first;
            ANNOTATION_TB_BLANK_HEIGHT = (Integer)imageWidthHeight.second;
        }
        return ANNOTATION_TB_BLANK_WIDTH;
    }

    public static int getAnnotationBlankImageHeight() {
        if (ANNOTATION_TB_BLANK_HEIGHT == -1) {
            Pair<@NonNull Integer, @NonNull Integer> imageWidthHeight = StreamlineUIUtils.getImageWidthHeight("VisualAnnotationBlank.png");
            ANNOTATION_TB_BLANK_HEIGHT = (Integer)imageWidthHeight.second;
            ANNOTATION_TB_BLANK_WIDTH = (Integer)imageWidthHeight.first;
        }
        return ANNOTATION_TB_BLANK_HEIGHT;
    }
}

