/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.text;

import com.arm.streamline.common.CommonPlugin;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class VariableResolver {
    private static final IStringVariableManager MGR = VariablesPlugin.getDefault().getStringVariableManager();
    private static final HashSet<String> VARS = new HashSet();

    public static final void add(String var) {
        VARS.add(var);
    }

    public static final String resolve(String text) {
        try {
            text = VariableResolver.resolve(text, false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return text;
    }

    public static final String resolve(String text, boolean reportUndefinedVars) throws CoreException {
        return MGR.performStringSubstitution(text, reportUndefinedVars);
    }

    public static final String reverseResolve(String text) {
        for (String var : VARS) {
            text = VariableResolver.reverseResolveOne(text, var, null);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            text = VariableResolver.reverseResolveOne(text, "workspace_loc", project.getName());
            ++n2;
        }
        return text;
    }

    public static final String reverseResolveOne(String text, String variableName, String arg) {
        try {
            int pos;
            String var = MGR.generateVariableExpression(variableName, arg);
            String value = MGR.performStringSubstitution(var);
            StringBuilder buffer = new StringBuilder();
            while ((pos = text.indexOf(value)) != -1) {
                buffer.setLength(0);
                if (pos > 0) {
                    buffer.append(text.substring(0, pos));
                }
                buffer.append(var);
                if ((pos += value.length()) < text.length()) {
                    buffer.append(text.substring(pos));
                }
                text = buffer.toString();
            }
        }
        catch (CoreException exception) {
            CommonPlugin.error((Throwable)exception);
        }
        return text;
    }
}

