/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.text;

import com.arm.streamline.utility.text.IStringWidthMeasurer;
import org.eclipse.jdt.annotation.NonNull;

public class StringTruncator {
    private final @NonNull String mFullInput;
    private final int mFullWidth;
    private final @NonNull IStringWidthMeasurer mMeasurer;

    public StringTruncator(@NonNull String fullInput, int fullWidth, @NonNull IStringWidthMeasurer stringMeasurer) {
        this.mFullInput = fullInput;
        this.mFullWidth = fullWidth;
        this.mMeasurer = stringMeasurer;
    }

    public String truncateFromRight(int cellWidth) {
        if (this.mFullWidth <= cellWidth) {
            return this.mFullInput;
        }
        TruncationFromRightState current = new TruncationFromRightState(0, this.mFullInput.length(), cellWidth);
        int index = current.initialSuggestion();
        int measuredWidth = this.mMeasurer.width(this.mFullInput.substring(0, index));
        while (current.canContinue()) {
            int proposed = current.suggestNext(index, measuredWidth);
            if (proposed < 0) break;
            index = proposed;
            measuredWidth = this.mMeasurer.width(this.mFullInput.substring(0, index));
        }
        return this.mFullInput.substring(0, index);
    }

    public String truncateFromRight(int cellWidth, @NonNull String suffix) {
        int suffixWidth = this.mMeasurer.width(suffix);
        if (suffixWidth >= cellWidth) {
            return this.truncateFromRight(cellWidth);
        }
        if (this.mFullInput.length() == 0) {
            return "";
        }
        return this.truncateFromRight(cellWidth - suffixWidth) + suffix;
    }

    private static int midpointOf(int l, int r) {
        return (l + r) / 2;
    }

    private static class TruncationFromRightState {
        int lbound;
        int rbound;
        int targetPixelWidth;

        TruncationFromRightState(int l, int r, int targetWidth) {
            this.lbound = l;
            this.rbound = r;
            this.targetPixelWidth = targetWidth;
        }

        public int suggestNext(int testedIndex, int measuredPixelWidth) {
            if (this.targetPixelWidth < measuredPixelWidth) {
                int next = StringTruncator.midpointOf(this.lbound, testedIndex);
                this.rbound = testedIndex;
                return next;
            }
            int next = StringTruncator.midpointOf(testedIndex, this.rbound);
            if (testedIndex == next && this.rbound - this.lbound == 1) {
                return -1;
            }
            this.lbound = testedIndex;
            return next;
        }

        public boolean canContinue() {
            return this.lbound < this.rbound;
        }

        public String toString() {
            return "{lbound: " + this.lbound + " rbound: " + this.rbound + "}";
        }

        public int initialSuggestion() {
            return Math.min(this.rbound, 128);
        }
    }
}

