/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.text;

import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.jni.apcdbgen.proto.ISampleInstructionRowDataProperties;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Triplet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class DisassemblyRenderer {
    public static final int MAX_DISASM_WIDTH = 48;
    public static final int MAX_TARGET_SYMBOL_WIDTH = 120;
    private static final Pattern MNEMONIC_ONLY_PATTERN = Pattern.compile("([0-9A-Za-z_\\-.]+)");
    private static final Pattern NORMAL_PATTERN = Pattern.compile("([0-9A-Za-z_\\-.]+)([ \\t]+)(.+)");

    public static final int draw(GC gc, Font font, int x, int y, boolean isSelected, boolean isFocus, @NonNull ISampleInstructionRowDataProperties row) {
        List<Token> tokens = DisassemblyRenderer.tokenize(row.getDisassembly());
        if (tokens.size() > 0) {
            Font savedFont = gc.getFont();
            Color savedColor = gc.getForeground();
            int baseline = FontInfo.get(font).getBaseline();
            for (Token token : tokens) {
                Color currentColour;
                Font currentFont;
                switch (token.type()) {
                    case IMM: {
                        currentFont = Fonts.getFontWithStyle(font, 0, 1.0);
                        currentColour = Colors.getDarkRed();
                        break;
                    }
                    case MEM: {
                        currentFont = Fonts.getFontWithStyle(font, 0, 1.0);
                        currentColour = Colors.getDarkGreen();
                        break;
                    }
                    case MNEMONIC: {
                        currentFont = Fonts.getFontWithStyle(font, 1, 1.0);
                        currentColour = Colors.getDarkBlue();
                        break;
                    }
                    case REG: {
                        currentFont = Fonts.getFontWithStyle(font, 0, 1.0);
                        currentColour = Colors.getDarkYellow();
                        break;
                    }
                    case TARGET: {
                        currentFont = Fonts.getFontWithStyle(font, 2, 1.0);
                        currentColour = Colors.getDarkMagenta();
                        break;
                    }
                    case TEXT: {
                        currentColour = Colors.getText(isFocus && isSelected);
                        currentFont = font;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)token.type());
                    }
                }
                gc.setForeground(currentColour);
                gc.setFont(currentFont);
                FontInfo fontInfo = FontInfo.get(currentFont);
                TextDrawing.drawString(gc, token.text(), x, y + baseline - fontInfo.getBaseline(), 16384);
                x += gc.stringExtent((String)token.text()).x;
            }
            gc.setForeground(savedColor);
            gc.setFont(savedFont);
        }
        return x;
    }

    public static final @NonNull List<@NonNull Token> tokenize(@NonNull String disasm) {
        if ((disasm = disasm.strip()).isBlank()) {
            return Collections.emptyList();
        }
        Matcher normalMatcher = NORMAL_PATTERN.matcher(disasm);
        if (normalMatcher.matches()) {
            String mnemonic = (String)NullChecking.neverNull((Object)normalMatcher.group(1));
            String space = (String)NullChecking.neverNull((Object)normalMatcher.group(2));
            String suffix = (String)NullChecking.neverNull((Object)normalMatcher.group(3));
            return DisassemblyRenderer.tokenize(mnemonic, space, suffix);
        }
        Matcher shortMatcher = MNEMONIC_ONLY_PATTERN.matcher(disasm);
        if (shortMatcher.matches()) {
            return Arrays.asList(new Token(TokenType.MNEMONIC, disasm));
        }
        return Arrays.asList(new Token(TokenType.TEXT, disasm));
    }

    private static @Nullable Triplet<@NonNull TokenType, @NonNull List<@NonNull String>, @NonNull List<@NonNull String>> mapMarkupType(@NonNull List<@NonNull String> tokens) {
        String typeToken;
        if (tokens.size() < 3) {
            return null;
        }
        String colonToken = tokens.get(1);
        if (!colonToken.contentEquals(":")) {
            return null;
        }
        switch (typeToken = tokens.get(0)) {
            case "imm": {
                return DisassemblyRenderer.measureMarkup(TokenType.IMM, tokens.subList(2, tokens.size()));
            }
            case "reg": {
                return DisassemblyRenderer.measureMarkup(TokenType.REG, tokens.subList(2, tokens.size()));
            }
            case "target": {
                return DisassemblyRenderer.measureMarkup(TokenType.TARGET, tokens.subList(2, tokens.size()));
            }
            case "mem": {
                return DisassemblyRenderer.measureMarkup(TokenType.MEM, tokens.subList(2, tokens.size()));
            }
        }
        return null;
    }

    private static @Nullable Triplet<@NonNull TokenType, @NonNull List<@NonNull String>, @NonNull List<@NonNull String>> measureMarkup(@NonNull TokenType markupType, @NonNull List<@NonNull String> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            String token = tokens.get(i);
            List<String> remaining = tokens.subList(i + 1, tokens.size());
            switch (token) {
                case "<": {
                    Triplet<TokenType, List<String>, List<String>> innerTypeTriplet = DisassemblyRenderer.mapMarkupType(remaining);
                    if (innerTypeTriplet == null) break;
                    List innerSeq = (List)innerTypeTriplet.second;
                    List innerRemaining = (List)innerTypeTriplet.third;
                    assert (innerSeq.size() + 3 <= remaining.size());
                    assert (innerRemaining.size() < remaining.size());
                    i = tokens.size() - (innerRemaining.size() + 1);
                    break;
                }
                case ">": {
                    return new Triplet((Object)markupType, tokens.subList(0, i), remaining);
                }
            }
            ++i;
        }
        return null;
    }

    private static @NonNull List<@NonNull Token> tokenize(@NonNull String mnemonic, @NonNull String space, @NonNull String suffix) {
        ArrayList<Token> result = new ArrayList<Token>();
        result.add(new Token(TokenType.MNEMONIC, mnemonic));
        result.add(new Token(TokenType.TEXT, space));
        DisassemblyRenderer.tokenizeSequence(result, Arrays.stream(suffix.splitWithDelimiters("[<>:]", 0)).filter(t -> !t.isEmpty()).toList(), TokenType.TEXT);
        return result;
    }

    private static @NonNull List<@NonNull String> tokenizeMarkup(@NonNull List<@NonNull Token> result, @NonNull List<@NonNull String> rawTokens, @NonNull TokenType textType) {
        Triplet<TokenType, List<String>, List<String>> typeAndTokensAndRemaining = DisassemblyRenderer.mapMarkupType(rawTokens);
        if (typeAndTokensAndRemaining == null) {
            result.add(new Token(textType, "<"));
            DisassemblyRenderer.tokenizeSequence(result, rawTokens, textType);
            return Collections.emptyList();
        }
        TokenType markupType = (TokenType)((Object)typeAndTokensAndRemaining.first);
        List<String> markupTokens = (List<String>)typeAndTokensAndRemaining.second;
        List remainingTokens = (List)typeAndTokensAndRemaining.third;
        while (!markupTokens.isEmpty()) {
            String token = (String)markupTokens.get(0);
            markupTokens = markupTokens.subList(1, markupTokens.size());
            switch (token) {
                case "<": {
                    markupTokens = DisassemblyRenderer.tokenizeMarkup(result, markupTokens, markupType);
                    break;
                }
                case ">": {
                    assert (false);
                }
                default: {
                    result.add(new Token(markupType, token));
                }
            }
        }
        return remainingTokens;
    }

    private static void tokenizeSequence(@NonNull List<@NonNull Token> result, @NonNull List<@NonNull String> tokens, @NonNull TokenType textType) {
        while (!tokens.isEmpty()) {
            String token = tokens.get(0);
            tokens = tokens.subList(1, tokens.size());
            switch (token) {
                case "<": {
                    tokens = DisassemblyRenderer.tokenizeMarkup(result, tokens, textType);
                    break;
                }
                default: {
                    result.add(new Token(textType, token));
                }
            }
        }
    }

    public record Token(@NonNull TokenType type, @NonNull String text) {
    }

    public static enum TokenType {
        IMM,
        MEM,
        MNEMONIC,
        REG,
        TARGET,
        TEXT;

    }
}

