/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.target;

import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.authentication.TargetAuthenticationConfig;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.utility.target.CredentialsAddress;
import com.arm.streamline.utility.target.ICredentials;
import java.io.File;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class TargetCredentials
implements ICredentials {
    private final boolean mAllowTargetChange;
    private final @NonNull TargetAuthentication mAuthentication;
    private final @NonNull TargetAuthenticationConfig mConfig;

    public TargetCredentials(@NonNull TargetAuthentication authentication, @NonNull TargetAuthenticationConfig config, boolean allowTargetChange) {
        this.mAuthentication = authentication;
        this.mConfig = config;
        this.mAllowTargetChange = allowTargetChange;
    }

    @Override
    public @NonNull TargetAuthentication asTargetAuth() {
        return this.mAuthentication;
    }

    @Override
    public CredentialsAddress getAddress() {
        CredentialsAddress result = this.mAuthentication.getCredentialsAddress();
        if (result != null) {
            return result;
        }
        return new CredentialsAddress(new TargetAddressString());
    }

    @Override
    public @NonNull List<@NonNull File> getKeyFiles() {
        return this.mAuthentication.getKeyFiles();
    }

    @Override
    public String getPassphrase() {
        return null;
    }

    @Override
    public String getPassword() {
        return this.mAuthentication.getPassword();
    }

    @Override
    public int getSSHPort() {
        return this.mAuthentication.getSSHPort();
    }

    @Override
    public String getUsername() {
        return this.mAuthentication.getUsername();
    }

    @Override
    public ICredentials reprompt() {
        TargetAuthentication authentication = TargetAuthentication.prompt(this.mAuthentication, this.mConfig, false);
        if (authentication == null) {
            return null;
        }
        return new TargetCredentials(authentication, this.mConfig, this.mAllowTargetChange);
    }
}

