/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.target;

import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.utility.target.CredentialsAddress;
import com.arm.streamline.utility.target.ICredentials;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SimpleCredentials
implements ICredentials {
    private final @NonNull CredentialsAddress mAddress;
    private final @Nullable String mUsername;
    private final @Nullable String mPassword;
    private final @NonNull List<@NonNull File> mKeyFiles;
    private final @Nullable String mPassphrase;
    private final int mPort;

    public SimpleCredentials(@NonNull CredentialsAddress address, @Nullable String username, @Nullable String password, @Nullable List<@NonNull File> keyFiles, @Nullable String passphrase, int port) {
        this.mAddress = address;
        this.mUsername = username;
        this.mPassword = password;
        this.mKeyFiles = keyFiles != null ? keyFiles : Collections.emptyList();
        this.mPassphrase = passphrase;
        this.mPort = port;
    }

    @Override
    public @NonNull CredentialsAddress getAddress() {
        return this.mAddress;
    }

    @Override
    public String getPassphrase() {
        return this.mPassphrase;
    }

    @Override
    public String getPassword() {
        return this.mPassword;
    }

    @Override
    public String getUsername() {
        return this.mUsername;
    }

    @Override
    public @NonNull List<@NonNull File> getKeyFiles() {
        return this.mKeyFiles;
    }

    @Override
    public ICredentials reprompt() {
        return null;
    }

    @Override
    public int getSSHPort() {
        return this.mPort;
    }

    @Override
    public @NonNull TargetAuthentication asTargetAuth() {
        return new TargetAuthentication(this.mAddress, this.mUsername, this.mPassword, this.mKeyFiles, this.mPort);
    }
}

