/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.target;

import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.databrowser.TargetAddressString;
import org.eclipse.jdt.annotation.NonNull;

public final class CredentialsAddress
implements Comparable<CredentialsAddress> {
    public final @NonNull String address;
    public final boolean android;

    public CredentialsAddress(@NonNull TargetAddressString address) {
        if (address.isAndroid()) {
            this.android = true;
            this.address = address.getAndroidSerialNumber();
        } else {
            TargetAuthentication.Address tcpAddress = address.getTcpAddressOrDefault("", 0);
            this.android = false;
            this.address = tcpAddress != null ? tcpAddress.hostname() : "";
        }
    }

    @Override
    public int compareTo(@NonNull CredentialsAddress o) {
        if (this.android != o.android) {
            return this.android ? -1 : 1;
        }
        return this.address.compareTo(o.address);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CredentialsAddress) {
            CredentialsAddress that = (CredentialsAddress)obj;
            return this.android == that.android && this.address.contentEquals(that.address);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public String toString() {
        return this.address;
    }

    public @NonNull TargetAddressString asTargetAddressString() {
        if (this.address.isBlank()) {
            return new TargetAddressString();
        }
        if (this.android) {
            return new TargetAddressString(String.format("adb:%s", this.address));
        }
        return new TargetAddressString(String.format("tcp:%s", this.address));
    }
}

